/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.MultiBucketAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregator;
import org.elasticsearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregatorFactory;
import org.elasticsearch.search.internal.SearchContext;

public class AdjacencyMatrixAggregationBuilder
extends AbstractAggregationBuilder<AdjacencyMatrixAggregationBuilder>
implements MultiBucketAggregationBuilder {
    public static final String NAME = "adjacency_matrix";
    private static final String DEFAULT_SEPARATOR = "&";
    private static final ParseField SEPARATOR_FIELD = new ParseField("separator", new String[0]);
    private static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    private List<AdjacencyMatrixAggregator.KeyedFilter> filters;
    private String separator = "&";
    private static final ObjectParser<AdjacencyMatrixAggregationBuilder, Void> PARSER = new ObjectParser("adjacency_matrix");

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        AdjacencyMatrixAggregationBuilder result = (AdjacencyMatrixAggregationBuilder)PARSER.parse(parser, (Object)new AdjacencyMatrixAggregationBuilder(aggregationName), null);
        result.checkConsistency();
        return result;
    }

    protected void checkConsistency() {
        if (this.filters == null || this.filters.size() == 0) {
            throw new IllegalStateException("[" + this.name + "] is missing : " + FILTERS_FIELD.getPreferredName() + " parameter");
        }
    }

    protected void setFiltersAsMap(Map<String, QueryBuilder> filters) {
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(filters.size());
        for (Map.Entry<String, QueryBuilder> kv : filters.entrySet()) {
            this.filters.add(new AdjacencyMatrixAggregator.KeyedFilter(kv.getKey(), kv.getValue()));
        }
        Collections.sort(this.filters, Comparator.comparing(AdjacencyMatrixAggregator.KeyedFilter::key));
    }

    protected void setFiltersAsList(List<AdjacencyMatrixAggregator.KeyedFilter> filters) {
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(filters);
        Collections.sort(this.filters, Comparator.comparing(AdjacencyMatrixAggregator.KeyedFilter::key));
    }

    protected AdjacencyMatrixAggregationBuilder(String name) {
        super(name);
    }

    public AdjacencyMatrixAggregationBuilder(String name, Map<String, QueryBuilder> filters) {
        this(name, DEFAULT_SEPARATOR, filters);
    }

    protected AdjacencyMatrixAggregationBuilder(AdjacencyMatrixAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(clone.filters);
        this.separator = clone.separator;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new AdjacencyMatrixAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public AdjacencyMatrixAggregationBuilder(String name, String separator, Map<String, QueryBuilder> filters) {
        super(name);
        this.separator = separator;
        this.setFiltersAsMap(filters);
    }

    public AdjacencyMatrixAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        int filtersSize = in.readVInt();
        this.separator = in.readString();
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(filtersSize);
        for (int i = 0; i < filtersSize; ++i) {
            this.filters.add(new AdjacencyMatrixAggregator.KeyedFilter(in));
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.filters.size());
        out.writeString(this.separator);
        for (AdjacencyMatrixAggregator.KeyedFilter keyedFilter : this.filters) {
            keyedFilter.writeTo(out);
        }
    }

    public AdjacencyMatrixAggregationBuilder separator(String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("[separator] must not be null: [" + this.name + "]");
        }
        this.separator = separator;
        return this;
    }

    public String separator() {
        return this.separator;
    }

    public Map<String, QueryBuilder> filters() {
        HashMap<String, QueryBuilder> result = new HashMap<String, QueryBuilder>(this.filters.size());
        for (AdjacencyMatrixAggregator.KeyedFilter keyedFilter : this.filters) {
            result.put(keyedFilter.key(), keyedFilter.filter());
        }
        return result;
    }

    @Override
    protected AggregatorFactory<?> doBuild(SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        int maxFilters = context.indexShard().indexSettings().getMaxAdjacencyMatrixFilters();
        if (this.filters.size() > maxFilters) {
            throw new IllegalArgumentException("Number of filters is too large, must be less than or equal to: [" + maxFilters + "] but was [" + this.filters.size() + "].This limit can be set by changing the [" + IndexSettings.MAX_ADJACENCY_MATRIX_FILTERS_SETTING.getKey() + "] index level setting.");
        }
        ArrayList<AdjacencyMatrixAggregator.KeyedFilter> rewrittenFilters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(this.filters.size());
        for (AdjacencyMatrixAggregator.KeyedFilter kf : this.filters) {
            rewrittenFilters.add(new AdjacencyMatrixAggregator.KeyedFilter(kf.key(), Rewriteable.rewrite(kf.filter(), context.getQueryShardContext(), true)));
        }
        return new AdjacencyMatrixAggregatorFactory(this.name, rewrittenFilters, this.separator, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SEPARATOR_FIELD.getPreferredName(), this.separator);
        builder.startObject(AdjacencyMatrixAggregator.FILTERS_FIELD.getPreferredName());
        for (AdjacencyMatrixAggregator.KeyedFilter keyedFilter : this.filters) {
            builder.field(keyedFilter.key(), (ToXContent)keyedFilter.filter());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filters, this.separator);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AdjacencyMatrixAggregationBuilder other = (AdjacencyMatrixAggregationBuilder)obj;
        return Objects.equals(this.filters, other.filters) && Objects.equals(this.separator, other.separator);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        PARSER.declareString(AdjacencyMatrixAggregationBuilder::separator, SEPARATOR_FIELD);
        PARSER.declareNamedObjects(AdjacencyMatrixAggregationBuilder::setFiltersAsList, AdjacencyMatrixAggregator.KeyedFilter.PARSER, FILTERS_FIELD);
    }
}

