/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions.impl;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaPicoContainer;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import org.jetbrains.kotlin.com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;

public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    private static final boolean DEBUG_REGISTRATION = Boolean.FALSE;
    private final AreaPicoContainer myPicoContainer;
    private final Map<String, ExtensionPointImpl> myExtensionPoints = ContainerUtil.newConcurrentMap();
    private final Map<String, Throwable> myEPTraces = DEBUG_REGISTRATION ? new THashMap() : null;
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners = MultiMap.createSmart();
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;

    public ExtensionsAreaImpl(@Nullable String areaClass, @Nullable AreaInstance areaInstance, PicoContainer parentPicoContainer) {
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new DefaultPicoContainer(parentPicoContainer);
        this.initialize();
    }

    @Nullable
    AreaInstance getAreaInstance() {
        return this.myAreaInstance;
    }

    public final void notifyAreaReplaced(@NotNull ExtensionsAreaImpl newArea) {
        if (newArea == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(0);
        }
        THashSet processedEPs = ContainerUtil.newTroveSet();
        for (ExtensionPointImpl extensionPointImpl : this.myExtensionPoints.values()) {
            extensionPointImpl.notifyAreaReplaced(this);
            processedEPs.add((String)extensionPointImpl.getName());
        }
        if (!this.myAvailabilityListeners.isEmpty()) {
            for (Map.Entry entry : this.myAvailabilityListeners.entrySet()) {
                String key = (String)entry.getKey();
                if (processedEPs.contains(key)) continue;
                boolean wasAdded = false;
                for (ExtensionPointAvailabilityListener listener : (Collection)entry.getValue()) {
                    if (newArea.hasAvailabilityListener(key, listener)) continue;
                    newArea.addAvailabilityListener(key, listener, null);
                    wasAdded = true;
                }
                if (!wasAdded) continue;
                processedEPs.add((String)key);
            }
        }
        for (ExtensionPointImpl extensionPointImpl : newArea.myExtensionPoints.values()) {
            if (processedEPs.contains(extensionPointImpl.getName())) continue;
            extensionPointImpl.notifyAreaReplaced(this);
        }
    }

    @Override
    @NotNull
    public AreaPicoContainer getPicoContainer() {
        AreaPicoContainer areaPicoContainer = this.myPicoContainer;
        if (areaPicoContainer == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(1);
        }
        return areaPicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    @Override
    public void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(2);
        }
        if (extensionPointElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(3);
        }
        assert (pluginDescriptor.getPluginId() != null);
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        String pointName = extensionPointElement.getAttributeValue("qualifiedName");
        if (pointName == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + pluginId + "' plugin");
            }
            pointName = pluginId + '.' + name;
        }
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginId + "' plugin");
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginId + "' plugin");
        }
        ExtensionPointImpl point = interfaceClassName == null ? new BeanExtensionPoint(pointName, beanClassName, this, pluginDescriptor) : new InterfaceExtensionPoint(pointName, interfaceClassName, this, pluginDescriptor);
        this.registerExtensionPoint(point);
    }

    @Override
    public void registerExtension(@NotNull ExtensionPoint extensionPoint, @NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement) {
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(6);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(7);
        }
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(8);
        }
        ((ExtensionPointImpl)extensionPoint).createAndRegisterAdapter(extensionElement, pluginDescriptor);
    }

    @NotNull
    public static String extractPointName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName;
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(9);
        }
        if ((epName = extensionElement.getAttributeValue("point")) == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        String string = epName;
        if (string == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    private void initialize() {
        InterfaceExtensionPoint<EPAvailabilityListenerExtension> point = new InterfaceExtensionPoint<EPAvailabilityListenerExtension>("org.jetbrains.kotlin.com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class, this);
        this.registerExtensionPoint(point);
        point.addExtensionPointListener(new ExtensionPointListener<EPAvailabilityListenerExtension>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void extensionRemoved(@NotNull EPAvailabilityListenerExtension extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                MultiMap multiMap = ExtensionsAreaImpl.this.myAvailabilityListeners;
                synchronized (multiMap) {
                    Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get(extension.getExtensionPointName());
                    Iterator iterator2 = listeners.iterator();
                    while (iterator2.hasNext()) {
                        ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator2.next();
                        if (!listener.getClass().getName().equals(extension.getListenerClass())) continue;
                        iterator2.remove();
                        return;
                    }
                }
                LOG.warn("Failed to find EP availability listener: " + extension.getListenerClass());
            }

            @Override
            public void extensionAdded(@NotNull EPAvailabilityListenerExtension extension, @Nullable PluginDescriptor pluginDescriptor) {
                ExtensionPointAvailabilityListener listener;
                if (extension == null) {
                    1.$$$reportNull$$$0(1);
                }
                String epName = extension.getExtensionPointName();
                try {
                    listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(extension.loadListenerClass());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "extension";
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, null);
    }

    @NotNull
    private Object instantiate(@NotNull Class clazz2) {
        if (clazz2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(11);
        }
        CachingConstructorInjectionComponentAdapter adapter = new CachingConstructorInjectionComponentAdapter(Integer.toString(System.identityHashCode(new Object())), clazz2);
        Object object = adapter.getComponentInstance(this.getPicoContainer());
        if (object == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(12);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAvailabilityListener(final @NotNull String extensionPointName, final @NotNull ExtensionPointAvailabilityListener listener, @Nullable Disposable parentDisposable) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(13);
        }
        if (listener == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(14);
        }
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            this.myAvailabilityListeners.putValue(extensionPointName, listener);
        }
        ExtensionPointImpl ep = this.myExtensionPoints.get(extensionPointName);
        if (ep != null) {
            listener.extensionPointRegistered(ep);
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    ExtensionsAreaImpl.this.removeAvailabilityListener(extensionPointName, listener);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(15);
        }
        if (listener == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(16);
        }
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            this.myAvailabilityListeners.remove(extensionPointName, listener);
        }
    }

    private boolean hasAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(17);
        }
        if (listener == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(18);
        }
        Collection<ExtensionPointAvailabilityListener> listeners = this.myAvailabilityListeners.get(extensionPointName);
        return ContainerUtil.containsIdentity(listeners, listener);
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(19);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(20);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(21);
        }
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
    }

    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(26);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(27);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(28);
        }
        UndefinedPluginDescriptor pluginDescriptor = new UndefinedPluginDescriptor();
        ExtensionPointImpl point = kind == ExtensionPoint.Kind.INTERFACE ? new InterfaceExtensionPoint(extensionPointName, extensionPointBeanClass, this, pluginDescriptor) : new BeanExtensionPoint(extensionPointName, extensionPointBeanClass, this, pluginDescriptor);
        this.registerExtensionPoint(point);
    }

    @Nullable
    private static PluginId extractPluginId(@NotNull PluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(29);
        }
        return descriptor2 instanceof UndefinedPluginDescriptor ? null : descriptor2.getPluginId();
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(30);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(31);
        }
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        String message2 = "Duplicate registration for EP: " + pointName + ": original plugin " + ExtensionsAreaImpl.extractPluginId(((ExtensionPointImpl)this.getExtensionPoint(pointName)).getDescriptor()) + ", new plugin " + ExtensionsAreaImpl.extractPluginId(pluginDescriptor);
        if (DEBUG_REGISTRATION) {
            LOG.error(message2, this.myEPTraces.get(pointName));
        }
        throw new PicoPluginExtensionInitializationException(message2, null, ExtensionsAreaImpl.extractPluginId(pluginDescriptor));
    }

    public void registerExtensionPoint(@NotNull ExtensionPointImpl<?> point) {
        if (point == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(32);
        }
        String name = point.getName();
        this.checkThatPointNotDuplicated(name, point.getDescriptor());
        this.myExtensionPoints.put(name, point);
        this.notifyPointRegistered(point);
        if (DEBUG_REGISTRATION) {
            this.myEPTraces.put(name, new Throwable("Original registration for " + name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPointRegistered(@NotNull ExtensionPoint extensionPoint) {
        Collection<ExtensionPointAvailabilityListener> listeners;
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(33);
        }
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            listeners = this.myAvailabilityListeners.get(extensionPoint.getName());
        }
        for (ExtensionPointAvailabilityListener listener : listeners) {
            listener.extensionPointRegistered(extensionPoint);
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(34);
        }
        if ((extensionPoint = this.myExtensionPoints.get(extensionPointName)) == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        ExtensionPointImpl extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(35);
        }
        return extensionPointImpl;
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(36);
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(37);
        }
        return extensionPoint;
    }

    @Override
    @NotNull
    public ExtensionPoint[] getExtensionPoints() {
        ExtensionPoint[] extensionPointArray = this.myExtensionPoints.values().toArray(new ExtensionPoint[0]);
        if (extensionPointArray == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(38);
        }
        return extensionPointArray;
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(41);
        }
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(42);
        }
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return (this.myAreaClass == null ? "Root" : this.myAreaClass) + " Area";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 35: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 35: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newArea";
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 6: 
            case 22: 
            case 33: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 20: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointBeanClass";
                break;
            }
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPointName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiate";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 35: 
            case 37: 
            case 38: {
                break;
            }
            case 2: 
            case 3: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractPointName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAvailabilityListener";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeAvailabilityListener";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasAvailabilityListener";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtensionPoint";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "extractPluginId";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkThatPointNotDuplicated";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "notifyPointRegistered";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPoint";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoint";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "notifyEPRemoved";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasExtensionPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 35: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

