/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrArithBuilder;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.TypeOperatorLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.TypeOperatorLowering$WhenMappings;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionWithCopy;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\tR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\tR\u0014\u0010 \u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\tR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\tR\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\tR\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/TypeOperatorLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "booleanMarker", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "getBooleanMarker", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "byteMask", "", "getByteMask", "calculator", "Lorg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "eqeq", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "functionMarker", "getFunctionMarker", "instanceOfIntrinsicSymbol", "isArraySymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "isInterfaceSymbol", "isObjectSymbol", "isSuspendFunctionSymbol", "jsClassIntrinsicSymbol", "lit16", "getLit16", "lit24", "getLit24", "litFalse", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getLitFalse", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "litNull", "getLitNull", "litTrue", "getLitTrue", "numberMarker", "getNumberMarker", "shortMask", "getShortMask", "stringMarker", "getStringMarker", "throwCCE", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "throwNPE", "typeOfIntrinsicSymbol", "unit", "Lorg/jetbrains/kotlin/ir/types/IrType;", "unitValue", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "getUnitValue", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.js"})
public final class TypeOperatorLowering
implements FileLoweringPass {
    private final IrType unit;
    private final JsIrArithBuilder calculator;
    private final IrFunctionSymbol throwCCE;
    private final IrFunctionSymbol throwNPE;
    private final IrSimpleFunctionSymbol eqeq;
    private final IrSimpleFunctionSymbol isSuspendFunctionSymbol;
    private final IrSimpleFunctionSymbol instanceOfIntrinsicSymbol;
    private final IrSimpleFunctionSymbol typeOfIntrinsicSymbol;
    private final IrSimpleFunctionSymbol jsClassIntrinsicSymbol;
    @NotNull
    private final JsIrBackendContext context;

    private final IrGetObjectValueImpl getUnitValue() {
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(this.unit);
        if (irClassifierSymbol == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
        }
        return JsIrBuilder.INSTANCE.buildGetObjectValue(this.unit, (IrClassSymbol)irClassifierSymbol);
    }

    private final IrConstImpl<Integer> getLit24() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 24);
    }

    private final IrConstImpl<Integer> getLit16() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 16);
    }

    private final IrConstImpl<Integer> getByteMask() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 255);
    }

    private final IrConstImpl<Integer> getShortMask() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 65535);
    }

    private final IrSimpleFunctionSymbol isInterfaceSymbol() {
        return this.context.getIntrinsics().isInterfaceSymbol();
    }

    private final IrSimpleFunctionSymbol isArraySymbol() {
        return this.context.getIntrinsics().isArraySymbol();
    }

    private final IrSimpleFunctionSymbol isObjectSymbol() {
        return this.context.getIntrinsics().isObjectSymbol();
    }

    private final IrConstImpl<String> getStringMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "string");
    }

    private final IrConstImpl<String> getBooleanMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "boolean");
    }

    private final IrConstImpl<String> getFunctionMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "function");
    }

    private final IrConstImpl<String> getNumberMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "number");
    }

    private final IrExpression getLitTrue() {
        return JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), true);
    }

    private final IrExpression getLitFalse() {
        return JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), false);
    }

    private final IrExpression getLitNull() {
        return JsIrBuilder.INSTANCE.buildNull(this.context.getIrBuiltIns().getNothingNType());
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        irFile.transformChildren((IrElementTransformer)new IrElementTransformer<IrDeclarationParent>(this){
            final /* synthetic */ TypeOperatorLowering this$0;

            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclaration declaration2, @NotNull IrDeclarationParent data) {
                IrDeclarationParent irDeclarationParent;
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                IrDeclaration irDeclaration = declaration2;
                if (!(irDeclaration instanceof IrDeclarationParent)) {
                    irDeclaration = null;
                }
                if ((irDeclarationParent = (IrDeclarationParent)((Object)irDeclaration)) == null) {
                    irDeclarationParent = data;
                }
                return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration2, irDeclarationParent);
            }

            @NotNull
            public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent data) {
                IrExpression irExpression;
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
                switch (TypeOperatorLowering$WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
                    case 1: {
                        irExpression = this.lowerImplicitCast(expression2);
                        break;
                    }
                    case 2: {
                        irExpression = this.lowerImplicitDynamicCast(expression2);
                        break;
                    }
                    case 3: {
                        irExpression = this.lowerCoercionToUnit(expression2);
                        break;
                    }
                    case 4: {
                        irExpression = this.lowerIntegerCoercion(expression2, data);
                        break;
                    }
                    case 5: {
                        irExpression = this.lowerImplicitNotNull(expression2, data);
                        break;
                    }
                    case 6: {
                        irExpression = this.lowerInstanceOf(expression2, data, false);
                        break;
                    }
                    case 7: {
                        irExpression = this.lowerInstanceOf(expression2, data, true);
                        break;
                    }
                    case 8: {
                        irExpression = this.lowerCast(expression2, data, false);
                        break;
                    }
                    case 9: {
                        irExpression = this.lowerCast(expression2, data, true);
                        break;
                    }
                    case 10: {
                        String string = "SAM conversion: " + RenderIrElementKt.render(expression2);
                        boolean bl = false;
                        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return irExpression;
            }

            private final IrExpression lowerImplicitNotNull(IrTypeOperatorCall expression2, IrDeclarationParent declaration2) {
                boolean bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_NOTNULL;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(expression2.getTypeOperand()) ^ org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(expression2.getArgument().getType());
                bl2 = false;
                bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl2 = false;
                List newStatements = new ArrayList<E>();
                Function0<IrExpressionWithCopy> argument = this.cacheValue(expression2.getArgument(), newStatements, declaration2);
                IrCall irNullCheck = this.nullCheck(argument.invoke());
                Object object = newStatements;
                IrWhen irWhen = JsIrBuilder.INSTANCE.buildIfElse(expression2.getTypeOperand(), irNullCheck, JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getThrowNPE$p(this.this$0), null, null, 6, null), argument.invoke());
                boolean bl6 = false;
                object.add(irWhen);
                object = expression2;
                boolean bl7 = false;
                bl6 = false;
                Object $this$run = object;
                boolean bl8 = false;
                return new IrCompositeImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getTypeOperand(), null, newStatements);
            }

            private final IrExpression lowerCast(IrTypeOperatorCall expression2, IrDeclarationParent declaration2, boolean isSafe) {
                boolean bl = expression2.getOperator() == IrTypeOperator.CAST || expression2.getOperator() == IrTypeOperator.SAFE_CAST;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = expression2.getOperator() == IrTypeOperator.SAFE_CAST == isSafe;
                bl2 = false;
                bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrType toType = expression2.getTypeOperand();
                IrExpression failResult = isSafe ? TypeOperatorLowering.access$getLitNull$p(this.this$0) : (IrExpression)JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getThrowCCE$p(this.this$0), null, null, 6, null);
                boolean bl6 = false;
                List newStatements = new ArrayList<E>();
                Function0<IrExpressionWithCopy> argument = this.cacheValue(expression2.getArgument(), newStatements, declaration2);
                IrExpression check2 = this.generateTypeCheck(argument, toType);
                Object object = newStatements;
                IrWhen irWhen = JsIrBuilder.INSTANCE.buildIfElse(expression2.getType(), check2, argument.invoke(), failResult);
                boolean bl7 = false;
                object.add(irWhen);
                object = expression2;
                boolean bl8 = false;
                bl7 = false;
                Object $this$run = object;
                boolean bl9 = false;
                return new IrCompositeImpl($this$run.getStartOffset(), $this$run.getEndOffset(), expression2.getType(), null, newStatements);
            }

            private final IrExpression lowerImplicitCast(IrTypeOperatorCall expression2) {
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                boolean bl = false;
                boolean bl2 = false;
                IrTypeOperatorCall $this$run = irTypeOperatorCall;
                boolean bl3 = false;
                boolean bl4 = $this$run.getOperator() == IrTypeOperator.IMPLICIT_CAST;
                boolean bl5 = false;
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl7 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                return $this$run.getArgument();
            }

            private final IrExpression lowerImplicitDynamicCast(IrTypeOperatorCall expression2) {
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                boolean bl = false;
                boolean bl2 = false;
                IrTypeOperatorCall $this$run = irTypeOperatorCall;
                boolean bl3 = false;
                boolean bl4 = $this$run.getOperator() == IrTypeOperator.IMPLICIT_DYNAMIC_CAST;
                boolean bl5 = false;
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl7 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                return $this$run.getArgument();
            }

            private final boolean advancedCheckRequired(IrType type2) {
                return IrTypeUtilsKt.isInterface(type2) || IrTypePredicatesKt.isArray(type2) || IrTypeUtilsKt.isPrimitiveArray(type2) || this.isTypeOfCheckingType(type2);
            }

            private final boolean isTypeOfCheckingType(IrType type2) {
                return IrTypePredicatesKt.isByte(type2) || IrTypePredicatesKt.isShort(type2) || IrTypePredicatesKt.isInt(type2) || IrTypePredicatesKt.isFloat(type2) || IrTypePredicatesKt.isDouble(type2) || IrTypePredicatesKt.isBoolean(type2) || IrTypeUtilsKt.isFunctionOrKFunction(type2) || IrTypePredicatesKt.isString(type2);
            }

            @NotNull
            public final IrExpression lowerInstanceOf(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent declaration2, boolean inverted) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                boolean bl = expression2.getOperator() == IrTypeOperator.INSTANCEOF || expression2.getOperator() == IrTypeOperator.NOT_INSTANCEOF;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = expression2.getOperator() == IrTypeOperator.NOT_INSTANCEOF == inverted;
                bl2 = false;
                bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrType toType = expression2.getTypeOperand();
                bl3 = false;
                List newStatements = new ArrayList<E>();
                Function0<IrExpressionWithCopy> argument = this.cacheValue(expression2.getArgument(), newStatements, declaration2);
                IrExpression check2 = this.generateTypeCheck(argument, toType);
                IrExpression result2 = inverted ? TypeOperatorLowering.access$getCalculator$p(this.this$0).not(check2) : check2;
                Collection collection = newStatements;
                boolean bl6 = false;
                collection.add(result2);
                return new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType(), null, newStatements);
            }

            private final IrCall nullCheck(IrExpression value) {
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getEqeq$p(this.this$0), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, value);
                $this$apply.putValueArgument(1, TypeOperatorLowering.access$getLitNull$p(this.this$0));
                return irCall;
            }

            private final Function0<IrExpressionWithCopy> cacheValue(IrExpression value, List<IrStatement> newStatements, IrDeclarationParent declaration2) {
                IrVariable varDeclaration = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, value.getType(), declaration2, null, false, false, false, value, 60, null);
                Collection collection = newStatements;
                boolean bl = false;
                collection.add(varDeclaration);
                return new Function0<IrGetValueImpl>(varDeclaration){
                    final /* synthetic */ IrVariable $varDeclaration;

                    @NotNull
                    public final IrGetValueImpl invoke() {
                        return JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)this.$varDeclaration.getSymbol());
                    }
                    {
                        this.$varDeclaration = irVariable2;
                        super(0);
                    }
                };
            }

            private final IrExpression generateTypeCheck(Function0<? extends IrExpressionWithCopy> argument, IrType toType) {
                IrExpression irExpression;
                IrType toNotNullable = IrTypesKt.makeNotNull(toType);
                IrExpressionWithCopy argumentInstance = argument.invoke();
                IrExpression instanceCheck = this.generateTypeCheckNonNull(argumentInstance, toNotNullable);
                boolean isFromNullable = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(argumentInstance.getType());
                boolean isToNullable = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(toType);
                boolean isNativeCheck = !this.advancedCheckRequired(toNotNullable);
                if (!isFromNullable) {
                    irExpression = instanceCheck;
                } else if (isToNullable) {
                    JsIrArithBuilder jsIrArithBuilder = TypeOperatorLowering.access$getCalculator$p(this.this$0);
                    boolean bl = false;
                    boolean bl2 = false;
                    JsIrArithBuilder $this$run = jsIrArithBuilder;
                    boolean bl3 = false;
                    irExpression = $this$run.oror(this.nullCheck(argument.invoke()), instanceCheck);
                } else if (isNativeCheck) {
                    irExpression = instanceCheck;
                } else {
                    JsIrArithBuilder jsIrArithBuilder = TypeOperatorLowering.access$getCalculator$p(this.this$0);
                    boolean bl = false;
                    boolean bl4 = false;
                    JsIrArithBuilder $this$run = jsIrArithBuilder;
                    boolean bl5 = false;
                    irExpression = $this$run.andand($this$run.not(this.nullCheck(argument.invoke())), instanceCheck);
                }
                return irExpression;
            }

            private final IrExpression generateTypeCheckNonNull(IrExpressionWithCopy argument, IrType toType) {
                IrExpression irExpression;
                boolean bl = !IrTypePredicatesKt.isMarkedNullable(toType);
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (IrTypePredicatesKt.isAny(toType)) {
                    irExpression = this.generateIsObjectCheck(argument);
                } else if (IrTypePredicatesKt.isNothing(toType)) {
                    irExpression = JsIrBuilder.INSTANCE.buildComposite(this.this$0.getContext().getIrBuiltIns().getBooleanType(), CollectionsKt.listOf(argument, TypeOperatorLowering.access$getLitFalse$p(this.this$0)));
                } else if (IrTypeUtilsKt.isSuspendFunctionTypeOrSubtype(toType)) {
                    irExpression = this.generateSuspendFunctionCheck(argument, toType);
                } else if (this.isTypeOfCheckingType(toType)) {
                    irExpression = this.generateTypeOfCheck(argument, toType);
                } else if (IrTypePredicatesKt.isNumber(toType)) {
                    irExpression = this.generateNumberCheck(argument);
                } else if (IrTypePredicatesKt.isComparable(toType)) {
                    irExpression = this.generateComparableCheck(argument);
                } else if (IrTypePredicatesKt.isCharSequence(toType)) {
                    irExpression = this.generateCharSequenceCheck(argument);
                } else if (IrTypePredicatesKt.isArray(toType)) {
                    irExpression = this.generateGenericArrayCheck(argument);
                } else if (IrTypeUtilsKt.isPrimitiveArray(toType)) {
                    irExpression = this.generatePrimitiveArrayTypeCheck(argument, toType);
                } else if (IrTypeUtilsKt.isTypeParameter(toType)) {
                    irExpression = this.generateTypeCheckWithTypeParameter(argument, toType);
                } else if (IrTypeUtilsKt.isInterface(toType)) {
                    IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(toType).getOwner();
                    if (irSymbolOwner == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    }
                    irExpression = IrUtilsKt.isEffectivelyExternal((IrClass)irSymbolOwner) ? (IrExpression)this.generateIsObjectCheck(argument) : this.generateInterfaceCheck(argument, toType);
                } else {
                    irExpression = this.generateNativeInstanceOf(argument, toType);
                }
                return irExpression;
            }

            private final IrCall generateIsObjectCheck(IrExpression argument) {
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isObjectSymbol$p(this.this$0), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                return irCall;
            }

            /*
             * WARNING - void declaration
             */
            private final IrExpression generateTypeCheckWithTypeParameter(IrExpressionWithCopy argument, IrType toType) {
                void $this$fold$iv;
                IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(toType);
                if (!(irClassifierSymbol instanceof IrTypeParameterSymbol)) {
                    irClassifierSymbol = null;
                }
                IrTypeParameterSymbol irTypeParameterSymbol = (IrTypeParameterSymbol)irClassifierSymbol;
                if (irTypeParameterSymbol == null) {
                    String string = "expected type parameter, but " + toType;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                IrTypeParameterSymbol typeParameterSymbol = irTypeParameterSymbol;
                IrTypeParameter typeParameter = (IrTypeParameter)typeParameterSymbol.getOwner();
                Iterable iterable = typeParameter.getSuperTypes();
                IrExpression initial$iv = TypeOperatorLowering.access$getLitTrue$p(this.this$0);
                boolean $i$f$fold = false;
                IrExpression accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void t;
                    IrType irType = (IrType)element$iv;
                    IrExpression r = accumulator$iv;
                    boolean bl = false;
                    IrExpression check2 = this.generateTypeCheckNonNull(argument.copy(), IrTypesKt.makeNotNull((IrType)t));
                    accumulator$iv = TypeOperatorLowering.access$getCalculator$p(this.this$0).and(r, check2);
                }
                return accumulator$iv;
            }

            private final IrExpression generateSuspendFunctionCheck(IrExpression argument, IrType toType) {
                IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(toType).getOwner();
                if (irSymbolOwner == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                }
                int arity = ((IrClass)irSymbolOwner).getTypeParameters().size() - 1;
                IrBuiltIns irBuiltIns = this.this$0.getContext().getIrBuiltIns();
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isSuspendFunctionSymbol$p(this.this$0), irBuiltIns.getBooleanType(), null, 4, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                $this$apply.putValueArgument(1, JsIrBuilder.INSTANCE.buildInt(irBuiltIns.getIntType(), arity));
                return irCall;
            }

            private final IrExpression generateTypeOfCheck(IrExpression argument, IrType toType) {
                IrConstImpl marker = IrTypeUtilsKt.isFunctionOrKFunction(toType) ? TypeOperatorLowering.access$getFunctionMarker$p(this.this$0) : (IrTypePredicatesKt.isBoolean(toType) ? TypeOperatorLowering.access$getBooleanMarker$p(this.this$0) : (IrTypePredicatesKt.isString(toType) ? TypeOperatorLowering.access$getStringMarker$p(this.this$0) : TypeOperatorLowering.access$getNumberMarker$p(this.this$0)));
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getTypeOfIntrinsicSymbol$p(this.this$0), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                IrCall typeOf = irCall;
                irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getEqeq$p(this.this$0), null, null, 6, null);
                bl = false;
                bl2 = false;
                $this$apply = irCall;
                boolean bl4 = false;
                $this$apply.putValueArgument(0, typeOf);
                $this$apply.putValueArgument(1, marker);
                return irCall;
            }

            private final IrCall wrapTypeReference(IrType toType) {
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getJsClassIntrinsicSymbol$p(this.this$0), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putTypeArgument(0, toType);
                return irCall;
            }

            private final IrCall generateGenericArrayCheck(IrExpression argument) {
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isArraySymbol$p(this.this$0), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                return irCall;
            }

            private final IrCall generateNumberCheck(IrExpression argument) {
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().isNumberSymbol(), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                return irCall;
            }

            private final IrCall generateComparableCheck(IrExpression argument) {
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().isComparableSymbol(), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                return irCall;
            }

            private final IrCall generateCharSequenceCheck(IrExpression argument) {
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().isCharSequenceSymbol(), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                return irCall;
            }

            private final IrExpression generatePrimitiveArrayTypeCheck(IrExpression argument, IrType toType) {
                Object object = this.this$0.getContext().getIntrinsics().isPrimitiveArray();
                PrimitiveType primitiveType = IrTypeUtilsKt.getPrimitiveArrayElementType(toType);
                boolean bl = false;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = object.get((Object)((Object)primitiveType));
                if (irSimpleFunctionSymbol == null) {
                    Intrinsics.throwNpe();
                }
                IrSimpleFunctionSymbol f = irSimpleFunctionSymbol;
                object = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, f, null, null, 6, null);
                boolean bl2 = false;
                bl = false;
                Object $this$apply = object;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                return (IrExpression)object;
            }

            private final IrExpression generateInterfaceCheck(IrExpression argument, IrType toType) {
                IrCall irType = this.wrapTypeReference(toType);
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isInterfaceSymbol$p(this.this$0), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                $this$apply.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression generateNativeInstanceOf(IrExpression argument, IrType toType) {
                IrCall irType = this.wrapTypeReference(toType);
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getInstanceOfIntrinsicSymbol$p(this.this$0), null, null, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, argument);
                $this$apply.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression lowerCoercionToUnit(IrTypeOperatorCall expression2) {
                boolean bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                bl2 = false;
                bl3 = false;
                IrTypeOperatorCall $this$run = irTypeOperatorCall;
                boolean bl5 = false;
                return new IrCompositeImpl($this$run.getStartOffset(), $this$run.getEndOffset(), TypeOperatorLowering.access$getUnit$p(this.this$0), null, CollectionsKt.listOf($this$run.getArgument(), TypeOperatorLowering.access$getUnitValue$p(this.this$0)));
            }

            private final IrExpression lowerIntegerCoercion(IrTypeOperatorCall expression2, IrDeclarationParent declaration2) {
                boolean bl;
                Object object;
                IrExpression irExpression;
                boolean bl2 = expression2.getOperator() == IrTypeOperator.IMPLICIT_INTEGER_COERCION;
                boolean bl3 = false;
                boolean bl4 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl2 = IrTypePredicatesKt.isInt(expression2.getArgument().getType());
                bl3 = false;
                bl4 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl6 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                boolean isNullable2 = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(expression2.getArgument().getType());
                IrType toType = expression2.getTypeOperand();
                Function3<IrExpression, IrExpression, IrExpressionWithCopy, IrExpression> $fun$maskOp$1 = new Function3<IrExpression, IrExpression, IrExpressionWithCopy, IrExpression>(this){
                    final /* synthetic */ lower.1 this$0;

                    @NotNull
                    public final IrExpression invoke(@NotNull IrExpression arg, @NotNull IrExpression mask, @NotNull IrExpressionWithCopy shift) {
                        Intrinsics.checkParameterIsNotNull(arg, "arg");
                        Intrinsics.checkParameterIsNotNull(mask, "mask");
                        Intrinsics.checkParameterIsNotNull(shift, "shift");
                        JsIrArithBuilder jsIrArithBuilder = TypeOperatorLowering.access$getCalculator$p(this.this$0.this$0);
                        boolean bl = false;
                        boolean bl2 = false;
                        JsIrArithBuilder $this$run = jsIrArithBuilder;
                        boolean bl3 = false;
                        return $this$run.shr($this$run.shl($this$run.and(arg, mask), shift), shift.copy());
                    }
                    {
                        this.this$0 = var1_1;
                        super(3);
                    }
                };
                boolean bl7 = false;
                List newStatements = new ArrayList<E>();
                Function0<IrExpressionWithCopy> argument = this.cacheValue(expression2.getArgument(), newStatements, declaration2);
                if (IrTypePredicatesKt.isByte(toType)) {
                    irExpression = $fun$maskOp$1.invoke((IrExpression)argument.invoke(), (IrExpression)TypeOperatorLowering.access$getByteMask$p(this.this$0), (IrExpressionWithCopy)TypeOperatorLowering.access$getLit24$p(this.this$0));
                } else if (IrTypePredicatesKt.isShort(toType)) {
                    irExpression = $fun$maskOp$1.invoke((IrExpression)argument.invoke(), (IrExpression)TypeOperatorLowering.access$getShortMask$p(this.this$0), (IrExpressionWithCopy)TypeOperatorLowering.access$getLit16$p(this.this$0));
                } else if (IrTypePredicatesKt.isLong(toType)) {
                    object = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsToLong(), null, null, 6, null);
                    boolean bl8 = false;
                    bl = false;
                    Object $this$apply = object;
                    boolean bl9 = false;
                    $this$apply.putValueArgument(0, argument.invoke());
                    irExpression = (IrExpression)object;
                } else {
                    String string = "Unreachable execution (coercion to non-Integer type";
                    boolean bl10 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                IrExpression casted = irExpression;
                object = newStatements;
                IrExpression irExpression2 = isNullable2 ? (IrExpression)JsIrBuilder.INSTANCE.buildIfElse(toType, this.nullCheck(argument.invoke()), TypeOperatorLowering.access$getLitNull$p(this.this$0), casted) : casted;
                bl = false;
                object.add(irExpression2);
                object = expression2;
                boolean bl11 = false;
                bl = false;
                Object $this$run = object;
                boolean bl12 = false;
                return new IrCompositeImpl($this$run.getStartOffset(), $this$run.getEndOffset(), toType, null, newStatements);
            }
            {
                this.this$0 = $outer;
            }

            @NotNull
            public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
            }

            @NotNull
            public IrBody visitBlockBody(@NotNull IrBlockBody body, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(body, "body");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitBlockBody(this, body, data);
            }

            @NotNull
            public IrBody visitBody(@NotNull IrBody body, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(body, "body");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitBody(this, body, data);
            }

            @NotNull
            public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(branch, "branch");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
            }

            @NotNull
            public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(jump, "jump");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
            }

            @NotNull
            public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(jump, "jump");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            @NotNull
            public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
            }

            @NotNull
            public IrElement visitCallableReference(@NotNull IrCallableReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            @NotNull
            public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
            }

            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitClass(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
            }

            @NotNull
            public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
            }

            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
            }

            @NotNull
            public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            @NotNull
            public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(jump, "jump");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
            }

            @NotNull
            public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            @NotNull
            public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            @NotNull
            public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(loop2, "loop");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
            }

            @NotNull
            public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            @NotNull
            public IrElement visitElement(@NotNull IrElement element, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
            }

            @NotNull
            public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(branch, "branch");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
            }

            @NotNull
            public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            @NotNull
            public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            @NotNull
            public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
            }

            @NotNull
            public IrBody visitExpressionBody(@NotNull IrExpressionBody body, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(body, "body");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body, data);
            }

            @NotNull
            public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
            }

            @NotNull
            public IrStatement visitField(@NotNull IrField declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitField(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            @NotNull
            public IrFile visitFile(@NotNull IrFile declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitFile(this, declaration2, data);
            }

            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitFunction(this, declaration2, data);
            }

            @NotNull
            public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            @NotNull
            public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
            }

            @NotNull
            public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            @NotNull
            public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
            }

            @NotNull
            public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(loop2, "loop");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
            }

            @NotNull
            public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            @NotNull
            public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
            }

            @NotNull
            public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
            }

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitProperty(this, declaration2, data);
            }

            @NotNull
            public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSetVariable(@NotNull IrSetVariable expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitSetVariable(this, expression2, data);
            }

            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            @NotNull
            public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(spread, "spread");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            @NotNull
            public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            @NotNull
            public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(body, "body");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body, data);
            }

            @NotNull
            public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
            }

            @NotNull
            public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(aTry, "aTry");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
            }

            @NotNull
            public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            @NotNull
            public IrStatement visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
            }

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitVariable(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
            }

            @NotNull
            public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(loop2, "loop");
                Intrinsics.checkParameterIsNotNull(data, "data");
                return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
            }
        }, irFile);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public TypeOperatorLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
        this.unit = this.context.getIrBuiltIns().getUnitType();
        this.calculator = new JsIrArithBuilder(this.context);
        this.throwCCE = this.context.getIr().getSymbols().getThrowTypeCastException();
        this.throwNPE = this.context.getIr().getSymbols().getThrowNullPointerException();
        this.eqeq = this.context.getIrBuiltIns().getEqeqSymbol();
        this.isSuspendFunctionSymbol = this.context.getIntrinsics().isSuspendFunctionSymbol();
        this.instanceOfIntrinsicSymbol = this.context.getIntrinsics().getJsInstanceOf();
        this.typeOfIntrinsicSymbol = this.context.getIntrinsics().getJsTypeOf();
        this.jsClassIntrinsicSymbol = this.context.getIntrinsics().getJsClass();
    }

    public static final /* synthetic */ IrFunctionSymbol access$getThrowNPE$p(TypeOperatorLowering $this) {
        return $this.throwNPE;
    }

    public static final /* synthetic */ IrExpression access$getLitNull$p(TypeOperatorLowering $this) {
        return $this.getLitNull();
    }

    public static final /* synthetic */ IrFunctionSymbol access$getThrowCCE$p(TypeOperatorLowering $this) {
        return $this.throwCCE;
    }

    public static final /* synthetic */ JsIrArithBuilder access$getCalculator$p(TypeOperatorLowering $this) {
        return $this.calculator;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getEqeq$p(TypeOperatorLowering $this) {
        return $this.eqeq;
    }

    public static final /* synthetic */ IrExpression access$getLitFalse$p(TypeOperatorLowering $this) {
        return $this.getLitFalse();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isObjectSymbol$p(TypeOperatorLowering $this) {
        return $this.isObjectSymbol();
    }

    public static final /* synthetic */ IrExpression access$getLitTrue$p(TypeOperatorLowering $this) {
        return $this.getLitTrue();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isSuspendFunctionSymbol$p(TypeOperatorLowering $this) {
        return $this.isSuspendFunctionSymbol;
    }

    public static final /* synthetic */ IrConstImpl access$getFunctionMarker$p(TypeOperatorLowering $this) {
        return $this.getFunctionMarker();
    }

    public static final /* synthetic */ IrConstImpl access$getBooleanMarker$p(TypeOperatorLowering $this) {
        return $this.getBooleanMarker();
    }

    public static final /* synthetic */ IrConstImpl access$getStringMarker$p(TypeOperatorLowering $this) {
        return $this.getStringMarker();
    }

    public static final /* synthetic */ IrConstImpl access$getNumberMarker$p(TypeOperatorLowering $this) {
        return $this.getNumberMarker();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getTypeOfIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.typeOfIntrinsicSymbol;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getJsClassIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.jsClassIntrinsicSymbol;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isArraySymbol$p(TypeOperatorLowering $this) {
        return $this.isArraySymbol();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isInterfaceSymbol$p(TypeOperatorLowering $this) {
        return $this.isInterfaceSymbol();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getInstanceOfIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.instanceOfIntrinsicSymbol;
    }

    public static final /* synthetic */ IrType access$getUnit$p(TypeOperatorLowering $this) {
        return $this.unit;
    }

    public static final /* synthetic */ IrGetObjectValueImpl access$getUnitValue$p(TypeOperatorLowering $this) {
        return $this.getUnitValue();
    }

    public static final /* synthetic */ IrConstImpl access$getByteMask$p(TypeOperatorLowering $this) {
        return $this.getByteMask();
    }

    public static final /* synthetic */ IrConstImpl access$getLit24$p(TypeOperatorLowering $this) {
        return $this.getLit24();
    }

    public static final /* synthetic */ IrConstImpl access$getShortMask$p(TypeOperatorLowering $this) {
        return $this.getShortMask();
    }

    public static final /* synthetic */ IrConstImpl access$getLit16$p(TypeOperatorLowering $this) {
        return $this.getLit16();
    }
}

