/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import org.coode.mdock.Node;
import org.coode.mdock.Splitter;
import org.coode.mdock.SplitterNode;
import org.coode.mdock.Util;

public class HorizontalSplitter
extends Splitter {
    public HorizontalSplitter(SplitterNode node, Node child0, Node child1) {
        super(node, child0, child1);
    }

    @Override
    public void resetBounds() {
        int x = Util.getX(this.getChild1(), this.getParent(), false) + 3 + 1;
        int y = Util.getY(this.getChild1(), this.getParent(), false) - 3 + 1;
        int w = Util.getWidth(this.getChild1(), this.getParent(), false) - 6 - 2;
        int h = 4;
        this.setBounds(x, y, w, h);
    }

    @Override
    public Point getMaxLocation() {
        int x = Util.getX(this.getChild1(), this.getParent(), false) + 3;
        int y = Util.getY(this.getChild1(), this.getParent(), false) - 6;
        int h = Util.getHeight(this.getChild1(), this.getParent(), false);
        return new Point(x, y + h);
    }

    @Override
    public Point getMinLocation() {
        int x = Util.getX(this.getChild0(), this.getParent(), false) + 3;
        int y = Util.getY(this.getChild0(), this.getParent(), false);
        return new Point(x, y);
    }

    @Override
    protected int getSpan(Node child, Component parent, boolean includingSplitter) {
        return Util.getHeight(child, parent, includingSplitter);
    }

    @Override
    protected int convertToLocation(Point pt) {
        return pt.y;
    }

    @Override
    protected void setSplitterCursor() {
        this.setCursor(Cursor.getPredefinedCursor(8));
    }
}

