/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.SamplingThread;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Stacks;
import org.netbeans.lib.profiler.server.system.Timers;

class ProfilerRuntimeSampler
extends ProfilerRuntime {
    private static Sampling sampling;
    private static int samplingFrequency;

    ProfilerRuntimeSampler() {
    }

    static void setSamplngFrequency(int n) {
        samplingFrequency = n;
    }

    static void initialize() {
        sampling = new Sampling(samplingFrequency);
        sampling.start();
    }

    public static void shutdown() {
        sampling.terminate();
        sampling = null;
        ProfilerRuntime.clearDataStructures();
    }

    static void resetProfilerCollectors() {
        if (sampling != null) {
            sampling.resetData = true;
        }
    }

    static {
        samplingFrequency = 10;
    }

    static class Sampling
    extends SamplingThread {
        private int[] states = new int[0];
        private int[][] methodIds = new int[0][];
        private Map arrayOffsetMap = new HashMap();
        private Map threadIdMap = new HashMap();
        private volatile boolean resetData = false;
        private boolean sendDataAvailable = true;

        Sampling(int n) {
            super(n);
            this.setName("*** Profiler Agent Special Execution Thread 10");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void sample() {
            Thread[][] threadArray = new Thread[1][];
            int[][] nArrayArray = new int[1][];
            int[][][] nArrayArray2 = new int[1][][];
            HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
            HashMap<Long, Integer> hashMap2 = new HashMap<Long, Integer>();
            if (this.resetData) {
                this.resetProfilerCollectors();
                this.resetData = false;
                this.sendDataAvailable = true;
            }
            Stacks.getAllStackTraces(threadArray, nArrayArray, nArrayArray2);
            long l = Timers.getCurrentTimeInCounts();
            if (threadArray[0] == null || ProfilerRuntime.eventBuffer == null) return;
            byte[] byArray = ProfilerRuntime.eventBuffer;
            synchronized (ProfilerRuntime.eventBuffer) {
                if (this.resetData) {
                    // ** MonitorExit[var8_7] (shouldn't be in output)
                    return;
                }
                this.writeThreadDumpStart(l);
                for (int i = 0; i < threadArray[0].length; ++i) {
                    Thread thread = threadArray[0][i];
                    int[] nArray = nArrayArray2[0][i];
                    if (ThreadInfo.isProfilerServerThread(thread)) continue;
                    int n = nArrayArray[0][i];
                    Long l2 = thread.getId();
                    Integer n2 = (Integer)this.arrayOffsetMap.get(l2);
                    Integer n3 = (Integer)this.threadIdMap.get(l2);
                    if (n2 != null) {
                        if (n == this.states[n2] && Arrays.equals(nArray, this.methodIds[n2])) {
                            this.writeThreadInfoNoChange(n3);
                        } else {
                            this.writeThreadInfo(n3, n, nArray);
                        }
                    } else {
                        if (n == 0 || nArray.length <= 0) continue;
                        ThreadInfo threadInfo = ThreadInfo.getThreadInfo(thread);
                        n3 = new Integer(threadInfo.getThreadId());
                        if (!threadInfo.isInitialized()) {
                            threadInfo.initialize();
                            ProfilerRuntime.writeThreadCreationEvent(thread, n3);
                        }
                        this.writeThreadInfo(n3, n, nArray);
                    }
                    hashMap.put(l2, new Integer(i));
                    hashMap2.put(l2, n3);
                }
                this.writeThreadDumpEnd();
                // ** MonitorExit[var8_7] (shouldn't be in output)
                this.arrayOffsetMap = hashMap;
                this.threadIdMap = hashMap2;
                this.states = nArrayArray[0];
                this.methodIds = nArrayArray2[0];
                return;
            }
        }

        private void resetProfilerCollectors() {
            this.arrayOffsetMap = new HashMap();
            this.threadIdMap = new HashMap();
            this.states = new int[0];
            this.methodIds = new int[0][];
        }

        private void writeThreadDumpStart(long l) {
            int n;
            if (ProfilerRuntime.eventBuffer == null) {
                return;
            }
            if (this.sendDataAvailable) {
                ProfilerServer.notifyClientOnResultsAvailability();
                this.sendDataAvailable = false;
            }
            if ((n = ProfilerRuntime.globalEvBufPos) + 8 > ProfilerRuntime.globalEvBufPosThreshold) {
                ProfilerRuntime.externalActionsHandler.handleEventBufferDump(ProfilerRuntime.eventBuffer, 0, n);
                n = 0;
            }
            ProfilerRuntime.eventBuffer[n++] = 31;
            ProfilerRuntime.eventBuffer[n++] = (byte)(l >> 48 & 0xFFL);
            ProfilerRuntime.eventBuffer[n++] = (byte)(l >> 40 & 0xFFL);
            ProfilerRuntime.eventBuffer[n++] = (byte)(l >> 32 & 0xFFL);
            ProfilerRuntime.eventBuffer[n++] = (byte)(l >> 24 & 0xFFL);
            ProfilerRuntime.eventBuffer[n++] = (byte)(l >> 16 & 0xFFL);
            ProfilerRuntime.eventBuffer[n++] = (byte)(l >> 8 & 0xFFL);
            ProfilerRuntime.eventBuffer[n++] = (byte)(l & 0xFFL);
            ProfilerRuntime.globalEvBufPos = n;
        }

        private void writeThreadDumpEnd() {
            if (ProfilerRuntime.eventBuffer == null) {
                return;
            }
            int n = ProfilerRuntime.globalEvBufPos;
            if (n + 1 > ProfilerRuntime.globalEvBufPosThreshold) {
                ProfilerRuntime.externalActionsHandler.handleEventBufferDump(ProfilerRuntime.eventBuffer, 0, n);
                n = 0;
            }
            ProfilerRuntime.eventBuffer[n++] = 32;
            ProfilerRuntime.globalEvBufPos = n;
        }

        private void writeThreadInfoNoChange(Integer n) {
            if (ProfilerRuntime.eventBuffer == null) {
                return;
            }
            int n2 = ProfilerRuntime.globalEvBufPos;
            if (n2 + 3 > ProfilerRuntime.globalEvBufPosThreshold) {
                ProfilerRuntime.externalActionsHandler.handleEventBufferDump(ProfilerRuntime.eventBuffer, 0, n2);
                n2 = 0;
            }
            int n3 = n;
            ProfilerRuntime.eventBuffer[n2++] = 33;
            ProfilerRuntime.eventBuffer[n2++] = (byte)(n3 >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[n2++] = (byte)(n3 & 0xFF);
            ProfilerRuntime.globalEvBufPos = n2;
        }

        private void writeThreadInfo(Integer n, int n2, int[] nArray) {
            if (ProfilerRuntime.eventBuffer == null) {
                return;
            }
            int n3 = ProfilerRuntime.globalEvBufPos;
            if (n3 + 6 + nArray.length * 4 > ProfilerRuntime.globalEvBufPosThreshold) {
                ProfilerRuntime.externalActionsHandler.handleEventBufferDump(ProfilerRuntime.eventBuffer, 0, n3);
                n3 = 0;
            }
            int n4 = n;
            int n5 = nArray.length;
            ProfilerRuntime.eventBuffer[n3++] = 34;
            ProfilerRuntime.eventBuffer[n3++] = (byte)(n4 >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[n3++] = (byte)(n4 & 0xFF);
            ProfilerRuntime.eventBuffer[n3++] = (byte)(n2 & 0xFF);
            ProfilerRuntime.eventBuffer[n3++] = (byte)(n5 >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[n3++] = (byte)(n5 & 0xFF);
            for (int i = 0; i < nArray.length; ++i) {
                ProfilerRuntime.eventBuffer[n3++] = (byte)(nArray[i] >> 24 & 0xFF);
                ProfilerRuntime.eventBuffer[n3++] = (byte)(nArray[i] >> 16 & 0xFF);
                ProfilerRuntime.eventBuffer[n3++] = (byte)(nArray[i] >> 8 & 0xFF);
                ProfilerRuntime.eventBuffer[n3++] = (byte)(nArray[i] & 0xFF);
            }
            ProfilerRuntime.globalEvBufPos = n3;
        }
    }
}

