/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.gnome;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.proxy.NetworkProxySettings;
import org.netbeans.core.network.proxy.gnome.GnomeNetworkProxy;

public class GconfNetworkProxy {
    private static final Logger LOGGER = Logger.getLogger(GconfNetworkProxy.class.getName());
    private static final String EQUALS = "=";
    private static final String COLON = ",";
    private static final String SQ_BRACKET_LEFT = "[";
    private static final String SQ_BRACKET_RIGHT = "]";
    protected static final String GCONF_PATH = "/usr/bin/gconftool-2";
    private static final String GCONF_ARGUMENT_LIST_RECURSIVELY = " -R ";
    private static final String GCONF_NODE_PROXY = "/system/proxy";
    private static final String GCONF_NODE_HTTP_PROXY = "/system/http_proxy";
    private static final String GCONF_KEY_MODE = "mode";
    private static final String GCONF_KEY_PAC_URL = "autoconfig_url";
    private static final String GCONF_KEY_HTTP_ALL = "use_http_proxy";
    private static final String GCONF_KEY_HTTP_HOST = "host";
    private static final String GCONF_KEY_HTTP_PORT = "port";
    private static final String GCONF_KEY_HTTPS_HOST = "secure_host";
    private static final String GCONF_KEY_HTTPS_PORT = "secure_port";
    private static final String GCONF_KEY_SOCKS_HOST = "socks_host";
    private static final String GCONF_KEY_SOCKS_PORT = "socks_port";
    private static final String GCONF_KEY_IGNORE_HOSTS = "ignore_hosts";
    private static final String GCONF_VALUE_NONE = "none";
    private static final String GCONF_VALUE_AUTO = "auto";
    private static final String GCONF_VALUE_MANUAL = "manual";

    protected static NetworkProxySettings getNetworkProxySettings() {
        LOGGER.log(Level.FINE, "GConf system proxy resolver started.");
        Map<String, String> map = GconfNetworkProxy.getGconfMap(GCONF_NODE_PROXY);
        String string = map.get(GCONF_KEY_MODE);
        if (string == null) {
            LOGGER.log(Level.SEVERE, "GConf proxy mode is null.");
            return new NetworkProxySettings(false);
        }
        if (string.equals(GCONF_VALUE_NONE)) {
            LOGGER.log(Level.INFO, "GConf system proxy resolver: direct connection");
            return new NetworkProxySettings();
        }
        if (string.equals(GCONF_VALUE_AUTO)) {
            String string2 = map.get(GCONF_KEY_PAC_URL);
            LOGGER.log(Level.INFO, "GConf system proxy resolver: auto - PAC ({0})", string2);
            if (string2 != null) {
                return new NetworkProxySettings(string2);
            }
            return new NetworkProxySettings("");
        }
        if (string.equals(GCONF_VALUE_MANUAL)) {
            map.putAll(GconfNetworkProxy.getGconfMap(GCONF_NODE_HTTP_PROXY));
            String string3 = map.get(GCONF_KEY_HTTP_ALL);
            String string4 = map.get(GCONF_KEY_HTTP_HOST);
            String string5 = map.get(GCONF_KEY_HTTP_PORT);
            String string6 = map.get(GCONF_KEY_IGNORE_HOSTS);
            LOGGER.log(Level.INFO, "GConf system proxy resolver: manual - http for all ({0})", string3);
            LOGGER.log(Level.INFO, "GConf system proxy resolver: manual - http host ({0})", string4);
            LOGGER.log(Level.INFO, "GConf system proxy resolver: manual - http port ({0})", string5);
            LOGGER.log(Level.INFO, "GConf system proxy resolver: manual - no proxy hosts ({0})", string6);
            if (string3 != null && Boolean.parseBoolean(string3)) {
                return new NetworkProxySettings(string4, string5, GconfNetworkProxy.getNoProxyHosts(string6));
            }
            String string7 = map.get(GCONF_KEY_HTTPS_HOST);
            String string8 = map.get(GCONF_KEY_HTTPS_PORT);
            String string9 = map.get(GCONF_KEY_SOCKS_HOST);
            String string10 = map.get(GCONF_KEY_SOCKS_PORT);
            LOGGER.log(Level.INFO, "GConf system proxy resolver: manual - https host ({0})", string7);
            LOGGER.log(Level.INFO, "GConf system proxy resolver: manual - https port ({0})", string8);
            LOGGER.log(Level.INFO, "GConf system proxy resolver: manual - socks host ({0})", string9);
            LOGGER.log(Level.INFO, "GConf system proxy resolver: manual - socks port ({0})", string10);
            return new NetworkProxySettings(string4, string5, string7, string8, string9, string10, GconfNetworkProxy.getNoProxyHosts(string6));
        }
        return new NetworkProxySettings(false);
    }

    protected static boolean isGconfValid() {
        String string = "/usr/bin/gconftool-2 -R /system/proxy";
        try {
            BufferedReader bufferedReader = GnomeNetworkProxy.executeCommand(string);
            if (bufferedReader.ready()) {
                return true;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Cannot read line: " + string, iOException);
        }
        LOGGER.log(Level.WARNING, "GConf return empty list");
        return false;
    }

    private static Map<String, String> getGconfMap(String string) {
        HashMap<String, String> hashMap;
        block5: {
            hashMap = new HashMap<String, String>();
            String string2 = "/usr/bin/gconftool-2 -R " + string;
            try {
                BufferedReader bufferedReader = GnomeNetworkProxy.executeCommand(string2);
                if (bufferedReader != null) {
                    String string3 = bufferedReader.readLine();
                    while (string3 != null) {
                        String string4 = GconfNetworkProxy.getKey(string3).toLowerCase();
                        if (string4 != null && !string4.isEmpty()) {
                            String string5 = GconfNetworkProxy.getValue(string3);
                            hashMap.put(string4, string5);
                        }
                        string3 = bufferedReader.readLine();
                    }
                    break block5;
                }
                return hashMap;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Cannot read line: " + string2, iOException);
            }
        }
        return hashMap;
    }

    private static String getKey(String string) {
        return string.substring(0, string.indexOf(EQUALS)).trim();
    }

    private static String getValue(String string) {
        return string.substring(string.indexOf(EQUALS) + 1).trim();
    }

    private static String[] getNoProxyHosts(String string) {
        if (string != null && !string.isEmpty()) {
            if (string.startsWith(SQ_BRACKET_LEFT)) {
                string = string.substring(1);
            }
            if (string.endsWith(SQ_BRACKET_RIGHT)) {
                string = string.substring(0, string.length() - 1);
            }
            return string.split(COLON);
        }
        return new String[0];
    }
}

