/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.details;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.profiler.snaptracer.impl.details.DetailsTable;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderPanel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.ScrollBar;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;

public final class DetailsPanel
extends JPanel {
    private JPanel noDataContainer;
    private JComponent dataContainer;
    private JScrollBar scrollBar;
    private DetailsTable table;
    private final TimelineSupport support;
    private boolean selectionAdjusting;
    private KeyStroke tableKeyStroke;

    public DetailsPanel(TimelineSupport timelineSupport) {
        this.support = timelineSupport;
        this.initComponents();
        this.initListeners();
    }

    public void setTableModel(TableModel tableModel) {
        if (tableModel == null) {
            this.table.clearSelection();
            this.table.setModel(new DefaultTableModel());
            this.removeAll();
            this.add((Component)this.noDataContainer, "Center");
        } else {
            int n = this.getSelectedRow();
            this.table.setModel(tableModel);
            if (n != -1) {
                this.table.getSelectionModel().setSelectionInterval(n, n);
            }
            this.removeAll();
            this.add((Component)this.dataContainer, "Center");
        }
        this.validate();
        this.repaint();
    }

    private void initListeners() {
        TableListener tableListener = new TableListener();
        this.table.getSelectionModel().addListSelectionListener(tableListener);
        this.table.addKeyListener(tableListener);
        this.table.addMouseListener(tableListener);
    }

    private int getSelectedRow() {
        int n = this.table.getSelectedRow();
        return n == -1 ? -1 : this.table.convertRowIndexToModel(n);
    }

    private boolean isTrackingEnd() {
        if (this.scrollBar == null) {
            return false;
        }
        return this.scrollBar.getValue() + this.scrollBar.getVisibleAmount() >= this.scrollBar.getMaximum();
    }

    private boolean isSelectionChanging() {
        if (this.selectionAdjusting) {
            return true;
        }
        if (this.tableKeyStroke == null) {
            return false;
        }
        return this.table.getActionForKeyStroke(this.tableKeyStroke) != null;
    }

    private void initComponents() {
        this.table = new DetailsTable();
        this.table.getSelectionModel().setSelectionMode(0);
        Viewport viewport = new Viewport(this.table);
        final JScrollPane jScrollPane = new JScrollPane(22, 30);
        jScrollPane.setViewport(viewport);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", new HeaderPanel());
        this.scrollBar = new ScrollBar(1){

            @Override
            public int getUnitIncrement(int n) {
                JViewport jViewport = jScrollPane.getViewport();
                Scrollable scrollable = (Scrollable)((Object)jViewport.getView());
                Rectangle rectangle = jViewport.getViewRect();
                return scrollable.getScrollableUnitIncrement(rectangle, this.getOrientation(), n);
            }

            @Override
            public int getBlockIncrement(int n) {
                JViewport jViewport = jScrollPane.getViewport();
                Scrollable scrollable = (Scrollable)((Object)jViewport.getView());
                Rectangle rectangle = jViewport.getViewRect();
                return scrollable.getScrollableBlockIncrement(rectangle, this.getOrientation(), n);
            }

            @Override
            public void setValues(int n, int n2, int n3, int n4) {
                this.setEnabled(n2 < n4);
                if (this.isEnabled() && !DetailsPanel.this.isSelectionChanging() && DetailsPanel.this.isTrackingEnd()) {
                    n = n4 - n2;
                }
                super.setValues(n, n2, n3, n4);
            }
        };
        jScrollPane.setVerticalScrollBar(this.scrollBar);
        this.dataContainer = jScrollPane;
        JLabel jLabel = new JLabel("<No probe selected>", 0);
        jLabel.setEnabled(false);
        this.noDataContainer = new JPanel(new BorderLayout());
        this.noDataContainer.setOpaque(false);
        this.noDataContainer.add((Component)jLabel, "Center");
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.noDataContainer, "Center");
    }

    private static class Viewport
    extends JViewport {
        private final DetailsTable view;
        private final Color background;

        Viewport(DetailsTable detailsTable) {
            this.setView(detailsTable);
            this.view = detailsTable;
            this.setOpaque(true);
            this.background = detailsTable.getBackground();
            this.setBackground(this.background);
            detailsTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                    Viewport.this.repaint();
                }

                @Override
                public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                    Viewport.this.repaint();
                }

                @Override
                public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                    Viewport.this.repaint();
                }

                @Override
                public void columnMarginChanged(ChangeEvent changeEvent) {
                    Viewport.this.repaint();
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                }
            });
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.paintVerticalLines(graphics);
        }

        private void paintVerticalLines(Graphics graphics) {
            int n = this.getHeight();
            int n2 = this.view.getHeight();
            if (n2 >= n) {
                return;
            }
            graphics.setColor(this.background);
            graphics.fillRect(0, n2, this.getWidth(), this.getHeight() - n2);
            int n3 = 0;
            TableColumnModel tableColumnModel = this.view.getColumnModel();
            int n4 = tableColumnModel.getColumnCount();
            graphics.setColor(DetailsTable.DEFAULT_GRID_COLOR);
            for (int i = 0; i < n4; ++i) {
                int n5 = tableColumnModel.getColumn(i).getWidth();
                graphics.drawLine((n3 += n5) - 1, n2, n3 - 1, n);
            }
        }
    }

    private class TableListener
    extends MouseAdapter
    implements ListSelectionListener,
    KeyListener {
        private TableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DetailsPanel.this.selectionAdjusting = listSelectionEvent.getValueIsAdjusting();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            DetailsPanel.this.tableKeyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            DetailsPanel.this.tableKeyStroke = null;
            if (keyEvent.getKeyCode() == 32) {
                DetailsPanel.this.support.scrollChartToIndex(DetailsPanel.this.getSelectedRow());
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                DetailsPanel.this.support.scrollChartToIndex(DetailsPanel.this.getSelectedRow());
            }
        }
    }
}

