/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import java.io.IOException;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class MultiTermVectorsItemResponse
implements Streamable {
    private TermVectorsResponse response;
    private MultiTermVectorsResponse.Failure failure;

    MultiTermVectorsItemResponse() {
    }

    public MultiTermVectorsItemResponse(TermVectorsResponse response, MultiTermVectorsResponse.Failure failure) {
        assert (response == null && failure != null || response != null && failure == null);
        this.response = response;
        this.failure = failure;
    }

    public String getIndex() {
        if (this.failure != null) {
            return this.failure.getIndex();
        }
        return this.response.getIndex();
    }

    public String getType() {
        if (this.failure != null) {
            return this.failure.getType();
        }
        return this.response.getType();
    }

    public String getId() {
        if (this.failure != null) {
            return this.failure.getId();
        }
        return this.response.getId();
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public TermVectorsResponse getResponse() {
        return this.response;
    }

    public MultiTermVectorsResponse.Failure getFailure() {
        return this.failure;
    }

    public static MultiTermVectorsItemResponse readItemResponse(StreamInput in) throws IOException {
        MultiTermVectorsItemResponse response = new MultiTermVectorsItemResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.failure = MultiTermVectorsResponse.Failure.readFailure(in);
        } else {
            this.response = new TermVectorsResponse(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.failure != null) {
            out.writeBoolean(true);
            this.failure.writeTo(out);
        } else {
            out.writeBoolean(false);
            this.response.writeTo(out);
        }
    }
}

