/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"

#include"getput.h"
#include"bravais.h"
#include"matrix.h"

int INFO_LEVEL;

int main (int argc, char *argv[])
{
  int anz,
      i;

  rational *r;

  matrix_TYP **F;

  bravais_TYP *G,
              *H;

  read_header(argc, argv);
  if(FILEANZ != 1)
  {
    printf("Usage: %s 'file' [-n] [-i]\n",argv[0]);
    printf("\n");
    printf("file: bravais_TYP of the finite unimodular group G.\n");
    printf("\n");
    printf("Calculates the transposed group of G.\n");
    printf("\n");
    printf("Options:\n");
    printf("-n    : The space of invariant forms of the transposed group is not\n");
    printf("        calculated.\n");
    printf("-i    : Invert the generators of G, G->normal, G->cen to give an isomorphism.\n");
    printf("\n");
    printf("Cf. Tr.\n");
    if (is_option('h')){
       exit(0);
    }
    else{
       exit(31);
    }
  }

  G = get_bravais(FILENAMES[0]);
  H = tr_bravais(G,!is_option('n'),is_option('i'));

  if (G->order){
     H->order = G->order;
     factorize_new(H->order,H->divisors);
  }

  put_bravais(H,NULL,NULL);

  exit(0);
}
