/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "tools.h"

/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: ovfl_mul.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

/* 
@-------------------------------------------------------------------------
@  int ovfl_mul( a, b);
@ int a,b;
@
@  The routine should catch an integer-overflow.
@  Slow. Unluckily "c" does not provide machine-independent access to the
@  integer hardware overflow-routines.
@  if there is no overflow the function returns the product a*b,
@  otherwise the program exits.
@
@-------------------------------------------------------------------------
 */
int ovfl_mul( a, b)
int a, b;
{ 
register int result;

  result = a * b;
  if ( result / a != b ) {
    fprintf(stderr,"ovfl_mul: Error: Integer overflow during multiplication\n");
    fprintf(stderr,"left operand: 0x%08x, right operand: 0x%08x, result: 0x%08x\n", a, b, result );
    exit(3);
  }                
  return result;
}

/*{{{}}}*/
