/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Comparator;
import java.util.Objects;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.data.osm.search.SearchSetting;

public class Filter
extends SearchSetting
implements Comparable<Filter> {
    private static final String version = "1";
    public boolean enable = true;
    public boolean hiding;
    public boolean inverted;

    public Filter() {
        this.mode = SearchMode.add;
    }

    public Filter(SearchSetting setting) {
        super(setting);
    }

    public Filter(FilterPreferenceEntry e) {
        this();
        this.text = e.text;
        if ("replace".equals(e.mode)) {
            this.mode = SearchMode.replace;
        } else if ("add".equals(e.mode)) {
            this.mode = SearchMode.add;
        } else if ("remove".equals(e.mode)) {
            this.mode = SearchMode.remove;
        } else if ("in_selection".equals(e.mode)) {
            this.mode = SearchMode.in_selection;
        }
        this.caseSensitive = e.case_sensitive;
        this.regexSearch = e.regex_search;
        this.mapCSSSearch = e.mapCSS_search;
        this.enable = e.enable;
        this.hiding = e.hiding;
        this.inverted = e.inverted;
    }

    public FilterPreferenceEntry getPreferenceEntry() {
        FilterPreferenceEntry e = new FilterPreferenceEntry();
        e.version = version;
        e.text = this.text;
        e.mode = this.mode.name();
        e.case_sensitive = this.caseSensitive;
        e.regex_search = this.regexSearch;
        e.mapCSS_search = this.mapCSSSearch;
        e.enable = this.enable;
        e.hiding = this.hiding;
        e.inverted = this.inverted;
        return e;
    }

    @Override
    public int compareTo(Filter o) {
        return Comparator.comparing(f -> f.text).thenComparing(f -> f.mode).thenComparing(f -> f.caseSensitive).thenComparing(f -> f.regexSearch).thenComparing(f -> f.mapCSSSearch).thenComparing(f -> f.enable).thenComparing(f -> f.hiding).thenComparing(f -> f.inverted).compare(this, o);
    }

    public static class FilterPreferenceEntry {
        @StructUtils.WriteExplicitly
        @StructUtils.StructEntry
        public String version = "1";
        @StructUtils.StructEntry
        public String text;
        @StructUtils.WriteExplicitly
        @StructUtils.StructEntry
        public String mode = "add";
        @StructUtils.StructEntry
        public boolean case_sensitive;
        @StructUtils.StructEntry
        public boolean regex_search;
        @StructUtils.StructEntry
        public boolean mapCSS_search;
        @StructUtils.WriteExplicitly
        @StructUtils.StructEntry
        public boolean enable = true;
        @StructUtils.WriteExplicitly
        @StructUtils.StructEntry
        public boolean hiding;
        @StructUtils.WriteExplicitly
        @StructUtils.StructEntry
        public boolean inverted;

        public int hashCode() {
            return Objects.hash(this.case_sensitive, this.enable, this.hiding, this.inverted, this.mapCSS_search, this.mode, this.regex_search, this.text, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FilterPreferenceEntry other = (FilterPreferenceEntry)obj;
            return this.case_sensitive == other.case_sensitive && this.enable == other.enable && this.hiding == other.hiding && this.inverted == other.inverted && this.mapCSS_search == other.mapCSS_search && this.regex_search == other.regex_search && Objects.equals(this.mode, other.mode) && Objects.equals(this.text, other.text) && Objects.equals(this.version, other.version);
        }
    }
}

