/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openstreetmap.josm.tools.I18n;

public class OptionParser {
    private HashMap<String, AvailableOption> availableOptions = new HashMap();
    private final String program;

    public OptionParser(String program) {
        Objects.requireNonNull(program, "program name must be provided");
        this.program = program;
    }

    public OptionParser addShortAlias(String optionName, String shortName) {
        if (!shortName.matches("\\w")) {
            throw new IllegalArgumentException("Short name '" + shortName + "' must be one character");
        }
        if (this.availableOptions.containsKey("-" + shortName)) {
            throw new IllegalArgumentException("Short name '" + shortName + "' is already used");
        }
        AvailableOption longDefinition = this.availableOptions.get("--" + optionName);
        if (longDefinition == null) {
            throw new IllegalArgumentException("No long definition for " + optionName + " was defined. Define the long definition first before creating a short definition for it.");
        }
        this.availableOptions.put("-" + shortName, longDefinition);
        return this;
    }

    public OptionParser addFlagParameter(String optionName, Runnable handler) {
        this.checkOptionName(optionName);
        this.availableOptions.put("--" + optionName, parameter -> handler.run());
        return this;
    }

    private void checkOptionName(String optionName) {
        if (!optionName.matches("\\w([\\w-]*\\w)?")) {
            throw new IllegalArgumentException("Illegal option name: '" + optionName + "'");
        }
        if (this.availableOptions.containsKey("--" + optionName)) {
            throw new IllegalArgumentException("The option '--" + optionName + "' is already registered");
        }
    }

    public OptionParser addArgumentParameter(String optionName, final OptionCount count, final Consumer<String> handler) {
        this.checkOptionName(optionName);
        this.availableOptions.put("--" + optionName, new AvailableOption(){

            @Override
            public boolean requiresParameter() {
                return true;
            }

            @Override
            public OptionCount getRequiredCount() {
                return count;
            }

            @Override
            public void runFor(String parameter) {
                Objects.requireNonNull(parameter, "parameter");
                handler.accept(parameter);
            }
        });
        return this;
    }

    public List<String> parseOptionsOrExit(List<String> arguments) {
        try {
            return this.parseOptions(arguments);
        }
        catch (OptionParseException e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(1);
            throw e;
        }
    }

    public List<String> parseOptions(List<String> arguments) {
        LinkedList<String> toHandle = new LinkedList<String>(arguments);
        LinkedList<String> remainingArguments = new LinkedList<String>();
        boolean argumentOnlyMode = false;
        LinkedList<FoundOption> options = new LinkedList<FoundOption>();
        while (!toHandle.isEmpty()) {
            String next = toHandle.removeFirst();
            if (argumentOnlyMode || !next.matches("-.+")) {
                remainingArguments.add(next);
                continue;
            }
            if ("--".equals(next)) {
                argumentOnlyMode = true;
                continue;
            }
            if (next.matches("-\\w\\w+")) {
                toHandle.addFirst("-" + next.substring(2));
                next = next.substring(0, 2);
            }
            String[] split = next.split("=", 2);
            String optionName = split[0];
            AvailableOption definition = this.findParameter(optionName);
            String parameter = null;
            if (definition.requiresParameter()) {
                if (split.length > 1) {
                    parameter = split[1];
                } else {
                    if (toHandle.isEmpty() || "--".equals(toHandle.getFirst())) {
                        throw new OptionParseException(I18n.tr("{0}: option ''{1}'' requires an argument", this.program, optionName));
                    }
                    parameter = toHandle.removeFirst();
                }
            } else if (split.length > 1) {
                throw new OptionParseException(I18n.tr("{0}: option ''{1}'' does not allow an argument", this.program, optionName));
            }
            options.add(new FoundOption(optionName, definition, parameter));
        }
        this.availableOptions.values().stream().distinct().forEach(def -> {
            long count = options.stream().filter(p -> def.equals(((FoundOption)p).option)).count();
            String optionName = this.availableOptions.entrySet().stream().filter(entry -> def.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElse("?");
            if (count < (long)def.getRequiredCount().min) {
                throw new OptionParseException(I18n.tr("{0}: option ''{1}'' is required", this.program, optionName));
            }
            if (count > (long)def.getRequiredCount().max) {
                throw new OptionParseException(I18n.tr("{0}: option ''{1}'' may not appear multiple times", this.program, optionName));
            }
        });
        for (FoundOption option : options) {
            try {
                option.option.runFor(option.parameter);
            }
            catch (OptionParseException e) {
                StringBuilder message = new StringBuilder();
                if (option.parameter == null) {
                    message.append(I18n.tr("{0}: Error while handling option ''{1}''", this.program, option.optionName));
                } else {
                    message.append(I18n.tr("{0}: Invalid value {2} for option ''{1}''", this.program, option.optionName, option.parameter));
                }
                if (!e.getLocalizedMessage().isEmpty()) {
                    message.append(": ").append(e.getLocalizedMessage().isEmpty());
                }
                throw new OptionParseException(message.toString(), e);
            }
        }
        return remainingArguments;
    }

    private AvailableOption findParameter(String optionName) {
        AvailableOption exactMatch = this.availableOptions.get(optionName);
        if (exactMatch != null) {
            return exactMatch;
        }
        if (optionName.startsWith("--")) {
            List alternatives = this.availableOptions.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(optionName)).map(Map.Entry::getValue).distinct().collect(Collectors.toList());
            if (alternatives.size() == 1) {
                return (AvailableOption)alternatives.get(0);
            }
            if (alternatives.size() > 1) {
                throw new OptionParseException(I18n.tr("{0}: option ''{1}'' is ambiguous", this.program, optionName));
            }
        }
        throw new OptionParseException(I18n.tr("{0}: unrecognized option ''{1}''", this.program, optionName));
    }

    public static class OptionParseException
    extends RuntimeException {
        private final String localizedMessage;

        public OptionParseException() {
            this.localizedMessage = "";
        }

        public OptionParseException(String localizedMessage) {
            super(localizedMessage);
            this.localizedMessage = localizedMessage;
        }

        public OptionParseException(String localizedMessage, Throwable t) {
            super(localizedMessage, t);
            this.localizedMessage = localizedMessage;
        }

        @Override
        public String getLocalizedMessage() {
            return this.localizedMessage;
        }
    }

    private static class FoundOption {
        private final String optionName;
        private final AvailableOption option;
        private final String parameter;

        FoundOption(String optionName, AvailableOption option, String parameter) {
            this.optionName = optionName;
            this.option = option;
            this.parameter = parameter;
        }
    }

    protected static interface AvailableOption {
        default public boolean requiresParameter() {
            return false;
        }

        default public OptionCount getRequiredCount() {
            return OptionCount.OPTIONAL;
        }

        public void runFor(String var1);
    }

    public static enum OptionCount {
        OPTIONAL(0, 1),
        REQUIRED(1, 1),
        MULTIPLE(0, Integer.MAX_VALUE);

        private int min;
        private int max;

        private OptionCount(int min, int max) {
            this.min = min;
            this.max = max;
        }
    }
}

