/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.DefaultGeoProperty;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public final class Territories {
    public static final String FILENAME = "boundaries.osm";
    private static final String ISO3166_1 = "ISO3166-1:alpha2";
    private static final String ISO3166_2 = "ISO3166-2";
    private static DataSet dataSet;
    private static volatile Map<String, GeoPropertyIndex<Boolean>> iso3166Cache;

    private Territories() {
    }

    public static synchronized Set<String> getKnownIso3166Codes() {
        return iso3166Cache.keySet();
    }

    public static GeoPropertyIndex<Boolean> getGeoPropertyIndex(String code) {
        return iso3166Cache.get(code);
    }

    public static synchronized boolean isIso3166Code(String code, LatLon ll) {
        GeoPropertyIndex<Boolean> gpi = iso3166Cache.get(code);
        if (gpi == null) {
            Logging.warn(I18n.tr("Unknown territory id: {0}", code));
            return false;
        }
        return Boolean.TRUE.equals(gpi.get(ll));
    }

    public static synchronized DataSet getDataSet() {
        return new DataSet(dataSet);
    }

    public static synchronized void initialize() {
        iso3166Cache = new HashMap<String, GeoPropertyIndex<Boolean>>();
        try (CachedFile cf = new CachedFile("resource://data/boundaries.osm");
             InputStream is = cf.getInputStream();){
            dataSet = OsmReader.parseDataSet(is, null);
            ArrayList<Way> candidates = new ArrayList<Way>(dataSet.getWays());
            candidates.addAll(dataSet.getRelations());
            for (OsmPrimitive osmPrimitive : candidates) {
                String iso1 = osmPrimitive.get(ISO3166_1);
                String iso2 = osmPrimitive.get(ISO3166_2);
                if (iso1 == null && iso2 == null) continue;
                DefaultGeoProperty gp = osmPrimitive instanceof Way ? new DefaultGeoProperty(Collections.singleton((Way)osmPrimitive)) : new DefaultGeoProperty((Relation)osmPrimitive);
                GeoPropertyIndex<Boolean> gpi = new GeoPropertyIndex<Boolean>(gp, 24);
                if (iso1 != null) {
                    iso3166Cache.put(iso1, gpi);
                }
                if (iso2 == null) continue;
                iso3166Cache.put(iso2, gpi);
            }
        }
        catch (IOException | IllegalDataException ex) {
            throw new JosmRuntimeException(ex);
        }
    }
}

