/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.ComponentDesc;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.InstallerDesc;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.LaunchDesc;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.Parser;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.UpdateDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ClasspathMatcher;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class JNLPFile {
    protected URL sourceLocation = null;
    protected URL fileLocation;
    protected ParserSettings parserSettings = null;
    protected String uniqueKey = null;
    protected URL codeBase;
    protected Version fileVersion;
    protected Version specVersion;
    protected List<InformationDesc> info;
    protected UpdateDesc update;
    protected List<ResourcesDesc> resources;
    protected ResourcesDesc sharedResources = new ResourcesDesc(this, null, null, null);
    protected LaunchDesc launchType;
    protected ComponentDesc component;
    protected SecurityDesc security;
    protected Locale defaultLocale = null;
    protected String defaultOS = null;
    protected String defaultArch = null;
    private boolean missingSignedJNLP = false;
    private boolean containsSpecialProperties = false;
    private final String[] generalProperties = SecurityDesc.getJnlpRIAPermissions();
    private final ManifestsAttributes manifestsAttributes = new ManifestsAttributes();
    public static final String TITLE_NOT_FOUND = "Application title was not found in manifest. Check with application vendor";

    protected JNLPFile() {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public JNLPFile(URL location) throws IOException, ParseException {
        this(location, new ParserSettings());
    }

    public JNLPFile(URL location, ParserSettings settings) throws IOException, ParseException {
        this(location, (Version)null, settings);
    }

    public JNLPFile(URL location, Version version, ParserSettings settings) throws IOException, ParseException {
        this(location, version, settings, JNLPRuntime.getDefaultUpdatePolicy());
    }

    public JNLPFile(URL location, Version version, ParserSettings settings, UpdatePolicy policy) throws IOException, ParseException {
        this(location, version, settings, policy, null);
    }

    protected JNLPFile(URL location, Version version, ParserSettings settings, UpdatePolicy policy, URL forceCodebase) throws IOException, ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        InputStream input = JNLPFile.openURL(location, version, policy);
        this.parserSettings = settings;
        this.parse(input, location, forceCodebase);
        if (this.sourceLocation != null && "file".equals(location.getProtocol())) {
            JNLPFile.openURL(this.sourceLocation, version, policy);
        }
        this.fileLocation = location;
        this.uniqueKey = Calendar.getInstance().getTimeInMillis() + "-" + (int)(Math.random() * 2.147483647E9) + "-" + location;
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "UNIQUEKEY=" + this.uniqueKey);
    }

    public JNLPFile(URL location, String uniqueKey, Version version, ParserSettings settings, UpdatePolicy policy) throws IOException, ParseException {
        this(location, version, settings, policy);
        this.uniqueKey = uniqueKey;
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "UNIQUEKEY (override) =" + this.uniqueKey);
    }

    public JNLPFile(InputStream input, ParserSettings settings) throws ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.parserSettings = settings;
        this.parse(input, null, null);
    }

    public JNLPFile(InputStream input, URL codebase, ParserSettings settings) throws ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.parserSettings = settings;
        this.parse(input, null, codebase);
    }

    public static InputStream openURL(URL location, Version version, UpdatePolicy policy) throws IOException {
        if (location == null || policy == null) {
            throw new IllegalArgumentException(Translator.R("NullParameter"));
        }
        try {
            ResourceTracker tracker = new ResourceTracker(false);
            tracker.addResource(location, version, null, policy);
            File f = tracker.getCacheFile(location);
            return new FileInputStream(f);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public String getTitle() {
        String jnlpTitle = this.getTitleFromJnlp();
        String manifestTitle = this.getTitleFromManifest();
        if (jnlpTitle != null && manifestTitle != null) {
            if (jnlpTitle.equals(manifestTitle)) {
                return jnlpTitle;
            }
            return jnlpTitle + " (" + manifestTitle + ")";
        }
        if (jnlpTitle != null && manifestTitle == null) {
            return jnlpTitle;
        }
        if (jnlpTitle == null && manifestTitle != null) {
            return manifestTitle;
        }
        String mainClass = this.getManifestsAttributes().getMainClass();
        return mainClass;
    }

    public String getTitleFromJnlp() {
        return this.getInformation().getTitle();
    }

    public String getTitleFromManifest() {
        String inManifestTitle = this.getManifestsAttributes().getApplicationName();
        if (inManifestTitle == null && this.getManifestsAttributes().isLoader()) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, TITLE_NOT_FOUND);
        }
        return inManifestTitle;
    }

    public String getVendor() {
        return this.getInformation().getVendor();
    }

    public URL getSourceLocation() {
        return this.sourceLocation;
    }

    public URL getFileLocation() {
        return this.fileLocation;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public ParserSettings getParserSettings() {
        return this.parserSettings;
    }

    public Version getFileVersion() {
        return this.fileVersion;
    }

    public Version getSpecVersion() {
        return this.specVersion;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public URL getNotNullProbalbeCodeBase() {
        if (this.getCodeBase() != null) {
            return this.getCodeBase();
        }
        try {
            return UrlUtils.removeFileName(this.getSourceLocation());
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return this.getSourceLocation();
        }
    }

    public InformationDesc getInformation() {
        return this.getInformation(this.defaultLocale);
    }

    public InformationDesc getInformation(final Locale locale) {
        boolean strict = false;
        if (this.info != null) {
            for (InformationDesc infoDesc : this.info) {
                if (!infoDesc.strict) continue;
                strict = true;
                break;
            }
        }
        return new InformationDesc(new Locale[]{locale}, strict){

            @Override
            protected List<Object> getItems(Object key) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Match precision : Match.values()) {
                    for (InformationDesc infoDesc : JNLPFile.this.info) {
                        if (!JNLPFile.this.localeMatches(locale, infoDesc.getLocales(), precision)) continue;
                        result.addAll(infoDesc.getItems(key));
                    }
                    if (result.size() <= 0) continue;
                    return result;
                }
                return result;
            }

            @Override
            public String getTitle() {
                for (Match precision : Match.values()) {
                    for (InformationDesc infoDesc : JNLPFile.this.info) {
                        String title = infoDesc.getTitle();
                        if (!JNLPFile.this.localeMatches(locale, infoDesc.getLocales(), precision) || title == null || "".equals(title)) continue;
                        return title;
                    }
                }
                return null;
            }

            @Override
            public String getVendor() {
                for (Match precision : Match.values()) {
                    for (InformationDesc infoDesc : JNLPFile.this.info) {
                        String vendor = infoDesc.getVendor();
                        if (!JNLPFile.this.localeMatches(locale, infoDesc.getLocales(), precision) || vendor == null || "".equals(vendor)) continue;
                        return vendor;
                    }
                }
                return null;
            }
        };
    }

    public UpdateDesc getUpdate() {
        return this.update;
    }

    public SecurityDesc getSecurity() {
        return this.security;
    }

    public SecurityDesc.RequestedPermissionLevel getRequestedPermissionLevel() {
        return this.security.getRequestedPermissionLevel();
    }

    public ResourcesDesc getResources() {
        return this.getResources(this.defaultLocale, this.defaultOS, this.defaultArch);
    }

    public ResourcesDesc getResources(final Locale locale, final String os, final String arch) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{os}, new String[]{arch}){

            @Override
            public <T> List<T> getResources(Class<T> launchType) {
                ArrayList<T> result = new ArrayList<T>();
                for (ResourcesDesc rescDesc : JNLPFile.this.resources) {
                    boolean hasUsableLocale = false;
                    for (Match match : Match.values()) {
                        hasUsableLocale |= JNLPFile.this.localeMatches(locale, rescDesc.getLocales(), match);
                    }
                    if (!hasUsableLocale || !JNLPFile.stringMatches(os, rescDesc.getOS()) || !JNLPFile.stringMatches(arch, rescDesc.getArch())) continue;
                    List<T> ll = rescDesc.getResources(launchType);
                    result.addAll(ll);
                }
                result.addAll(JNLPFile.this.sharedResources.getResources(launchType));
                return result;
            }

            @Override
            public void addResource(Object resource) {
                JNLPFile.this.sharedResources.addResource(resource);
            }
        };
    }

    public ResourcesDesc[] getResourcesDescs() {
        return this.getResourcesDescs(this.defaultLocale, this.defaultOS, this.defaultArch);
    }

    public ResourcesDesc[] getResourcesDescs(Locale locale, String os, String arch) {
        ArrayList<ResourcesDesc> matchingResources = new ArrayList<ResourcesDesc>();
        for (ResourcesDesc rescDesc : this.resources) {
            boolean hasUsableLocale = false;
            for (Match match : Match.values()) {
                hasUsableLocale |= this.localeMatches(locale, rescDesc.getLocales(), match);
            }
            if (!hasUsableLocale || !JNLPFile.stringMatches(os, rescDesc.getOS()) || !JNLPFile.stringMatches(arch, rescDesc.getArch())) continue;
            matchingResources.add(rescDesc);
        }
        return matchingResources.toArray(new ResourcesDesc[0]);
    }

    public LaunchDesc getLaunchInfo() {
        return this.launchType;
    }

    public AppletDesc getApplet() {
        if (!this.isApplet()) {
            throw new UnsupportedOperationException(Translator.R("JNotApplet"));
        }
        return (AppletDesc)this.launchType;
    }

    public ApplicationDesc getApplication() {
        if (!this.isApplication()) {
            throw new UnsupportedOperationException(Translator.R("JNotApplication"));
        }
        return (ApplicationDesc)this.launchType;
    }

    public ComponentDesc getComponent() {
        if (!this.isComponent()) {
            throw new UnsupportedOperationException(Translator.R("JNotComponent"));
        }
        return this.component;
    }

    public InstallerDesc getInstaller() {
        if (!this.isInstaller()) {
            throw new UnsupportedOperationException(Translator.R("NotInstaller"));
        }
        return (InstallerDesc)this.launchType;
    }

    public boolean isApplet() {
        return this.launchType instanceof AppletDesc;
    }

    public boolean isApplication() {
        return this.launchType instanceof ApplicationDesc;
    }

    public boolean isComponent() {
        return this.component != null;
    }

    public boolean isInstaller() {
        return this.launchType instanceof InstallerDesc;
    }

    public void setDefaults(String os, String arch, Locale locale) {
        this.defaultOS = os;
        this.defaultArch = arch;
        this.defaultLocale = locale;
    }

    public boolean localeMatches(Locale requested, Locale[] available, Match matchLevel) {
        if (matchLevel == Match.GENERALIZED) {
            return available == null || available.length == 0;
        }
        String language = requested.getLanguage();
        String country = requested.getCountry();
        String variant = requested.getVariant();
        block5: for (Locale locale : available) {
            switch (matchLevel) {
                case LANG: {
                    if (language.isEmpty() || !language.equals(locale.getLanguage()) || !locale.getCountry().isEmpty() || !locale.getVariant().isEmpty()) continue block5;
                    return true;
                }
                case LANG_COUNTRY: {
                    if (language.isEmpty() || !language.equals(locale.getLanguage()) || country.isEmpty() || !country.equals(locale.getCountry()) || !locale.getVariant().isEmpty()) continue block5;
                    return true;
                }
                case LANG_COUNTRY_VARIANT: {
                    if (!language.equals(locale.getLanguage()) || !country.equals(locale.getCountry()) || !variant.equals(locale.getVariant())) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    static boolean stringMatches(String prefixStr, String[] available) {
        if (available == null || available.length == 0) {
            return true;
        }
        for (String candidate : available) {
            String trimmedPrefix = null;
            if (prefixStr != null) {
                trimmedPrefix = prefixStr.split("\\s+")[0];
            }
            String trimmedCandidate = null;
            if (candidate != null) {
                trimmedCandidate = candidate.split("\\s+")[0];
            }
            if (trimmedCandidate == null || !trimmedCandidate.startsWith(trimmedPrefix)) continue;
            return true;
        }
        return false;
    }

    private void parse(InputStream input, URL location, URL forceCodebase) throws ParseException {
        try {
            Node root = Parser.getRootNode(input, this.parserSettings);
            Parser parser = new Parser(this, location, root, this.parserSettings, forceCodebase);
            this.specVersion = parser.getSpecVersion();
            this.fileVersion = parser.getFileVersion();
            this.codeBase = parser.getCodeBase();
            this.sourceLocation = parser.getFileLocation() != null ? parser.getFileLocation() : location;
            this.info = parser.getInfo(root);
            parser.checkForInformation();
            this.update = parser.getUpdate(root);
            this.resources = parser.getResources(root, false);
            this.launchType = parser.getLauncher(root);
            this.component = parser.getComponent(root);
            this.security = parser.getSecurity(root);
            this.checkForSpecialProperties();
        }
        catch (ParseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            throw new RuntimeException(ex.toString());
        }
    }

    private void checkForSpecialProperties() {
        for (ResourcesDesc res : this.resources) {
            for (PropertyDesc propertyDesc : res.getProperties()) {
                String property;
                for (int i = 0; i < this.generalProperties.length && !(property = propertyDesc.getKey()).equals(this.generalProperties[i]); ++i) {
                    if (property.equals(this.generalProperties[i]) || i != this.generalProperties.length - 1) continue;
                    this.containsSpecialProperties = true;
                    return;
                }
            }
        }
    }

    public boolean needsNewVM() {
        return !this.getNewVMArgs().isEmpty();
    }

    public List<String> getNewVMArgs() {
        JREDesc[] jres;
        LinkedList<String> newVMArgs = new LinkedList<String>();
        for (JREDesc jre : jres = this.getResources().getJREs()) {
            String vmArgsFromJre;
            String maxHeapSize;
            String initialHeapSize = jre.getInitialHeapSize();
            if (initialHeapSize != null) {
                newVMArgs.add("-Xms" + initialHeapSize);
            }
            if ((maxHeapSize = jre.getMaximumHeapSize()) != null) {
                newVMArgs.add("-Xmx" + maxHeapSize);
            }
            if ((vmArgsFromJre = jre.getVMArgs()) == null) continue;
            String[] args = vmArgsFromJre.split(" ");
            newVMArgs.addAll(Arrays.asList(args));
        }
        return newVMArgs;
    }

    public DownloadOptions getDownloadOptions() {
        boolean usePack = false;
        boolean useVersion = false;
        ResourcesDesc desc = this.getResources();
        if (Boolean.valueOf(desc.getPropertiesMap().get("jnlp.packEnabled")).booleanValue()) {
            usePack = true;
        }
        if (Boolean.valueOf(desc.getPropertiesMap().get("jnlp.versionEnabled")).booleanValue()) {
            useVersion = true;
        }
        return new DownloadOptions(usePack, useVersion);
    }

    public boolean requiresSignedJNLPWarning() {
        return this.missingSignedJNLP && this.containsSpecialProperties;
    }

    public void setSignedJNLPAsMissing() {
        this.missingSignedJNLP = true;
    }

    public ManifestsAttributes getManifestsAttributes() {
        return this.manifestsAttributes;
    }

    public String createJnlpVendorValue() {
        String location = this.getSourceLocation() != null ? this.getSourceLocation().toString() : (this.getCodeBase() != null ? this.getCodeBase().toString() : "unknown");
        return location;
    }

    public String createJnlpVendor() {
        return "Generated from applet from " + this.createJnlpVendorValue();
    }

    public String createJnlpTitleValue() {
        String location = this.getSourceLocation() != null ? new File(this.getSourceLocation().getFile()).getName() : (this.getCodeBase() != null ? new File(this.getCodeBase().getFile()).getName() : "unknown");
        return location;
    }

    public String createJnlpTitle() {
        String shortenedTitle = this.getTitle();
        int i = shortenedTitle.lastIndexOf("(");
        if (i >= 2) {
            shortenedTitle = shortenedTitle.substring(0, i - 1);
        }
        if (this.createJnlpTitleValue().startsWith(shortenedTitle)) {
            return this.createJnlpTitleValue();
        }
        return this.getTitle() + " from " + this.createJnlpTitleValue();
    }

    static String[] splitEntryPoints(String entryPointString) {
        if (entryPointString == null || entryPointString.trim().isEmpty()) {
            return null;
        }
        String[] result = entryPointString.trim().split("\\s+");
        if (result.length == 0) {
            return null;
        }
        return result;
    }

    public class ManifestsAttributes {
        public static final String APP_NAME = "Application-Name";
        public static final String CALLER_ALLOWABLE = "Caller-Allowable-Codebase";
        public static final String APP_LIBRARY_ALLOWABLE = "Application-Library-Allowable-Codebase";
        public static final String PERMISSIONS = "Permissions";
        public static final String CODEBASE = "Codebase";
        public static final String TRUSTED_ONLY = "Trusted-Only";
        public static final String TRUSTED_LIBRARY = "Trusted-Library";
        public static final String ENTRY_POINT = "Entry-Point";
        private JNLPClassLoader loader;

        public void setLoader(JNLPClassLoader loader) {
            this.loader = loader;
        }

        public boolean isLoader() {
            return this.loader != null;
        }

        public String getMainClass() {
            if (this.loader == null) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Jars not ready to provide main class");
                return null;
            }
            return this.loader.getMainClass();
        }

        public String[] getEntryPoints() {
            return JNLPFile.splitEntryPoints(this.getEntryPointString());
        }

        public String getEntryPointString() {
            return this.getAttribute(ENTRY_POINT);
        }

        public String getApplicationName() {
            return this.getAttribute(APP_NAME);
        }

        public ClasspathMatcher.ClasspathMatchers getCallerAllowableCodebase() {
            return this.getCodeBaseMatchersAttribute(CALLER_ALLOWABLE, false);
        }

        public ClasspathMatcher.ClasspathMatchers getApplicationLibraryAllowableCodebase() {
            return this.getCodeBaseMatchersAttribute(APP_LIBRARY_ALLOWABLE, true);
        }

        public ClasspathMatcher.ClasspathMatchers getCodebase() {
            return this.getCodeBaseMatchersAttribute(CODEBASE, false);
        }

        public ManifestBoolean isTrustedOnly() {
            return this.processBooleanAttribute(TRUSTED_ONLY);
        }

        public ManifestBoolean isTrustedLibrary() {
            return this.processBooleanAttribute(TRUSTED_LIBRARY);
        }

        public ManifestBoolean isSandboxForced() {
            String s = this.getAttribute(PERMISSIONS);
            if (s == null) {
                return ManifestBoolean.UNDEFINED;
            }
            if (s.trim().equalsIgnoreCase(SecurityDesc.RequestedPermissionLevel.SANDBOX.toHtmlString())) {
                return ManifestBoolean.TRUE;
            }
            if (s.trim().equalsIgnoreCase(SecurityDesc.RequestedPermissionLevel.ALL.toHtmlString())) {
                return ManifestBoolean.FALSE;
            }
            throw new IllegalArgumentException("Unknown value of Permissions attribute " + s + ". Expected " + SecurityDesc.RequestedPermissionLevel.SANDBOX.toHtmlString() + " or " + SecurityDesc.RequestedPermissionLevel.ALL.toHtmlString());
        }

        public String permissionsToString() {
            String s = this.getAttribute(PERMISSIONS);
            if (s == null) {
                return "Not defined";
            }
            if (s.trim().equalsIgnoreCase(SecurityDesc.RequestedPermissionLevel.SANDBOX.toHtmlString())) {
                return s.trim();
            }
            if (s.trim().equalsIgnoreCase(SecurityDesc.RequestedPermissionLevel.ALL.toHtmlString())) {
                return s.trim();
            }
            return "illegal";
        }

        String getAttribute(String name) {
            return this.getAttribute(new Attributes.Name(name));
        }

        public String getAttribute(Attributes.Name name) {
            if (this.loader == null) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Jars not ready to provide attribute " + name);
                return null;
            }
            return this.loader.checkForAttributeInJars(Arrays.asList(JNLPFile.this.getResources().getJARs()), name);
        }

        public ClasspathMatcher.ClasspathMatchers getCodeBaseMatchersAttribute(String s, boolean includePath) {
            return this.getCodeBaseMatchersAttribute(new Attributes.Name(s), includePath);
        }

        public ClasspathMatcher.ClasspathMatchers getCodeBaseMatchersAttribute(Attributes.Name name, boolean includePath) {
            String s = this.getAttribute(name);
            if (s == null) {
                return null;
            }
            return ClasspathMatcher.ClasspathMatchers.compile(s, includePath);
        }

        private ManifestBoolean processBooleanAttribute(String id) throws IllegalArgumentException {
            String s = this.getAttribute(id);
            if (s == null) {
                return ManifestBoolean.UNDEFINED;
            }
            switch (s = s.toLowerCase().trim()) {
                case "true": {
                    return ManifestBoolean.TRUE;
                }
                case "false": {
                    return ManifestBoolean.FALSE;
                }
            }
            throw new IllegalArgumentException("Unknown value of " + id + " attribute " + s + ". Expected true or false");
        }
    }

    static enum Match {
        LANG_COUNTRY_VARIANT,
        LANG_COUNTRY,
        LANG,
        GENERALIZED;

    }

    public static enum ManifestBoolean {
        TRUE,
        FALSE,
        UNDEFINED;

    }
}

