/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.datatool.DTLcompare;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifinlist;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifintclosedbetween;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifintopenbetween;
import com.dickimawbooks.texparserlib.latex.datatool.DTLinsertinto;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnewcurrencysymbol;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnumitemsinlist;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetdefaultcurrency;
import com.dickimawbooks.texparserlib.latex.ifthen.IfThenSty;
import java.io.IOException;
import java.util.Vector;

public class DataToolBaseSty
extends LaTeXSty {
    private IfThenSty ifThenSty;
    private Vector<TeXObject> currencySymbolList;
    private TeXObject defaultCurrency;
    private CountRegister sortCountReg;

    public DataToolBaseSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "datatool-base", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        TeXParser teXParser = this.getListener().getParser();
        this.sortCountReg = teXParser.getSettings().newcount(false, "dtl@sortresult");
        this.registerControlSequence(new DTLnewcurrencysymbol(this));
        this.registerControlSequence(new DTLsetdefaultcurrency(this));
        this.registerControlSequence(new DTLifintopenbetween());
        this.registerControlSequence(new DTLifintclosedbetween());
        this.registerControlSequence(new DTLifinlist());
        this.registerControlSequence(new DTLnumitemsinlist());
        this.registerControlSequence(new DTLinsertinto(this));
        this.registerControlSequence(new DTLinsertinto("edtlinsertinto", true, this));
        this.registerControlSequence(new DTLcompare());
        this.registerControlSequence(new DTLcompare("dtlicompare", false));
        this.addCurrencySymbol("$");
        this.addCurrencySymbol("pounds");
        this.addCurrencySymbol("textsterling");
        this.addCurrencySymbol("textdollar");
        this.addCurrencySymbol("textyen");
        this.addCurrencySymbol("texteuro");
        this.addCurrencySymbol("textwon");
        this.addCurrencySymbol("textcurrency");
        this.addCurrencySymbol("euro");
        this.addCurrencySymbol("yen");
    }

    @Override
    protected void preOptions() throws IOException {
        this.getListener().requirepackage("etoolbox");
        this.ifThenSty = (IfThenSty)this.getListener().requirepackage("ifthen");
    }

    public void addCurrencySymbol(TeXObject teXObject) {
        if (this.currencySymbolList == null) {
            this.currencySymbolList = new Vector();
            this.defaultCurrency = teXObject;
        }
        if (teXObject == null) {
            throw new NullPointerException();
        }
        this.currencySymbolList.add(teXObject);
    }

    public void addCurrencySymbol(String string) {
        this.addCurrencySymbol(new TeXCsRef(string));
    }

    public boolean isCurrencySymbol(TeXObject teXObject) {
        if (teXObject == null) {
            return false;
        }
        for (TeXObject teXObject2 : this.currencySymbolList) {
            if (teXObject2 instanceof ControlSequence && teXObject instanceof ControlSequence && ((ControlSequence)teXObject2).getName().equals(((ControlSequence)teXObject).getName())) {
                return true;
            }
            if (!teXObject2.equals(teXObject)) continue;
            return true;
        }
        return false;
    }

    public void setDefaultCurrency(TeXObject teXObject) {
        this.defaultCurrency = teXObject;
    }

    public IfThenSty getIfThenSty() {
        return this.ifThenSty;
    }

    public CountRegister getSortCountRegister() {
        return this.sortCountReg;
    }
}

