/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.StackTrace;
import org.netbeans.lib.profiler.heap.TagBounds;

class StackTraceSegment
extends TagBounds {
    private static final int SERIALNUM_DIV = 16;
    HprofHeap hprofHeap;
    final int threadSerialNumberOffset;
    final int stackTraceSerialNumberOffset;
    final int lengthOffset;
    final int framesListOffset;
    final int numberOfFramesOffset;
    final int timeOffset;
    private Map serialNumToStackTrace;

    StackTraceSegment(HprofHeap hprofHeap, long l, long l2) {
        super(5, l, l2);
        this.hprofHeap = hprofHeap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stackTraceSerialNumberOffset = this.lengthOffset + 4;
        this.threadSerialNumberOffset = this.stackTraceSerialNumberOffset + 4;
        this.numberOfFramesOffset = this.threadSerialNumberOffset + 4;
        this.framesListOffset = this.numberOfFramesOffset + 4;
    }

    StackTrace getStackTraceBySerialNumber(long l) {
        this.initSerialNumToFrame();
        Long l2 = (Long)this.serialNumToStackTrace.get(new Long(l / 16L));
        if (l2 == null) {
            l2 = new Long(this.startOffset);
        }
        long[] lArray = new long[]{l2};
        while (lArray[0] < this.endOffset) {
            long l3 = lArray[0];
            long l4 = this.readStackTraceTag(lArray);
            if (l4 != l) continue;
            return new StackTrace(this, l3);
        }
        return null;
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer hprofByteBuffer = this.hprofHeap.dumpBuffer;
        return hprofByteBuffer;
    }

    private int readStackTraceTag(long[] lArray) {
        long l = lArray[0];
        if (this.hprofHeap.readTag(lArray) != 5) {
            return 0;
        }
        return this.getDumpBuffer().getInt(l + (long)this.stackTraceSerialNumberOffset);
    }

    private synchronized void initSerialNumToFrame() {
        if (this.serialNumToStackTrace == null) {
            long[] lArray = new long[]{this.startOffset};
            this.serialNumToStackTrace = new HashMap();
            while (lArray[0] < this.endOffset) {
                long l = lArray[0];
                long l2 = this.readStackTraceTag(lArray);
                Long l3 = new Long(l2 / 16L);
                Long l4 = (Long)this.serialNumToStackTrace.get(l3);
                if (l4 != null && l4 <= l) continue;
                this.serialNumToStackTrace.put(l3, new Long(l));
            }
        }
    }
}

