/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.finger;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class FingerConnection {
    public static final int DEFAULT_PORT = 79;
    private static final String US_ASCII = "US-ASCII";
    protected Socket socket;
    protected boolean verbose;

    public FingerConnection(String string) throws IOException {
        this(string, 79);
    }

    public FingerConnection(String string, int n) throws IOException {
        this.socket = new Socket(string, n);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public String list() throws IOException {
        return this.finger(null, null);
    }

    public String finger(String string) throws IOException {
        return this.finger(string, null);
    }

    public String finger(String string, String string2) throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream = new BufferedOutputStream(outputStream);
        if (this.verbose) {
            outputStream.write(47);
            outputStream.write(87);
            if (string != null || string2 != null) {
                outputStream.write(32);
            }
        }
        if (string != null) {
            outputStream.write(string.getBytes(US_ASCII));
        }
        if (string2 != null) {
            outputStream.write(64);
            outputStream.write(string2.getBytes(US_ASCII));
        }
        outputStream.write(13);
        outputStream.write(10);
        outputStream.flush();
        InputStream inputStream = this.socket.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        return byteArrayOutputStream.toString(US_ASCII);
    }
}

