/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Argument;
import com.github.cereda.arara.model.Command;
import com.github.cereda.arara.model.Directive;
import com.github.cereda.arara.model.Evaluator;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.model.Rule;
import com.github.cereda.arara.model.RuleCommand;
import com.github.cereda.arara.model.Trigger;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.DisplayUtils;
import com.github.cereda.arara.utils.InterpreterUtils;
import com.github.cereda.arara.utils.Methods;
import com.github.cereda.arara.utils.RuleUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private static final LanguageController messages = LanguageController.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(Interpreter.class);
    private List<Directive> directives;

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws AraraException {
        for (Directive directive : this.directives) {
            logger.info(messages.getMessage(Messages.LOG_INFO_INTERPRET_RULE, directive.getIdentifier()));
            ConfigurationController.getInstance().put("execution.file", directive.getParameters().get("reference"));
            File file = this.getRule(directive);
            logger.info(messages.getMessage(Messages.LOG_INFO_RULE_LOCATION, file.getParent()));
            ConfigurationController.getInstance().put("execution.info.rule.id", directive.getIdentifier());
            ConfigurationController.getInstance().put("execution.info.rule.path", file.getParent());
            ConfigurationController.getInstance().put("execution.directive.lines", directive.getLineNumbers());
            ConfigurationController.getInstance().put("execution.directive.reference", directive.getParameters().get("reference"));
            Rule rule = this.parseRule(file, directive);
            Map<String, Object> parameters = this.parseArguments(rule, directive);
            Methods.addRuleMethods(parameters);
            String name = rule.getName();
            ArrayList<String> authors = rule.getAuthors() == null ? new ArrayList() : rule.getAuthors();
            ConfigurationController.getInstance().put("execution.rule.arguments", InterpreterUtils.getRuleArguments(rule));
            Evaluator evaluator = new Evaluator();
            boolean available = true;
            if (InterpreterUtils.runPriorEvaluation(directive.getConditional())) {
                available = evaluator.evaluate(directive.getConditional());
            }
            if (!available) continue;
            do {
                List<RuleCommand> commands = rule.getCommands();
                for (RuleCommand command : commands) {
                    String closure = command.getCommand();
                    Object result = null;
                    try {
                        result = TemplateRuntime.eval(closure, parameters);
                    }
                    catch (RuntimeException exception) {
                        throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_INTERPRETER_COMMAND_RUNTIME_ERROR)), exception);
                    }
                    List<Object> execution = new ArrayList<Object>();
                    if (CommonUtils.checkClass(List.class, result)) {
                        execution = CommonUtils.flatten((List)result);
                    } else {
                        execution.add(result);
                    }
                    for (Object current : execution) {
                        if (current == null) {
                            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_INTERPRETER_NULL_COMMAND)));
                        }
                        if (CommonUtils.checkEmptyString(String.valueOf(current))) continue;
                        DisplayUtils.printEntry(name, command.getName() == null ? messages.getMessage(Messages.INFO_LABEL_UNNAMED_TASK) : command.getName());
                        boolean success = true;
                        if (CommonUtils.checkClass(Trigger.class, current)) {
                            if (!((Boolean)ConfigurationController.getInstance().get("execution.dryrun")).booleanValue()) {
                                if (((Boolean)ConfigurationController.getInstance().get("execution.verbose")).booleanValue()) {
                                    DisplayUtils.wrapText(messages.getMessage(Messages.INFO_INTERPRETER_VERBOSE_MODE_TRIGGER_MODE));
                                }
                            } else {
                                DisplayUtils.printAuthors(authors);
                                DisplayUtils.wrapText(messages.getMessage(Messages.INFO_INTERPRETER_DRYRUN_MODE_TRIGGER_MODE));
                                DisplayUtils.printConditional(directive.getConditional());
                            }
                            Trigger trigger = (Trigger)current;
                            trigger.process();
                        } else {
                            Object representation = CommonUtils.checkClass(Command.class, current) ? current : String.valueOf(current);
                            logger.info(messages.getMessage(Messages.LOG_INFO_SYSTEM_COMMAND, representation));
                            if (!((Boolean)ConfigurationController.getInstance().get("execution.dryrun")).booleanValue()) {
                                int code = InterpreterUtils.run(representation);
                                Object check = null;
                                try {
                                    HashMap<String, Integer> context = new HashMap<String, Integer>();
                                    context.put("value", code);
                                    check = TemplateRuntime.eval("@{ ".concat(command.getExit() == null ? "value == 0" : command.getExit()).concat(" }"), context);
                                }
                                catch (RuntimeException exception) {
                                    throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_INTERPRETER_EXIT_RUNTIME_ERROR)), exception);
                                }
                                if (!CommonUtils.checkClass(Boolean.class, check)) throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_INTERPRETER_WRONG_EXIT_CLOSURE_RETURN)));
                                success = (Boolean)check;
                            } else {
                                DisplayUtils.printAuthors(authors);
                                DisplayUtils.wrapText(messages.getMessage(Messages.INFO_INTERPRETER_DRYRUN_MODE_SYSTEM_COMMAND, representation));
                                DisplayUtils.printConditional(directive.getConditional());
                            }
                        }
                        DisplayUtils.printEntryResult(success);
                        if (!((Boolean)ConfigurationController.getInstance().get("trigger.halt")).booleanValue() && (!((Boolean)ConfigurationController.getInstance().get("execution.errors.halt")).booleanValue() || success)) continue;
                        return;
                    }
                }
            } while (evaluator.evaluate(directive.getConditional()));
        }
    }

    private File getRule(Directive directive) throws AraraException {
        File file = InterpreterUtils.buildRulePath(directive.getIdentifier());
        if (file == null) {
            throw new AraraException(messages.getMessage(Messages.ERROR_INTERPRETER_RULE_NOT_FOUND, directive.getIdentifier(), CommonUtils.getCollectionElements(CommonUtils.getAllRulePaths(), "(", ")", "; ")));
        }
        return file;
    }

    private Rule parseRule(File file, Directive directive) throws AraraException {
        return RuleUtils.parseRule(file, directive.getIdentifier());
    }

    private Map<String, Object> parseArguments(Rule rule, Directive directive) throws AraraException {
        List<Argument> arguments = rule.getArguments();
        Set<String> unknown = CommonUtils.getUnknownKeys(directive.getParameters(), arguments);
        unknown.remove("file");
        unknown.remove("reference");
        if (!unknown.isEmpty()) {
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_INTERPRETER_UNKNOWN_KEYS, CommonUtils.getCollectionElements(unknown, "(", ")", ", "))));
        }
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("file", directive.getParameters().get("file"));
        mapping.put("reference", directive.getParameters().get("reference"));
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("parameters", directive.getParameters());
        context.put("file", directive.getParameters().get("file"));
        context.put("reference", directive.getParameters().get("reference"));
        Methods.addRuleMethods(context);
        for (Argument argument : arguments) {
            Object result;
            if (argument.isRequired() && !directive.getParameters().containsKey(argument.getIdentifier())) {
                throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_INTERPRETER_ARGUMENT_IS_REQUIRED, argument.getIdentifier())));
            }
            if (argument.getDefault() != null) {
                try {
                    result = TemplateRuntime.eval(argument.getDefault(), context);
                    mapping.put(argument.getIdentifier(), result);
                }
                catch (RuntimeException exception) {
                    throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_INTERPRETER_DEFAULT_VALUE_RUNTIME_ERROR)), exception);
                }
            } else {
                mapping.put(argument.getIdentifier(), "");
            }
            if (argument.getFlag() == null || !directive.getParameters().containsKey(argument.getIdentifier())) continue;
            try {
                result = TemplateRuntime.eval(argument.getFlag(), context);
                mapping.put(argument.getIdentifier(), result);
            }
            catch (RuntimeException exception) {
                throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_INTERPRETER_FLAG_RUNTIME_EXCEPTION)), exception);
            }
        }
        return mapping;
    }
}

