/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.DTP;
import gnu.inet.ftp.DTPOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CompressedOutputStream
extends DTPOutputStream {
    static final byte RECORD = -128;
    static final byte EOF = 64;

    CompressedOutputStream(DTP dTP, OutputStream outputStream) {
        super(dTP, outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] byArray = new byte[]{-128, 0, 1, 1, (byte)n};
        this.out.write(byArray, 0, 5);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] byArray2 = this.compress(byArray, n, n2);
        n2 = byArray2.length;
        byArray2[0] = -128;
        byArray2[1] = (byte)((n2 & 0xFF) >> 8);
        byArray2[2] = (byte)(n2 & 0xFF00);
        this.out.write(byArray2, 0, n2);
    }

    byte[] compress(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        byte by = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        for (int i = n; i < n2; ++i) {
            byte by2 = byArray[i];
            if (i > n && by2 == by) {
                if (n4 > 0) {
                    if (n3 + (n4 + 1) > byArray2.length) {
                        byArray2 = this.realloc(byArray2, n2);
                    }
                    n3 = this.flush_raw(byArray2, n3, byArray, i - n4 - 1, n4);
                    n4 = 0;
                }
                ++n5;
            } else {
                if (n5 > 1) {
                    if (n3 + 2 > byArray2.length) {
                        byArray2 = this.realloc(byArray2, n2);
                    }
                    n3 = this.flush_compressed(byArray2, n3, n5, by);
                    n5 = 1;
                }
                ++n4;
            }
            if (n5 == 127) {
                if (n3 + 2 > byArray2.length) {
                    byArray2 = this.realloc(byArray2, n2);
                }
                n3 = this.flush_compressed(byArray2, n3, n5, by);
                n5 = 1;
            }
            if (n4 == 127) {
                if (n3 + (n4 + 1) > byArray2.length) {
                    byArray2 = this.realloc(byArray2, n2);
                }
                n3 = this.flush_raw(byArray2, n3, byArray, i - n4, n4);
                n4 = 0;
            }
            by = by2;
        }
        if (n5 > 1) {
            if (n3 + 2 > byArray2.length) {
                byArray2 = this.realloc(byArray2, n2);
            }
            n3 = this.flush_compressed(byArray2, n3, n5, by);
            n5 = 1;
        }
        if (n4 > 0) {
            if (n3 + (n4 + 1) > byArray2.length) {
                byArray2 = this.realloc(byArray2, n2);
            }
            n3 = this.flush_raw(byArray2, n3, byArray, n2 - n4, n4);
            n4 = 0;
        }
        byte[] byArray3 = new byte[n3 + 3];
        System.arraycopy(byArray2, 0, byArray3, 3, n3);
        return byArray3;
    }

    int flush_compressed(byte[] byArray, int n, int n2, byte by) {
        byArray[n++] = (byte)(0x80 | n2);
        byArray[n++] = by;
        return n;
    }

    int flush_raw(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        byArray[n++] = (byte)n3;
        System.arraycopy(byArray2, n2, byArray, n, n3);
        return n + n3;
    }

    byte[] realloc(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    @Override
    public void close() throws IOException {
        byte[] byArray = new byte[]{64, 0, 0};
        this.out.write(byArray, 0, 3);
        this.out.close();
    }
}

