/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SqlFedAuthToken;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.kerberos.KerberosPrincipal;

class SQLServerADAL4JUtils {
    private static final Logger adal4jLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerADAL4JUtils");

    SQLServerADAL4JUtils() {
    }

    static SqlFedAuthToken getSqlFedAuthToken(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String user, String password, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            AuthenticationContext context = new AuthenticationContext(fedAuthInfo.stsurl, false, executorService);
            Future future = context.acquireToken(fedAuthInfo.spn, "7f98cb04-cd1e-40df-9140-3bf7e2cea4db", user, password, null);
            AuthenticationResult authenticationResult = (AuthenticationResult)future.get();
            SqlFedAuthToken sqlFedAuthToken = new SqlFedAuthToken(authenticationResult.getAccessToken(), authenticationResult.getExpiresOnDate());
            return sqlFedAuthToken;
        }
        catch (InterruptedException | MalformedURLException e) {
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_ADALExecution"));
            Object[] msgArgs = new Object[]{user, authenticationString};
            String correctedErrorMessage = e.getCause().getMessage().replaceAll("\\\\r\\\\n", "\r\n");
            AuthenticationException correctedAuthenticationException = new AuthenticationException(correctedErrorMessage);
            ExecutionException correctedExecutionException = new ExecutionException((Throwable)correctedAuthenticationException);
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)correctedExecutionException);
        }
        finally {
            executorService.shutdown();
        }
    }

    static SqlFedAuthToken getSqlFedAuthTokenIntegrated(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            KerberosPrincipal kerberosPrincipal = new KerberosPrincipal("username");
            String username = kerberosPrincipal.getName();
            if (adal4jLogger.isLoggable(Level.FINE)) {
                adal4jLogger.fine(adal4jLogger.toString() + " realm name is:" + kerberosPrincipal.getRealm());
            }
            AuthenticationContext context = new AuthenticationContext(fedAuthInfo.stsurl, false, executorService);
            Future future = context.acquireToken(fedAuthInfo.spn, "7f98cb04-cd1e-40df-9140-3bf7e2cea4db", username, null, null);
            AuthenticationResult authenticationResult = (AuthenticationResult)future.get();
            SqlFedAuthToken sqlFedAuthToken = new SqlFedAuthToken(authenticationResult.getAccessToken(), authenticationResult.getExpiresOnDate());
            return sqlFedAuthToken;
        }
        catch (IOException | InterruptedException e) {
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_ADALExecution"));
            Object[] msgArgs = new Object[]{"", authenticationString};
            if (null == e.getCause() || null == e.getCause().getMessage()) {
                throw new SQLServerException(form.format(msgArgs), null);
            }
            String correctedErrorMessage = e.getCause().getMessage().replaceAll("\\\\r\\\\n", "\r\n");
            AuthenticationException correctedAuthenticationException = new AuthenticationException(correctedErrorMessage);
            ExecutionException correctedExecutionException = new ExecutionException((Throwable)correctedAuthenticationException);
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)correctedExecutionException);
        }
        finally {
            executorService.shutdown();
        }
    }
}

