/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.transfer;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.transfer.OWLObjectDragGestureListener;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLObjectTreeDragGestureListener
extends OWLObjectDragGestureListener {
    private final OWLObjectTree<? extends OWLObject> tree;

    public OWLObjectTreeDragGestureListener(OWLEditorKit owlEditorKit, OWLObjectTree<? extends OWLObject> tree) {
        super(owlEditorKit, tree);
        this.tree = tree;
    }

    @Override
    protected List<OWLObject> getSelectedObjects() {
        return new ArrayList<OWLObject>(this.tree.getSelectedOWLObjects());
    }

    @Override
    protected JComponent getRendererComponent() {
        return (JComponent)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, this.tree.getSelectionPath().getLastPathComponent(), false, true, true, 0, false);
    }

    @Override
    protected Dimension getRendererComponentSize() {
        Rectangle bounds = this.tree.getRowBounds(this.tree.getRowForPath(this.tree.getSelectionPath()));
        return bounds.getSize();
    }

    @Override
    protected Point getImageOffset() {
        TreePath selPath = this.tree.getSelectionPath();
        Rectangle rowBounds = this.tree.getRowBounds(this.tree.getRowForPath(selPath));
        Point pt = this.tree.getMousePosition();
        return new Point(rowBounds.x - pt.x, rowBounds.y - pt.y);
    }

    @Override
    protected boolean canPerformDrag() {
        return true;
    }
}

