/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.render;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.plus.render.RenderingIcons;
import net.osmand.plus.render.TextRenderer;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.Cap;
import net.sourceforge.offroad.DashPathEffect;
import net.sourceforge.offroad.ui.ColorUtils;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.Paint;
import org.apache.commons.logging.Log;

public class OsmandRenderer {
    private static final Log log = PlatformUtil.getLog(OsmandRenderer.class);
    public static final int TILE_SIZE = 256;
    private static final int MAX_V = 75;
    private Map<String, float[]> parsedDashEffects = new LinkedHashMap<String, float[]>();
    private Map<String, TexturePaint> shaders = new LinkedHashMap<String, TexturePaint>();
    private TextRenderer textRenderer = new TextRenderer();

    public Stroke getDashEffect(float pWidth, RenderingContext rc, float[] cachedValues, float st, int cap) {
        float[] dashes = new float[cachedValues.length / 2];
        for (int i = 0; i < dashes.length; ++i) {
            dashes[i] = rc.getDensityValue(cachedValues[i * 2]) + cachedValues[i * 2 + 1];
        }
        return new BasicStroke(pWidth, cap, 2, 1.0f, dashes, st);
    }

    public TexturePaint getShader(String resId) {
        if (this.shaders.get(resId) == null) {
            BufferedImage bmp = RenderingIcons.getIcon(resId, true);
            if (bmp != null) {
                TexturePaint sh = new TexturePaint(bmp, new Rectangle2D.Float(0.0f, 0.0f, bmp.getWidth(), bmp.getHeight()));
                this.shaders.put(resId, sh);
            } else {
                this.shaders.put(resId, null);
            }
        }
        return this.shaders.get(resId);
    }

    private void put(TIntObjectHashMap<TIntArrayList> map, int k, int v) {
        if (!map.containsKey(k)) {
            map.put(k, (Object)new TIntArrayList());
        }
        ((TIntArrayList)map.get(k)).add(v);
    }

    void drawObject(RenderingContext rc, Graphics2D pGraphics2d, RenderingRuleSearchRequest req, List<MapDataObjectPrimitive> array, int objOrder) {
        double minPolygonSize = 1.0 / rc.polygonMinSizeToDisplay;
        for (int i = 0; i < array.size(); ++i) {
            ++rc.allObjects;
            BinaryMapDataObject mObj = array.get((int)i).obj;
            BinaryMapIndexReader.TagValuePair pair = mObj.getMapIndex().decodeType(mObj.getTypes()[array.get((int)i).typeInd]);
            if (objOrder == 0) {
                if (array.get((int)i).order > minPolygonSize + (double)((int)array.get((int)i).order)) continue;
                this.drawPolygon(mObj, req, pGraphics2d, rc, pair);
            } else if (objOrder == 1 || objOrder == 2) {
                this.drawPolyline(mObj, req, pGraphics2d, rc, pair, mObj.getSimpleLayer(), objOrder == 1);
            } else if (objOrder == 3) {
                this.drawPoint(mObj, req, pGraphics2d, rc, pair, array.get((int)i).typeInd == 0);
            }
            if (i % 25 != 0 || !rc.interrupted) continue;
            return;
        }
    }

    public void generateNewBitmap(RenderingContext rc, List<BinaryMapDataObject> objects, Graphics2D pGraphics2d, RenderingRuleSearchRequest render, OsmBitmapPanel.IntermediateImageListener pListener) {
        long now = System.currentTimeMillis();
        if (rc.defaultColor != 0) {
            pGraphics2d.setColor(this.createColor(rc.defaultColor));
        }
        if (objects != null && !objects.isEmpty() && rc.width > 0 && rc.height > 0) {
            rc.cosRotateTileSize = (float)(Math.cos((float)Math.toRadians(rc.rotate)) * 256.0);
            rc.sinRotateTileSize = (float)(Math.sin((float)Math.toRadians(rc.rotate)) * 256.0);
            ArrayList<MapDataObjectPrimitive> pointsArray = new ArrayList<MapDataObjectPrimitive>();
            ArrayList<MapDataObjectPrimitive> polygonsArray = new ArrayList<MapDataObjectPrimitive>();
            ArrayList<MapDataObjectPrimitive> linesArray = new ArrayList<MapDataObjectPrimitive>();
            this.sortObjectsByProperOrder(rc, objects, render, pointsArray, polygonsArray, linesArray);
            rc.lastRenderedKey = 0;
            this.drawObject(rc, pGraphics2d, render, polygonsArray, 0);
            rc.lastRenderedKey = 5;
            if (rc.shadowRenderingMode > 1) {
                this.drawObject(rc, pGraphics2d, render, linesArray, 1);
            }
            rc.lastRenderedKey = 40;
            this.drawObject(rc, pGraphics2d, render, linesArray, 2);
            rc.lastRenderedKey = 60;
            pListener.propagateImage();
            this.drawObject(rc, pGraphics2d, render, pointsArray, 3);
            rc.lastRenderedKey = 125;
            pListener.propagateImage();
            long beforeIconTextTime = System.currentTimeMillis() - now;
            this.drawIconsOverCanvas(rc, pGraphics2d);
            this.textRenderer.drawTextOverCanvas(rc, pGraphics2d, rc.preferredLocale);
            long time = System.currentTimeMillis() - now;
            rc.renderingDebugInfo = String.format("Rendering: %s ms  (%s text)\n(%s points, %s points inside, %s of %s objects visible)", time, time - beforeIconTextTime, rc.pointCount, rc.pointInsideCount, rc.visible, rc.allObjects);
            log.debug((Object)rc.renderingDebugInfo);
        }
    }

    private void drawIconsOverCanvas(RenderingContext rc, Graphics2D pGraphics2d) {
        Collections.sort(rc.iconsToDraw, new Comparator<IconDrawInfo>(){

            @Override
            public int compare(IconDrawInfo object1, IconDrawInfo object2) {
                return object1.iconOrder - object2.iconOrder;
            }
        });
        QuadRect bounds = new QuadRect(0.0, 0.0, rc.width, rc.height);
        bounds.inset(-bounds.width() / 4.0, -bounds.height() / 4.0);
        QuadTree<Object> boundIntersections = new QuadTree<Object>(bounds, 4, 0.6f);
        ArrayList result = new ArrayList();
        for (IconDrawInfo icon : rc.iconsToDraw) {
            BufferedImage ico;
            if (icon.resId != null && (ico = RenderingIcons.getIcon(icon.resId, true)) != null && icon.y >= 0.0f && icon.y < (float)rc.height && icon.x >= 0.0f && icon.x < (float)rc.width) {
                int visbleWidth = icon.iconSize >= 0.0f ? (int)icon.iconSize : ico.getWidth();
                int visbleHeight = icon.iconSize >= 0.0f ? (int)icon.iconSize : ico.getHeight();
                boolean intersects = false;
                float coeff = rc.getDensityValue(rc.screenDensityRatio * rc.textScale);
                Rectangle2D rf = this.calculateRect(rc, icon, ico.getWidth(), ico.getHeight());
                Rectangle2D visibleRect = null;
                if (visbleHeight > 0 && visbleWidth > 0) {
                    visibleRect = this.calculateRect(rc, icon, visbleWidth, visbleHeight);
                    boundIntersections.queryInBox(new QuadRect(visibleRect.getMinX(), visibleRect.getMinY(), visibleRect.getMaxX(), visibleRect.getMaxY()), result);
                    for (Rectangle2D r : result) {
                        if (!r.intersects(visibleRect.getMinX(), visibleRect.getMinY(), visibleRect.getMaxX(), visibleRect.getMaxY())) continue;
                        intersects = true;
                        break;
                    }
                }
                if (!intersects) {
                    BufferedImage shield;
                    BufferedImage bufferedImage = shield = icon.shieldId == null ? null : RenderingIcons.getIcon(icon.shieldId, true);
                    if (shield != null) {
                        Rectangle2D shieldRf = this.calculateRect(rc, icon, shield.getWidth(), shield.getHeight());
                        if (coeff != 1.0f) {
                            Rectangle2D.Float src = new Rectangle2D.Float(0.0f, 0.0f, shield.getWidth(), shield.getHeight());
                            this.drawBitmap(pGraphics2d, shield, shieldRf, src);
                        } else {
                            this.drawBitmap(pGraphics2d, shield, shieldRf);
                        }
                    }
                    if (coeff != 1.0f) {
                        Rectangle2D.Float src = new Rectangle2D.Float(0.0f, 0.0f, ico.getWidth(), ico.getHeight());
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId_1, true), rf, src);
                        this.drawBitmap(pGraphics2d, ico, rf, src);
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId2, true), rf, src);
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId3, true), rf, src);
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId4, true), rf, src);
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId5, true), rf, src);
                    } else {
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId_1, true), rf);
                        this.drawBitmap(pGraphics2d, ico, rf);
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId2, true), rf);
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId3, true), rf);
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId4, true), rf);
                        this.drawBitmap(pGraphics2d, RenderingIcons.getIcon(icon.resId5, true), rf);
                    }
                    if (visibleRect != null) {
                        visibleRect.add(-visibleRect.getWidth() / 4.0, -visibleRect.getHeight() / 4.0);
                        boundIntersections.insert(visibleRect, new QuadRect(visibleRect.getMinX(), visibleRect.getMinY(), visibleRect.getMaxX(), visibleRect.getMaxY()));
                    }
                }
            }
            if (!rc.interrupted) continue;
            return;
        }
    }

    protected void drawBitmap(Graphics2D pGraphics2d, BufferedImage ico, Rectangle2D rf) {
        if (ico == null) {
            return;
        }
        pGraphics2d.drawImage((Image)ico, (int)rf.getX(), (int)rf.getY(), null);
    }

    protected void drawBitmap(Graphics2D pGraphics2d, BufferedImage ico, Rectangle2D rf, Rectangle2D src) {
        if (ico == null) {
            return;
        }
        pGraphics2d.drawImage(ico, (int)rf.getX(), (int)rf.getY(), (int)rf.getMaxX(), (int)rf.getMaxY(), (int)src.getMinX(), (int)src.getMinY(), (int)src.getMaxX(), (int)src.getMaxY(), null);
    }

    private Rectangle2D calculateRect(RenderingContext rc, IconDrawInfo icon, int visbleWidth, int visbleHeight) {
        float coeff = rc.getDensityValue(rc.screenDensityRatio * rc.textScale);
        float left = icon.x - (float)(visbleWidth / 2) * coeff;
        float top = icon.y - (float)(visbleHeight / 2) * coeff;
        float width = (float)visbleWidth * coeff;
        float height = (float)visbleHeight * coeff;
        Rectangle2D.Double rf = new Rectangle2D.Double(left, top, width, height);
        return rf;
    }

    Comparator<MapDataObjectPrimitive> sortByOrder() {
        return new Comparator<MapDataObjectPrimitive>(){

            @Override
            public int compare(MapDataObjectPrimitive i, MapDataObjectPrimitive j) {
                if (i.order == j.order) {
                    if (i.typeInd == j.typeInd) {
                        if (i.obj.getPointsLength() == j.obj.getPointsLength()) {
                            return 0;
                        }
                        return i.obj.getPointsLength() < j.obj.getPointsLength() ? -1 : 1;
                    }
                    return i.typeInd < j.typeInd ? -1 : 1;
                }
                return i.order < j.order ? -1 : 1;
            }
        };
    }

    Comparator<MapDataObjectPrimitive> sortPolygonsOrder() {
        return new Comparator<MapDataObjectPrimitive>(){

            @Override
            public int compare(MapDataObjectPrimitive i, MapDataObjectPrimitive j) {
                if (i.order == j.order) {
                    return i.typeInd < j.typeInd ? -1 : 1;
                }
                return i.order > j.order ? -1 : 1;
            }
        };
    }

    private void sortObjectsByProperOrder(RenderingContext rc, List<BinaryMapDataObject> objects, RenderingRuleSearchRequest render, List<MapDataObjectPrimitive> pointsArray, List<MapDataObjectPrimitive> polygonsArray, List<MapDataObjectPrimitive> linesResArray) {
        int sz = objects.size();
        ArrayList<MapDataObjectPrimitive> linesArray = new ArrayList<MapDataObjectPrimitive>();
        if (render != null) {
            render.clearState();
            float mult = (float)(1.0 / MapUtils.getPowZoom(Math.max(31 - (rc.zoom + 8), 0)));
            for (int i = 0; i < sz; ++i) {
                BinaryMapDataObject o = objects.get(i);
                for (int j = 0; j < o.getTypes().length; ++j) {
                    BinaryMapIndexReader.TagValuePair pair;
                    int wholeType = o.getTypes()[j];
                    int layer = 0;
                    if (o.getPointsLength() > 1) {
                        layer = o.getSimpleLayer();
                    }
                    if ((pair = o.getMapIndex().decodeType(wholeType)) == null) continue;
                    render.setTagValueZoomLayer(pair.tag, pair.value, rc.zoom, layer, o);
                    render.setBooleanFilter(render.ALL.R_AREA, o.isArea());
                    render.setBooleanFilter(render.ALL.R_POINT, o.getPointsLength() == 1);
                    render.setBooleanFilter(render.ALL.R_CYCLE, o.isCycle());
                    if (!render.search(5)) continue;
                    int objectType = render.getIntPropertyValue(render.ALL.R_OBJECT_TYPE);
                    int order = render.getIntPropertyValue(render.ALL.R_ORDER);
                    MapDataObjectPrimitive mapObj = new MapDataObjectPrimitive();
                    mapObj.objectType = objectType;
                    mapObj.order = order;
                    mapObj.typeInd = j;
                    mapObj.obj = o;
                    if (objectType == 3) {
                        MapDataObjectPrimitive pointObj = mapObj;
                        pointObj.objectType = 1;
                        double area = this.polygonArea(mapObj, mult);
                        if (area > 75.0) {
                            mapObj.order += 1.0 / area;
                            polygonsArray.add(mapObj);
                            pointsArray.add(pointObj);
                        }
                    } else if (objectType == 1) {
                        pointsArray.add(mapObj);
                    } else {
                        linesArray.add(mapObj);
                    }
                    if (!render.isSpecified(render.ALL.R_SHADOW_LEVEL)) continue;
                    rc.shadowLevelMin = Math.min(rc.shadowLevelMin, order);
                    rc.shadowLevelMax = Math.max(rc.shadowLevelMax, order);
                    render.clearValue(render.ALL.R_SHADOW_LEVEL);
                }
                if (!rc.interrupted) continue;
                return;
            }
        }
        Collections.sort(polygonsArray, this.sortByOrder());
        Collections.sort(pointsArray, this.sortByOrder());
        Collections.sort(linesArray, this.sortByOrder());
        this.filterLinesByDensity(rc, linesResArray, linesArray);
    }

    void filterLinesByDensity(RenderingContext rc, List<MapDataObjectPrimitive> linesResArray, List<MapDataObjectPrimitive> linesArray) {
        linesResArray.addAll(linesArray);
    }

    private double polygonArea(MapDataObjectPrimitive mapObj, float mult) {
        double area = 0.0;
        int j = mapObj.obj.getPointsLength() - 1;
        int i = 0;
        while (i < mapObj.obj.getPointsLength()) {
            int px = mapObj.obj.getPoint31XTile(i);
            int py = mapObj.obj.getPoint31YTile(i);
            int sx = mapObj.obj.getPoint31XTile(j);
            int sy = mapObj.obj.getPoint31YTile(j);
            area += (double)(((float)sx + (float)px) * ((float)sy - (float)py));
            j = i++;
        }
        return Math.abs(area) * (double)mult * (double)mult * 0.5;
    }

    private Point2D calcPoint(int xt, int yt, RenderingContext rc) {
        ++rc.pointCount;
        double tx = (double)xt / rc.tileDivisor;
        double ty = (double)yt / rc.tileDivisor;
        double dTileX = tx - rc.leftX;
        double dTileY = ty - rc.topY;
        float x = (float)((double)rc.cosRotateTileSize * dTileX - (double)rc.sinRotateTileSize * dTileY);
        float y = (float)((double)rc.sinRotateTileSize * dTileX + (double)rc.cosRotateTileSize * dTileY);
        rc.tempPoint.setLocation(x, y);
        if (rc.tempPoint.getX() >= 0.0 && rc.tempPoint.getX() < (double)rc.width && rc.tempPoint.getY() >= 0.0 && rc.tempPoint.getY() < (double)rc.height) {
            ++rc.pointInsideCount;
        }
        return rc.tempPoint;
    }

    private Point2D calcPoint(BinaryMapDataObject o, int ind, RenderingContext rc) {
        return this.calcPoint(o.getPoint31XTile(ind), o.getPoint31YTile(ind), rc);
    }

    public void clearCachedResources() {
        this.shaders.clear();
    }

    private void drawPolygon(BinaryMapDataObject obj, RenderingRuleSearchRequest render, Graphics2D pGraphics2d, RenderingContext rc, BinaryMapIndexReader.TagValuePair pair) {
        if (render == null || pair == null) {
            return;
        }
        float xText = 0.0f;
        float yText = 0.0f;
        int zoom = rc.zoom;
        Path2D path = null;
        Graphics2D newGraphics = (Graphics2D)pGraphics2d.create();
        render.setInitialTagValueZoom(pair.tag, pair.value, zoom, obj);
        boolean rendered = render.search(3);
        if (!rendered || !this.updatePaint(render, newGraphics, 0, true, rc)) {
            newGraphics.dispose();
            return;
        }
        ++rc.visible;
        int len = obj.getPointsLength();
        for (int i = 0; i < obj.getPointsLength(); ++i) {
            Point2D p = this.calcPoint(obj, i, rc);
            xText = (float)((double)xText + p.getX());
            yText = (float)((double)yText + p.getY());
            if (path == null) {
                path = new Path2D.Float();
                path.moveTo(p.getX(), p.getY());
                continue;
            }
            path.lineTo(p.getX(), p.getY());
        }
        int[][] polygonInnerCoordinates = obj.getPolygonInnerCoordinates();
        if (polygonInnerCoordinates != null && path != null) {
            path.setWindingRule(0);
            for (int j = 0; j < polygonInnerCoordinates.length; ++j) {
                for (int i = 0; i < polygonInnerCoordinates[j].length; i += 2) {
                    Point2D p = this.calcPoint(polygonInnerCoordinates[j][i], polygonInnerCoordinates[j][i + 1], rc);
                    if (i == 0) {
                        path.moveTo(p.getX(), p.getY());
                        continue;
                    }
                    path.lineTo(p.getX(), p.getY());
                }
            }
        }
        if (path != null && len > 0) {
            newGraphics.fill(path);
            this.updateAndDraw(render, newGraphics, rc, path, true, false, 1);
            this.textRenderer.renderText(obj, render, pGraphics2d, rc, pair, xText / (float)len, yText / (float)len, null, null);
        }
        newGraphics.dispose();
    }

    public boolean updatePaint(RenderingRuleSearchRequest req, Graphics2D pGraphics, int ind, boolean area, RenderingContext rc) {
        Paint p = new Paint();
        boolean res = this.updatePaint(req, p, ind, area, rc);
        p.updateGraphics(pGraphics);
        return res;
    }

    public boolean updatePaint(RenderingRuleSearchRequest req, Paint p, int ind, boolean area, RenderingContext rc) {
        RenderingRuleProperty rPathEff;
        RenderingRuleProperty rCap;
        RenderingRuleProperty rStrokeW;
        RenderingRuleProperty rColor;
        if (ind == 0) {
            rColor = req.ALL.R_COLOR;
            rStrokeW = req.ALL.R_STROKE_WIDTH;
            rCap = req.ALL.R_CAP;
            rPathEff = req.ALL.R_PATH_EFFECT;
        } else if (ind == 1) {
            rColor = req.ALL.R_COLOR_2;
            rStrokeW = req.ALL.R_STROKE_WIDTH_2;
            rCap = req.ALL.R_CAP_2;
            rPathEff = req.ALL.R_PATH_EFFECT_2;
        } else if (ind == -1) {
            rColor = req.ALL.R_COLOR_0;
            rStrokeW = req.ALL.R_STROKE_WIDTH_0;
            rCap = req.ALL.R_CAP_0;
            rPathEff = req.ALL.R_PATH_EFFECT_0;
        } else if (ind == -2) {
            rColor = req.ALL.R_COLOR__1;
            rStrokeW = req.ALL.R_STROKE_WIDTH__1;
            rCap = req.ALL.R_CAP__1;
            rPathEff = req.ALL.R_PATH_EFFECT__1;
        } else if (ind == 2) {
            rColor = req.ALL.R_COLOR_3;
            rStrokeW = req.ALL.R_STROKE_WIDTH_3;
            rCap = req.ALL.R_CAP_3;
            rPathEff = req.ALL.R_PATH_EFFECT_3;
        } else if (ind == -3) {
            rColor = req.ALL.R_COLOR__2;
            rStrokeW = req.ALL.R_STROKE_WIDTH__2;
            rCap = req.ALL.R_CAP__2;
            rPathEff = req.ALL.R_PATH_EFFECT__2;
        } else if (ind == 3) {
            rColor = req.ALL.R_COLOR_4;
            rStrokeW = req.ALL.R_STROKE_WIDTH_4;
            rCap = req.ALL.R_CAP_4;
            rPathEff = req.ALL.R_PATH_EFFECT_4;
        } else {
            rColor = req.ALL.R_COLOR_5;
            rStrokeW = req.ALL.R_STROKE_WIDTH_5;
            rCap = req.ALL.R_CAP_5;
            rPathEff = req.ALL.R_PATH_EFFECT_5;
        }
        if (area) {
            if (!req.isSpecified(rColor) && !req.isSpecified(req.ALL.R_SHADER)) {
                return false;
            }
            p.setShader(null);
            p.setColorFilter(null);
            p.clearShadowLayer();
            p.setStyle(Paint.Style.FILL_AND_STROKE);
            p.setStrokeWidth(0.0f);
        } else {
            String pathEffect;
            if (!req.isSpecified(rStrokeW)) {
                return false;
            }
            p.setShader(null);
            p.setColorFilter(null);
            p.clearShadowLayer();
            p.setStyle(Paint.Style.STROKE);
            float width = rc.getComplexValue(req, rStrokeW);
            width = Math.max(0.0f, width);
            int capValue = 0;
            String cap = req.getStringPropertyValue(rCap);
            if (!Algorithms.isEmpty(cap)) {
                capValue = Cap.valueOf(cap.toUpperCase()).getVal();
            }
            if (!Algorithms.isEmpty(pathEffect = req.getStringPropertyValue(rPathEff))) {
                if (!this.parsedDashEffects.containsKey(pathEffect)) {
                    String[] vls = pathEffect.split("_");
                    float[] vs = new float[vls.length * 2];
                    for (int i = 0; i < vls.length; ++i) {
                        int s = vls[i].indexOf(58);
                        String pre = vls[i];
                        String post = "";
                        if (s != -1) {
                            pre = vls[i].substring(0, i);
                            post = vls[i].substring(i + 1);
                        }
                        if (pre.length() > 0) {
                            vs[i * 2] = Float.parseFloat(pre);
                        }
                        if (post.length() <= 0) continue;
                        vs[i * 2 + 1] = Float.parseFloat(post);
                    }
                    this.parsedDashEffects.put(pathEffect, vs);
                }
                float[] cachedValues = this.parsedDashEffects.get(pathEffect);
                p.setStroke(this.getDashEffect(width, rc, cachedValues, 0.0f, capValue));
            } else {
                p.setStroke(new BasicStroke(width, capValue, 1));
            }
        }
        p.setColor(this.createColor(req.getIntPropertyValue(rColor)));
        if (ind == 0) {
            String resId = req.getStringPropertyValue(req.ALL.R_SHADER);
            if (resId != null) {
                if (req.getIntPropertyValue(rColor) == 0) {
                    p.setColor(Color.WHITE);
                }
                p.setPaint(this.getShader(resId));
            }
            if (rc.shadowRenderingMode == 1) {
                int shadowColor = req.getIntPropertyValue(req.ALL.R_SHADOW_COLOR);
                if (shadowColor == 0) {
                    shadowColor = rc.shadowRenderingColor;
                }
                throw new IllegalArgumentException("Shadow not implemented here");
            }
        }
        return true;
    }

    public Color createColor(int colorInt) {
        return ColorUtils.createARGB(colorInt);
    }

    private void drawPoint(BinaryMapDataObject obj, RenderingRuleSearchRequest render, Graphics2D pGraphics2d, RenderingContext rc, BinaryMapIndexReader.TagValuePair pair, boolean renderText) {
        if (render == null || pair == null) {
            return;
        }
        render.setInitialTagValueZoom(pair.tag, pair.value, rc.zoom, obj);
        render.search(1);
        String resId = render.getStringPropertyValue(render.ALL.R_ICON);
        if (resId == null && !renderText) {
            return;
        }
        int len = obj.getPointsLength();
        ++rc.visible;
        Point2D.Double ps = new Point2D.Double(0.0, 0.0);
        for (int i = 0; i < len; ++i) {
            Point2D p = this.calcPoint(obj, i, rc);
            ((Point2D)ps).setLocation(((Point2D)ps).getX() + p.getX(), ((Point2D)ps).getY() + p.getY());
        }
        if (len > 1) {
            ((Point2D)ps).setLocation(((Point2D)ps).getX() / (double)len, ((Point2D)ps).getY() / (double)len);
        }
        if (resId != null) {
            IconDrawInfo ico = new IconDrawInfo();
            ico.x = (float)((Point2D)ps).getX();
            ico.y = (float)((Point2D)ps).getY();
            ico.iconOrder = render.getIntPropertyValue(render.ALL.R_ICON_ORDER, 100);
            ico.iconSize = rc.getComplexValue(render, render.ALL.R_ICON_VISIBLE_SIZE, -1);
            ico.shieldId = render.getStringPropertyValue(render.ALL.R_SHIELD);
            ico.resId_1 = render.getStringPropertyValue(render.ALL.R_ICON__1);
            ico.resId = resId;
            ico.resId2 = render.getStringPropertyValue(render.ALL.R_ICON_2);
            ico.resId3 = render.getStringPropertyValue(render.ALL.R_ICON_3);
            ico.resId4 = render.getStringPropertyValue(render.ALL.R_ICON_4);
            ico.resId5 = render.getStringPropertyValue(render.ALL.R_ICON_5);
            rc.iconsToDraw.add(ico);
        }
        if (renderText) {
            this.textRenderer.renderText(obj, render, pGraphics2d, rc, pair, ((Point2D)ps).getX(), ((Point2D)ps).getY(), null, null);
        }
    }

    private void drawPolylineShadow(Graphics2D pGraphics2d, RenderingContext rc, Path2D pPath, int shadowColor, int shadowRadius) {
        if (rc.shadowRenderingMode == 2 && shadowRadius > 0) {
            this.drawPath(pGraphics2d, pPath);
            throw new IllegalArgumentException("Shadow type not implemented");
        }
        if (rc.shadowRenderingMode == 3 && shadowRadius > 0) {
            Graphics2D newGraphics = (Graphics2D)pGraphics2d.create();
            if (newGraphics.getStroke() instanceof BasicStroke) {
                BasicStroke bs = (BasicStroke)newGraphics.getStroke();
                newGraphics.setStroke(new BasicStroke(bs.getLineWidth() + (float)(shadowRadius * 2)));
            }
            newGraphics.setComposite(AlphaComposite.getInstance(5));
            newGraphics.setColor(this.createColor(shadowColor));
            this.drawPath(newGraphics, pPath);
            newGraphics.dispose();
        }
    }

    private void drawPolyline(BinaryMapDataObject obj, RenderingRuleSearchRequest render, Graphics2D pGraphics2d, RenderingContext rc, BinaryMapIndexReader.TagValuePair pair, int layer, boolean drawOnlyShadow) {
        if (render == null || pair == null) {
            return;
        }
        int length = obj.getPointsLength();
        if (length < 2) {
            return;
        }
        render.setInitialTagValueZoom(pair.tag, pair.value, rc.zoom, obj);
        render.setIntFilter(render.ALL.R_LAYER, layer);
        boolean rendered = render.search(2);
        if (!rendered || !this.updatePaint(render, pGraphics2d, 0, false, rc)) {
            return;
        }
        int oneway = 0;
        if (rc.zoom >= 16 && "highway".equals(pair.tag)) {
            if (obj.containsAdditionalType(obj.getMapIndex().onewayAttribute)) {
                oneway = 1;
            } else if (obj.containsAdditionalType(obj.getMapIndex().onewayReverseAttribute)) {
                oneway = -1;
            }
        }
        ++rc.visible;
        Path2D.Float path = null;
        float xMid = 0.0f;
        float yMid = 0.0f;
        int middle = obj.getPointsLength() / 2;
        Point2D[] textPoints = null;
        if (!drawOnlyShadow) {
            textPoints = new Point2D[length];
        }
        boolean intersect = false;
        Point2D prev = null;
        for (int i = 0; i < length; ++i) {
            Point2D p = this.calcPoint(obj, i, rc);
            if (textPoints != null) {
                textPoints[i] = new Point2D.Double(p.getX(), p.getY());
            }
            if (!intersect) {
                if (p.getX() >= 0.0 && p.getY() >= 0.0 && p.getX() < (double)rc.width && p.getY() < (double)rc.height) {
                    intersect = true;
                }
                if (!intersect && prev != null) {
                    intersect = !(p.getX() < 0.0 && prev.getX() < 0.0 || p.getY() < 0.0 && prev.getY() < 0.0 || p.getX() > (double)rc.width && prev.getX() > (double)rc.width || p.getY() > (double)rc.height && prev.getY() > (double)rc.height);
                }
            }
            if (path == null) {
                path = new Path2D.Float();
                ((Path2D)path).moveTo(p.getX(), p.getY());
            } else {
                if (i == middle) {
                    xMid = (float)p.getX();
                    yMid = (float)p.getY();
                }
                ((Path2D)path).lineTo(p.getX(), p.getY());
            }
            prev = p;
        }
        if (!intersect) {
            return;
        }
        if (path != null) {
            if (drawOnlyShadow) {
                int shadowColor = render.getIntPropertyValue(render.ALL.R_SHADOW_COLOR);
                int shadowRadius = (int)rc.getComplexValue(render, render.ALL.R_SHADOW_RADIUS);
                if (shadowColor == 0) {
                    shadowColor = rc.shadowRenderingColor;
                }
                this.drawPolylineShadow(pGraphics2d, rc, path, shadowColor, shadowRadius);
            } else {
                boolean update = false;
                update = this.updateAndDraw(render, pGraphics2d, rc, path, true, false, -3);
                update = this.updateAndDraw(render, pGraphics2d, rc, path, true, false, -2);
                update = this.updateAndDraw(render, pGraphics2d, rc, path, true, false, -1);
                update = this.updateAndDraw(render, pGraphics2d, rc, path, update, true, 0);
                this.updateAndDraw(render, pGraphics2d, rc, path, true, false, 1);
                this.updateAndDraw(render, pGraphics2d, rc, path, true, false, 2);
                this.updateAndDraw(render, pGraphics2d, rc, path, true, false, 3);
                this.updateAndDraw(render, pGraphics2d, rc, path, true, false, 4);
            }
            if (oneway != 0 && !drawOnlyShadow) {
                Stroke oldStroke = pGraphics2d.getStroke();
                Stroke[] strokes = oneway == -1 ? this.getReverseOneWayPaints(rc) : this.getOneWayPaints(rc);
                for (int i = 0; i < strokes.length; ++i) {
                    pGraphics2d.setColor(this.createColor(-9670443));
                    pGraphics2d.setStroke(strokes[i]);
                    this.drawPath(pGraphics2d, path);
                }
                pGraphics2d.setStroke(oldStroke);
            }
            if (textPoints != null) {
                this.textRenderer.renderText(obj, render, pGraphics2d, rc, pair, xMid, yMid, path, textPoints);
            }
        }
    }

    private boolean updateAndDraw(RenderingRuleSearchRequest render, Graphics2D pGraphics2d, RenderingContext rc, Path2D path, boolean doUpdate, boolean pDontCheckUpdateResult, int pInd) {
        boolean update = false;
        Graphics2D newGraphics = (Graphics2D)pGraphics2d.create();
        if (doUpdate) {
            update = this.updatePaint(render, newGraphics, pInd, false, rc);
        }
        if (pDontCheckUpdateResult || update) {
            this.drawPath(newGraphics, path);
        }
        newGraphics.dispose();
        return update;
    }

    private void drawPath(Graphics2D pGraphics2d, Path2D pPath) {
        pGraphics2d.draw(pPath);
    }

    private static Stroke oneWayPaint(float pWidth, DashPathEffect pDashEffect) {
        return new BasicStroke(pWidth, 0, 2, 1.0f, pDashEffect.getDashes(), pDashEffect.getDashPhase());
    }

    public Stroke[] getReverseOneWayPaints(RenderingContext rc) {
        if (rc.reverseOneWay == null) {
            int rmin = (int)rc.getDensityValue(1.0f);
            if (rmin > 2) {
                rmin /= 2;
            }
            DashPathEffect arrowDashEffect1 = new DashPathEffect(new float[]{0.0f, 12.0f, 10 * rmin, 152.0f}, 0.0f);
            DashPathEffect arrowDashEffect2 = new DashPathEffect(new float[]{0.0f, 12 + rmin, 9 * rmin, 152.0f}, 1.0f);
            DashPathEffect arrowDashEffect3 = new DashPathEffect(new float[]{0.0f, 12 + 2 * rmin, 2 * rmin, 152 + 6 * rmin}, 1.0f);
            DashPathEffect arrowDashEffect4 = new DashPathEffect(new float[]{0.0f, 12 + 3 * rmin, 1 * rmin, 152 + 6 * rmin}, 1.0f);
            rc.reverseOneWay = new Stroke[4];
            rc.reverseOneWay[0] = OsmandRenderer.oneWayPaint(rmin * 2, arrowDashEffect1);
            rc.reverseOneWay[1] = OsmandRenderer.oneWayPaint(rmin, arrowDashEffect2);
            rc.reverseOneWay[2] = OsmandRenderer.oneWayPaint(rmin * 3, arrowDashEffect3);
            rc.reverseOneWay[3] = OsmandRenderer.oneWayPaint(rmin * 4, arrowDashEffect4);
        }
        return rc.reverseOneWay;
    }

    public Stroke[] getOneWayPaints(RenderingContext rc) {
        if (rc.oneWay == null) {
            float rmin = rc.getDensityValue(1.0f);
            if (rmin > 1.0f) {
                rmin = rmin * 2.0f / 3.0f;
            }
            DashPathEffect arrowDashEffect1 = new DashPathEffect(new float[]{0.0f, 12.0f, 10.0f * rmin, 152.0f}, 0.0f);
            DashPathEffect arrowDashEffect2 = new DashPathEffect(new float[]{0.0f, 12.0f, 9.0f * rmin, 152.0f + rmin}, 1.0f);
            DashPathEffect arrowDashEffect3 = new DashPathEffect(new float[]{0.0f, 12.0f + 6.0f * rmin, 2.0f * rmin, 152.0f + 2.0f * rmin}, 1.0f);
            DashPathEffect arrowDashEffect4 = new DashPathEffect(new float[]{0.0f, 12.0f + 6.0f * rmin, 1.0f * rmin, 152.0f + 3.0f * rmin}, 1.0f);
            rc.oneWay = new Stroke[4];
            rc.oneWay[0] = OsmandRenderer.oneWayPaint(rmin, arrowDashEffect1);
            rc.oneWay[1] = OsmandRenderer.oneWayPaint(rmin * 2.0f, arrowDashEffect2);
            rc.oneWay[2] = OsmandRenderer.oneWayPaint(rmin * 3.0f, arrowDashEffect3);
            rc.oneWay[3] = OsmandRenderer.oneWayPaint(rmin * 4.0f, arrowDashEffect4);
        }
        return rc.oneWay;
    }

    public static class RenderingContext
    extends net.osmand.RenderingContext {
        List<TextRenderer.TextDrawInfo> textToDraw = new ArrayList<TextRenderer.TextDrawInfo>();
        List<IconDrawInfo> iconsToDraw = new ArrayList<IconDrawInfo>();
        RenderingResult result = new RenderingResult();
        Stroke[] oneWay;
        Stroke[] reverseOneWay;
        Point2D tempPoint = new Point2D.Double();
        float cosRotateTileSize;
        float sinRotateTileSize;
        int shadowLevelMin = 256;
        int shadowLevelMax = 0;
        boolean ended = false;

        @Override
        protected byte[] getIconRawData(String data) {
            return RenderingIcons.getIconRawData(data);
        }
    }

    public static class RenderingResult {
        public List<TextInfo> effectiveTextObjects = new ArrayList<TextInfo>();
    }

    public static class TextInfo {
        public String mText;
        public Path2D path;
    }

    private static class IconDrawInfo {
        float x = 0.0f;
        float y = 0.0f;
        String resId_1;
        String resId;
        String resId2;
        String resId3;
        String resId4;
        String resId5;
        String shieldId;
        int iconOrder;
        float iconSize;

        private IconDrawInfo() {
        }
    }

    public class MapDataObjectPrimitive {
        BinaryMapDataObject obj;
        int typeInd;
        double order;
        int objectType;
    }
}

