/// <reference path="thenable.d.ts" />
/// <reference types="node" />
import { Message, MessageType, RequestMessage, RequestType, RequestType0, RequestType1, RequestType2, RequestType3, RequestType4, RequestType5, RequestType6, RequestType7, RequestType8, RequestType9, ResponseMessage, ResponseError, ErrorCodes, NotificationMessage, NotificationType, NotificationType0, NotificationType1, NotificationType2, NotificationType3, NotificationType4, NotificationType5, NotificationType6, NotificationType7, NotificationType8, NotificationType9 } from './messages';
import { MessageReader, DataCallback, StreamMessageReader, IPCMessageReader, SocketMessageReader } from './messageReader';
import { MessageWriter, StreamMessageWriter, IPCMessageWriter, SocketMessageWriter } from './messageWriter';
import { Disposable, Event, Emitter } from './events';
import { CancellationTokenSource, CancellationToken } from './cancellation';
import { LinkedMap } from './linkedMap';
export { Message, MessageType, ErrorCodes, ResponseError, RequestMessage, RequestType, RequestType0, RequestType1, RequestType2, RequestType3, RequestType4, RequestType5, RequestType6, RequestType7, RequestType8, RequestType9, NotificationMessage, NotificationType, NotificationType0, NotificationType1, NotificationType2, NotificationType3, NotificationType4, NotificationType5, NotificationType6, NotificationType7, NotificationType8, NotificationType9, MessageReader, DataCallback, StreamMessageReader, IPCMessageReader, SocketMessageReader, MessageWriter, StreamMessageWriter, IPCMessageWriter, SocketMessageWriter, CancellationTokenSource, CancellationToken, Disposable, Event, Emitter };
export * from './pipeSupport';
export * from './socketSupport';
export declare type HandlerResult<R, E> = R | ResponseError<E> | Thenable<R> | Thenable<ResponseError<E>> | Thenable<R | ResponseError<E>>;
export interface StarRequestHandler {
    (method: string, ...params: any[]): HandlerResult<any, any>;
}
export interface GenericRequestHandler<R, E> {
    (...params: any[]): HandlerResult<R, E>;
}
export interface RequestHandler0<R, E> {
    (token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler<P, R, E> {
    (params: P, token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler1<P1, R, E> {
    (p1: P1, token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler2<P1, P2, R, E> {
    (p1: P1, p2: P2, token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler3<P1, P2, P3, R, E> {
    (p1: P1, p2: P2, p3: P3, token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler4<P1, P2, P3, P4, R, E> {
    (p1: P1, p2: P2, p3: P3, p4: P4, token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler5<P1, P2, P3, P4, P5, R, E> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler6<P1, P2, P3, P4, P5, P6, R, E> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler7<P1, P2, P3, P4, P5, P6, P7, R, E> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler8<P1, P2, P3, P4, P5, P6, P7, P8, R, E> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, p8: P8, token: CancellationToken): HandlerResult<R, E>;
}
export interface RequestHandler9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R, E> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, p8: P8, p9: P9, token: CancellationToken): HandlerResult<R, E>;
}
export interface StarNotificationHandler {
    (method: string, ...params: any[]): void;
}
export interface GenericNotificationHandler {
    (...params: any[]): void;
}
export interface NotificationHandler0 {
    (): void;
}
export interface NotificationHandler<P> {
    (params: P): void;
}
export interface NotificationHandler1<P1> {
    (p1: P1): void;
}
export interface NotificationHandler2<P1, P2> {
    (p1: P1, p2: P2): void;
}
export interface NotificationHandler3<P1, P2, P3> {
    (p1: P1, p2: P2, p3: P3): void;
}
export interface NotificationHandler4<P1, P2, P3, P4> {
    (p1: P1, p2: P2, p3: P3, p4: P4): void;
}
export interface NotificationHandler5<P1, P2, P3, P4, P5> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5): void;
}
export interface NotificationHandler6<P1, P2, P3, P4, P5, P6> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6): void;
}
export interface NotificationHandler7<P1, P2, P3, P4, P5, P6, P7> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7): void;
}
export interface NotificationHandler8<P1, P2, P3, P4, P5, P6, P7, P8> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, p8: P8): void;
}
export interface NotificationHandler9<P1, P2, P3, P4, P5, P6, P7, P8, P9> {
    (p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, p8: P8, p9: P9): void;
}
export interface Logger {
    error(message: string): void;
    warn(message: string): void;
    info(message: string): void;
    log(message: string): void;
}
export declare const NullLogger: Logger;
export declare enum Trace {
    Off = 0,
    Messages = 1,
    Verbose = 2
}
export declare type TraceValues = 'off' | 'messages' | 'verbose';
export declare namespace Trace {
    function fromString(value: string): Trace;
    function toString(value: Trace): TraceValues;
}
export declare enum TraceFormat {
    Text = "text",
    JSON = "json"
}
export declare namespace TraceFormat {
    function fromString(value: string): TraceFormat;
}
export interface TraceOptions {
    sendNotification?: boolean;
    traceFormat?: TraceFormat;
}
export interface SetTraceParams {
    value: TraceValues;
}
export declare namespace SetTraceNotification {
    const type: NotificationType<SetTraceParams, void>;
}
export interface LogTraceParams {
    message: string;
    verbose?: string;
}
export declare namespace LogTraceNotification {
    const type: NotificationType<LogTraceParams, void>;
}
export interface Tracer {
    log(dataObject: any): void;
    log(message: string, data?: string): void;
}
export declare enum ConnectionErrors {
    /**
     * The connection is closed.
     */
    Closed = 1,
    /**
     * The connection got disposed.
     */
    Disposed = 2,
    /**
     * The connection is already in listening mode.
     */
    AlreadyListening = 3
}
export declare class ConnectionError extends Error {
    readonly code: ConnectionErrors;
    constructor(code: ConnectionErrors, message: string);
}
export declare type MessageQueue = LinkedMap<string, Message>;
export declare type ConnectionStrategy = {
    cancelUndispatched?: (message: Message, next: (message: Message) => ResponseMessage | undefined) => ResponseMessage | undefined;
};
export declare namespace ConnectionStrategy {
    function is(value: any): value is ConnectionStrategy;
}
export interface MessageConnection {
    sendRequest<R, E, RO>(type: RequestType0<R, E, RO>, token?: CancellationToken): Thenable<R>;
    sendRequest<P, R, E, RO>(type: RequestType<P, R, E, RO>, params: P, token?: CancellationToken): Thenable<R>;
    sendRequest<P1, R, E, RO>(type: RequestType1<P1, R, E, RO>, p1: P1, token?: CancellationToken): Thenable<R>;
    sendRequest<P1, P2, R, E, RO>(type: RequestType2<P1, P2, R, E, RO>, p1: P1, p2: P2, token?: CancellationToken): Thenable<R>;
    sendRequest<P1, P2, P3, R, E, RO>(type: RequestType3<P1, P2, P3, R, E, RO>, p1: P1, p2: P2, p3: P3, token?: CancellationToken): Thenable<R>;
    sendRequest<P1, P2, P3, P4, R, E, RO>(type: RequestType4<P1, P2, P3, P4, R, E, RO>, p1: P1, p2: P2, p3: P3, p4: P4, token?: CancellationToken): Thenable<R>;
    sendRequest<P1, P2, P3, P4, P5, R, E, RO>(type: RequestType5<P1, P2, P3, P4, P5, R, E, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, token?: CancellationToken): Thenable<R>;
    sendRequest<P1, P2, P3, P4, P5, P6, R, E, RO>(type: RequestType6<P1, P2, P3, P4, P5, P6, R, E, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, token?: CancellationToken): Thenable<R>;
    sendRequest<P1, P2, P3, P4, P5, P6, P7, R, E, RO>(type: RequestType7<P1, P2, P3, P4, P5, P6, P7, R, E, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, token?: CancellationToken): Thenable<R>;
    sendRequest<P1, P2, P3, P4, P5, P6, P7, P8, R, E, RO>(type: RequestType8<P1, P2, P3, P4, P5, P6, P7, P8, R, E, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, p8: P8, token?: CancellationToken): Thenable<R>;
    sendRequest<P1, P2, P3, P4, P5, P6, P7, P8, P9, R, E, RO>(type: RequestType9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R, E, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, p8: P8, p9: P9, token?: CancellationToken): Thenable<R>;
    sendRequest<R>(method: string, ...params: any[]): Thenable<R>;
    onRequest<R, E, RO>(type: RequestType0<R, E, RO>, handler: RequestHandler0<R, E>): void;
    onRequest<P, R, E, RO>(type: RequestType<P, R, E, RO>, handler: RequestHandler<P, R, E>): void;
    onRequest<P1, R, E, RO>(type: RequestType1<P1, R, E, RO>, handler: RequestHandler1<P1, R, E>): void;
    onRequest<P1, P2, R, E, RO>(type: RequestType2<P1, P2, R, E, RO>, handler: RequestHandler2<P1, P2, R, E>): void;
    onRequest<P1, P2, P3, R, E, RO>(type: RequestType3<P1, P2, P3, R, E, RO>, handler: RequestHandler3<P1, P2, P3, R, E>): void;
    onRequest<P1, P2, P3, P4, R, E, RO>(type: RequestType4<P1, P2, P3, P4, R, E, RO>, handler: RequestHandler4<P1, P2, P3, P4, R, E>): void;
    onRequest<P1, P2, P3, P4, P5, R, E, RO>(type: RequestType5<P1, P2, P3, P4, P5, R, E, RO>, handler: RequestHandler5<P1, P2, P3, P4, P5, R, E>): void;
    onRequest<P1, P2, P3, P4, P5, P6, R, E, RO>(type: RequestType6<P1, P2, P3, P4, P5, P6, R, E, RO>, handler: RequestHandler6<P1, P2, P3, P4, P5, P6, R, E>): void;
    onRequest<P1, P2, P3, P4, P5, P6, P7, R, E, RO>(type: RequestType7<P1, P2, P3, P4, P5, P6, P7, R, E, RO>, handler: RequestHandler7<P1, P2, P3, P4, P5, P6, P7, R, E>): void;
    onRequest<P1, P2, P3, P4, P5, P6, P7, P8, R, E, RO>(type: RequestType8<P1, P2, P3, P4, P5, P6, P7, P8, R, E, RO>, handler: RequestHandler8<P1, P2, P3, P4, P5, P6, P7, P8, R, E>): void;
    onRequest<P1, P2, P3, P4, P5, P6, P7, P8, P9, R, E, RO>(type: RequestType9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R, E, RO>, handler: RequestHandler9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R, E>): void;
    onRequest<R, E>(method: string, handler: GenericRequestHandler<R, E>): void;
    onRequest(handler: StarRequestHandler): void;
    sendNotification<RO>(type: NotificationType0<RO>): void;
    sendNotification<P, RO>(type: NotificationType<P, RO>, params?: P): void;
    sendNotification<P1, RO>(type: NotificationType1<P1, RO>, p1: P1): void;
    sendNotification<P1, P2, RO>(type: NotificationType2<P1, P2, RO>, p1: P1, p2: P2): void;
    sendNotification<P1, P2, P3, RO>(type: NotificationType3<P1, P2, P3, RO>, p1: P1, p2: P2, p3: P3): void;
    sendNotification<P1, P2, P3, P4, RO>(type: NotificationType4<P1, P2, P3, P4, RO>, p1: P1, p2: P2, p3: P3, p4: P4): void;
    sendNotification<P1, P2, P3, P4, P5, RO>(type: NotificationType5<P1, P2, P3, P4, P5, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5): void;
    sendNotification<P1, P2, P3, P4, P5, P6, RO>(type: NotificationType6<P1, P2, P3, P4, P5, P6, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6): void;
    sendNotification<P1, P2, P3, P4, P5, P6, P7, RO>(type: NotificationType7<P1, P2, P3, P4, P5, P6, P7, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7): void;
    sendNotification<P1, P2, P3, P4, P5, P6, P7, P8, RO>(type: NotificationType8<P1, P2, P3, P4, P5, P6, P7, P8, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, p8: P8): void;
    sendNotification<P1, P2, P3, P4, P5, P6, P7, P8, P9, RO>(type: NotificationType9<P1, P2, P3, P4, P5, P6, P7, P8, P9, RO>, p1: P1, p2: P2, p3: P3, p4: P4, p5: P5, p6: P6, p7: P7, p8: P8, p9: P9): void;
    sendNotification(method: string, ...params: any[]): void;
    onNotification<RO>(type: NotificationType0<RO>, handler: NotificationHandler0): void;
    onNotification<P, RO>(type: NotificationType<P, RO>, handler: NotificationHandler<P>): void;
    onNotification<P1, RO>(type: NotificationType1<P1, RO>, handler: NotificationHandler1<P1>): void;
    onNotification<P1, P2, RO>(type: NotificationType2<P1, P2, RO>, handler: NotificationHandler2<P1, P2>): void;
    onNotification<P1, P2, P3, RO>(type: NotificationType3<P1, P2, P3, RO>, handler: NotificationHandler3<P1, P2, P3>): void;
    onNotification<P1, P2, P3, P4, RO>(type: NotificationType4<P1, P2, P3, P4, RO>, handler: NotificationHandler4<P1, P2, P3, P4>): void;
    onNotification<P1, P2, P3, P4, P5, RO>(type: NotificationType5<P1, P2, P3, P4, P5, RO>, handler: NotificationHandler5<P1, P2, P3, P4, P5>): void;
    onNotification<P1, P2, P3, P4, P5, P6, RO>(type: NotificationType6<P1, P2, P3, P4, P5, P6, RO>, handler: NotificationHandler6<P1, P2, P3, P4, P5, P6>): void;
    onNotification<P1, P2, P3, P4, P5, P6, P7, RO>(type: NotificationType7<P1, P2, P3, P4, P5, P6, P7, RO>, handler: NotificationHandler7<P1, P2, P3, P4, P5, P6, P7>): void;
    onNotification<P1, P2, P3, P4, P5, P6, P7, P8, RO>(type: NotificationType8<P1, P2, P3, P4, P5, P6, P7, P8, RO>, handler: NotificationHandler8<P1, P2, P3, P4, P5, P6, P7, P8>): void;
    onNotification<P1, P2, P3, P4, P5, P6, P7, P8, P9, RO>(type: NotificationType9<P1, P2, P3, P4, P5, P6, P7, P8, P9, RO>, handler: NotificationHandler9<P1, P2, P3, P4, P5, P6, P7, P8, P9>): void;
    onNotification(method: string, handler: GenericNotificationHandler): void;
    onNotification(handler: StarNotificationHandler): void;
    trace(value: Trace, tracer: Tracer, sendNotification?: boolean): void;
    trace(value: Trace, tracer: Tracer, traceOptions?: TraceOptions): void;
    onError: Event<[Error, Message | undefined, number | undefined]>;
    onClose: Event<void>;
    onUnhandledNotification: Event<NotificationMessage>;
    listen(): void;
    onDispose: Event<void>;
    dispose(): void;
    inspect(): void;
}
export declare function createMessageConnection(reader: MessageReader, writer: MessageWriter, logger?: Logger, strategy?: ConnectionStrategy): MessageConnection;
export declare function createMessageConnection(inputStream: NodeJS.ReadableStream, outputStream: NodeJS.WritableStream, logger?: Logger, strategy?: ConnectionStrategy): MessageConnection;
