/**
 * Provides information based on the programs on your PATH
 */
export default class Executables {
    /**
     * @param path is expected to to be a ':' separated list of paths.
     */
    static fromPath(path: string): Promise<Executables>;
    private executables;
    private constructor();
    /**
     * Find all programs in your PATH
     */
    list(): Array<string>;
    /**
     * Check if the the given {{executable}} exists on the PATH
     */
    isExecutableOnPATH(executable: string): boolean;
    /**
     * Look up documentation for the given executable.
     *
     * For now it simply tries to look up the MAN documentation.
     */
    documentation(executable: string): Promise<string>;
}
