/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.queries.intervals.CachingMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;

class MinimizingConjunctionMatchesIterator
implements IntervalMatchesIterator {
    final IntervalIterator iterator;
    private final List<CachingMatchesIterator> subs = new ArrayList<CachingMatchesIterator>();
    private boolean cached = true;

    MinimizingConjunctionMatchesIterator(IntervalIterator iterator, List<MatchesIterator> subs) {
        this.iterator = iterator;
        for (MatchesIterator mi : subs) {
            assert (mi instanceof CachingMatchesIterator);
            this.subs.add((CachingMatchesIterator)mi);
        }
    }

    public boolean next() throws IOException {
        if (this.cached) {
            this.cached = false;
            return true;
        }
        return this.iterator.nextInterval() != Integer.MAX_VALUE;
    }

    public int startPosition() {
        return this.iterator.start();
    }

    public int endPosition() {
        return this.iterator.end();
    }

    public int startOffset() throws IOException {
        int start = Integer.MAX_VALUE;
        int endPos = this.endPosition();
        for (CachingMatchesIterator s : this.subs) {
            start = Math.min(start, s.startOffset(endPos));
        }
        return start;
    }

    public int endOffset() throws IOException {
        int end = 0;
        int endPos = this.endPosition();
        for (CachingMatchesIterator s : this.subs) {
            end = Math.max(end, s.endOffset(endPos));
        }
        return end;
    }

    @Override
    public int gaps() {
        return this.iterator.gaps();
    }

    public MatchesIterator getSubMatches() throws IOException {
        ArrayList<MatchesIterator> mis = new ArrayList<MatchesIterator>();
        int endPos = this.endPosition();
        for (CachingMatchesIterator s : this.subs) {
            mis.add(s.getSubMatches(endPos));
        }
        return MatchesUtils.disjunction(mis);
    }

    public Query getQuery() {
        return null;
    }
}

