/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.internal.thread.FutureResultAdapter;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IFutureResult;
import org.testng.internal.thread.IThreadFactory;

public class ExecutorAdapter
extends ThreadPoolExecutor
implements IExecutor {
    private IThreadFactory m_threadFactory;

    public ExecutorAdapter(int n, IThreadFactory iThreadFactory) {
        super(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)iThreadFactory.getThreadFactory());
        this.m_threadFactory = iThreadFactory;
    }

    @Override
    public IFutureResult submitRunnable(Runnable runnable) {
        return new FutureResultAdapter(super.submit(runnable));
    }

    @Override
    public void stopNow() {
        super.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long l) {
        boolean bl = false;
        try {
            bl = super.awaitTermination(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("[WARN] ThreadPoolExecutor has been interrupted while awaiting termination");
            Thread.currentThread().interrupt();
        }
        return bl;
    }

    @Override
    public StackTraceElement[][] getStackTraces() {
        List<Thread> list = this.m_threadFactory.getThreads();
        int n = list.size();
        StackTraceElement[][] stackTraceElementArray = new StackTraceElement[n][];
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stackTraceElementArray[i] = list.get(i).getStackTrace();
        }
        return stackTraceElementArray;
    }
}

