/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenSet {
    public static final TokenSet EMPTY = new TokenSet(Short.MAX_VALUE, 0, null);
    public static final TokenSet ANY = TokenSet.forAllMatching(IElementType.TRUE);
    public static final TokenSet WHITE_SPACE = TokenSet.doCreate(TokenType.WHITE_SPACE);
    private final short myShift;
    private final short myMax;
    private final long[] myWords;
    @Nullable
    private final IElementType.Predicate myOrCondition;
    private volatile IElementType[] myTypes;

    private TokenSet(short shift, short max, @Nullable IElementType.Predicate orCondition) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
        this.myOrCondition = orCondition;
    }

    private boolean get(int index2) {
        int wordIndex = (index2 >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index2) != 0L;
    }

    @Contract(value="null -> false")
    public boolean contains(@Nullable IElementType t) {
        if (t == null) {
            return false;
        }
        short i = t.getIndex();
        return 0 <= i && i <= this.myMax && this.get(i) || this.myOrCondition != null && this.myOrCondition.matches(t);
    }

    @NotNull
    public IElementType[] getTypes() {
        if (this.myOrCondition != null) {
            IElementType[] iElementTypeArray = IElementType.enumerate(this::contains);
            if (iElementTypeArray == null) {
                TokenSet.$$$reportNull$$$0(0);
            }
            return iElementTypeArray;
        }
        IElementType[] types2 = this.myTypes;
        if (types2 == null) {
            if (this.myWords.length == 0) {
                types2 = IElementType.EMPTY_ARRAY;
            } else {
                ArrayList<IElementType> list2 = new ArrayList<IElementType>();
                for (short i = (short)Math.max(1, this.myShift << 6); i <= this.myMax; i = (short)(i + 1)) {
                    IElementType type2;
                    if (!this.get(i) || (type2 = IElementType.find(i)) == null) continue;
                    list2.add(type2);
                }
                types2 = list2.toArray(IElementType.EMPTY_ARRAY);
            }
            this.myTypes = types2;
        }
        if (types2 == null) {
            TokenSet.$$$reportNull$$$0(1);
        }
        return types2;
    }

    public String toString() {
        return Arrays.toString(this.getTypes());
    }

    @NotNull
    public static TokenSet create(IElementType ... types2) {
        if (types2 == null) {
            TokenSet.$$$reportNull$$$0(2);
        }
        if (types2.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(3);
            }
            return tokenSet;
        }
        if (types2.length == 1 && types2[0] == TokenType.WHITE_SPACE) {
            TokenSet tokenSet = WHITE_SPACE;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(4);
            }
            return tokenSet;
        }
        TokenSet tokenSet = TokenSet.doCreate(types2);
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(5);
        }
        return tokenSet;
    }

    @NotNull
    private static TokenSet doCreate(IElementType ... types2) {
        if (types2 == null) {
            TokenSet.$$$reportNull$$$0(6);
        }
        short min = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type2 : types2) {
            if (type2 == null) continue;
            short index2 = type2.getIndex();
            assert (index2 >= 0) : "Unregistered elements are not allowed here: " + LogUtil.objectAndClass(type2);
            if (min > index2) {
                min = index2;
            }
            if (max >= index2) continue;
            max = index2;
        }
        short shift = (short)(min >> 6);
        TokenSet set = new TokenSet(shift, max, null);
        for (IElementType type3 : types2) {
            int wordIndex;
            if (type3 == null) continue;
            short index3 = type3.getIndex();
            int n = wordIndex = (index3 >> 6) - shift;
            set.myWords[n] = set.myWords[n] | 1L << index3;
        }
        TokenSet tokenSet = set;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(7);
        }
        return tokenSet;
    }

    public static TokenSet forAllMatching(@NotNull IElementType.Predicate condition) {
        if (condition == null) {
            TokenSet.$$$reportNull$$$0(8);
        }
        return new TokenSet(Short.MAX_VALUE, 0, condition);
    }

    @NotNull
    public static TokenSet orSet(TokenSet ... sets) {
        if (sets == null) {
            TokenSet.$$$reportNull$$$0(9);
        }
        if (sets.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(10);
            }
            return tokenSet;
        }
        ArrayList<IElementType.Predicate> orConditions = new ArrayList<IElementType.Predicate>();
        ContainerUtil.addIfNotNull(orConditions, sets[0].myOrCondition);
        short shift = sets[0].myShift;
        short max = sets[0].myMax;
        for (int i = 1; i < sets.length; ++i) {
            if (shift > sets[i].myShift) {
                shift = sets[i].myShift;
            }
            if (max < sets[i].myMax) {
                max = sets[i].myMax;
            }
            ContainerUtil.addIfNotNull(orConditions, sets[i].myOrCondition);
        }
        OrPredicate disjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : new OrPredicate(orConditions));
        TokenSet newSet = new TokenSet(shift, max, disjunction);
        for (TokenSet set : sets) {
            int shiftDiff = set.myShift - newSet.myShift;
            for (int i = 0; i < set.myWords.length; ++i) {
                int n = i + shiftDiff;
                newSet.myWords[n] = newSet.myWords[n] | set.myWords[i];
            }
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(11);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andSet(@NotNull TokenSet a, @NotNull TokenSet b) {
        if (a == null) {
            TokenSet.$$$reportNull$$$0(12);
        }
        if (b == null) {
            TokenSet.$$$reportNull$$$0(13);
        }
        ArrayList orConditions = new ArrayList();
        ContainerUtil.addIfNotNull(orConditions, a.myOrCondition);
        ContainerUtil.addIfNotNull(orConditions, b.myOrCondition);
        IElementType.Predicate conjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : t -> a.myOrCondition.matches(t) && b.myOrCondition.matches(t));
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax), conjunction);
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & (0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(14);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andNot(@NotNull TokenSet a, @NotNull TokenSet b) {
        if (a == null) {
            TokenSet.$$$reportNull$$$0(15);
        }
        if (b == null) {
            TokenSet.$$$reportNull$$$0(16);
        }
        IElementType.Predicate difference2 = a.myOrCondition == null ? null : e -> !b.contains(e) && a.myOrCondition.matches(e);
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax), difference2);
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & ((0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(17);
        }
        return tokenSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/tree/TokenSet";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/tree/TokenSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "orSet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "andSet";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "andNot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCreate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forAllMatching";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "orSet";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "andSet";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "andNot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OrPredicate
    implements IElementType.Predicate {
        private final IElementType.Predicate[] myComponents;

        OrPredicate(List<IElementType.Predicate> components) {
            this.myComponents = (IElementType.Predicate[])components.stream().flatMap(p -> p instanceof OrPredicate ? Arrays.stream(((OrPredicate)p).myComponents) : Stream.of(p)).distinct().toArray(IElementType.Predicate[]::new);
        }

        @Override
        public boolean matches(@NotNull IElementType t) {
            if (t == null) {
                OrPredicate.$$$reportNull$$$0(0);
            }
            for (IElementType.Predicate component : this.myComponents) {
                if (!component.matches(t)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/tree/TokenSet$OrPredicate", "matches"));
        }
    }
}

