/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.extension.alert.AlertTreeModel;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.utils.ApiUtils;

public class AlertAPI
extends ApiImplementor {
    public static final String PREFIX = "alert";
    private static final String ACTION_DELETE_ALL_ALERTS = "deleteAllAlerts";
    private static final String ACTION_DELETE_ALERT = "deleteAlert";
    private static final String VIEW_ALERT = "alert";
    private static final String VIEW_ALERTS = "alerts";
    private static final String VIEW_ALERTS_SUMMARY = "alertsSummary";
    private static final String VIEW_NUMBER_OF_ALERTS = "numberOfAlerts";
    private static final String VIEW_ALERTS_BY_RISK = "alertsByRisk";
    private static final String VIEW_ALERT_COUNTS_BY_RISK = "alertCountsByRisk";
    private static final String PARAM_BASE_URL = "baseurl";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_URL = "url";
    private static final String PARAM_ID = "id";
    private static final String PARAM_RECURSE = "recurse";
    private static final String PARAM_RISK = "riskId";
    private static final String PARAM_START = "start";
    private static final int NO_RISK_ID = -1;
    private ExtensionAlert extension = null;
    private static final Logger logger = Logger.getLogger(AlertAPI.class);

    public AlertAPI(ExtensionAlert ext) {
        this.extension = ext;
        this.addApiView(new ApiView("alert", new String[]{PARAM_ID}));
        this.addApiView(new ApiView(VIEW_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT, PARAM_RISK}));
        this.addApiView(new ApiView(VIEW_ALERTS_SUMMARY, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView(VIEW_NUMBER_OF_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_RISK}));
        this.addApiView(new ApiView(VIEW_ALERTS_BY_RISK, null, new String[]{PARAM_URL, PARAM_RECURSE}));
        this.addApiView(new ApiView(VIEW_ALERT_COUNTS_BY_RISK, null, new String[]{PARAM_URL, PARAM_RECURSE}));
        this.addApiAction(new ApiAction(ACTION_DELETE_ALL_ALERTS));
        this.addApiAction(new ApiAction(ACTION_DELETE_ALERT, new String[]{PARAM_ID}));
    }

    @Override
    public String getPrefix() {
        return "alert";
    }

    @Override
    public ApiResponse handleApiView(final String name, JSONObject params) throws ApiException {
        ApiResponse result = null;
        if ("alert".equals(name)) {
            RecordAlert recordAlert;
            TableAlert tableAlert = Model.getSingleton().getDb().getTableAlert();
            try {
                recordAlert = tableAlert.read(this.getParam(params, PARAM_ID, -1));
            }
            catch (DatabaseException e) {
                logger.error((Object)"Failed to read the alert from the session:", (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
            if (recordAlert == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            result = new ApiResponseElement(this.alertToSet(new Alert(recordAlert)));
        } else if (VIEW_ALERTS.equals(name)) {
            final ApiResponseList resultList = new ApiResponseList(name);
            this.processAlerts(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), this.getRiskId(params), new Processor<Alert>(){

                @Override
                public void process(Alert alert) {
                    resultList.addItem(AlertAPI.this.alertToSet(alert));
                }
            });
            result = resultList;
        } else if (VIEW_NUMBER_OF_ALERTS.equals(name)) {
            CounterProcessor<Alert> counter = new CounterProcessor<Alert>();
            this.processAlerts(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), this.getRiskId(params), counter);
            result = new ApiResponseElement(name, Integer.toString(counter.getCount()));
        } else if (VIEW_ALERTS_SUMMARY.equals(name)) {
            final int[] riskSummary = new int[]{0, 0, 0, 0};
            Processor<Alert> counter = new Processor<Alert>(){

                @Override
                public void process(Alert alert) {
                    int n = alert.getRisk();
                    riskSummary[n] = riskSummary[n] + 1;
                }
            };
            this.processAlerts(this.getParam(params, PARAM_BASE_URL, null), -1, -1, -1, counter);
            HashMap<String, Integer> alertData = new HashMap<String, Integer>();
            for (int i = 0; i < riskSummary.length; ++i) {
                alertData.put(Alert.MSG_RISK[i], riskSummary[i]);
            }
            result = new ApiResponseSet<Object>("risk", alertData){

                @Override
                public JSON toJSON() {
                    JSONObject response = new JSONObject();
                    response.put((Object)name, (Object)super.toJSON());
                    return response;
                }
            };
        } else if (VIEW_ALERTS_BY_RISK.equals(name)) {
            String url = this.getParam(params, PARAM_URL, "");
            boolean recurse = this.getParam(params, PARAM_RECURSE, false);
            ApiResponseList resultList = new ApiResponseList(name);
            result = resultList;
            ApiResponseList[] list = new ApiResponseList[4];
            for (int i = 0; i < list.length; ++i) {
                list[i] = new ApiResponseList(Alert.MSG_RISK[i]);
            }
            AlertTreeModel model = this.extension.getTreeModel();
            AlertNode root = (AlertNode)model.getRoot();
            Enumeration<TreeNode> enumAllAlerts = root.children();
            while (enumAllAlerts.hasMoreElements()) {
                AlertNode child = (AlertNode)enumAllAlerts.nextElement();
                Alert alert = child.getUserObject();
                ApiResponseList alertList = this.filterAlertInstances(child, url, recurse);
                if (alertList.getItems().size() <= 0) continue;
                list[alert.getRisk()].addItem(alertList);
            }
            for (int i = 0; i < list.length; ++i) {
                resultList.addItem(list[i]);
            }
        } else if (VIEW_ALERT_COUNTS_BY_RISK.equals(name)) {
            String url = this.getParam(params, PARAM_URL, "");
            boolean recurse = this.getParam(params, PARAM_RECURSE, false);
            int[] counts = new int[]{0, 0, 0, 0};
            AlertTreeModel model = this.extension.getTreeModel();
            AlertNode root = (AlertNode)model.getRoot();
            Enumeration<TreeNode> enumAllAlerts = root.children();
            while (enumAllAlerts.hasMoreElements()) {
                AlertNode child = (AlertNode)enumAllAlerts.nextElement();
                Alert alert = child.getUserObject();
                ApiResponseList alertList = this.filterAlertInstances(child, url, recurse);
                if (alertList.getItems().size() <= 0) continue;
                int n = alert.getRisk();
                counts[n] = counts[n] + 1;
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(Alert.MSG_RISK[3], counts[3]);
            map.put(Alert.MSG_RISK[2], counts[2]);
            map.put(Alert.MSG_RISK[1], counts[1]);
            map.put(Alert.MSG_RISK[0], counts[0]);
            result = new ApiResponseSet(name, map);
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return result;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        if (ACTION_DELETE_ALERT.equals(name)) {
            RecordAlert recAlert;
            int alertId = ApiUtils.getIntParam(params, PARAM_ID);
            try {
                recAlert = Model.getSingleton().getDb().getTableAlert().read(alertId);
            }
            catch (DatabaseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
            }
            if (recAlert == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ID);
            }
            ExtensionAlert extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
            if (extAlert != null) {
                extAlert.deleteAlert(new Alert(recAlert));
            } else {
                try {
                    Model.getSingleton().getDb().getTableAlert().deleteAlert(alertId);
                }
                catch (DatabaseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
                }
            }
        } else if (ACTION_DELETE_ALL_ALERTS.equals(name)) {
            ExtensionAlert extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
            if (extAlert != null) {
                extAlert.deleteAllAlerts();
            } else {
                try {
                    Model.getSingleton().getDb().getTableAlert().deleteAllAlerts();
                }
                catch (DatabaseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                SiteNode rootNode = Model.getSingleton().getSession().getSiteTree().getRoot();
                rootNode.deleteAllAlerts();
                AlertAPI.removeHistoryReferenceAlerts(rootNode);
            }
        } else {
            throw new ApiException(ApiException.Type.BAD_ACTION);
        }
        return ApiResponseElement.OK;
    }

    private static void removeHistoryReferenceAlerts(SiteNode siteNode) {
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            AlertAPI.removeHistoryReferenceAlerts((SiteNode)siteNode.getChildAt(i));
        }
        if (siteNode.getHistoryReference() != null) {
            siteNode.getHistoryReference().deleteAllAlerts();
        }
        for (HistoryReference hRef : siteNode.getPastHistoryReference()) {
            hRef.deleteAllAlerts();
        }
    }

    private ApiResponseList filterAlertInstances(AlertNode alertNode, String url, boolean recurse) {
        ApiResponseList alertList = new ApiResponseList(alertNode.getUserObject().getName());
        Enumeration<TreeNode> enumAlertInsts = alertNode.children();
        while (enumAlertInsts.hasMoreElements()) {
            AlertNode childAlert = (AlertNode)enumAlertInsts.nextElement();
            if (!url.isEmpty()) {
                String alertUrl = childAlert.getUserObject().getUri();
                if (!alertUrl.startsWith(url)) continue;
                if (!recurse) {
                    if (alertUrl.indexOf(63) > 0) {
                        alertUrl = alertUrl.substring(0, alertUrl.indexOf(63));
                    }
                    if (!alertUrl.equals(url)) continue;
                }
            }
            alertList.addItem(this.alertSummaryToSet(childAlert.getUserObject()));
        }
        return alertList;
    }

    private void processAlerts(String baseUrl, int start, int count, int riskId, Processor<Alert> processor) throws ApiException {
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        try {
            TableAlert tableAlert = Model.getSingleton().getDb().getTableAlert();
            Vector<Integer> v = tableAlert.getAlertList();
            PaginationConstraintsChecker pcc = new PaginationConstraintsChecker(start, count);
            for (int i = 0; i < v.size(); ++i) {
                int alertId = v.get(i);
                RecordAlert recAlert = tableAlert.read(alertId);
                Alert alert = new Alert(recAlert);
                if (alert.getConfidence() == 0 || alerts.contains(alert) || baseUrl != null && !alert.getUri().startsWith(baseUrl) || riskId != -1 && alert.getRisk() != riskId) continue;
                pcc.recordProcessed();
                alerts.add(alert);
                if (!pcc.hasPageStarted()) continue;
                processor.process(alert);
                if (!pcc.hasPageEnded()) {
                    continue;
                }
                break;
            }
        }
        catch (DatabaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
    }

    private ApiResponseSet<String> alertToSet(Alert alert) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PARAM_ID, String.valueOf(alert.getAlertId()));
        map.put("pluginId", String.valueOf(alert.getPluginId()));
        map.put("alert", alert.getName());
        map.put("name", alert.getName());
        map.put("description", alert.getDescription());
        map.put("risk", Alert.MSG_RISK[alert.getRisk()]);
        map.put("confidence", Alert.MSG_CONFIDENCE[alert.getConfidence()]);
        map.put(PARAM_URL, alert.getUri());
        map.put("method", alert.getMethod());
        map.put("other", alert.getOtherInfo());
        map.put("param", alert.getParam());
        map.put("attack", alert.getAttack());
        map.put("evidence", alert.getEvidence());
        map.put("reference", alert.getReference());
        map.put("cweid", String.valueOf(alert.getCweId()));
        map.put("wascid", String.valueOf(alert.getWascId()));
        map.put("sourceid", String.valueOf(alert.getSource().getId()));
        map.put("solution", alert.getSolution());
        map.put("messageId", alert.getHistoryRef() != null ? String.valueOf(alert.getHistoryRef().getHistoryId()) : "");
        return new ApiResponseSet<String>("alert", map);
    }

    private ApiResponseSet<String> alertSummaryToSet(Alert alert) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PARAM_ID, String.valueOf(alert.getAlertId()));
        map.put("name", alert.getName());
        map.put("risk", Alert.MSG_RISK[alert.getRisk()]);
        map.put("confidence", Alert.MSG_CONFIDENCE[alert.getConfidence()]);
        map.put(PARAM_URL, alert.getUri());
        map.put("param", alert.getParam());
        return new ApiResponseSet<String>("alertsummary", map);
    }

    private static void throwInvalidRiskId() throws ApiException {
        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "Parameter riskId is not a valid risk ID (integer in interval [0, 3]).");
    }

    private int getRiskId(JSONObject parameters) throws ApiException {
        String riskIdParam = this.getParam(parameters, PARAM_RISK, "").trim();
        if (riskIdParam.isEmpty()) {
            return -1;
        }
        int riskId = -1;
        try {
            riskId = Integer.parseInt(riskIdParam);
        }
        catch (NumberFormatException e) {
            AlertAPI.throwInvalidRiskId();
        }
        if (riskId < 0 || riskId > 3) {
            AlertAPI.throwInvalidRiskId();
        }
        return riskId;
    }

    private static class PaginationConstraintsChecker {
        private boolean pageStarted;
        private boolean pageEnded;
        private final int startRecord;
        private final boolean hasEnd;
        private final int finalRecord;
        private int recordsProcessed = 0;

        public PaginationConstraintsChecker(int start, int count) {
            if (start > 0) {
                this.pageStarted = false;
                this.startRecord = start;
            } else {
                this.pageStarted = true;
                this.startRecord = 0;
            }
            if (count > 0) {
                this.hasEnd = true;
                this.finalRecord = !this.pageStarted ? start + count - 1 : count;
            } else {
                this.hasEnd = false;
                this.finalRecord = 0;
            }
            this.pageEnded = false;
        }

        public void recordProcessed() {
            ++this.recordsProcessed;
            if (!this.pageStarted) {
                boolean bl = this.pageStarted = this.recordsProcessed >= this.startRecord;
            }
            if (this.hasEnd && !this.pageEnded) {
                this.pageEnded = this.recordsProcessed >= this.finalRecord;
            }
        }

        public boolean hasPageStarted() {
            return this.pageStarted;
        }

        public boolean hasPageEnded() {
            return this.pageEnded;
        }
    }

    private static class CounterProcessor<T>
    implements Processor<T> {
        private int count = 0;

        @Override
        public void process(T object) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static interface Processor<T> {
        public void process(T var1);
    }
}

