/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.options.OptionsPanelControllerAccessor;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TabbedController
extends OptionsPanelController {
    private static final Logger LOGGER = Logger.getLogger(TabbedController.class.getName());
    private final String tabFolder;
    private Lookup.Result<AdvancedOption> options;
    private Map<String, String> id2tabTitle;
    private Map<String, OptionsPanelController> tabTitle2controller;
    private final Map<String, AdvancedOption> tabTitle2Option;
    private Lookup masterLookup;
    private final LookupListener lookupListener = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            TabbedController.this.readPanels();
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    TabbedController.this.initTabbedPane();
                }
            });
        }
    };
    private JTabbedPane pane;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final ChangeListener tabbedPaneChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            TabbedController.this.handleTabSwitched(null, null);
        }
    };

    public TabbedController(String string) {
        this.tabFolder = string;
        this.tabTitle2Option = Collections.synchronizedMap(new LinkedHashMap());
        this.readPanels();
        this.options.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, this.options));
    }

    @Override
    public void update() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.update();
        }
    }

    @Override
    public void applyChanges() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.applyChanges();
        }
    }

    @Override
    public void cancel() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.cancel();
        }
    }

    @Override
    public boolean isValid() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            if (optionsPanelController.isValid() || !optionsPanelController.isChanged()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isChanged() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            if (!optionsPanelController.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getComponent(Lookup lookup) {
        if (this.pane == null) {
            this.pane = new JTabbedPane();
            this.pane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TabbedController.class, (String)"TabbedController.pane.AD"));
            this.masterLookup = lookup;
            this.initTabbedPane();
        }
        return this.pane;
    }

    @Override
    public void handleSuccessfulSearch(String string, List<String> list) {
        this.handleTabSwitched(string, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTabbedPane() {
        if (this.pane != null) {
            this.pane.removeChangeListener(this.tabbedPaneChangeListener);
            this.pane.removeAll();
            Set<String> set = this.tabTitle2Option.keySet();
            Map<String, AdvancedOption> map = this.tabTitle2Option;
            synchronized (map) {
                for (String string : set) {
                    this.pane.addTab(string, new JLabel(string));
                }
            }
            this.pane.addChangeListener(this.tabbedPaneChangeListener);
            this.handleTabSwitched(null, null);
        }
    }

    private void handleTabSwitched(String string, List<String> list) {
        int n = this.pane.getSelectedIndex();
        if (n != -1) {
            String string2 = this.pane.getTitleAt(n);
            OptionsPanelController optionsPanelController = this.tabTitle2controller.get(string2);
            if (this.pane.getSelectedComponent() instanceof JLabel) {
                JComponent jComponent;
                Object object;
                if (optionsPanelController == null) {
                    object = this.tabTitle2Option.get(string2);
                    if (object == null) {
                        LOGGER.log(Level.INFO, "AdvancedOption for {0} is not present.", string2);
                        return;
                    }
                    optionsPanelController = ((AdvancedOption)object).create();
                    this.tabTitle2controller.put(string2, optionsPanelController);
                    jComponent = optionsPanelController.getComponent(this.masterLookup);
                    for (PropertyChangeListener propertyChangeListener : this.pcs.getPropertyChangeListeners()) {
                        optionsPanelController.addPropertyChangeListener(propertyChangeListener);
                    }
                } else {
                    jComponent = optionsPanelController.getComponent(this.masterLookup);
                }
                if (null == jComponent.getBorder()) {
                    jComponent.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
                }
                object = new JScrollPane(jComponent);
                ((JComponent)object).setBorder(BorderFactory.createEmptyBorder());
                ((JComponent)object).setOpaque(false);
                ((JScrollPane)object).getViewport().setOpaque(false);
                ((JScrollPane)object).getVerticalScrollBar().setUnitIncrement(16);
                ((JScrollPane)object).getHorizontalScrollBar().setUnitIncrement(16);
                this.pane.setComponentAt(n, (Component)object);
                optionsPanelController.update();
                optionsPanelController.isValid();
            }
            if (string != null && list != null) {
                optionsPanelController.handleSuccessfulSearch(string, list);
            }
            this.pcs.firePropertyChange("helpCtx", null, null);
        }
    }

    @Override
    public HelpCtx getHelpCtx() {
        if (this.pane != null && this.pane.getSelectedIndex() != -1) {
            return this.getHelpCtx(this.pane.getTitleAt(this.pane.getSelectedIndex()));
        }
        return null;
    }

    private HelpCtx getHelpCtx(String string) {
        OptionsPanelController optionsPanelController = this.tabTitle2controller.get(string);
        if (optionsPanelController != null) {
            return optionsPanelController.getHelpCtx();
        }
        return new HelpCtx("netbeans.optionsDialog.java");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    protected void setCurrentSubcategory(String string) {
        String string2;
        String string3 = string.indexOf(47) == -1 ? string : string.substring(0, string.indexOf(47));
        String string4 = string.indexOf(47) == -1 ? null : string.substring(string.indexOf(47) + 1);
        LOGGER.fine("Set current subcategory: " + string);
        if (!this.id2tabTitle.containsKey(string3)) {
            LOGGER.warning("Subcategory " + string3 + " not found.");
            return;
        }
        String string5 = this.id2tabTitle.get(string3);
        String string6 = string2 = this.pane.getSelectedIndex() != -1 ? this.pane.getTitleAt(this.pane.getSelectedIndex()) : null;
        if (!string5.equals(string2)) {
            for (int i = 0; i < this.pane.getTabCount(); ++i) {
                if (!this.pane.getTitleAt(i).equals(string5)) continue;
                this.pane.setSelectedIndex(i);
                break;
            }
        }
        if (string4 != null) {
            OptionsPanelControllerAccessor.getDefault().setCurrentSubcategory(this.tabTitle2controller.get(string5), string4);
        }
    }

    @Override
    public Lookup getLookup() {
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            Lookup lookup = optionsPanelController.getLookup();
            if (lookup != null && lookup != Lookup.EMPTY) {
                arrayList.add(lookup);
            }
            if (lookup != null) continue;
            LOGGER.log(Level.WARNING, "{0}.getLookup() should never return null. Please, see Bug #194736.", optionsPanelController.getClass().getName());
            throw new NullPointerException(optionsPanelController.getClass().getName() + ".getLookup() should never return null. Please, see Bug #194736.");
        }
        if (arrayList.isEmpty()) {
            return Lookup.EMPTY;
        }
        return new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
    }

    private Collection<OptionsPanelController> getControllers() {
        return this.tabTitle2controller.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPanels() {
        Lookup lookup = Lookups.forPath((String)this.tabFolder);
        this.options = lookup.lookup(new Lookup.Template(AdvancedOption.class));
        this.tabTitle2controller = new HashMap<String, OptionsPanelController>();
        this.id2tabTitle = new HashMap<String, String>();
        Map<String, AdvancedOption> map = this.tabTitle2Option;
        synchronized (map) {
            for (Lookup.Item item : this.options.allItems()) {
                AdvancedOption advancedOption = (AdvancedOption)item.getInstance();
                String string = advancedOption.getDisplayName();
                if (string != null) {
                    this.tabTitle2Option.put(string, advancedOption);
                    String string2 = item.getId().substring(item.getId().lastIndexOf(47) + 1);
                    this.id2tabTitle.put(string2, string);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Display name not defined: {0}", item.toString());
            }
        }
    }
}

