"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class MemoryStorageProvider {
    constructor() {
        this.appserviceUsers = {};
        this.appserviceTransactions = {};
    }
    setSyncToken(token) {
        this.syncToken = token;
    }
    getSyncToken() {
        return this.syncToken;
    }
    setFilter(filter) {
        this.filter = filter;
    }
    getFilter() {
        return this.filter;
    }
    addRegisteredUser(userId) {
        this.appserviceUsers[userId] = {
            registered: true,
        };
    }
    isUserRegistered(userId) {
        return this.appserviceUsers[userId] && this.appserviceUsers[userId].registered;
    }
    isTransactionCompleted(transactionId) {
        return !!this.appserviceTransactions[transactionId];
    }
    setTransactionCompleted(transactionId) {
        this.appserviceTransactions[transactionId] = true;
    }
}
exports.MemoryStorageProvider = MemoryStorageProvider;
