/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.renderer;

import org.sunflow.core.BucketOrder;
import org.sunflow.core.Display;
import org.sunflow.core.ImageSampler;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.Options;
import org.sunflow.core.Scene;
import org.sunflow.core.ShadingCache;
import org.sunflow.core.ShadingState;
import org.sunflow.core.bucket.BucketOrderFactory;
import org.sunflow.image.Color;
import org.sunflow.math.MathUtils;
import org.sunflow.math.QMC;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

public class MultipassRenderer
implements ImageSampler {
    private Scene scene;
    private Display display;
    private int imageWidth;
    private int imageHeight;
    private String bucketOrderName = "hilbert";
    private BucketOrder bucketOrder;
    private int bucketSize = 32;
    private int bucketCounter;
    private int[] bucketCoords;
    private int numSamples = 16;
    private float invNumSamples;
    private boolean shadingCache = false;

    public boolean prepare(Options options, Scene scene, int n, int n2) {
        this.scene = scene;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.bucketSize = options.getInt("bucket.size", this.bucketSize);
        this.bucketOrderName = options.getString("bucket.order", this.bucketOrderName);
        this.numSamples = options.getInt("aa.samples", this.numSamples);
        this.shadingCache = options.getBoolean("aa.cache", this.shadingCache);
        this.bucketSize = MathUtils.clamp(this.bucketSize, 16, 512);
        int n3 = (this.imageWidth + this.bucketSize - 1) / this.bucketSize;
        int n4 = (this.imageHeight + this.bucketSize - 1) / this.bucketSize;
        this.bucketOrder = BucketOrderFactory.create(this.bucketOrderName);
        this.bucketCoords = this.bucketOrder.getBucketSequence(n3, n4);
        this.numSamples = Math.max(1, this.numSamples);
        this.invNumSamples = 1.0f / (float)this.numSamples;
        UI.printInfo(UI.Module.BCKT, "Multipass renderer settings:", new Object[0]);
        UI.printInfo(UI.Module.BCKT, "  * Resolution:         %dx%d", this.imageWidth, this.imageHeight);
        UI.printInfo(UI.Module.BCKT, "  * Bucket size:        %d", this.bucketSize);
        UI.printInfo(UI.Module.BCKT, "  * Number of buckets:  %dx%d", n3, n4);
        UI.printInfo(UI.Module.BCKT, "  * Samples / pixel:    %d", this.numSamples);
        UI.printInfo(UI.Module.BCKT, "  * Shading cache:      %s", this.shadingCache ? "enabled" : "disabled");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Display display) {
        int n;
        this.display = display;
        display.imageBegin(this.imageWidth, this.imageHeight, this.bucketSize);
        this.bucketCounter = 0;
        Timer timer = new Timer();
        timer.start();
        UI.taskStart("Rendering", 0, this.bucketCoords.length);
        BucketThread[] bucketThreadArray = new BucketThread[this.scene.getThreads()];
        for (n = 0; n < bucketThreadArray.length; ++n) {
            bucketThreadArray[n] = new BucketThread(n);
            bucketThreadArray[n].setPriority(this.scene.getThreadPriority());
            bucketThreadArray[n].start();
        }
        try {
            for (n = 0; n < bucketThreadArray.length; ++n) {
                try {
                    bucketThreadArray[n].join();
                    continue;
                }
                finally {
                    bucketThreadArray[n].updateStats();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            for (int i = 0; i < bucketThreadArray.length; ++i) {
                bucketThreadArray[i].interrupt();
            }
            UI.printError(UI.Module.BCKT, "Bucket processing was interrupted", new Object[0]);
        }
        UI.taskStop();
        timer.end();
        UI.printInfo(UI.Module.BCKT, "Render time: %s", timer.toString());
        display.imageEnd();
    }

    private void renderBucket(Display display, int n, int n2, int n3, IntersectionState intersectionState, ShadingCache shadingCache) {
        int n4 = n * this.bucketSize;
        int n5 = n2 * this.bucketSize;
        int n6 = Math.min(this.bucketSize, this.imageWidth - n4);
        int n7 = Math.min(this.bucketSize, this.imageHeight - n5);
        display.imagePrepare(n4, n5, n6, n7, n3);
        Color[] colorArray = new Color[n6 * n7];
        float[] fArray = new float[n6 * n7];
        int n8 = 0;
        int n9 = 0;
        int n10 = this.imageHeight - 1 - n5;
        while (n8 < n7) {
            int n11 = 0;
            int n12 = n4;
            while (n11 < n6) {
                Color color = Color.black();
                float f = 0.0f;
                int n13 = ((n12 & Short.MAX_VALUE) << 15) + QMC.sigma(n10 & Short.MAX_VALUE, 15);
                double d = QMC.halton(0, n13);
                double d2 = QMC.halton(1, n13);
                double d3 = QMC.halton(2, n13);
                double d4 = QMC.halton(3, n13);
                double d5 = QMC.halton(4, n13);
                for (int i = 0; i < this.numSamples; ++i) {
                    double d6;
                    float f2 = (float)n12 + 0.5f + (float)MultipassRenderer.warpCubic(QMC.mod1(d + (double)((float)i * this.invNumSamples)));
                    float f3 = (float)n10 + 0.5f + (float)MultipassRenderer.warpCubic(QMC.mod1(d2 + QMC.halton(0, i)));
                    double d7 = QMC.mod1(d3 + QMC.halton(1, i));
                    double d8 = QMC.mod1(d4 + QMC.halton(2, i));
                    ShadingState shadingState = this.scene.getRadiance(intersectionState, f2, f3, d8, d6 = QMC.mod1(d5 + QMC.halton(3, i)), d7, n13 + i, 5, shadingCache);
                    if (shadingState == null) continue;
                    color.add(shadingState.getResult());
                    f += 1.0f;
                }
                colorArray[n9] = color.mul(this.invNumSamples);
                fArray[n9] = f * this.invNumSamples;
                if (shadingCache != null) {
                    shadingCache.reset();
                }
                ++n11;
                ++n9;
                ++n12;
            }
            ++n8;
            --n10;
        }
        display.imageUpdate(n4, n5, n6, n7, colorArray, fArray);
    }

    private static final float warpTent(float f) {
        if (f < 0.5f) {
            return -1.0f + (float)Math.sqrt(2.0f * f);
        }
        return 1.0f - (float)Math.sqrt(2.0f - 2.0f * f);
    }

    private static final double warpCubic(double d) {
        if (d < 0.041666666666666664) {
            return MultipassRenderer.qpow(24.0 * d) - 2.0;
        }
        if (d < 0.5) {
            return MultipassRenderer.distb1(2.1818181818181817 * (d - 0.041666666666666664)) - 1.0;
        }
        if (d < 0.9583333134651184) {
            return 1.0 - MultipassRenderer.distb1(2.1818181818181817 * (0.9583333333333334 - d));
        }
        return 2.0 - MultipassRenderer.qpow(24.0 * (1.0 - d));
    }

    private static final double qpow(double d) {
        return Math.sqrt(Math.sqrt(d));
    }

    private static final double distb1(double d) {
        double d2 = d;
        for (int i = 0; i < 5; ++i) {
            d2 = (11.0 * d + d2 * d2 * (6.0 + d2 * (8.0 - 9.0 * d2))) / (4.0 + 12.0 * d2 * (1.0 + d2 * (1.0 - d2)));
        }
        return d2;
    }

    private class BucketThread
    extends Thread {
        private final int threadID;
        private final IntersectionState istate;
        private final ShadingCache cache;

        BucketThread(int n) {
            this.threadID = n;
            this.istate = new IntersectionState();
            this.cache = MultipassRenderer.this.shadingCache ? new ShadingCache() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                int n;
                int n2;
                MultipassRenderer multipassRenderer = MultipassRenderer.this;
                synchronized (multipassRenderer) {
                    if (MultipassRenderer.this.bucketCounter >= MultipassRenderer.this.bucketCoords.length) {
                        return;
                    }
                    UI.taskUpdate(MultipassRenderer.this.bucketCounter);
                    n2 = MultipassRenderer.this.bucketCoords[MultipassRenderer.this.bucketCounter + 0];
                    n = MultipassRenderer.this.bucketCoords[MultipassRenderer.this.bucketCounter + 1];
                    MultipassRenderer.this.bucketCounter += 2;
                }
                MultipassRenderer.this.renderBucket(MultipassRenderer.this.display, n2, n, this.threadID, this.istate, this.cache);
            }
        }

        void updateStats() {
            MultipassRenderer.this.scene.accumulateStats(this.istate);
            if (MultipassRenderer.this.shadingCache) {
                MultipassRenderer.this.scene.accumulateStats(this.cache);
            }
        }
    }
}

