/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LocalVariableBinding
extends VariableBinding {
    public int resolvedPosition;
    public static final int UNUSED = 0;
    public static final int USED = 1;
    public static final int FAKE_USED = 2;
    public int useFlag;
    public BlockScope declaringScope;
    public LocalDeclaration declaration;
    public int[] initializationPCs;
    public int initializationCount = 0;
    public FakedTrackingVariable closeTracker;

    public LocalVariableBinding(char[] cArray, TypeBinding typeBinding, int n, boolean bl) {
        super(cArray, typeBinding, n, bl ? Constant.NotAConstant : null);
        if (bl) {
            this.tagBits |= 0x400L;
        }
        this.tagBits |= 0x800L;
    }

    public LocalVariableBinding(LocalDeclaration localDeclaration, TypeBinding typeBinding, int n, boolean bl) {
        this(localDeclaration.name, typeBinding, n, bl);
        this.declaration = localDeclaration;
    }

    public LocalVariableBinding(LocalDeclaration localDeclaration, TypeBinding typeBinding, int n, MethodScope methodScope) {
        this(localDeclaration, typeBinding, n, true);
        this.declaringScope = methodScope;
    }

    @Override
    public final int kind() {
        return 2;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        boolean bl2;
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        BlockScope blockScope = this.declaringScope;
        int n2 = 0;
        if (blockScope != null) {
            MethodScope methodScope = blockScope instanceof MethodScope ? (MethodScope)blockScope : blockScope.enclosingMethodScope();
            ReferenceContext referenceContext = methodScope.referenceContext;
            if (referenceContext instanceof AbstractMethodDeclaration) {
                object = ((AbstractMethodDeclaration)referenceContext).binding;
                if (object != null) {
                    stringBuffer.append(object.computeUniqueKey(false));
                }
            } else if (referenceContext instanceof TypeDeclaration) {
                object = ((TypeDeclaration)referenceContext).binding;
                if (object != null) {
                    stringBuffer.append(object.computeUniqueKey(false));
                }
            } else if (referenceContext instanceof LambdaExpression && (object = ((LambdaExpression)referenceContext).binding) != null) {
                stringBuffer.append(object.computeUniqueKey(false));
            }
            this.getScopeKey(blockScope, stringBuffer);
            object = blockScope.locals;
            for (n = 0; n < blockScope.localIndex; ++n) {
                LocalVariableBinding localVariableBinding = object[n];
                if (!CharOperation.equals(this.name, localVariableBinding.name)) continue;
                if (this == localVariableBinding) break;
                ++n2;
            }
        }
        stringBuffer.append('#');
        stringBuffer.append(this.name);
        boolean bl3 = bl2 = this.isParameter() && this.declaringScope != null;
        if (n2 > 0 || bl2) {
            stringBuffer.append('#');
            stringBuffer.append(n2);
            if (bl2) {
                int n3 = -1;
                object = this.declaringScope.locals;
                for (n = 0; n < ((LocalVariableBinding[])object).length; ++n) {
                    if (object[n] != this) continue;
                    n3 = n;
                    break;
                }
                if (n3 > -1) {
                    stringBuffer.append('#');
                    stringBuffer.append(n3);
                }
            }
        }
        int n4 = stringBuffer.length();
        object = new char[n4];
        stringBuffer.getChars(0, n4, (char[])object, 0);
        return object;
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        Annotation[] annotationArray;
        if (this.declaringScope == null) {
            if ((this.tagBits & 0x200000000L) != 0L) {
                if (this.declaration == null) {
                    return Binding.NO_ANNOTATIONS;
                }
                Annotation[] annotationArray2 = this.declaration.annotations;
                if (annotationArray2 != null) {
                    int n = annotationArray2.length;
                    AnnotationBinding[] annotationBindingArray = new AnnotationBinding[n];
                    for (int i = 0; i < n; ++i) {
                        AnnotationBinding annotationBinding = annotationArray2[i].getCompilerAnnotation();
                        if (annotationBinding == null) {
                            return Binding.NO_ANNOTATIONS;
                        }
                        annotationBindingArray[i] = annotationBinding;
                    }
                    return annotationBindingArray;
                }
            }
            return Binding.NO_ANNOTATIONS;
        }
        SourceTypeBinding sourceTypeBinding = this.declaringScope.enclosingSourceType();
        if (sourceTypeBinding == null) {
            return Binding.NO_ANNOTATIONS;
        }
        if ((this.tagBits & 0x200000000L) == 0L && (this.tagBits & 0x400L) != 0L && this.declaration != null && (annotationArray = this.declaration.annotations) != null) {
            ASTNode.resolveAnnotations(this.declaringScope, annotationArray, this, true);
        }
        return sourceTypeBinding.retrieveAnnotations(this);
    }

    private void getScopeKey(BlockScope blockScope, StringBuffer stringBuffer) {
        int n = blockScope.scopeIndex();
        if (n != -1) {
            this.getScopeKey((BlockScope)blockScope.parent, stringBuffer);
            stringBuffer.append('#');
            stringBuffer.append(n);
        }
    }

    public boolean isSecret() {
        return this.declaration == null && (this.tagBits & 0x400L) == 0L;
    }

    public void recordInitializationEndPC(int n) {
        if (this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == -1) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = n;
        }
    }

    public void recordInitializationStartPC(int n) {
        int n2;
        if (this.initializationPCs == null) {
            return;
        }
        if (this.initializationCount > 0) {
            n2 = this.initializationPCs[(this.initializationCount - 1 << 1) + 1];
            if (n2 == -1) {
                return;
            }
            if (n2 == n) {
                this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = -1;
                return;
            }
        }
        if ((n2 = this.initializationCount << 1) == this.initializationPCs.length) {
            this.initializationPCs = new int[this.initializationCount << 2];
            System.arraycopy(this.initializationPCs, 0, this.initializationPCs, 0, n2);
        }
        this.initializationPCs[n2] = n;
        this.initializationPCs[n2 + 1] = -1;
        ++this.initializationCount;
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotationBindingArray, Scope scope) {
        if (scope == null) {
            return;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding != null) {
            sourceTypeBinding.storeAnnotations(this, annotationBindingArray);
        }
    }

    public void resetInitializations() {
        this.initializationCount = 0;
        this.initializationPCs = null;
    }

    @Override
    public String toString() {
        String string = super.toString();
        switch (this.useFlag) {
            case 1: {
                string = string + "[pos: " + String.valueOf(this.resolvedPosition) + "]";
                break;
            }
            case 0: {
                string = string + "[pos: unused]";
                break;
            }
            case 2: {
                string = string + "[pos: fake_used]";
            }
        }
        string = string + "[id:" + String.valueOf(this.id) + "]";
        if (this.initializationCount > 0) {
            string = string + "[pc: ";
            for (int i = 0; i < this.initializationCount; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + String.valueOf(this.initializationPCs[i << 1]) + "-" + (this.initializationPCs[(i << 1) + 1] == -1 ? "?" : String.valueOf(this.initializationPCs[(i << 1) + 1]));
            }
            string = string + "]";
        }
        return string;
    }

    @Override
    public boolean isParameter() {
        return (this.tagBits & 0x400L) != 0L;
    }

    public boolean isCatchParameter() {
        return false;
    }

    public MethodBinding getEnclosingMethod() {
        BlockScope blockScope = this.declaringScope;
        if (blockScope != null) {
            ReferenceContext referenceContext = blockScope.referenceContext();
            if (referenceContext instanceof Initializer) {
                return null;
            }
            if (referenceContext instanceof AbstractMethodDeclaration) {
                return ((AbstractMethodDeclaration)referenceContext).binding;
            }
        }
        return null;
    }
}

