/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import com.sun.jndi.toolkit.dir.ContainmentFilter;
import com.sun.jndi.toolkit.dir.ContextEnumerator;
import com.sun.jndi.toolkit.dir.HierarchicalName;
import com.sun.jndi.toolkit.dir.HierarchicalNameParser;
import com.sun.jndi.toolkit.dir.LazySearchEnumerationImpl;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;

public class HierMemDirCtx
implements DirContext {
    private static final boolean debug = false;
    private static final NameParser defaultParser = new HierarchicalNameParser();
    protected Hashtable<String, Object> myEnv;
    protected Hashtable<Name, Object> bindings;
    protected Attributes attrs;
    protected boolean ignoreCase = false;
    protected NamingException readOnlyEx = null;
    protected NameParser myParser = defaultParser;
    private boolean alwaysUseFactory;

    @Override
    public void close() throws NamingException {
        this.myEnv = null;
        this.bindings = null;
        this.attrs = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Cannot determine full name");
    }

    public HierMemDirCtx() {
        this(null, false, false);
    }

    public HierMemDirCtx(boolean ignoreCase) {
        this(null, ignoreCase, false);
    }

    public HierMemDirCtx(Hashtable<String, Object> environment, boolean ignoreCase) {
        this(environment, ignoreCase, false);
    }

    protected HierMemDirCtx(Hashtable<String, Object> environment, boolean ignoreCase, boolean useFac) {
        this.myEnv = environment;
        this.ignoreCase = ignoreCase;
        this.init();
        this.alwaysUseFactory = useFac;
    }

    private void init() {
        this.attrs = new BasicAttributes(this.ignoreCase);
        this.bindings = new Hashtable(11, 0.75f);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.myParser.parse(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.doLookup(name, this.alwaysUseFactory);
    }

    public Object doLookup(Name name, boolean useFactory) throws NamingException {
        Object target = null;
        name = this.canonizeName(name);
        switch (name.size()) {
            case 0: {
                target = this;
                break;
            }
            case 1: {
                target = this.bindings.get(name);
                break;
            }
            default: {
                HierMemDirCtx ctx = (HierMemDirCtx)this.bindings.get(name.getPrefix(1));
                target = ctx == null ? null : ctx.doLookup(name.getSuffix(1), false);
            }
        }
        if (target == null) {
            throw new NameNotFoundException(name.toString());
        }
        if (useFactory) {
            try {
                return DirectoryManager.getObjectInstance(target, name, this, this.myEnv, target instanceof HierMemDirCtx ? ((HierMemDirCtx)target).attrs : null);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                NamingException e2 = new NamingException("Problem calling getObjectInstance");
                e2.setRootCause(e);
                throw e2;
            }
        }
        return target;
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.myParser.parse(name), obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.doBind(name, obj, null, this.alwaysUseFactory);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind(this.myParser.parse(name), obj, attrs);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.doBind(name, obj, attrs, this.alwaysUseFactory);
    }

    protected void doBind(Name name, Object obj, Attributes attrs, boolean useFactory) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (useFactory) {
            DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.myEnv, attrs);
            obj = res.getObject();
            attrs = res.getAttributes();
        }
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        ctx.doBindAux(this.getLeafName(name), obj);
        if (attrs != null && attrs.size() > 0) {
            this.modifyAttributes(name, 1, attrs);
        }
    }

    protected void doBindAux(Name name, Object obj) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        if (this.bindings.get(name) != null) {
            throw new NameAlreadyBoundException(name.toString());
        }
        if (!(obj instanceof HierMemDirCtx)) {
            throw new SchemaViolationException("This context only supports binding objects of it's own kind");
        }
        this.bindings.put(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.myParser.parse(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.doRebind(name, obj, null, this.alwaysUseFactory);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(this.myParser.parse(name), obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.doRebind(name, obj, attrs, this.alwaysUseFactory);
    }

    protected void doRebind(Name name, Object obj, Attributes attrs, boolean useFactory) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot rebind empty name");
        }
        if (useFactory) {
            DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.myEnv, attrs);
            obj = res.getObject();
            attrs = res.getAttributes();
        }
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        ctx.doRebindAux(this.getLeafName(name), obj);
        if (attrs != null && attrs.size() > 0) {
            this.modifyAttributes(name, 1, attrs);
        }
    }

    protected void doRebindAux(Name name, Object obj) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        if (!(obj instanceof HierMemDirCtx)) {
            throw new SchemaViolationException("This context only supports binding objects of it's own kind");
        }
        this.bindings.put(name, obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.myParser.parse(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        ctx.doUnbind(this.getLeafName(name));
    }

    protected void doUnbind(Name name) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        this.bindings.remove(name);
    }

    @Override
    public void rename(String oldname, String newname) throws NamingException {
        this.rename(this.myParser.parse(oldname), this.myParser.parse(newname));
    }

    @Override
    public void rename(Name oldname, Name newname) throws NamingException {
        if (newname.isEmpty() || oldname.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (!this.getInternalName(newname).equals(this.getInternalName(oldname))) {
            throw new InvalidNameException("Cannot rename across contexts");
        }
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(this.getInternalName(newname), false);
        ctx.doRename(this.getLeafName(oldname), this.getLeafName(newname));
    }

    protected void doRename(Name oldname, Name newname) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        oldname = this.canonizeName(oldname);
        if (this.bindings.get(newname = this.canonizeName(newname)) != null) {
            throw new NameAlreadyBoundException(newname.toString());
        }
        Object oldBinding = this.bindings.remove(oldname);
        if (oldBinding == null) {
            throw new NameNotFoundException(oldname.toString());
        }
        this.bindings.put(newname, oldBinding);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this.myParser.parse(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(name, false);
        return ctx.doList();
    }

    protected NamingEnumeration<NameClassPair> doList() throws NamingException {
        return new FlatNames(this.bindings.keys());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this.myParser.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(name, false);
        return ctx.doListBindings(this.alwaysUseFactory);
    }

    protected NamingEnumeration<Binding> doListBindings(boolean useFactory) throws NamingException {
        return new FlatBindings(this.bindings, this.myEnv, useFactory);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.myParser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        ctx.doDestroySubcontext(this.getLeafName(name));
    }

    protected void doDestroySubcontext(Name name) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        name = this.canonizeName(name);
        this.bindings.remove(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.myParser.parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name, null);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSubcontext(this.myParser.parse(name), attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        return ctx.doCreateSubcontext(this.getLeafName(name), attrs);
    }

    protected DirContext doCreateSubcontext(Name name, Attributes attrs) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        if (this.bindings.get(name = this.canonizeName(name)) != null) {
            throw new NameAlreadyBoundException(name.toString());
        }
        HierMemDirCtx newCtx = this.createNewCtx();
        this.bindings.put(name, newCtx);
        if (attrs != null) {
            newCtx.modifyAttributes("", 1, attrs);
        }
        return newCtx;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.myParser.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.myParser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.myParser;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        name = this.canonizeName(name);
        prefix = this.canonizeName(prefix);
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        this.myEnv = this.myEnv == null ? new Hashtable(11, 0.75f) : (Hashtable)this.myEnv.clone();
        return this.myEnv.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        this.myEnv = (Hashtable)this.myEnv.clone();
        return this.myEnv.remove(propName);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable<String, Object>(5, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(this.myParser.parse(name));
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(name, false);
        return ctx.doGetAttributes();
    }

    protected Attributes doGetAttributes() throws NamingException {
        return (Attributes)this.attrs.clone();
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(this.myParser.parse(name), attrIds);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(name, false);
        return ctx.doGetAttributes(attrIds);
    }

    protected Attributes doGetAttributes(String[] attrIds) throws NamingException {
        if (attrIds == null) {
            return this.doGetAttributes();
        }
        BasicAttributes attrs = new BasicAttributes(this.ignoreCase);
        Attribute attr = null;
        for (int i = 0; i < attrIds.length; ++i) {
            attr = this.attrs.get(attrIds[i]);
            if (attr == null) continue;
            attrs.put(attr);
        }
        return attrs;
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(this.myParser.parse(name), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        if (attrs == null || attrs.size() == 0) {
            throw new IllegalArgumentException("Cannot modify without an attribute");
        }
        NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
        ModificationItem[] mods = new ModificationItem[attrs.size()];
        for (int i = 0; i < mods.length && attrEnum.hasMoreElements(); ++i) {
            mods[i] = new ModificationItem(mod_op, attrEnum.next());
        }
        this.modifyAttributes(name, mods);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(this.myParser.parse(name), mods);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        HierMemDirCtx ctx = (HierMemDirCtx)this.doLookup(name, false);
        ctx.doModifyAttributes(mods);
    }

    protected void doModifyAttributes(ModificationItem[] mods) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        HierMemDirCtx.applyMods(mods, this.attrs);
    }

    protected static Attributes applyMods(ModificationItem[] mods, Attributes orig) throws NamingException {
        block5: for (int i = 0; i < mods.length; ++i) {
            ModificationItem mod = mods[i];
            Attribute modAttr = mod.getAttribute();
            switch (mod.getModificationOp()) {
                case 1: {
                    Attribute existingAttr = orig.get(modAttr.getID());
                    if (existingAttr == null) {
                        orig.put((Attribute)modAttr.clone());
                        continue block5;
                    }
                    NamingEnumeration<?> modVals = modAttr.getAll();
                    while (modVals.hasMore()) {
                        existingAttr.add(modVals.next());
                    }
                    continue block5;
                }
                case 2: {
                    if (modAttr.size() == 0) {
                        orig.remove(modAttr.getID());
                        continue block5;
                    }
                    orig.put((Attribute)modAttr.clone());
                    continue block5;
                }
                case 3: {
                    Attribute existingAttr = orig.get(modAttr.getID());
                    if (existingAttr == null) continue block5;
                    if (modAttr.size() == 0) {
                        orig.remove(modAttr.getID());
                        continue block5;
                    }
                    NamingEnumeration<?> modVals = modAttr.getAll();
                    while (modVals.hasMore()) {
                        existingAttr.remove(modVals.next());
                    }
                    if (existingAttr.size() != 0) continue block5;
                    orig.remove(modAttr.getID());
                    continue block5;
                }
                default: {
                    throw new AttributeModificationException("Unknown mod_op");
                }
            }
        }
        return orig;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(this.myParser.parse(name), matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        HierMemDirCtx target = (HierMemDirCtx)this.doLookup(name, false);
        SearchControls cons = new SearchControls();
        cons.setReturningAttributes(attributesToReturn);
        return new LazySearchEnumerationImpl(target.doListBindings(false), new ContainmentFilter(matchingAttributes), cons, this, this.myEnv, false);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        DirContext target = (DirContext)this.doLookup(name, false);
        SearchFilter stringfilter = new SearchFilter(filter);
        return new LazySearchEnumerationImpl(new HierContextEnumerator(target, cons != null ? cons.getSearchScope() : 1), stringfilter, cons, this, this.myEnv, this.alwaysUseFactory);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        String strfilter = SearchFilter.format(filterExpr, filterArgs);
        return this.search(name, strfilter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search(this.myParser.parse(name), filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(this.myParser.parse(name), filterExpr, filterArgs, cons);
    }

    protected HierMemDirCtx createNewCtx() throws NamingException {
        return new HierMemDirCtx(this.myEnv, this.ignoreCase);
    }

    protected Name canonizeName(Name name) throws NamingException {
        Name canonicalName = name;
        if (!(name instanceof HierarchicalName)) {
            canonicalName = new HierarchicalName();
            int n = name.size();
            for (int i = 0; i < n; ++i) {
                canonicalName.add(i, name.get(i));
            }
        }
        return canonicalName;
    }

    protected Name getInternalName(Name name) throws NamingException {
        return name.getPrefix(name.size() - 1);
    }

    protected Name getLeafName(Name name) throws NamingException {
        return name.getSuffix(name.size() - 1);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void setReadOnly(NamingException e) {
        this.readOnlyEx = e;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setNameParser(NameParser parser) {
        this.myParser = parser;
    }

    public class HierContextEnumerator
    extends ContextEnumerator {
        public HierContextEnumerator(Context context, int scope) throws NamingException {
            super(context, scope);
        }

        protected HierContextEnumerator(Context context, int scope, String contextName, boolean returnSelf) throws NamingException {
            super(context, scope, contextName, returnSelf);
        }

        @Override
        protected NamingEnumeration<Binding> getImmediateChildren(Context ctx) throws NamingException {
            return ((HierMemDirCtx)ctx).doListBindings(false);
        }

        @Override
        protected ContextEnumerator newEnumerator(Context ctx, int scope, String contextName, boolean returnSelf) throws NamingException {
            return new HierContextEnumerator(ctx, scope, contextName, returnSelf);
        }
    }

    private final class FlatBindings
    extends BaseFlatNames<Binding> {
        private Hashtable<Name, Object> bds;
        private Hashtable<String, Object> env;
        private boolean useFactory;

        FlatBindings(Hashtable<Name, Object> bindings, Hashtable<String, Object> env, boolean useFactory) {
            super(bindings.keys());
            this.env = env;
            this.bds = bindings;
            this.useFactory = useFactory;
        }

        @Override
        public Binding next() throws NamingException {
            Name name = (Name)this.names.nextElement();
            HierMemDirCtx obj = (HierMemDirCtx)this.bds.get(name);
            Object answer = obj;
            if (this.useFactory) {
                Attributes attrs = obj.getAttributes("");
                try {
                    answer = DirectoryManager.getObjectInstance(obj, name, HierMemDirCtx.this, this.env, attrs);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException e2 = new NamingException("Problem calling getObjectInstance");
                    e2.setRootCause(e);
                    throw e2;
                }
            }
            return new Binding(name.toString(), answer);
        }
    }

    private final class FlatNames
    extends BaseFlatNames<NameClassPair> {
        FlatNames(Enumeration<Name> names) {
            super(names);
        }

        @Override
        public NameClassPair next() throws NamingException {
            Name name = (Name)this.names.nextElement();
            String className = HierMemDirCtx.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name.toString(), className);
        }
    }

    private abstract class BaseFlatNames<T>
    implements NamingEnumeration<T> {
        Enumeration<Name> names;

        BaseFlatNames(Enumeration<Name> names) {
            this.names = names;
        }

        @Override
        public final boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        @Override
        public final boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        @Override
        public final T nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }

        @Override
        public abstract T next() throws NamingException;

        @Override
        public final void close() {
            this.names = null;
        }
    }
}

