/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.ScriptRunData;

public final class ScriptRun {
    private char[] text;
    private int textStart;
    private int textLimit;
    private int scriptStart;
    private int scriptLimit;
    private int scriptCode;
    private int[] stack;
    private int parenSP;
    static final int SURROGATE_START = 65536;
    static final int LEAD_START = 55296;
    static final int LEAD_LIMIT = 56320;
    static final int TAIL_START = 56320;
    static final int TAIL_LIMIT = 57344;
    static final int LEAD_SURROGATE_SHIFT = 10;
    static final int SURROGATE_OFFSET = -56613888;
    static final int DONE = -1;
    private static int[] pairedChars = new int[]{40, 41, 60, 62, 91, 93, 123, 125, 171, 187, 8216, 8217, 8220, 8221, 8249, 8250, 12296, 12297, 12298, 12299, 12300, 12301, 12302, 12303, 12304, 12305, 12308, 12309, 12310, 12311, 12312, 12313, 12314, 12315};
    private static final int pairedCharPower = 1 << ScriptRun.highBit(pairedChars.length);
    private static final int pairedCharExtra = pairedChars.length - pairedCharPower;

    public ScriptRun() {
    }

    public ScriptRun(char[] chars, int start, int count) {
        this.init(chars, start, count);
    }

    public void init(char[] chars, int start, int count) {
        if (chars == null || start < 0 || count < 0 || count > chars.length - start) {
            throw new IllegalArgumentException();
        }
        this.text = chars;
        this.textStart = start;
        this.textLimit = start + count;
        this.scriptStart = this.textStart;
        this.scriptLimit = this.textStart;
        this.scriptCode = -1;
        this.parenSP = 0;
    }

    public final int getScriptStart() {
        return this.scriptStart;
    }

    public final int getScriptLimit() {
        return this.scriptLimit;
    }

    public final int getScriptCode() {
        return this.scriptCode;
    }

    public final boolean next() {
        int ch;
        int startSP = this.parenSP;
        if (this.scriptLimit >= this.textLimit) {
            return false;
        }
        this.scriptCode = 0;
        this.scriptStart = this.scriptLimit;
        while ((ch = this.nextCodePoint()) != -1) {
            int pairIndex;
            int sc = ScriptRunData.getScript(ch);
            int n = pairIndex = sc == 0 ? ScriptRun.getPairIndex(ch) : -1;
            if (pairIndex >= 0) {
                if ((pairIndex & 1) == 0) {
                    if (this.stack == null) {
                        this.stack = new int[32];
                    } else if (this.parenSP == this.stack.length) {
                        int[] newstack = new int[this.stack.length + 32];
                        System.arraycopy(this.stack, 0, newstack, 0, this.stack.length);
                        this.stack = newstack;
                    }
                    this.stack[this.parenSP++] = pairIndex;
                    this.stack[this.parenSP++] = this.scriptCode;
                } else if (this.parenSP > 0) {
                    int pi = pairIndex & 0xFFFFFFFE;
                    while ((this.parenSP -= 2) >= 0 && this.stack[this.parenSP] != pi) {
                    }
                    if (this.parenSP >= 0) {
                        sc = this.stack[this.parenSP + 1];
                    } else {
                        this.parenSP = 0;
                    }
                    if (this.parenSP < startSP) {
                        startSP = this.parenSP;
                    }
                }
            }
            if (ScriptRun.sameScript(this.scriptCode, sc)) {
                if (this.scriptCode <= 1 && sc > 1) {
                    this.scriptCode = sc;
                    while (startSP < this.parenSP) {
                        this.stack[startSP + 1] = this.scriptCode;
                        startSP += 2;
                    }
                }
                if (pairIndex <= 0 || (pairIndex & 1) == 0 || this.parenSP <= 0) continue;
                this.parenSP -= 2;
                continue;
            }
            this.pushback(ch);
            break;
        }
        return true;
    }

    private final int nextCodePoint() {
        char nch;
        int ch;
        if (this.scriptLimit >= this.textLimit) {
            return -1;
        }
        if ((ch = this.text[this.scriptLimit++]) >= 55296 && ch < 56320 && this.scriptLimit < this.textLimit && (nch = this.text[this.scriptLimit]) >= '\udc00' && nch < '\ue000') {
            ++this.scriptLimit;
            ch = (ch << 10) + nch + -56613888;
        }
        return ch;
    }

    private final void pushback(int ch) {
        if (ch >= 0) {
            this.scriptLimit = ch >= 65536 ? (this.scriptLimit -= 2) : --this.scriptLimit;
        }
    }

    private static boolean sameScript(int scriptOne, int scriptTwo) {
        return scriptOne == scriptTwo || scriptOne <= 1 || scriptTwo <= 1;
    }

    private static final byte highBit(int n) {
        if (n <= 0) {
            return -32;
        }
        byte bit = 0;
        if (n >= 65536) {
            n >>= 16;
            bit = (byte)(bit + 16);
        }
        if (n >= 256) {
            n >>= 8;
            bit = (byte)(bit + 8);
        }
        if (n >= 16) {
            n >>= 4;
            bit = (byte)(bit + 4);
        }
        if (n >= 4) {
            n >>= 2;
            bit = (byte)(bit + 2);
        }
        if (n >= 2) {
            n >>= 1;
            bit = (byte)(bit + 1);
        }
        return bit;
    }

    private static int getPairIndex(int ch) {
        int probe = pairedCharPower;
        int index = 0;
        if (ch >= pairedChars[pairedCharExtra]) {
            index = pairedCharExtra;
        }
        while (probe > 1) {
            if (ch < pairedChars[index + (probe >>= 1)]) continue;
            index += probe;
        }
        if (pairedChars[index] != ch) {
            index = -1;
        }
        return index;
    }
}

