/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Field;
import sun.reflect.UnsafeFieldAccessorImpl;

class UnsafeDoubleFieldAccessorImpl
extends UnsafeFieldAccessorImpl {
    UnsafeDoubleFieldAccessorImpl(Field field) {
        super(field);
    }

    @Override
    public Object get(Object obj) throws IllegalArgumentException {
        return new Double(this.getDouble(obj));
    }

    @Override
    public boolean getBoolean(Object obj) throws IllegalArgumentException {
        throw this.newGetBooleanIllegalArgumentException();
    }

    @Override
    public byte getByte(Object obj) throws IllegalArgumentException {
        throw this.newGetByteIllegalArgumentException();
    }

    @Override
    public char getChar(Object obj) throws IllegalArgumentException {
        throw this.newGetCharIllegalArgumentException();
    }

    @Override
    public short getShort(Object obj) throws IllegalArgumentException {
        throw this.newGetShortIllegalArgumentException();
    }

    @Override
    public int getInt(Object obj) throws IllegalArgumentException {
        throw this.newGetIntIllegalArgumentException();
    }

    @Override
    public long getLong(Object obj) throws IllegalArgumentException {
        throw this.newGetLongIllegalArgumentException();
    }

    @Override
    public float getFloat(Object obj) throws IllegalArgumentException {
        throw this.newGetFloatIllegalArgumentException();
    }

    @Override
    public double getDouble(Object obj) throws IllegalArgumentException {
        this.ensureObj(obj);
        return unsafe.getDouble(obj, this.fieldOffset);
    }

    @Override
    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(obj);
        if (this.isFinal) {
            this.throwFinalFieldIllegalAccessException(value);
        }
        if (value == null) {
            this.throwSetIllegalArgumentException(value);
        }
        if (value instanceof Byte) {
            unsafe.putDouble(obj, this.fieldOffset, (double)((Byte)value).byteValue());
            return;
        }
        if (value instanceof Short) {
            unsafe.putDouble(obj, this.fieldOffset, (double)((Short)value).shortValue());
            return;
        }
        if (value instanceof Character) {
            unsafe.putDouble(obj, this.fieldOffset, (double)((Character)value).charValue());
            return;
        }
        if (value instanceof Integer) {
            unsafe.putDouble(obj, this.fieldOffset, (double)((Integer)value).intValue());
            return;
        }
        if (value instanceof Long) {
            unsafe.putDouble(obj, this.fieldOffset, (double)((Long)value).longValue());
            return;
        }
        if (value instanceof Float) {
            unsafe.putDouble(obj, this.fieldOffset, (double)((Float)value).floatValue());
            return;
        }
        if (value instanceof Double) {
            unsafe.putDouble(obj, this.fieldOffset, (double)((Double)value));
            return;
        }
        this.throwSetIllegalArgumentException(value);
    }

    @Override
    public void setBoolean(Object obj, boolean z) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(z);
    }

    @Override
    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, b);
    }

    @Override
    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, c);
    }

    @Override
    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, s);
    }

    @Override
    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, i);
    }

    @Override
    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, l);
    }

    @Override
    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, f);
    }

    @Override
    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(obj);
        if (this.isFinal) {
            this.throwFinalFieldIllegalAccessException(d);
        }
        unsafe.putDouble(obj, this.fieldOffset, d);
    }
}

