/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.logs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.profiler.snaptracer.logs.LogRecords;
import org.openide.filesystems.FileObject;

public final class LogReader {
    private static final Logger LOG = Logger.getLogger(LogRecords.class.getName());
    private FileObject logFile;
    private NavigableMap<Long, LogRecord> recordList;

    public LogReader(FileObject fileObject) {
        this.logFile = fileObject;
        this.recordList = new TreeMap<Long, LogRecord>();
    }

    public void load() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.logFile.getInputStream(), 32768);
        try {
            LogRecords.scan(bufferedInputStream, new LogHandler());
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public LogRecord getRecordFor(long l) {
        Map.Entry<Long, LogRecord> entry = this.recordList.floorEntry(new Long(l));
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    class LogHandler
    extends Handler {
        LogHandler() {
        }

        @Override
        public void publish(LogRecord logRecord) {
            LogReader.this.recordList.put(new Long(logRecord.getMillis()), logRecord);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

