/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.InstrumentationFactory;
import org.netbeans.lib.profiler.instrumentation.MemoryProfMethodInstrumentor;
import org.netbeans.lib.profiler.instrumentation.SingleMethodScaner;

public class ObjLivenessMethodInstrumentor
extends MemoryProfMethodInstrumentor {
    protected static final int STANDARD_INSTRUMENTATION = 1;
    protected static final int SELECTIVE_INSTR_REMOVAL = 2;
    protected boolean[] allUnprofiledClassStatusArray;
    protected int operationCode;
    private final ProfilerEngineSettings engineSettings;
    private final InstrumentationFilter instrFilter;
    private final boolean instrObjectInit;
    private final boolean instrArr;

    public ObjLivenessMethodInstrumentor(ProfilingSessionStatus profilingSessionStatus, ProfilerEngineSettings profilerEngineSettings, boolean bl) {
        super(profilingSessionStatus, bl ? 10 : 9);
        this.engineSettings = profilerEngineSettings;
        this.instrFilter = profilerEngineSettings.getInstrumentationFilter();
        this.operationCode = 1;
        this.instrObjectInit = profilerEngineSettings.isInstrumentObjectInit();
        this.instrArr = profilerEngineSettings.isInstrumentArrayAllocation();
    }

    public Object[] getMethodsToInstrumentUponClassUnprofiling(boolean[] blArray) {
        this.operationCode = 2;
        this.initInstrumentationPackData();
        MethodScanerForBannedInstantiations methodScanerForBannedInstantiations = new MethodScanerForBannedInstantiations();
        methodScanerForBannedInstantiations.setUnprofiledClassStatusArray(blArray);
        this.setAllUnprofiledClassStatusArray(blArray);
        Object[] objectArray = ClassRepository.getClassEnumerationWithAllVersions();
        while (objectArray.hasMoreElements()) {
            DynamicClassInfo dynamicClassInfo;
            Object e = objectArray.nextElement();
            if (!(e instanceof DynamicClassInfo) || !(dynamicClassInfo = (DynamicClassInfo)e).isLoaded() || !dynamicClassInfo.hasInstrumentedMethods()) continue;
            String[] stringArray = dynamicClassInfo.getMethodNames();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!dynamicClassInfo.isMethodInstrumented(i)) continue;
                methodScanerForBannedInstantiations.setClassAndMethod(dynamicClassInfo, i);
                if (!methodScanerForBannedInstantiations.hasNewOpcodes(!this.instrObjectInit, this.instrArr)) continue;
                bl = true;
                dynamicClassInfo.setMethodSpecial(i);
                ++this.nInstrMethods;
            }
            if (!bl) continue;
            ++this.nInstrClasses;
            this.instrClasses.add(dynamicClassInfo);
        }
        objectArray = this.createInstrumentedMethodPack();
        this.operationCode = 1;
        return objectArray;
    }

    protected void setAllUnprofiledClassStatusArray(boolean[] blArray) {
        int n = blArray.length;
        if (this.allUnprofiledClassStatusArray == null || this.allUnprofiledClassStatusArray.length < n) {
            boolean[] blArray2 = this.allUnprofiledClassStatusArray;
            this.allUnprofiledClassStatusArray = new boolean[n];
            if (blArray2 != null) {
                System.arraycopy(blArray2, 0, this.allUnprofiledClassStatusArray, 0, blArray2.length);
            }
        }
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            this.allUnprofiledClassStatusArray[i] = true;
        }
    }

    @Override
    protected byte[] instrumentMethod(DynamicClassInfo dynamicClassInfo, int n) {
        return InstrumentationFactory.instrumentForMemoryProfiling(dynamicClassInfo, n, this.allUnprofiledClassStatusArray, this.injType, ObjLivenessMethodInstrumentor.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), dynamicClassInfo, n), this.instrFilter, !this.instrObjectInit, this.instrArr);
    }

    @Override
    protected boolean classNeedsInstrumentation(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        if (!this.instrObjectInit || this.instrArr) {
            return true;
        }
        return this.instrObjectInit && "java/lang/Object".equals(classInfo.getName()) && classInfo.getLoaderId() <= 0;
    }

    @Override
    protected boolean methodNeedsInstrumentation(ClassInfo classInfo, int n) {
        boolean bl = this.hasNewOpcodes(classInfo, n, !this.instrObjectInit, this.instrArr, this.instrFilter);
        boolean bl2 = ObjLivenessMethodInstrumentor.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), classInfo, n).length > 0;
        boolean bl3 = this.instrObjectInit && ObjLivenessMethodInstrumentor.isObjectConstructor(classInfo, n);
        return bl || bl2 || bl3;
    }

    @Override
    protected boolean methodNeedsRewriting(DynamicClassInfo dynamicClassInfo, int n) {
        if (this.operationCode == 1) {
            return dynamicClassInfo.isMethodInstrumented(n);
        }
        boolean bl = dynamicClassInfo.isMethodSpecial(n);
        dynamicClassInfo.unsetMethodSpecial(n);
        return bl;
    }

    private boolean trackAllAllocations() {
        return this.instrFilter.getType() == 0 && this.allUnprofiledClassStatusArray == null;
    }

    static boolean isObjectConstructor(ClassInfo classInfo, int n) {
        return "java/lang/Object".equals(classInfo.getName()) && classInfo.getLoaderId() <= 0 && "<init>".equals(classInfo.getMethodName(n));
    }

    static class MethodScanerForBannedInstantiations
    extends SingleMethodScaner {
        protected boolean[] unprofiledClassStatusArray;

        MethodScanerForBannedInstantiations() {
        }

        void setUnprofiledClassStatusArray(boolean[] blArray) {
            this.unprofiledClassStatusArray = blArray;
        }

        boolean hasNewOpcodes(boolean bl, boolean bl2) {
            if (!bl && !bl2) {
                return false;
            }
            int n = this.clazz.getLoaderId();
            for (int i = 0; i < this.bytecodesLength; i += this.opcodeLength(i)) {
                int n2;
                Object object;
                int n3;
                int n4 = this.bytecodes[i] & 0xFF;
                if (n4 == 187 && bl || n4 == 189 || n4 == 197 && bl2) {
                    n3 = this.getU2(i + 1);
                    object = this.clazz.getRefClassName(n3);
                    BaseClassInfo baseClassInfo = n4 == 187 ? ClassManager.javaClassOrPlaceholderForName((String)object, n) : (n4 == 189 ? ClassManager.javaClassForObjectArrayType((String)object) : ClassRepository.lookupSpecialClass((String)object));
                    int n5 = baseClassInfo.getInstrClassId();
                    if (n5 == -1 || this.unprofiledClassStatusArray.length <= n5 || !this.unprofiledClassStatusArray[n5]) continue;
                    return true;
                }
                if (n4 != 188 || !bl2 || (n2 = ((BaseClassInfo)(object = ClassManager.javaClassForPrimitiveArrayType(n3 = this.getByte(i + 1)))).getInstrClassId()) == -1 || !this.unprofiledClassStatusArray[n2]) continue;
                return true;
            }
            return false;
        }
    }
}

