/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.ApplicationDescriptorProvider;
import com.sun.tools.visualvm.application.ApplicationsSorting;
import com.sun.tools.visualvm.application.GeneralPropertiesProvider;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.model.ModelProvider;
import com.sun.tools.visualvm.core.properties.PropertiesProvider;
import com.sun.tools.visualvm.core.properties.PropertiesSupport;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.LocalHostDescriptor;
import java.lang.management.ManagementFactory;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class ApplicationSupport {
    private static ApplicationSupport instance;

    public static synchronized ApplicationSupport getInstance() {
        if (instance == null) {
            instance = new ApplicationSupport();
        }
        return instance;
    }

    Application createCurrentApplication() {
        String selfName = ManagementFactory.getRuntimeMXBean().getName();
        int selfPid = Integer.valueOf(selfName.substring(0, selfName.indexOf(64)));
        return new CurrentApplication(selfPid, Host.LOCALHOST, Host.LOCALHOST.getHostName() + "-" + selfPid);
    }

    private void initCurrentApplication() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        DataSourceDescriptor localHostDescriptor = DataSourceDescriptorFactory.getDescriptor((DataSource)Host.LOCALHOST);
                        if (localHostDescriptor instanceof LocalHostDescriptor) {
                            ((LocalHostDescriptor)localHostDescriptor).setChildrenComparator(ApplicationsSorting.instance().getInitialSorting());
                        }
                        Host.LOCALHOST.getRepository().addDataSource((DataSource)Application.CURRENT_APPLICATION);
                    }
                });
            }
        });
    }

    private ApplicationSupport() {
        DataSourceDescriptorFactory descriptorFactory = DataSourceDescriptorFactory.getDefault();
        descriptorFactory.registerProvider((ModelProvider)new ApplicationDescriptorProvider());
        PropertiesSupport.sharedInstance().registerPropertiesProvider((PropertiesProvider)new GeneralPropertiesProvider(), CurrentApplication.class);
        this.initCurrentApplication();
    }

    class CurrentApplication
    extends Application {
        private int selfPid;

        private CurrentApplication(int selfPid, Host host, String id) {
            super(host, id);
            this.selfPid = selfPid;
        }

        @Override
        public int getPid() {
            return this.selfPid;
        }
    }
}

