/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.security.sasl.SaslClient;

public class SaslInputStream
extends FilterInputStream {
    private final SaslClient sasl;
    private byte[] buf;
    private int pos;

    public SaslInputStream(SaslClient saslClient, InputStream inputStream) {
        super(inputStream);
        this.sasl = saslClient;
    }

    @Override
    public int read() throws IOException {
        if (this.buf != null) {
            byte by = this.buf[this.pos++];
            if (this.pos == this.buf.length) {
                this.buf = null;
            }
            return by;
        }
        int n = super.read();
        if (n == -1) {
            return n;
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = this.sasl.unwrap(byArray, 0, 1);
        n = byArray2[0];
        if (byArray2.length > 1) {
            int n2 = byArray2.length - 1;
            this.buf = new byte[n2];
            System.arraycopy(byArray2, 1, this.buf, 0, n2);
            this.pos = 0;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buf != null) {
            int n3 = this.buf.length;
            if (n3 - this.pos <= n2) {
                System.arraycopy(this.buf, this.pos, byArray, n, n3);
                this.buf = null;
                return n3;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }
        int n4 = super.read(byArray, n, n2);
        if (n4 == -1) {
            return n4;
        }
        byte[] byArray2 = this.sasl.unwrap(byArray, n, n4);
        int n5 = byArray2.length;
        if (n5 > n2) {
            int n6 = n5 - n2;
            this.buf = new byte[n6];
            System.arraycopy(byArray2, 0, byArray, n, n2);
            System.arraycopy(byArray2, n2, this.buf, 0, n6);
            this.pos = 0;
            return n2;
        }
        System.arraycopy(byArray2, 0, byArray, n, n5);
        for (int i = n5; i < n4; ++i) {
            byArray[n + n5] = 0;
        }
        return n5;
    }
}

