/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontSelector;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;

public class CharacterLayoutManager
extends LeafNodeLayoutManager {
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private Font font;
    private CommonBorderPaddingBackground borderProps;

    public CharacterLayoutManager(Character node) {
        super(node);
    }

    @Override
    public void initialize() {
        Character fobj = (Character)this.fobj;
        this.font = FontSelector.selectFontForCharacter(fobj, this);
        SpaceVal ls = SpaceVal.makeLetterSpacing(fobj.getLetterSpacing());
        this.letterSpaceIPD = ls.getSpace();
        this.hyphIPD = fobj.getCommonHyphenation().getHyphIPD(this.font);
        this.borderProps = fobj.getCommonBorderPaddingBackground();
        this.setCommonBorderPaddingBackground(this.borderProps);
    }

    private TextArea createCharacterArea() {
        Character fobj = (Character)this.fobj;
        TextArea text = new TextArea();
        char ch = fobj.getCharacter();
        int ipd = this.font.getCharWidth(ch);
        int blockProgressionOffset = 0;
        int level = fobj.getBidiLevel();
        if (CharUtilities.isAnySpace(ch)) {
            if (!CharUtilities.isZeroWidthSpace(ch)) {
                text.addSpace(ch, ipd, CharUtilities.isAdjustableSpace(ch), blockProgressionOffset, level);
            }
        } else {
            int[] nArray;
            if (level >= 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = level;
            } else {
                nArray = null;
            }
            int[] levels = nArray;
            text.addWord(String.valueOf(ch), ipd, null, levels, null, blockProgressionOffset);
        }
        TraitSetter.setProducerID(text, fobj.getId());
        TraitSetter.addTextDecoration(text, fobj.getTextDecoration());
        text.setIPD(this.font.getCharWidth(fobj.getCharacter()));
        text.setBPD(this.font.getAscender() - this.font.getDescender());
        text.setBaselineOffset(this.font.getAscender());
        TraitSetter.addFontTraits(text, this.font);
        text.addTrait(Trait.COLOR, fobj.getColor());
        return text;
    }

    @Override
    protected InlineArea getEffectiveArea(LayoutContext layoutContext) {
        TextArea area = this.createCharacterArea();
        if (!layoutContext.treatAsArtifact()) {
            TraitSetter.addStructureTreeElement(area, ((Character)this.fobj).getStructureTreeElement());
        }
        return area;
    }

    @Override
    public List getNextKnuthElements(LayoutContext context, int alignment) {
        Character fobj = (Character)this.fobj;
        this.alignmentContext = new AlignmentContext(this.font, this.font.getFontSize(), fobj.getAlignmentAdjust(), fobj.getAlignmentBaseline(), fobj.getBaselineShift(), fobj.getDominantBaseline(), context.getAlignmentContext());
        InlineKnuthSequence seq = new InlineKnuthSequence();
        this.addKnuthElementsForBorderPaddingStart(seq);
        MinOptMax ipd = MinOptMax.getInstance(this.font.getCharWidth(fobj.getCharacter()));
        this.areaInfo = new LeafNodeLayoutManager.AreaInfo(this, 0, ipd, false, this.alignmentContext);
        if (this.letterSpaceIPD.isStiff()) {
            seq.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
        } else {
            seq.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            seq.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            seq.add(new KnuthGlue(0, 0, 0, new LeafPosition(this, -1), true));
            seq.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
        }
        this.addKnuthElementsForBorderPaddingEnd(seq);
        LinkedList<InlineKnuthSequence> returnList = new LinkedList<InlineKnuthSequence>();
        returnList.add(seq);
        this.setFinished(true);
        return returnList;
    }

    @Override
    public String getWordChars(Position pos) {
        return String.valueOf(((Character)this.fobj).getCharacter());
    }

    @Override
    public void hyphenate(Position pos, HyphContext hc) {
        if (hc.getNextHyphPoint() == 1) {
            this.areaInfo.isHyphenated = true;
            this.somethingChanged = true;
        }
        hc.updateOffset(1);
    }

    @Override
    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        return this.somethingChanged;
    }

    @Override
    public List getChangedKnuthElements(List oldList, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        this.addKnuthElementsForBorderPaddingStart(returnList);
        if (this.letterSpaceIPD.isStiff() || this.areaInfo.letterSpaces == 0) {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            if (this.areaInfo.isHyphenated) {
                returnList.add(new KnuthPenalty(this.hyphIPD, 50, true, new LeafPosition(this, -1), false));
            }
        } else {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt() - this.areaInfo.letterSpaces * this.letterSpaceIPD.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            returnList.add(new KnuthGlue(this.letterSpaceIPD.mult(this.areaInfo.letterSpaces), (Position)new LeafPosition(this, -1), true));
            returnList.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
            if (this.areaInfo.isHyphenated) {
                returnList.add(new KnuthPenalty(this.hyphIPD, 50, true, new LeafPosition(this, -1), false));
            }
        }
        this.addKnuthElementsForBorderPaddingEnd(returnList);
        this.setFinished(true);
        return returnList;
    }
}

