/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.junit.contrib.java.lang.system.internal.PrintStreamHandler;
import org.junit.runners.model.Statement;

public class DisallowWrite {
    private final PrintStreamHandler printStreamHandler;

    public DisallowWrite(PrintStreamHandler printStreamHandler) {
        this.printStreamHandler = printStreamHandler;
    }

    public Statement createStatement(final Statement base) {
        return this.printStreamHandler.createRestoreStatement(new Statement(){

            public void evaluate() throws Throwable {
                DisallowWrite.this.printStreamHandler.replaceCurrentStreamWithOutputStream(new DisallowWriteStream());
                base.evaluate();
            }
        });
    }

    private static class DisallowWriteStream
    extends OutputStream {
        private DisallowWriteStream() {
        }

        public void write(int b) throws IOException {
            throw new AssertionError((Object)("Tried to write '" + (char)b + "' although this is not allowed."));
        }
    }
}

