/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.view.AbstractOWLSelectionViewComponent;
import org.semanticweb.owlapi.manchestersyntax.renderer.ManchesterOWLSyntaxFrameRenderer;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class ManchesterSyntaxFrameView
extends AbstractOWLSelectionViewComponent {
    private static final long serialVersionUID = -7745031898151962692L;
    private JTextArea textArea;
    private JScrollPane scroller;

    @Override
    public void initialiseView() throws Exception {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("monospaced", 0, 12));
        this.scroller = new JScrollPane(this.textArea);
        this.add(this.scroller, "Center");
        this.updateView();
    }

    @Override
    protected OWLObject updateView() {
        OWLEntity owlEntity = this.getOWLWorkspace().getOWLSelectionModel().getSelectedEntity();
        if (owlEntity != null) {
            StringWriter w = new StringWriter();
            try {
                BufferedWriter bw = new BufferedWriter(w);
                this.renderOWLEntity(owlEntity, bw);
                bw.close();
                this.textArea.setText(w.getBuffer().toString());
                SwingUtilities.invokeLater(() -> this.scroller.getViewport().setViewPosition(new Point(0, 0)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return owlEntity;
    }

    private void renderOWLEntity(OWLEntity entity, Writer writer) throws Exception {
        OWLEntityFrameRendererAdapter adapter = new OWLEntityFrameRendererAdapter(this.getOWLModelManager(), writer);
        entity.accept((OWLEntityVisitor)adapter);
    }

    @Override
    public void disposeView() {
    }

    class OWLEntityFrameRendererAdapter
    implements OWLEntityVisitor {
        private ManchesterOWLSyntaxFrameRenderer ren;

        OWLEntityFrameRendererAdapter(OWLModelManager mngr, Writer writer) {
            this.ren = new ManchesterOWLSyntaxFrameRenderer(mngr.getActiveOntology(), writer, (ShortFormProvider)mngr.getOWLEntityRenderer());
        }

        public void visit(OWLClass owlClass) {
            this.ren.write(owlClass);
        }

        public void visit(OWLObjectProperty owlObjectProperty) {
            this.ren.write((OWLObjectPropertyExpression)owlObjectProperty);
        }

        public void visit(OWLDataProperty owlDataProperty) {
            this.ren.write(owlDataProperty);
        }

        public void visit(OWLNamedIndividual owlNamedIndividual) {
            this.ren.write((OWLIndividual)owlNamedIndividual);
        }

        public void visit(OWLDatatype owlDatatype) {
            this.ren.write(owlDatatype);
        }

        public void visit(OWLAnnotationProperty owlAnnotationProperty) {
            this.ren.write(owlAnnotationProperty);
        }
    }
}

