#!/usr/bin/env python
#
#      Restriction Analysis Libraries.
#      Copyright (C) 2004. Frederic Sohm.
#
# This code is part of the Biopython distribution and governed by its
# license.  Please see the LICENSE file that should have been included
# as part of this package.
#
# This file is automatically generated - do not edit it by hand! Instead,
# use the tool Scripts/Restriction/ranacompiler.py which in turn uses
# Scripts/Restriction/rebase_update.py and Bio/Restriction/RanaConfig.py
#
# The following dictionaries used to be defined in one go, but that does
# not work on Jython due to JVM limitations. Therefore we break this up
# into steps, using temporary functions to avoid the JVM limits.
#
# Used REBASE emboss files version 711 (2017).

rest_dict = {}


def _temp():
    return {
        'charac': (3, -3, None, None, 'TTATAA'),
        'compsite': '(?=(?P<AanI>TTATAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTATAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['AanI'] = _temp()


def _temp():
    return {
        'charac': (11, 8, None, None, 'CACCTGC'),
        'compsite': '(?=(?P<AarI>CACCTGC))|(?=(?P<AarI_as>GCAGGTG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': 8,
        'fst5': 11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACCTGC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['AarI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'GACNNNNNNGTC'),
        'compsite': '(?=(?P<AasI>GAC......GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNNNGTC',
        'size': 12,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['AasI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GACGTC'),
        'compsite': '(?=(?P<AatII>GACGTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'ACGT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACGTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'K', 'M', 'N', 'V'),
    }


rest_dict['AatII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CRRTAAG'),
        'compsite': '(?=(?P<Aba6411II>C[AG][AG]TAAG))|(?=(?P<Aba6411II_as>CTTA[CT][CT]G))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CRRTAAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Aba6411II'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CTATCAV'),
        'compsite': '(?=(?P<AbaCIII>CTATCA[ACG]))|(?=(?P<AbaCIII_as>[CGT]TGATAG))',
        'dna': None,
        'freq': 5461.333333333333,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTATCAV',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AbaCIII'] = _temp()


def _temp():
    return {
        'charac': (12, 9, None, None, 'C'),
        'compsite': '(?=(?P<AbaSI>C))|(?=(?P<AbaSI_as>G))',
        'dna': None,
        'freq': 4.0,
        'fst3': 9,
        'fst5': 12,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'C',
        'size': 1,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['AbaSI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'YCCGSS'),
        'compsite': '(?=(?P<AbaUMB2I>[CT]CCG[CG][CG]))|(?=(?P<AbaUMB2I_as>[CG][CG]CGG[AG]))',
        'dna': None,
        'freq': 512.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YCCGSS',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AbaUMB2I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCTCGAGG'),
        'compsite': '(?=(?P<AbsI>CCTCGAGG))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TCGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTCGAGG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['AbsI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGCGCA'),
        'compsite': '(?=(?P<Acc16I>TGCGCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGCGCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Acc16I'] = _temp()


def _temp():
    return {
        'charac': (10, 8, None, None, 'ACCTGC'),
        'compsite': '(?=(?P<Acc36I>ACCTGC))|(?=(?P<Acc36I_as>GCAGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 8,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCTGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Acc36I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGTACC'),
        'compsite': '(?=(?P<Acc65I>GGTACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTACC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'N', 'V'),
    }


rest_dict['Acc65I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GACGCA'),
        'compsite': '(?=(?P<Acc65V>GACGCA))|(?=(?P<Acc65V_as>TGCGTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACGCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Acc65V'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGYRCC'),
        'compsite': '(?=(?P<AccB1I>GG[CT][AG]CC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GYRC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGYRCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AccB1I'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CCANNNNNTGG'),
        'compsite': '(?=(?P<AccB7I>CCA.....TGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCANNNNNTGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AccB7I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CCGCTC'),
        'compsite': '(?=(?P<AccBSI>CCGCTC))|(?=(?P<AccBSI_as>GAGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AccBSI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GTMKAC'),
        'compsite': '(?=(?P<AccI>GT[AC][GT]AC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'MK',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTMKAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'M', 'N', 'Q', 'R', 'X'),
    }


rest_dict['AccI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCG'),
        'compsite': '(?=(?P<AccII>CGCG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('J', 'K'),
    }


rest_dict['AccII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCCGGA'),
        'compsite': '(?=(?P<AccIII>TCCGGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCGGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'K', 'R'),
    }


rest_dict['AccIII'] = _temp()


def _temp():
    return {
        'charac': (13, 11, None, None, 'CAGCTC'),
        'compsite': '(?=(?P<AceIII>CAGCTC))|(?=(?P<AceIII_as>GAGCTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 11,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AceIII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'AGCCAG'),
        'compsite': '(?=(?P<AchA6III>AGCCAG))|(?=(?P<AchA6III_as>CTGGCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGCCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AchA6III'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCGC'),
        'compsite': '(?=(?P<AciI>CCGC))|(?=(?P<AciI_as>GCGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['AciI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'AACGTT'),
        'compsite': '(?=(?P<AclI>AACGTT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AACGTT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N', 'V'),
    }


rest_dict['AclI'] = _temp()


def _temp():
    return {
        'charac': (9, 5, None, None, 'GGATC'),
        'compsite': '(?=(?P<AclWI>GGATC))|(?=(?P<AclWI_as>GATCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['AclWI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCRGAG'),
        'compsite': '(?=(?P<Aco12261II>CC[AG]GAG))|(?=(?P<Aco12261II_as>CTC[CT]GG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCRGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Aco12261II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'YGGCCR'),
        'compsite': '(?=(?P<AcoI>[CT]GGCC[AG]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YGGCCR',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['AcoI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RAATTY'),
        'compsite': '(?=(?P<AcsI>[AG]AATT[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RAATTY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AcsI'] = _temp()


def _temp():
    return {
        'charac': (22, 14, None, None, 'CTGAAG'),
        'compsite': '(?=(?P<AcuI>CTGAAG))|(?=(?P<AcuI_as>CTTCAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 14,
        'fst5': 22,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTGAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['AcuI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CACGTG'),
        'compsite': '(?=(?P<AcvI>CACGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('Q', 'X'),
    }


rest_dict['AcvI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GRCGYC'),
        'compsite': '(?=(?P<AcyI>G[AG]CG[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRCGYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J',),
    }


rest_dict['AcyI'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'CACNNNGTG'),
        'compsite': '(?=(?P<AdeI>CAC...GTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACNNNGTG',
        'size': 9,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['AdeI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAANCAG'),
        'compsite': '(?=(?P<Adh6U21I>GAA.CAG))|(?=(?P<Adh6U21I_as>CTG.TTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAANCAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Adh6U21I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GTAC'),
        'compsite': '(?=(?P<AfaI>GTAC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTAC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['AfaI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGCGCT'),
        'compsite': '(?=(?P<AfeI>AGCGCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGCGCT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['AfeI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'compsite': '(?=(?P<AfiI>CC.......GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNNNNNNNGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['AfiI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTTAAG'),
        'compsite': '(?=(?P<AflII>CTTAAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TTAA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'K', 'N'),
    }


rest_dict['AflII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACRYGT'),
        'compsite': '(?=(?P<AflIII>AC[AG][CT]GT))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CRYG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACRYGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('M', 'N', 'S'),
    }


rest_dict['AflIII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACCGGT'),
        'compsite': '(?=(?P<AgeI>ACCGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCGGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'N', 'R'),
    }


rest_dict['AgeI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TTSAA'),
        'compsite': '(?=(?P<AgsI>TT[CG]AA))',
        'dna': None,
        'freq': 512.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'S',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTSAA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['AgsI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TTTAAA'),
        'compsite': '(?=(?P<AhaIII>TTTAAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTTAAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AhaIII'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'GACNNNNNGTC'),
        'compsite': '(?=(?P<AhdI>GAC.....GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNNGTC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['AhdI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACTAGT'),
        'compsite': '(?=(?P<AhlI>ACTAGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACTAGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AhlI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCYYGAC'),
        'compsite': '(?=(?P<AhyRBAHI>GC[CT][CT]GAC))|(?=(?P<AhyRBAHI_as>GTC[AG][AG]GC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCYYGAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AhyRBAHI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'YAAMGAG'),
        'compsite': '(?=(?P<AhyYL17I>[CT]AA[AC]GAG))|(?=(?P<AhyYL17I_as>CTC[GT]TT[AG]))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YAAMGAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AhyYL17I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CACGTC'),
        'compsite': '(?=(?P<AjiI>CACGTC))|(?=(?P<AjiI_as>GACGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['AjiI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'CCWGG'),
        'compsite': '(?=(?P<AjnI>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCWGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['AjnI'] = _temp()


def _temp():
    return {
        'charac': (-7, -26, 25, 6, 'GAANNNNNNNTTGG'),
        'compsite': '(?=(?P<AjuI>GAA.......TTGG))|(?=(?P<AjuI_as>CCAA.......TTC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': -26,
        'fst5': -7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 6,
        'scd5': 25,
        'site': 'GAANNNNNNNTTGG',
        'size': 14,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['AjuI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CACNNNNGTG'),
        'compsite': '(?=(?P<AleI>CAC....GTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACNNNNGTG',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['AleI'] = _temp()


def _temp():
    return {
        'charac': (-10, -24, 24, 10, 'GCANNNNNNTGC'),
        'compsite': '(?=(?P<AlfI>GCA......TGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -24,
        'fst5': -10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': 10,
        'scd5': 24,
        'site': 'GCANNNNNNTGC',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AlfI'] = _temp()


def _temp():
    return {
        'charac': (-7, -25, 25, 7, 'GAACNNNNNNTCC'),
        'compsite': '(?=(?P<AloI>GAAC......TCC))|(?=(?P<AloI_as>GGA......GTTC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': -25,
        'fst5': -7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 7,
        'scd5': 25,
        'site': 'GAACNNNNNNTCC',
        'size': 13,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['AloI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'AGCT'),
        'compsite': '(?=(?P<AluBI>AGCT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGCT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['AluBI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'AGCT'),
        'compsite': '(?=(?P<AluI>AGCT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGCT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
    }


rest_dict['AluI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GWGCWC'),
        'compsite': '(?=(?P<Alw21I>G[AT]GC[AT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'WGCW',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GWGCWC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Alw21I'] = _temp()


def _temp():
    return {
        'charac': (6, 5, None, None, 'GTCTC'),
        'compsite': '(?=(?P<Alw26I>GTCTC))|(?=(?P<Alw26I_as>GAGAC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTCTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Alw26I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GTGCAC'),
        'compsite': '(?=(?P<Alw44I>GTGCAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTGCAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J'),
    }


rest_dict['Alw44I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAAAYNNNNNRTG'),
        'compsite': '(?=(?P<AlwFI>GAAA[CT].....[AG]TG))|(?=(?P<AlwFI_as>CA[CT].....[AG]TTTC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAAYNNNNNRTG',
        'size': 13,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AlwFI'] = _temp()


def _temp():
    return {
        'charac': (9, 5, None, None, 'GGATC'),
        'compsite': '(?=(?P<AlwI>GGATC))|(?=(?P<AlwI_as>GATCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['AlwI'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'CAGNNNCTG'),
        'compsite': '(?=(?P<AlwNI>CAG...CTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAGNNNCTG',
        'size': 9,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['AlwNI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CYCGRG'),
        'compsite': '(?=(?P<Ama87I>C[CT]CG[AG]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'YCGR',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYCGRG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Ama87I'] = _temp()


def _temp():
    return {
        'charac': (17, 9, None, None, 'GCTCCA'),
        'compsite': '(?=(?P<AmaCSI>GCTCCA))|(?=(?P<AmaCSI_as>TGGAGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 9,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AmaCSI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCCGGA'),
        'compsite': '(?=(?P<Aor13HI>TCCGGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCGGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['Aor13HI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGCGCT'),
        'compsite': '(?=(?P<Aor51HI>AGCGCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGCGCT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['Aor51HI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GGCC'),
        'compsite': '(?=(?P<AoxI>GGCC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['AoxI'] = _temp()


def _temp():
    return {
        'charac': (8, -8, None, None, 'GCANNNNNTGC'),
        'compsite': '(?=(?P<ApaBI>GCA.....TGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -8,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCANNNNNTGC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['ApaBI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GGGCCC'),
        'compsite': '(?=(?P<ApaI>GGGCCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGCCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['ApaI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GTGCAC'),
        'compsite': '(?=(?P<ApaLI>GTGCAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTGCAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C', 'K', 'N'),
    }


rest_dict['ApaLI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCWGC'),
        'compsite': '(?=(?P<ApeKI>GC[AT]GC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'CWG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCWGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['ApeKI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RAATTY'),
        'compsite': '(?=(?P<ApoI>[AG]AATT[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RAATTY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['ApoI'] = _temp()


def _temp():
    return {
        'charac': (26, 18, None, None, 'ATCGAC'),
        'compsite': '(?=(?P<ApyPI>ATCGAC))|(?=(?P<ApyPI_as>GTCGAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 18,
        'fst5': 26,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATCGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['ApyPI'] = _temp()


def _temp():
    return {
        'charac': (27, 18, None, None, 'GCCGNAC'),
        'compsite': '(?=(?P<AquII>GCCG.AC))|(?=(?P<AquII_as>GT.CGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 18,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCGNAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AquII'] = _temp()


def _temp():
    return {
        'charac': (26, 18, None, None, 'GAGGAG'),
        'compsite': '(?=(?P<AquIII>GAGGAG))|(?=(?P<AquIII_as>CTCCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 18,
        'fst5': 26,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AquIII'] = _temp()


def _temp():
    return {
        'charac': (26, 17, None, None, 'GRGGAAG'),
        'compsite': '(?=(?P<AquIV>G[AG]GGAAG))|(?=(?P<AquIV_as>CTTCC[CT]C))',
        'dna': None,
        'freq': 8192.0,
        'fst3': 17,
        'fst5': 26,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRGGAAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AquIV'] = _temp()


def _temp():
    return {
        'charac': (-8, -26, 24, 6, 'GACNNNNNNTTYG'),
        'compsite': '(?=(?P<ArsI>GAC......TT[CT]G))|(?=(?P<ArsI_as>C[AG]AA......GTC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -26,
        'fst5': -8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 6,
        'scd5': 24,
        'site': 'GACNNNNNNTTYG',
        'size': 13,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['ArsI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCGCGCC'),
        'compsite': '(?=(?P<AscI>GGCGCGCC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCGCC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['AscI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATTAAT'),
        'compsite': '(?=(?P<AseI>ATTAAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATTAAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'N'),
    }


rest_dict['AseI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GATC'),
        'compsite': '(?=(?P<Asi256I>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Asi256I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACCGGT'),
        'compsite': '(?=(?P<AsiGI>ACCGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCGGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AsiGI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GCGATCGC'),
        'compsite': '(?=(?P<AsiSI>GCGATCGC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGATCGC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['AsiSI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'AGCABCC'),
        'compsite': '(?=(?P<Asp114II>AGCA[CGT]CC))|(?=(?P<Asp114II_as>GG[ACG]TGCT))',
        'dna': None,
        'freq': 5461.333333333333,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGCABCC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Asp114II'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GAANNNNTTC'),
        'compsite': '(?=(?P<Asp700I>GAA....TTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAANNNNTTC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('M',),
    }


rest_dict['Asp700I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGTACC'),
        'compsite': '(?=(?P<Asp718I>GGTACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTACC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('M', 'S'),
    }


rest_dict['Asp718I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCTAGG'),
        'compsite': '(?=(?P<AspA2I>CCTAGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTAGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AspA2I'] = _temp()


def _temp():
    return {
        'charac': (13, 12, None, None, 'YSCNS'),
        'compsite': '(?=(?P<AspBHI>[CT][CG]C.[CG]))|(?=(?P<AspBHI_as>[CG].G[CG][AG]))',
        'dna': None,
        'freq': 32.0,
        'fst3': 12,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YSCNS',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AspBHI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GNGCAAC'),
        'compsite': '(?=(?P<AspDUT2V>G.GCAAC))|(?=(?P<AspDUT2V_as>GTTGC.C))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GNGCAAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AspDUT2V'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGCCCAG'),
        'compsite': '(?=(?P<AspJHL3II>CGCCCAG))|(?=(?P<AspJHL3II_as>CTGGGCG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCCCAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AspJHL3II'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCGC'),
        'compsite': '(?=(?P<AspLEI>GCGC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AspLEI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGNCC'),
        'compsite': '(?=(?P<AspS9I>GG.CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AspS9I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGTRAC'),
        'compsite': '(?=(?P<Asu14238IV>CGT[AG]AC))|(?=(?P<Asu14238IV_as>GT[CT]ACG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGTRAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Asu14238IV'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCSGG'),
        'compsite': '(?=(?P<AsuC2I>CC[CG]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'S',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCSGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['AsuC2I'] = _temp()


def _temp():
    return {
        'charac': (13, 7, None, None, 'GGTGA'),
        'compsite': '(?=(?P<AsuHPI>GGTGA))|(?=(?P<AsuHPI_as>TCACC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 7,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTGA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AsuHPI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGNCC'),
        'compsite': '(?=(?P<AsuI>GG.CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AsuI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TTCGAA'),
        'compsite': '(?=(?P<AsuII>TTCGAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTCGAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['AsuII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCTAGC'),
        'compsite': '(?=(?P<AsuNHI>GCTAGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTAGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['AsuNHI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGGRAG'),
        'compsite': '(?=(?P<AteTI>GGG[AG]AG))|(?=(?P<AteTI_as>CT[CT]CCC))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGRAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AteTI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CYCGRG'),
        'compsite': '(?=(?P<AvaI>C[CT]CG[AG]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'YCGR',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYCGRG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'N', 'Q', 'X'),
    }


rest_dict['AvaI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGWCC'),
        'compsite': '(?=(?P<AvaII>GG[AT]CC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGWCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('J', 'N', 'R', 'X'),
    }


rest_dict['AvaII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ATGCAT'),
        'compsite': '(?=(?P<AvaIII>ATGCAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATGCAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['AvaIII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCTAGG'),
        'compsite': '(?=(?P<AvrII>CCTAGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTAGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['AvrII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCCRAG'),
        'compsite': '(?=(?P<Awo1030IV>GCC[AG]AG))|(?=(?P<Awo1030IV_as>CT[CT]GGC))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCRAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Awo1030IV'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'compsite': '(?=(?P<AxyI>CCT.AGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNAGG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('J',),
    }


rest_dict['AxyI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GKGCMC'),
        'compsite': '(?=(?P<BaeGI>G[GT]GC[AC]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'KGCM',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GKGCMC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BaeGI'] = _temp()


def _temp():
    return {
        'charac': (-10, -26, 23, 7, 'ACNNNNGTAYC'),
        'compsite': '(?=(?P<BaeI>AC....GTA[CT]C))|(?=(?P<BaeI_as>G[AG]TAC....GT))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -26,
        'fst5': -10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 7,
        'scd5': 23,
        'site': 'ACNNNNGTAYC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BaeI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCCGAG'),
        'compsite': '(?=(?P<Bag18758I>CCCGAG))|(?=(?P<Bag18758I_as>CTCGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Bag18758I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGGCCA'),
        'compsite': '(?=(?P<BalI>TGGCCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGGCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'Q', 'R', 'X'),
    }


rest_dict['BalI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGATCC'),
        'compsite': '(?=(?P<BamHI>GGATCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
    }


rest_dict['BamHI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGYRCC'),
        'compsite': '(?=(?P<BanI>GG[CT][AG]CC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GYRC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGYRCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N', 'R'),
    }


rest_dict['BanI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GRGCYC'),
        'compsite': '(?=(?P<BanII>G[AG]GC[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'RGCY',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRGCYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K', 'N', 'X'),
    }


rest_dict['BanII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'RTCAGG'),
        'compsite': '(?=(?P<BanLI>[AG]TCAGG))|(?=(?P<BanLI_as>CCTGA[CT]))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RTCAGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BanLI'] = _temp()


def _temp():
    return {
        'charac': (-7, -25, 25, 7, 'GAAGNNNNNNTAC'),
        'compsite': '(?=(?P<BarI>GAAG......TAC))|(?=(?P<BarI_as>GTA......CTTC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': -25,
        'fst5': -7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 7,
        'scd5': 25,
        'site': 'GAAGNNNNNNTAC',
        'size': 13,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BarI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CACGAG'),
        'compsite': '(?=(?P<BauI>CACGAG))|(?=(?P<BauI_as>CTCGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'ACGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BauI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CACGTG'),
        'compsite': '(?=(?P<BbrPI>CACGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('M',),
    }


rest_dict['BbrPI'] = _temp()


def _temp():
    return {
        'charac': (8, 6, None, None, 'GAAGAC'),
        'compsite': '(?=(?P<BbsI>GAAGAC))|(?=(?P<BbsI_as>GTCTTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 6,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BbsI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GWGCWC'),
        'compsite': '(?=(?P<Bbv12I>G[AT]GC[AT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'WGCW',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GWGCWC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bbv12I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCTCAGC'),
        'compsite': '(?=(?P<BbvCI>CCTCAGC))|(?=(?P<BbvCI_as>GCTGAGG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTCAGC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BbvCI'] = _temp()


def _temp():
    return {
        'charac': (13, 12, None, None, 'GCAGC'),
        'compsite': '(?=(?P<BbvI>GCAGC))|(?=(?P<BbvI_as>GCTGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 12,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BbvI'] = _temp()


def _temp():
    return {
        'charac': (8, 6, None, None, 'GAAGAC'),
        'compsite': '(?=(?P<BbvII>GAAGAC))|(?=(?P<BbvII_as>GTCTTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 6,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BbvII'] = _temp()


def _temp():
    return {
        'charac': (9, 5, None, None, 'CCATC'),
        'compsite': '(?=(?P<BccI>CCATC))|(?=(?P<BccI_as>GATGG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCATC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BccI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TAGGAG'),
        'compsite': '(?=(?P<Bce3081I>TAGGAG))|(?=(?P<Bce3081I_as>CTCCTA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TAGGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Bce3081I'] = _temp()


def _temp():
    return {
        'charac': (22, 14, None, None, 'CTTGAG'),
        'compsite': '(?=(?P<Bce83I>CTTGAG))|(?=(?P<Bce83I_as>CTCAAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 14,
        'fst5': 22,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Bce83I'] = _temp()


def _temp():
    return {
        'charac': (17, 14, None, None, 'ACGGC'),
        'compsite': '(?=(?P<BceAI>ACGGC))|(?=(?P<BceAI_as>GCCGT))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 14,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BceAI'] = _temp()


def _temp():
    return {
        'charac': (-7, -10, 14, 11, 'GCAGC'),
        'compsite': '(?=(?P<BceSIV>GCAGC))|(?=(?P<BceSIV_as>GCTGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -10,
        'fst5': -7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': 11,
        'scd5': 14,
        'site': 'GCAGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BceSIV'] = _temp()


def _temp():
    return {
        'charac': (17, 13, None, None, 'ACGGC'),
        'compsite': '(?=(?P<BcefI>ACGGC))|(?=(?P<BcefI_as>GCCGT))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 13,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BcefI'] = _temp()


def _temp():
    return {
        'charac': (-10, -24, 24, 10, 'CGANNNNNNTGC'),
        'compsite': '(?=(?P<BcgI>CGA......TGC))|(?=(?P<BcgI_as>GCA......TCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -24,
        'fst5': -10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': 10,
        'scd5': 24,
        'site': 'CGANNNNNNTGC',
        'size': 12,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BcgI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCWGG'),
        'compsite': '(?=(?P<BciT130I>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'W',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['BciT130I'] = _temp()


def _temp():
    return {
        'charac': (12, 5, None, None, 'GTATCC'),
        'compsite': '(?=(?P<BciVI>GTATCC))|(?=(?P<BciVI_as>GGATAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 5,
        'fst5': 12,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTATCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BciVI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TGATCA'),
        'compsite': '(?=(?P<BclI>TGATCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGATCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'J', 'M', 'N', 'O', 'R', 'S'),
    }


rest_dict['BclI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCSGG'),
        'compsite': '(?=(?P<BcnI>CC[CG]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'S',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCSGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['BcnI'] = _temp()


def _temp():
    return {
        'charac': (6, 5, None, None, 'GTCTC'),
        'compsite': '(?=(?P<BcoDI>GTCTC))|(?=(?P<BcoDI_as>GAGAC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTCTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BcoDI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACTAGT'),
        'compsite': '(?=(?P<BcuI>ACTAGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACTAGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BcuI'] = _temp()


def _temp():
    return {
        'charac': (-10, -24, 24, 10, 'TGANNNNNNTCA'),
        'compsite': '(?=(?P<BdaI>TGA......TCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -24,
        'fst5': -10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': 10,
        'scd5': 24,
        'site': 'TGANNNNNNTCA',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BdaI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'WCCGGW'),
        'compsite': '(?=(?P<BetI>[AT]CCGG[AT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'WCCGGW',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BetI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTAG'),
        'compsite': '(?=(?P<BfaI>CTAG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTAG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BfaI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GANGGAG'),
        'compsite': '(?=(?P<BfaSII>GA.GGAG))|(?=(?P<BfaSII_as>CTCC.TC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GANGGAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BfaSII'] = _temp()


def _temp():
    return {
        'charac': (11, 4, None, None, 'ACTGGG'),
        'compsite': '(?=(?P<BfiI>ACTGGG))|(?=(?P<BfiI_as>CCCAGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 4,
        'fst5': 11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACTGGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BfiI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTRYAG'),
        'compsite': '(?=(?P<BfmI>CT[AG][CT]AG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TRYA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTRYAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BfmI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'RGCGCY'),
        'compsite': '(?=(?P<BfoI>[AG]GCGC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'GCGC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGCGCY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BfoI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTTAAG'),
        'compsite': '(?=(?P<BfrI>CTTAAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TTAA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('M', 'S'),
    }


rest_dict['BfrI'] = _temp()


def _temp():
    return {
        'charac': (10, 8, None, None, 'ACCTGC'),
        'compsite': '(?=(?P<BfuAI>ACCTGC))|(?=(?P<BfuAI_as>GCAGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 8,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCTGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BfuAI'] = _temp()


def _temp():
    return {
        'charac': (12, 5, None, None, 'GTATCC'),
        'compsite': '(?=(?P<BfuI>GTATCC))|(?=(?P<BfuI_as>GGATAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 5,
        'fst5': 12,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTATCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BfuI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'GCCNNNNNGGC'),
        'compsite': '(?=(?P<BglI>GCC.....GGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCNNNNNGGC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'N', 'O', 'Q', 'R', 'V', 'X'),
    }


rest_dict['BglI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'AGATCT'),
        'compsite': '(?=(?P<BglII>AGATCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGATCT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['BglII'] = _temp()


def _temp():
    return {
        'charac': (9, 5, None, None, 'GGATC'),
        'compsite': '(?=(?P<BinI>GGATC))|(?=(?P<BinI_as>GATCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BinI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCNGC'),
        'compsite': '(?=(?P<BisI>GC.GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BisI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GRAGCAG'),
        'compsite': '(?=(?P<Ble402II>G[AG]AGCAG))|(?=(?P<Ble402II_as>CTGCT[CT]C))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRAGCAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Ble402II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCTAGG'),
        'compsite': '(?=(?P<BlnI>CCTAGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTAGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K', 'M', 'S'),
    }


rest_dict['BlnI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAGGAC'),
        'compsite': '(?=(?P<BloAII>GAGGAC))|(?=(?P<BloAII_as>GTCCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BloAII'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCTNAGC'),
        'compsite': '(?=(?P<BlpI>GCT.AGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTNAGC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BlpI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCNGC'),
        'compsite': '(?=(?P<BlsI>GC.GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BlsI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGTACT'),
        'compsite': '(?=(?P<BmcAI>AGTACT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGTACT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BmcAI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCNGG'),
        'compsite': '(?=(?P<Bme1390I>CC.GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Bme1390I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGWCC'),
        'compsite': '(?=(?P<Bme18I>GG[AT]CC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGWCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bme18I'] = _temp()


def _temp():
    return {
        'charac': (3, 0, None, None, 'C'),
        'compsite': '(?=(?P<BmeDI>C))|(?=(?P<BmeDI_as>G))',
        'dna': None,
        'freq': 4.0,
        'fst3': 0,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'C',
        'size': 1,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BmeDI'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'GACNNNNNGTC'),
        'compsite': '(?=(?P<BmeRI>GAC.....GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNNGTC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BmeRI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CYCGRG'),
        'compsite': '(?=(?P<BmeT110I>C[CT]CG[AG]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'YCGR',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYCGRG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['BmeT110I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CACGTC'),
        'compsite': '(?=(?P<BmgBI>CACGTC))|(?=(?P<BmgBI_as>GACGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BmgBI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GKGCCC'),
        'compsite': '(?=(?P<BmgI>G[GT]GCCC))|(?=(?P<BmgI_as>GGGC[AC]C))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GKGCCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BmgI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGNCC'),
        'compsite': '(?=(?P<BmgT120I>GG.CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['BmgT120I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GGNNCC'),
        'compsite': '(?=(?P<BmiI>GG..CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNNCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BmiI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCNGG'),
        'compsite': '(?=(?P<BmrFI>CC.GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BmrFI'] = _temp()


def _temp():
    return {
        'charac': (11, 4, None, None, 'ACTGGG'),
        'compsite': '(?=(?P<BmrI>ACTGGG))|(?=(?P<BmrI_as>CCCAGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 4,
        'fst5': 11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACTGGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BmrI'] = _temp()


def _temp():
    return {
        'charac': (10, 9, None, None, 'GCATC'),
        'compsite': '(?=(?P<BmsI>GCATC))|(?=(?P<BmsI_as>GATGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 9,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCATC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BmsI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GCTAGC'),
        'compsite': '(?=(?P<BmtI>GCTAGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTAGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N', 'V'),
    }


rest_dict['BmtI'] = _temp()


def _temp():
    return {
        'charac': (11, 4, None, None, 'ACTGGG'),
        'compsite': '(?=(?P<BmuI>ACTGGG))|(?=(?P<BmuI_as>CCCAGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 4,
        'fst5': 11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACTGGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BmuI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GACNNNNGTC'),
        'compsite': '(?=(?P<BoxI>GAC....GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNGTC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BoxI'] = _temp()


def _temp():
    return {
        'charac': (8, 6, None, None, 'GAAGAC'),
        'compsite': '(?=(?P<BpiI>GAAGAC))|(?=(?P<BpiI_as>GTCTTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 6,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BpiI'] = _temp()


def _temp():
    return {
        'charac': (-8, -24, 24, 8, 'GAGNNNNNCTC'),
        'compsite': '(?=(?P<BplI>GAG.....CTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -24,
        'fst5': -8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 8,
        'scd5': 24,
        'site': 'GAGNNNNNCTC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BplI'] = _temp()


def _temp():
    return {
        'charac': (22, 14, None, None, 'CTGGAG'),
        'compsite': '(?=(?P<BpmI>CTGGAG))|(?=(?P<BpmI_as>CTCCAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 14,
        'fst5': 22,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTGGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['BpmI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCTNAGC'),
        'compsite': '(?=(?P<Bpu10I>CCT.AGC))|(?=(?P<Bpu10I_as>GCT.AGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNAGC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'N', 'V'),
    }


rest_dict['Bpu10I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCTNAGC'),
        'compsite': '(?=(?P<Bpu1102I>GCT.AGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTNAGC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['Bpu1102I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TTCGAA'),
        'compsite': '(?=(?P<Bpu14I>TTCGAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTCGAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bpu14I'] = _temp()


def _temp():
    return {
        'charac': (22, 14, None, None, 'CTTGAG'),
        'compsite': '(?=(?P<BpuEI>CTTGAG))|(?=(?P<BpuEI_as>CTCAAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 14,
        'fst5': 22,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BpuEI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCSGG'),
        'compsite': '(?=(?P<BpuMI>CC[CG]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'S',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCSGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BpuMI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATCGAT'),
        'compsite': '(?=(?P<Bsa29I>ATCGAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATCGAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Bsa29I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'YACGTR'),
        'compsite': '(?=(?P<BsaAI>[CT]ACGT[AG]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YACGTR',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsaAI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GATNNNNATC'),
        'compsite': '(?=(?P<BsaBI>GAT....ATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATNNNNATC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsaBI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GRCGYC'),
        'compsite': '(?=(?P<BsaHI>G[AG]CG[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRCGYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsaHI'] = _temp()


def _temp():
    return {
        'charac': (7, 5, None, None, 'GGTCTC'),
        'compsite': '(?=(?P<BsaI>GGTCTC))|(?=(?P<BsaI_as>GAGACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 5,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsaI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCNNGG'),
        'compsite': '(?=(?P<BsaJI>CC..GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CNNG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNNGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsaJI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'WCCGGW'),
        'compsite': '(?=(?P<BsaWI>[AT]CCGG[AT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'WCCGGW',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsaWI'] = _temp()


def _temp():
    return {
        'charac': (-9, -23, 21, 7, 'ACNNNNNCTCC'),
        'compsite': '(?=(?P<BsaXI>AC.....CTCC))|(?=(?P<BsaXI_as>GGAG.....GT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -23,
        'fst5': -9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': 7,
        'scd5': 21,
        'site': 'ACNNNNNCTCC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsaXI'] = _temp()


def _temp():
    return {
        'charac': (27, 19, None, None, 'CAACAC'),
        'compsite': '(?=(?P<BsbI>CAACAC))|(?=(?P<BsbI_as>GTGTTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 19,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAACAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BsbI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'compsite': '(?=(?P<Bsc4I>CC.......GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNNNNNNNGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Bsc4I'] = _temp()


def _temp():
    return {
        'charac': (9, 6, None, None, 'GCATC'),
        'compsite': '(?=(?P<BscAI>GCATC))|(?=(?P<BscAI_as>GATGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 6,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCATC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BscAI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCCGT'),
        'compsite': '(?=(?P<BscGI>CCCGT))|(?=(?P<BscGI_as>ACGGG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCGT',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BscGI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RCCGGY'),
        'compsite': '(?=(?P<Bse118I>[AG]CCGG[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RCCGGY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bse118I'] = _temp()


def _temp():
    return {
        'charac': (6, -1, None, None, 'ACTGG'),
        'compsite': '(?=(?P<Bse1I>ACTGG))|(?=(?P<Bse1I_as>CCAGT))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'GN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACTGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bse1I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'compsite': '(?=(?P<Bse21I>CCT.AGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNAGG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bse21I'] = _temp()


def _temp():
    return {
        'charac': (8, 0, None, None, 'GCAATG'),
        'compsite': '(?=(?P<Bse3DI>GCAATG))|(?=(?P<Bse3DI_as>CATTGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 0,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAATG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bse3DI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GATNNNNATC'),
        'compsite': '(?=(?P<Bse8I>GAT....ATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATNNNNATC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bse8I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCCGGA'),
        'compsite': '(?=(?P<BseAI>TCCGGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCGGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['BseAI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCWGG'),
        'compsite': '(?=(?P<BseBI>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'W',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['BseBI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATCGAT'),
        'compsite': '(?=(?P<BseCI>ATCGAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATCGAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['BseCI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCNNGG'),
        'compsite': '(?=(?P<BseDI>CC..GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CNNG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNNGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BseDI'] = _temp()


def _temp():
    return {
        'charac': (7, 0, None, None, 'GGATG'),
        'compsite': '(?=(?P<BseGI>GGATG))|(?=(?P<BseGI_as>CATCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 0,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BseGI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GATNNNNATC'),
        'compsite': '(?=(?P<BseJI>GAT....ATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATNNNNATC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BseJI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'compsite': '(?=(?P<BseLI>CC.......GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNNNNNNNGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BseLI'] = _temp()


def _temp():
    return {
        'charac': (8, 0, None, None, 'GCAATG'),
        'compsite': '(?=(?P<BseMI>GCAATG))|(?=(?P<BseMI_as>CATTGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 0,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAATG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BseMI'] = _temp()


def _temp():
    return {
        'charac': (15, 8, None, None, 'CTCAG'),
        'compsite': '(?=(?P<BseMII>CTCAG))|(?=(?P<BseMII_as>CTGAG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 8,
        'fst5': 15,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCAG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BseMII'] = _temp()


def _temp():
    return {
        'charac': (6, -1, None, None, 'ACTGG'),
        'compsite': '(?=(?P<BseNI>ACTGG))|(?=(?P<BseNI_as>CCAGT))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'GN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACTGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BseNI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCGCGC'),
        'compsite': '(?=(?P<BsePI>GCGCGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGCGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BsePI'] = _temp()


def _temp():
    return {
        'charac': (16, 8, None, None, 'GAGGAG'),
        'compsite': '(?=(?P<BseRI>GAGGAG))|(?=(?P<BseRI_as>CTCCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 8,
        'fst5': 16,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BseRI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GKGCMC'),
        'compsite': '(?=(?P<BseSI>G[GT]GC[AC]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'KGCM',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GKGCMC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BseSI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGGCCG'),
        'compsite': '(?=(?P<BseX3I>CGGCCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGCCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BseX3I'] = _temp()


def _temp():
    return {
        'charac': (13, 12, None, None, 'GCAGC'),
        'compsite': '(?=(?P<BseXI>GCAGC))|(?=(?P<BseXI_as>GCTGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 12,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BseXI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCCAGC'),
        'compsite': '(?=(?P<BseYI>CCCAGC))|(?=(?P<BseYI_as>GCTGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCAGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BseYI'] = _temp()


def _temp():
    return {
        'charac': (22, 14, None, None, 'GTGCAG'),
        'compsite': '(?=(?P<BsgI>GTGCAG))|(?=(?P<BsgI_as>CTGCAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 14,
        'fst5': 22,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTGCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsgI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCG'),
        'compsite': '(?=(?P<Bsh1236I>CGCG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Bsh1236I'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CGRYCG'),
        'compsite': '(?=(?P<Bsh1285I>CG[AG][CT]CG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'RY',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGRYCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Bsh1285I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCC'),
        'compsite': '(?=(?P<BshFI>GGCC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['BshFI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGYRCC'),
        'compsite': '(?=(?P<BshNI>GG[CT][AG]CC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GYRC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGYRCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BshNI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACCGGT'),
        'compsite': '(?=(?P<BshTI>ACCGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCGGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BshTI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATCGAT'),
        'compsite': '(?=(?P<BshVI>ATCGAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATCGAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BshVI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CGRYCG'),
        'compsite': '(?=(?P<BsiEI>CG[AG][CT]CG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'RY',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGRYCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsiEI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GWGCWC'),
        'compsite': '(?=(?P<BsiHKAI>G[AT]GC[AT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'WGCW',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GWGCWC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsiHKAI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CYCGRG'),
        'compsite': '(?=(?P<BsiHKCI>C[CT]CG[AG]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'YCGR',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYCGRG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('Q', 'X'),
    }


rest_dict['BsiHKCI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CACGAG'),
        'compsite': '(?=(?P<BsiI>CACGAG))|(?=(?P<BsiI_as>CTCGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'ACGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BsiI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCGG'),
        'compsite': '(?=(?P<BsiSI>CCGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('C', 'Y'),
    }


rest_dict['BsiSI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGTACG'),
        'compsite': '(?=(?P<BsiWI>CGTACG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGTACG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsiWI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'compsite': '(?=(?P<BsiYI>CC.......GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNNNNNNNGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BsiYI'] = _temp()


def _temp():
    return {
        'charac': (15, 14, None, None, 'GGGAC'),
        'compsite': '(?=(?P<BslFI>GGGAC))|(?=(?P<BslFI_as>GTCCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 14,
        'fst5': 15,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BslFI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'compsite': '(?=(?P<BslI>CC.......GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNNNNNNNGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BslI'] = _temp()


def _temp():
    return {
        'charac': (6, 5, None, None, 'GTCTC'),
        'compsite': '(?=(?P<BsmAI>GTCTC))|(?=(?P<BsmAI_as>GAGAC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTCTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsmAI'] = _temp()


def _temp():
    return {
        'charac': (7, 5, None, None, 'CGTCTC'),
        'compsite': '(?=(?P<BsmBI>CGTCTC))|(?=(?P<BsmBI_as>GAGACG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 5,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGTCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsmBI'] = _temp()


def _temp():
    return {
        'charac': (15, 14, None, None, 'GGGAC'),
        'compsite': '(?=(?P<BsmFI>GGGAC))|(?=(?P<BsmFI_as>GTCCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 14,
        'fst5': 15,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsmFI'] = _temp()


def _temp():
    return {
        'charac': (7, -1, None, None, 'GAATGC'),
        'compsite': '(?=(?P<BsmI>GAATGC))|(?=(?P<BsmI_as>GCATTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'CN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAATGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'M', 'N', 'S'),
    }


rest_dict['BsmI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCC'),
        'compsite': '(?=(?P<BsnI>GGCC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BsnI'] = _temp()


def _temp():
    return {
        'charac': (7, 5, None, None, 'GGTCTC'),
        'compsite': '(?=(?P<Bso31I>GGTCTC))|(?=(?P<Bso31I_as>GAGACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 5,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bso31I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CYCGRG'),
        'compsite': '(?=(?P<BsoBI>C[CT]CG[AG]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'YCGR',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYCGRG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsoBI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TTCGAA'),
        'compsite': '(?=(?P<Bsp119I>TTCGAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTCGAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Bsp119I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGGCCC'),
        'compsite': '(?=(?P<Bsp120I>GGGCCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGCCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Bsp120I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GDGCHC'),
        'compsite': '(?=(?P<Bsp1286I>G[AGT]GC[ACT]C))',
        'dna': None,
        'freq': 455.1111111111111,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'DGCH',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GDGCHC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'K', 'N'),
    }


rest_dict['Bsp1286I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCCGGA'),
        'compsite': '(?=(?P<Bsp13I>TCCGGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCGGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bsp13I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TGTACA'),
        'compsite': '(?=(?P<Bsp1407I>TGTACA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGTACA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['Bsp1407I'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GATC'),
        'compsite': '(?=(?P<Bsp143I>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Bsp143I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCTNAGC'),
        'compsite': '(?=(?P<Bsp1720I>GCT.AGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTNAGC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bsp1720I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCATGG'),
        'compsite': '(?=(?P<Bsp19I>CCATGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCATGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bsp19I'] = _temp()


def _temp():
    return {
        'charac': (-8, -25, 24, 7, 'GACNNNNNNTGG'),
        'compsite': '(?=(?P<Bsp24I>GAC......TGG))|(?=(?P<Bsp24I_as>CCA......GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -25,
        'fst5': -8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 7,
        'scd5': 24,
        'site': 'GACNNNNNNTGG',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Bsp24I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCGCAT'),
        'compsite': '(?=(?P<Bsp3004IV>CCGCAT))|(?=(?P<Bsp3004IV_as>ATGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Bsp3004IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGCGCAG'),
        'compsite': '(?=(?P<Bsp460III>CGCGCAG))|(?=(?P<Bsp460III_as>CTGCGCG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCGCAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Bsp460III'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TCGCGA'),
        'compsite': '(?=(?P<Bsp68I>TCGCGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCGCGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Bsp68I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCGC'),
        'compsite': '(?=(?P<BspACI>CCGC))|(?=(?P<BspACI_as>GCGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BspACI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCC'),
        'compsite': '(?=(?P<BspANI>GGCC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('X',),
    }


rest_dict['BspANI'] = _temp()


def _temp():
    return {
        'charac': (14, 7, None, None, 'CTCAG'),
        'compsite': '(?=(?P<BspCNI>CTCAG))|(?=(?P<BspCNI_as>CTGAG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 7,
        'fst5': 14,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCAG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BspCNI'] = _temp()


def _temp():
    return {
        'charac': (9, 6, None, None, 'GACTC'),
        'compsite': '(?=(?P<BspD6I>GACTC))|(?=(?P<BspD6I_as>GAGTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 6,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BspD6I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATCGAT'),
        'compsite': '(?=(?P<BspDI>ATCGAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATCGAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BspDI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCCGGA'),
        'compsite': '(?=(?P<BspEI>TCCGGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCGGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BspEI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCG'),
        'compsite': '(?=(?P<BspFNI>CGCG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BspFNI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CTGGAC'),
        'compsite': '(?=(?P<BspGI>CTGGAC))|(?=(?P<BspGI_as>GTCCAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTGGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BspGI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCATGA'),
        'compsite': '(?=(?P<BspHI>TCATGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCATGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BspHI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GGNNCC'),
        'compsite': '(?=(?P<BspLI>GG..CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNNCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BspLI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACATGT'),
        'compsite': '(?=(?P<BspLU11I>ACATGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACATGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BspLU11I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CTGCAG'),
        'compsite': '(?=(?P<BspMAI>CTGCAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTGCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('X',),
    }


rest_dict['BspMAI'] = _temp()


def _temp():
    return {
        'charac': (10, 8, None, None, 'ACCTGC'),
        'compsite': '(?=(?P<BspMI>ACCTGC))|(?=(?P<BspMI_as>GCAGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 8,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCTGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BspMI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCCGGA'),
        'compsite': '(?=(?P<BspMII>TCCGGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCGGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BspMII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCAGA'),
        'compsite': '(?=(?P<BspNCI>CCAGA))|(?=(?P<BspNCI_as>TCTGG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCAGA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BspNCI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GCTAGC'),
        'compsite': '(?=(?P<BspOI>GCTAGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTAGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BspOI'] = _temp()


def _temp():
    return {
        'charac': (9, 5, None, None, 'GGATC'),
        'compsite': '(?=(?P<BspPI>GGATC))|(?=(?P<BspPI_as>GATCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BspPI'] = _temp()


def _temp():
    return {
        'charac': (8, 4, None, None, 'GCTCTTC'),
        'compsite': '(?=(?P<BspQI>GCTCTTC))|(?=(?P<BspQI_as>GAAGAGC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': 4,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTCTTC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BspQI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TTCGAA'),
        'compsite': '(?=(?P<BspT104I>TTCGAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTCGAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['BspT104I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGYRCC'),
        'compsite': '(?=(?P<BspT107I>GG[CT][AG]CC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GYRC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGYRCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['BspT107I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTTAAG'),
        'compsite': '(?=(?P<BspTI>CTTAAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TTAA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BspTI'] = _temp()


def _temp():
    return {
        'charac': (7, 5, None, None, 'GGTCTC'),
        'compsite': '(?=(?P<BspTNI>GGTCTC))|(?=(?P<BspTNI_as>GAGACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 5,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('X',),
    }


rest_dict['BspTNI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CCGCTC'),
        'compsite': '(?=(?P<BsrBI>CCGCTC))|(?=(?P<BsrBI_as>GAGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsrBI'] = _temp()


def _temp():
    return {
        'charac': (8, 0, None, None, 'GCAATG'),
        'compsite': '(?=(?P<BsrDI>GCAATG))|(?=(?P<BsrDI_as>CATTGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 0,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAATG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsrDI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RCCGGY'),
        'compsite': '(?=(?P<BsrFI>[AG]CCGG[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RCCGGY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsrFI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TGTACA'),
        'compsite': '(?=(?P<BsrGI>TGTACA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGTACA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsrGI'] = _temp()


def _temp():
    return {
        'charac': (6, -1, None, None, 'ACTGG'),
        'compsite': '(?=(?P<BsrI>ACTGG))|(?=(?P<BsrI_as>CCAGT))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'GN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACTGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BsrI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RCCGGY'),
        'compsite': '(?=(?P<BssAI>[AG]CCGG[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RCCGGY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['BssAI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCNNGG'),
        'compsite': '(?=(?P<BssECI>CC..GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CNNG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNNGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BssECI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCGCGC'),
        'compsite': '(?=(?P<BssHII>GCGCGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGCGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'K', 'M', 'N', 'Q', 'R', 'X'),
    }


rest_dict['BssHII'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GATC'),
        'compsite': '(?=(?P<BssMI>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BssMI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTATAC'),
        'compsite': '(?=(?P<BssNAI>GTATAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTATAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BssNAI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GRCGYC'),
        'compsite': '(?=(?P<BssNI>G[AG]CG[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRCGYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BssNI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CACGAG'),
        'compsite': '(?=(?P<BssSI>CACGAG))|(?=(?P<BssSI_as>CTCGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'ACGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BssSI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCWWGG'),
        'compsite': '(?=(?P<BssT1I>CC[AT][AT]GG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CWWG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWWGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BssT1I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTATAC'),
        'compsite': '(?=(?P<Bst1107I>GTATAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTATAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['Bst1107I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CACGAG'),
        'compsite': '(?=(?P<Bst2BI>CACGAG))|(?=(?P<Bst2BI_as>CTCGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'ACGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Bst2BI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCWGG'),
        'compsite': '(?=(?P<Bst2UI>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'W',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bst2UI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'ACNGT'),
        'compsite': '(?=(?P<Bst4CI>AC.GT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACNGT',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bst4CI'] = _temp()


def _temp():
    return {
        'charac': (7, 4, None, None, 'CTCTTC'),
        'compsite': '(?=(?P<Bst6I>CTCTTC))|(?=(?P<Bst6I_as>GAAGAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 4,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCTTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Bst6I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GRCGYC'),
        'compsite': '(?=(?P<BstACI>G[AG]CG[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRCGYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BstACI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTTAAG'),
        'compsite': '(?=(?P<BstAFI>CTTAAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TTAA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BstAFI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'GCANNNNNTGC'),
        'compsite': '(?=(?P<BstAPI>GCA.....TGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCANNNNNTGC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['BstAPI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TGTACA'),
        'compsite': '(?=(?P<BstAUI>TGTACA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGTACA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstAUI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'YACGTR'),
        'compsite': '(?=(?P<BstBAI>[CT]ACGT[AG]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YACGTR',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstBAI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TTCGAA'),
        'compsite': '(?=(?P<BstBI>TTCGAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTCGAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BstBI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCNNGC'),
        'compsite': '(?=(?P<BstC8I>GC..GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNNGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BstC8I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTNAG'),
        'compsite': '(?=(?P<BstDEI>CT.AG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTNAG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstDEI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCRYGG'),
        'compsite': '(?=(?P<BstDSI>CC[AG][CT]GG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CRYG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCRYGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstDSI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGTNACC'),
        'compsite': '(?=(?P<BstEII>GGT.ACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GTNAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTNACC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('C', 'J', 'N', 'R'),
    }


rest_dict['BstEII'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CCTNNNNNAGG'),
        'compsite': '(?=(?P<BstENI>CCT.....AGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNNNNNAGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstENI'] = _temp()


def _temp():
    return {
        'charac': (7, 0, None, None, 'GGATG'),
        'compsite': '(?=(?P<BstF5I>GGATG))|(?=(?P<BstF5I_as>CATCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 0,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstF5I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCG'),
        'compsite': '(?=(?P<BstFNI>CGCG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstFNI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'RGCGCY'),
        'compsite': '(?=(?P<BstH2I>[AG]GCGC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'GCGC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGCGCY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstH2I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCGC'),
        'compsite': '(?=(?P<BstHHI>GCGC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstHHI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GATC'),
        'compsite': '(?=(?P<BstKTI>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BstKTI'] = _temp()


def _temp():
    return {
        'charac': (6, 5, None, None, 'GTCTC'),
        'compsite': '(?=(?P<BstMAI>GTCTC))|(?=(?P<BstMAI_as>GAGAC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTCTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstMAI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GATC'),
        'compsite': '(?=(?P<BstMBI>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstMBI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CGRYCG'),
        'compsite': '(?=(?P<BstMCI>CG[AG][CT]CG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'RY',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGRYCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstMCI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'GCNNNNNNNGC'),
        'compsite': '(?=(?P<BstMWI>GC.......GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNNNNNNNGC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BstMWI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCWGG'),
        'compsite': '(?=(?P<BstNI>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'W',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BstNI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'RCATGY'),
        'compsite': '(?=(?P<BstNSI>[AG]CATG[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RCATGY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstNSI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GACNNNNGTC'),
        'compsite': '(?=(?P<BstPAI>GAC....GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNGTC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstPAI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGTNACC'),
        'compsite': '(?=(?P<BstPI>GGT.ACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GTNAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTNACC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['BstPI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'CCNGG'),
        'compsite': '(?=(?P<BstSCI>CC.GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCNGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BstSCI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTRYAG'),
        'compsite': '(?=(?P<BstSFI>CT[AG][CT]AG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TRYA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTRYAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BstSFI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GKGCMC'),
        'compsite': '(?=(?P<BstSLI>G[GT]GC[AC]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'KGCM',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GKGCMC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BstSLI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TACGTA'),
        'compsite': '(?=(?P<BstSNI>TACGTA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TACGTA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstSNI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCG'),
        'compsite': '(?=(?P<BstUI>CGCG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BstUI'] = _temp()


def _temp():
    return {
        'charac': (13, 12, None, None, 'GCAGC'),
        'compsite': '(?=(?P<BstV1I>GCAGC))|(?=(?P<BstV1I_as>GCTGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 12,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BstV1I'] = _temp()


def _temp():
    return {
        'charac': (8, 6, None, None, 'GAAGAC'),
        'compsite': '(?=(?P<BstV2I>GAAGAC))|(?=(?P<BstV2I_as>GTCTTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 6,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstV2I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RGATCY'),
        'compsite': '(?=(?P<BstX2I>[AG]GATC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGATCY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['BstX2I'] = _temp()


def _temp():
    return {
        'charac': (8, -8, None, None, 'CCANNNNNNTGG'),
        'compsite': '(?=(?P<BstXI>CCA......TGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -8,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCANNNNNNTGG',
        'size': 12,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'V', 'X', 'Y'),
    }


rest_dict['BstXI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RGATCY'),
        'compsite': '(?=(?P<BstYI>[AG]GATC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGATCY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BstYI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTATAC'),
        'compsite': '(?=(?P<BstZ17I>GTATAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTATAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BstZ17I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGGCCG'),
        'compsite': '(?=(?P<BstZI>CGGCCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGCCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('R',),
    }


rest_dict['BstZI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATCGAT'),
        'compsite': '(?=(?P<Bsu15I>ATCGAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATCGAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Bsu15I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'compsite': '(?=(?P<Bsu36I>CCT.AGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNAGG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['Bsu36I'] = _temp()


def _temp():
    return {
        'charac': (12, 5, None, None, 'GTATCC'),
        'compsite': '(?=(?P<BsuI>GTATCC))|(?=(?P<BsuI_as>GGATAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 5,
        'fst5': 12,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTATCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BsuI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCC'),
        'compsite': '(?=(?P<BsuRI>GGCC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'I'),
    }


rest_dict['BsuRI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATCGAT'),
        'compsite': '(?=(?P<BsuTUI>ATCGAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATCGAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('X',),
    }


rest_dict['BsuTUI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCRYGG'),
        'compsite': '(?=(?P<BtgI>CC[AG][CT]GG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CRYG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCRYGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BtgI'] = _temp()


def _temp():
    return {
        'charac': (16, 14, None, None, 'GCGATG'),
        'compsite': '(?=(?P<BtgZI>GCGATG))|(?=(?P<BtgZI_as>CATCGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 14,
        'fst5': 16,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGATG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BtgZI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GCNGC'),
        'compsite': '(?=(?P<BthCI>GC.GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'CNG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['BthCI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CACGTC'),
        'compsite': '(?=(?P<BtrI>CACGTC))|(?=(?P<BtrI_as>GACGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['BtrI'] = _temp()


def _temp():
    return {
        'charac': (7, 0, None, None, 'GGATG'),
        'compsite': '(?=(?P<BtsCI>GGATG))|(?=(?P<BtsCI_as>CATCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 0,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BtsCI'] = _temp()


def _temp():
    return {
        'charac': (8, 0, None, None, 'GCAGTG'),
        'compsite': '(?=(?P<BtsI>GCAGTG))|(?=(?P<BtsI_as>CACTGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 0,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAGTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BtsI'] = _temp()


def _temp():
    return {
        'charac': (7, 0, None, None, 'CAGTG'),
        'compsite': '(?=(?P<BtsIMutI>CAGTG))|(?=(?P<BtsIMutI_as>CACTG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 0,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAGTG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['BtsIMutI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TCGCGA'),
        'compsite': '(?=(?P<BtuMI>TCGCGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCGCGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['BtuMI'] = _temp()


def _temp():
    return {
        'charac': (10, 8, None, None, 'ACCTGC'),
        'compsite': '(?=(?P<BveI>ACCTGC))|(?=(?P<BveI_as>GCAGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 8,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCTGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['BveI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCNNGC'),
        'compsite': '(?=(?P<Cac8I>GC..GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNNGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['Cac8I'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'CAGNNNCTG'),
        'compsite': '(?=(?P<CaiI>CAG...CTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAGNNNCTG',
        'size': 9,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['CaiI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGTTAG'),
        'compsite': '(?=(?P<Cal14237I>GGTTAG))|(?=(?P<Cal14237I_as>CTAACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTTAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cal14237I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GRTTRAG'),
        'compsite': '(?=(?P<CalB3II>G[AG]TT[AG]AG))|(?=(?P<CalB3II_as>CT[CT]AA[CT]C))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRTTRAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CalB3II'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GTTAAT'),
        'compsite': '(?=(?P<Cau10061II>GTTAAT))|(?=(?P<Cau10061II_as>ATTAAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTTAAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cau10061II'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCSGG'),
        'compsite': '(?=(?P<CauII>CC[CG]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'S',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCSGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CauII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'AGGAAT'),
        'compsite': '(?=(?P<Cba13II>AGGAAT))|(?=(?P<Cba13II_as>ATTCCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGGAAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cba13II'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCTNAYNC'),
        'compsite': '(?=(?P<Cba16038I>CCT.A[CT].C))|(?=(?P<Cba16038I_as>G.[AG]T.AGG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNAYNC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cba16038I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCRGAAG'),
        'compsite': '(?=(?P<Cbo67071IV>GC[AG]GAAG))|(?=(?P<Cbo67071IV_as>CTTC[CT]GC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCRGAAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cbo67071IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GNGAAAY'),
        'compsite': '(?=(?P<Cch467III>G.GAAA[CT]))|(?=(?P<Cch467III_as>[AG]TTTC.C))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GNGAAAY',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cch467III'] = _temp()


def _temp():
    return {
        'charac': (17, 9, None, None, 'GGARGA'),
        'compsite': '(?=(?P<CchII>GGA[AG]GA))|(?=(?P<CchII_as>TC[CT]TCC))',
        'dna': None,
        'freq': 2048.0,
        'fst3': 9,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGARGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CchII'] = _temp()


def _temp():
    return {
        'charac': (26, 18, None, None, 'CCCAAG'),
        'compsite': '(?=(?P<CchIII>CCCAAG))|(?=(?P<CchIII_as>CTTGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 18,
        'fst5': 26,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CchIII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCATGA'),
        'compsite': '(?=(?P<CciI>TCATGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCATGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['CciI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCGGCCGC'),
        'compsite': '(?=(?P<CciNI>GCGGCCGC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGGCCGC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['CciNI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGACCAG'),
        'compsite': '(?=(?P<CcrNAIII>CGACCAG))|(?=(?P<CcrNAIII_as>CTGGTCG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGACCAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CcrNAIII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCGCAG'),
        'compsite': '(?=(?P<Cdi11397I>GCGCAG))|(?=(?P<Cdi11397I_as>CTGCGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cdi11397I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCMGAAG'),
        'compsite': '(?=(?P<Cdi81III>GC[AC]GAAG))|(?=(?P<Cdi81III_as>CTTC[GT]GC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCMGAAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cdi81III'] = _temp()


def _temp():
    return {
        'charac': (4, -1, None, None, 'CATCG'),
        'compsite': '(?=(?P<CdiI>CATCG))|(?=(?P<CdiI_as>CGATG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATCG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CdiI'] = _temp()


def _temp():
    return {
        'charac': (26, 18, None, None, 'GCGGAG'),
        'compsite': '(?=(?P<CdpI>GCGGAG))|(?=(?P<CdpI_as>CTCCGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 18,
        'fst5': 26,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CdpI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GTGAAG'),
        'compsite': '(?=(?P<Cdu23823II>GTGAAG))|(?=(?P<Cdu23823II_as>CTTCAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTGAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cdu23823II'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCGC'),
        'compsite': '(?=(?P<CfoI>GCGC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('M', 'R', 'S'),
    }


rest_dict['CfoI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RCCGGY'),
        'compsite': '(?=(?P<Cfr10I>[AG]CCGG[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RCCGGY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['Cfr10I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGNCC'),
        'compsite': '(?=(?P<Cfr13I>GG.CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Cfr13I'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CCGCGG'),
        'compsite': '(?=(?P<Cfr42I>CCGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'GC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Cfr42I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCCGGG'),
        'compsite': '(?=(?P<Cfr9I>CCCGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCGGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Cfr9I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'YGGCCR'),
        'compsite': '(?=(?P<CfrI>[CT]GGCC[AG]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YGGCCR',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CfrI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GARCAG'),
        'compsite': '(?=(?P<Cfupf3II>GA[AG]CAG))|(?=(?P<Cfupf3II_as>CTG[CT]TC))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GARCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cfupf3II'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGCGCA'),
        'compsite': '(?=(?P<Cgl13032I>GGCGCA))|(?=(?P<Cgl13032I_as>TGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cgl13032I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ACGABGG'),
        'compsite': '(?=(?P<Cgl13032II>ACGA[CGT]GG))|(?=(?P<Cgl13032II_as>CC[ACG]TCGT))',
        'dna': None,
        'freq': 5461.333333333333,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGABGG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cgl13032II'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GATC'),
        'compsite': '(?=(?P<ChaI>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['ChaI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCAAGG'),
        'compsite': '(?=(?P<CjeFIII>GCAAGG))|(?=(?P<CjeFIII_as>CCTTGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAAGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjeFIII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGRCA'),
        'compsite': '(?=(?P<CjeFV>GG[AG]CA))|(?=(?P<CjeFV_as>TG[CT]CC))',
        'dna': None,
        'freq': 512.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGRCA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjeFV'] = _temp()


def _temp():
    return {
        'charac': (-8, -25, 26, 9, 'CCANNNNNNGT'),
        'compsite': '(?=(?P<CjeI>CCA......GT))|(?=(?P<CjeI_as>AC......TGG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -25,
        'fst5': -8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 6,
        'ovhgseq': 'NNNNNN',
        'results': None,
        'scd3': 9,
        'scd5': 26,
        'site': 'CCANNNNNNGT',
        'size': 11,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjeI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAGNNNNNGT'),
        'compsite': '(?=(?P<CjeNII>GAG.....GT))|(?=(?P<CjeNII_as>AC.....CTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGNNNNNGT',
        'size': 10,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjeNII'] = _temp()


def _temp():
    return {
        'charac': (25, 17, None, None, 'GKAAYG'),
        'compsite': '(?=(?P<CjeNIII>G[GT]AA[CT]G))|(?=(?P<CjeNIII_as>C[AG]TT[AC]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 17,
        'fst5': 25,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GKAAYG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjeNIII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCYGA'),
        'compsite': '(?=(?P<CjeNV>CC[CT]GA))|(?=(?P<CjeNV_as>TC[AG]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCYGA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjeNV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CACNNNNNNNGAA'),
        'compsite': '(?=(?P<CjeP659IV>CAC.......GAA))|(?=(?P<CjeP659IV_as>TTC.......GTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACNNNNNNNGAA',
        'size': 13,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjeP659IV'] = _temp()


def _temp():
    return {
        'charac': (-7, -25, 26, 8, 'CCANNNNNNNTC'),
        'compsite': '(?=(?P<CjePI>CCA.......TC))|(?=(?P<CjePI_as>GA.......TGG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -25,
        'fst5': -7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 6,
        'ovhgseq': 'NNNNNN',
        'results': None,
        'scd3': 8,
        'scd5': 26,
        'site': 'CCANNNNNNNTC',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjePI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CAYNNNNNRTG'),
        'compsite': '(?=(?P<CjuI>CA[CT].....[AG]TG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAYNNNNNRTG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjuI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CAYNNNNNCTC'),
        'compsite': '(?=(?P<CjuII>CA[CT].....CTC))|(?=(?P<CjuII_as>GAG.....[AG]TG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAYNNNNNCTC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CjuII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCGAA'),
        'compsite': '(?=(?P<Cla11845III>GCGAA))|(?=(?P<Cla11845III_as>TTCGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGAA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cla11845III'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATCGAT'),
        'compsite': '(?=(?P<ClaI>ATCGAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATCGAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K', 'M', 'N', 'Q', 'R', 'S', 'X'),
    }


rest_dict['ClaI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'AAAAGRG'),
        'compsite': '(?=(?P<Cly7489II>AAAAG[AG]G))|(?=(?P<Cly7489II_as>C[CT]CTTTT))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AAAAGRG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cly7489II'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGGAAG'),
        'compsite': '(?=(?P<Cma23826I>CGGAAG))|(?=(?P<Cma23826I_as>CTTCCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Cma23826I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGGWCCG'),
        'compsite': '(?=(?P<CpoI>CGG[AT]CCG))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGWCCG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['CpoI'] = _temp()


def _temp():
    return {
        'charac': (10, 10, None, None, 'GACGC'),
        'compsite': '(?=(?P<CseI>GACGC))|(?=(?P<CseI_as>GCGTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 10,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['CseI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACCWGGT'),
        'compsite': '(?=(?P<CsiI>ACC[AT]GGT))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCWGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCWGGT',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['CsiI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGAGGC'),
        'compsite': '(?=(?P<Csp2014I>GGAGGC))|(?=(?P<Csp2014I_as>GCCTCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGAGGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Csp2014I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GTAC'),
        'compsite': '(?=(?P<Csp6I>GTAC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTAC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Csp6I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACCGGT'),
        'compsite': '(?=(?P<CspAI>ACCGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCGGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['CspAI'] = _temp()


def _temp():
    return {
        'charac': (-11, -25, 24, 10, 'CAANNNNNGTGG'),
        'compsite': '(?=(?P<CspCI>CAA.....GTGG))|(?=(?P<CspCI_as>CCAC.....TTG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': -25,
        'fst5': -11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': 10,
        'scd5': 24,
        'site': 'CAANNNNNGTGG',
        'size': 12,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['CspCI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGGWCCG'),
        'compsite': '(?=(?P<CspI>CGG[AT]CCG))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGWCCG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('R',),
    }


rest_dict['CspI'] = _temp()


def _temp():
    return {
        'charac': (26, 18, None, None, 'AAGGAG'),
        'compsite': '(?=(?P<CstMI>AAGGAG))|(?=(?P<CstMI_as>CTCCTT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 18,
        'fst5': 26,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AAGGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CstMI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CATG'),
        'compsite': '(?=(?P<CviAII>CATG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['CviAII'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'RGCY'),
        'compsite': '(?=(?P<CviJI>[AG]GC[CT]))',
        'dna': None,
        'freq': 64.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGCY',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('Q', 'X'),
    }


rest_dict['CviJI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'RGCY'),
        'compsite': '(?=(?P<CviKI_1>[AG]GC[CT]))',
        'dna': None,
        'freq': 64.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGCY',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['CviKI_1'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GTAC'),
        'compsite': '(?=(?P<CviQI>GTAC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTAC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['CviQI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TGCA'),
        'compsite': '(?=(?P<CviRI>TGCA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGCA',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['CviRI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCWGG'),
        'compsite': '(?=(?P<Dde51507I>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Dde51507I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTNAG'),
        'compsite': '(?=(?P<DdeI>CT.AG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTNAG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['DdeI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GGCGCC'),
        'compsite': '(?=(?P<DinI>GGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['DinI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GATC'),
        'compsite': '(?=(?P<DpnI>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'E', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['DpnI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GATC'),
        'compsite': '(?=(?P<DpnII>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['DpnII'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TTTAAA'),
        'compsite': '(?=(?P<DraI>TTTAAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTTAAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['DraI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'RGGNCCY'),
        'compsite': '(?=(?P<DraII>[AG]GG.CC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGGNCCY',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['DraII'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'CACNNNGTG'),
        'compsite': '(?=(?P<DraIII>CAC...GTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACNNNGTG',
        'size': 9,
        'substrat': 'DNA',
        'suppl': ('I', 'M', 'N', 'V'),
    }


rest_dict['DraIII'] = _temp()


def _temp():
    return {
        'charac': (27, 18, None, None, 'CAAGNAC'),
        'compsite': '(?=(?P<DraRI>CAAG.AC))|(?=(?P<DraRI_as>GT.CTTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 18,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAAGNAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['DraRI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'GACNNNNNNGTC'),
        'compsite': '(?=(?P<DrdI>GAC......GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNNNGTC',
        'size': 12,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['DrdI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAACCA'),
        'compsite': '(?=(?P<DrdII>GAACCA))|(?=(?P<DrdII_as>TGGTTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAACCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['DrdII'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'GACNNNNNGTC'),
        'compsite': '(?=(?P<DriI>GAC.....GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNNGTC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['DriI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCRYGG'),
        'compsite': '(?=(?P<DsaI>CC[AG][CT]GG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CRYG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCRYGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['DsaI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'GACNNNNNNGTC'),
        'compsite': '(?=(?P<DseDI>GAC......GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNNNGTC',
        'size': 12,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['DseDI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'YGGCCR'),
        'compsite': '(?=(?P<EaeI>[CT]GGCC[AG]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YGGCCR',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K', 'N'),
    }


rest_dict['EaeI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGGCCG'),
        'compsite': '(?=(?P<EagI>CGGCCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGCCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['EagI'] = _temp()


def _temp():
    return {
        'charac': (7, 4, None, None, 'CTCTTC'),
        'compsite': '(?=(?P<Eam1104I>CTCTTC))|(?=(?P<Eam1104I_as>GAAGAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 4,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCTTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eam1104I'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'GACNNNNNGTC'),
        'compsite': '(?=(?P<Eam1105I>GAC.....GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNNGTC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eam1105I'] = _temp()


def _temp():
    return {
        'charac': (7, 4, None, None, 'CTCTTC'),
        'compsite': '(?=(?P<EarI>CTCTTC))|(?=(?P<EarI_as>GAAGAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 4,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCTTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['EarI'] = _temp()


def _temp():
    return {
        'charac': (17, 9, None, None, 'GGCGGA'),
        'compsite': '(?=(?P<EciI>GGCGGA))|(?=(?P<EciI_as>TCCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 9,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['EciI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GAGCTC'),
        'compsite': '(?=(?P<Ecl136II>GAGCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Ecl136II'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAAAYTC'),
        'compsite': '(?=(?P<Ecl35734I>GAAA[CT]TC))|(?=(?P<Ecl35734I_as>GA[AG]TTTC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAAYTC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Ecl35734I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGGCCG'),
        'compsite': '(?=(?P<EclXI>CGGCCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGCCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('S',),
    }


rest_dict['EclXI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TACGTA'),
        'compsite': '(?=(?P<Eco105I>TACGTA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TACGTA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco105I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCWWGG'),
        'compsite': '(?=(?P<Eco130I>CC[AT][AT]GG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CWWG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWWGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco130I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGGCCT'),
        'compsite': '(?=(?P<Eco147I>AGGCCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGGCCT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco147I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GRGCYC'),
        'compsite': '(?=(?P<Eco24I>G[AG]GC[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'RGCY',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRGCYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco24I'] = _temp()


def _temp():
    return {
        'charac': (7, 5, None, None, 'GGTCTC'),
        'compsite': '(?=(?P<Eco31I>GGTCTC))|(?=(?P<Eco31I_as>GAGACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 5,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco31I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GATATC'),
        'compsite': '(?=(?P<Eco32I>GATATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATATC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco32I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAAABCC'),
        'compsite': '(?=(?P<Eco4465II>GAAA[CGT]CC))|(?=(?P<Eco4465II_as>GG[ACG]TTTC))',
        'dna': None,
        'freq': 5461.333333333333,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAABCC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Eco4465II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGWCC'),
        'compsite': '(?=(?P<Eco47I>GG[AT]CC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGWCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco47I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGCGCT'),
        'compsite': '(?=(?P<Eco47III>AGCGCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGCGCT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'M', 'R', 'S'),
    }


rest_dict['Eco47III'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGGCCG'),
        'compsite': '(?=(?P<Eco52I>CGGCCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGCCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['Eco52I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GAGCTC'),
        'compsite': '(?=(?P<Eco53kI>GAGCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['Eco53kI'] = _temp()


def _temp():
    return {
        'charac': (22, 14, None, None, 'CTGAAG'),
        'compsite': '(?=(?P<Eco57I>CTGAAG))|(?=(?P<Eco57I_as>CTTCAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 14,
        'fst5': 22,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTGAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco57I'] = _temp()


def _temp():
    return {
        'charac': (22, 14, None, None, 'CTGRAG'),
        'compsite': '(?=(?P<Eco57MI>CTG[AG]AG))|(?=(?P<Eco57MI_as>CT[CT]CAG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': 14,
        'fst5': 22,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTGRAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Eco57MI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CACGTG'),
        'compsite': '(?=(?P<Eco72I>CACGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco72I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'compsite': '(?=(?P<Eco81I>CCT.AGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNAGG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['Eco81I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CYCGRG'),
        'compsite': '(?=(?P<Eco88I>C[CT]CG[AG]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'YCGR',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYCGRG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco88I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGTNACC'),
        'compsite': '(?=(?P<Eco91I>GGT.ACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GTNAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTNACC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Eco91I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'RCSRC'),
        'compsite': '(?=(?P<EcoBLMcrX>[AG]C[CG][AG]C))|(?=(?P<EcoBLMcrX_as>G[CT][CG]G[CT]))',
        'dna': None,
        'freq': 128.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'S',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RCSRC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['EcoBLMcrX'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ACCYAC'),
        'compsite': '(?=(?P<EcoE1140I>ACC[CT]AC))|(?=(?P<EcoE1140I_as>GT[AG]GGT))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCYAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['EcoE1140I'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'CCSGG'),
        'compsite': '(?=(?P<EcoHI>CC[CG]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCSGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCSGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['EcoHI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GAGCTC'),
        'compsite': '(?=(?P<EcoICRI>GAGCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'R', 'V'),
    }


rest_dict['EcoICRI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CANCATC'),
        'compsite': '(?=(?P<EcoMVII>CA.CATC))|(?=(?P<EcoMVII_as>GATG.TG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CANCATC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['EcoMVII'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CCTNNNNNAGG'),
        'compsite': '(?=(?P<EcoNI>CCT.....AGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNNNNNAGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['EcoNI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'RGGNCCY'),
        'compsite': '(?=(?P<EcoO109I>[AG]GG.CC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGGNCCY',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'N'),
    }


rest_dict['EcoO109I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGTNACC'),
        'compsite': '(?=(?P<EcoO65I>GGT.ACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GTNAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTNACC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['EcoO65I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GAATTC'),
        'compsite': '(?=(?P<EcoRI>GAATTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAATTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
    }


rest_dict['EcoRI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'CCWGG'),
        'compsite': '(?=(?P<EcoRII>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCWGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B', 'J'),
    }


rest_dict['EcoRII'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GATATC'),
        'compsite': '(?=(?P<EcoRV>GATATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATATC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['EcoRV'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCWWGG'),
        'compsite': '(?=(?P<EcoT14I>CC[AT][AT]GG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CWWG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWWGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['EcoT14I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'ATGCAT'),
        'compsite': '(?=(?P<EcoT22I>ATGCAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATGCAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['EcoT22I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GRGCYC'),
        'compsite': '(?=(?P<EcoT38I>G[AG]GC[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'RGCY',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRGCYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J',),
    }


rest_dict['EcoT38I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GGCGCC'),
        'compsite': '(?=(?P<EgeI>GGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['EgeI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GGCGCC'),
        'compsite': '(?=(?P<EheI>GGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['EheI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCGGAG'),
        'compsite': '(?=(?P<Eli8509II>CCGGAG))|(?=(?P<Eli8509II_as>CTCCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Eli8509II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCWWGG'),
        'compsite': '(?=(?P<ErhI>CC[AT][AT]GG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CWWG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWWGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['ErhI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TCGA'),
        'compsite': '(?=(?P<EsaBC3I>TCGA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCGA',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['EsaBC3I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GACCAC'),
        'compsite': '(?=(?P<EsaSSI>GACCAC))|(?=(?P<EsaSSI_as>GTGGTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACCAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['EsaSSI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CAGAAG'),
        'compsite': '(?=(?P<Esp3007I>CAGAAG))|(?=(?P<Esp3007I_as>CTTCTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAGAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Esp3007I'] = _temp()


def _temp():
    return {
        'charac': (7, 5, None, None, 'CGTCTC'),
        'compsite': '(?=(?P<Esp3I>CGTCTC))|(?=(?P<Esp3I_as>GAGACG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 5,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGTCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Esp3I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCTNAGC'),
        'compsite': '(?=(?P<EspI>GCT.AGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTNAGC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['EspI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCCGAC'),
        'compsite': '(?=(?P<Exi27195I>GCCGAC))|(?=(?P<Exi27195I_as>GTCGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Exi27195I'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CATG'),
        'compsite': '(?=(?P<FaeI>CATG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['FaeI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'YATR'),
        'compsite': '(?=(?P<FaiI>[CT]AT[AG]))',
        'dna': None,
        'freq': 64.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YATR',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['FaiI'] = _temp()


def _temp():
    return {
        'charac': (-8, -24, 24, 8, 'AAGNNNNNCTT'),
        'compsite': '(?=(?P<FalI>AAG.....CTT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -24,
        'fst5': -8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 8,
        'scd5': 24,
        'site': 'AAGNNNNNCTT',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['FalI'] = _temp()


def _temp():
    return {
        'charac': (15, 14, None, None, 'GGGAC'),
        'compsite': '(?=(?P<FaqI>GGGAC))|(?=(?P<FaqI_as>GTCCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 14,
        'fst5': 15,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['FaqI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'CATG'),
        'compsite': '(?=(?P<FatI>CATG))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['FatI'] = _temp()


def _temp():
    return {
        'charac': (9, 6, None, None, 'CCCGC'),
        'compsite': '(?=(?P<FauI>CCCGC))|(?=(?P<FauI_as>GCGGG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 6,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['FauI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CATATG'),
        'compsite': '(?=(?P<FauNDI>CATATG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATATG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['FauNDI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TGATCA'),
        'compsite': '(?=(?P<FbaI>TGATCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGATCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['FbaI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GTMKAC'),
        'compsite': '(?=(?P<FblI>GT[AC][GT]AC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'MK',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTMKAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['FblI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGGAC'),
        'compsite': '(?=(?P<FinI>GGGAC))|(?=(?P<FinI_as>GTCCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['FinI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GGNCC'),
        'compsite': '(?=(?P<FmuI>GG.CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['FmuI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCNGC'),
        'compsite': '(?=(?P<Fnu4HI>GC.GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['Fnu4HI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCG'),
        'compsite': '(?=(?P<FnuDII>CGCG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['FnuDII'] = _temp()


def _temp():
    return {
        'charac': (14, 13, None, None, 'GGATG'),
        'compsite': '(?=(?P<FokI>GGATG))|(?=(?P<FokI_as>CATCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 13,
        'fst5': 14,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'V', 'X', 'Y'),
    }


rest_dict['FokI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GRGCYC'),
        'compsite': '(?=(?P<FriOI>G[AG]GC[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'RGCY',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRGCYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['FriOI'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'GGCCGGCC'),
        'compsite': '(?=(?P<FseI>GGCCGGCC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCCGGCC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['FseI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCNGC'),
        'compsite': '(?=(?P<Fsp4HI>GC.GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Fsp4HI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'RTGCGCAY'),
        'compsite': '(?=(?P<FspAI>[AG]TGCGCA[CT]))',
        'dna': None,
        'freq': 16384.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RTGCGCAY',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['FspAI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTAG'),
        'compsite': '(?=(?P<FspBI>CTAG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTAG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['FspBI'] = _temp()


def _temp():
    return {
        'charac': (14, 16, None, None, 'CC'),
        'compsite': '(?=(?P<FspEI>CC))|(?=(?P<FspEI_as>GG))',
        'dna': None,
        'freq': 16.0,
        'fst3': 16,
        'fst5': 14,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CC',
        'size': 2,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['FspEI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGCGCA'),
        'compsite': '(?=(?P<FspI>TGCGCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGCGCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'N'),
    }


rest_dict['FspI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAAACA'),
        'compsite': '(?=(?P<FtnUV>GAAACA))|(?=(?P<FtnUV_as>TGTTTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAACA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['FtnUV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGCGCAGG'),
        'compsite': '(?=(?P<GauT27I>CGCGCAGG))|(?=(?P<GauT27I_as>CCTGCGCG))',
        'dna': None,
        'freq': 65536.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCGCAGG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['GauT27I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ATGCAC'),
        'compsite': '(?=(?P<Gba708II>ATGCAC))|(?=(?P<Gba708II_as>GTGCAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATGCAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Gba708II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGGCCR'),
        'compsite': '(?=(?P<GdiII>CGGCC[AG]))|(?=(?P<GdiII_as>[CT]GGCCG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGCCR',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['GdiII'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCGC'),
        'compsite': '(?=(?P<GlaI>GCGC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['GlaI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCNGC'),
        'compsite': '(?=(?P<GluI>GC.GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['GluI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CCCAGC'),
        'compsite': '(?=(?P<GsaI>CCCAGC))|(?=(?P<GsaI_as>GCTGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CCAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCAGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['GsaI'] = _temp()


def _temp():
    return {
        'charac': (22, 14, None, None, 'CTGGAG'),
        'compsite': '(?=(?P<GsuI>CTGGAG))|(?=(?P<GsuI_as>CTCCAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 14,
        'fst5': 22,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTGGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['GsuI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'WGGCCW'),
        'compsite': '(?=(?P<HaeI>[AT]GGCC[AT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'WGGCCW',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HaeI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'RGCGCY'),
        'compsite': '(?=(?P<HaeII>[AG]GCGC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'GCGC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGCGCY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'K', 'N', 'R'),
    }


rest_dict['HaeII'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCC'),
        'compsite': '(?=(?P<HaeIII>GGCC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['HaeIII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCGG'),
        'compsite': '(?=(?P<HapII>CCGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['HapII'] = _temp()


def _temp():
    return {
        'charac': (17, 9, None, None, 'TGGCCA'),
        'compsite': '(?=(?P<HauII>TGGCCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 9,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGGCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HauII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCCCAG'),
        'compsite': '(?=(?P<HbaII>GCCCAG))|(?=(?P<HbaII_as>CTGGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HbaII'] = _temp()


def _temp():
    return {
        'charac': (10, 10, None, None, 'GACGC'),
        'compsite': '(?=(?P<HgaI>GACGC))|(?=(?P<HgaI_as>GCGTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 10,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['HgaI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GWGCWC'),
        'compsite': '(?=(?P<HgiAI>G[AT]GC[AT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'WGCW',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GWGCWC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HgiAI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGYRCC'),
        'compsite': '(?=(?P<HgiCI>GG[CT][AG]CC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GYRC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGYRCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HgiCI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ACCNNNNNNGGT'),
        'compsite': '(?=(?P<HgiEII>ACC......GGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCNNNNNNGGT',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HgiEII'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GRGCYC'),
        'compsite': '(?=(?P<HgiJII>G[AG]GC[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'RGCY',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRGCYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HgiJII'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCGC'),
        'compsite': '(?=(?P<HhaI>GCGC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'N', 'Q', 'R', 'X'),
    }


rest_dict['HhaI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GRCGYC'),
        'compsite': '(?=(?P<Hin1I>G[AG]CG[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRCGYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['Hin1I'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CATG'),
        'compsite': '(?=(?P<Hin1II>CATG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Hin1II'] = _temp()


def _temp():
    return {
        'charac': (-8, -24, 24, 8, 'GAYNNNNNVTC'),
        'compsite': '(?=(?P<Hin4I>GA[CT].....[ACG]TC))|(?=(?P<Hin4I_as>GA[CGT].....[AG]TC))',
        'dna': None,
        'freq': 682.6666666666666,
        'fst3': -24,
        'fst5': -8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 8,
        'scd5': 24,
        'site': 'GAYNNNNNVTC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Hin4I'] = _temp()


def _temp():
    return {
        'charac': (11, 5, None, None, 'CCTTC'),
        'compsite': '(?=(?P<Hin4II>CCTTC))|(?=(?P<Hin4II_as>GAAGG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Hin4II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCGC'),
        'compsite': '(?=(?P<Hin6I>GCGC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Hin6I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCGC'),
        'compsite': '(?=(?P<HinP1I>GCGC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['HinP1I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTYRAC'),
        'compsite': '(?=(?P<HincII>GT[CT][AG]AC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTYRAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'N', 'O', 'Q', 'R', 'X'),
    }


rest_dict['HincII'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTYRAC'),
        'compsite': '(?=(?P<HindII>GT[CT][AG]AC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTYRAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'M', 'S', 'V'),
    }


rest_dict['HindII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'AAGCTT'),
        'compsite': '(?=(?P<HindIII>AAGCTT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AGCT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AAGCTT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
    }


rest_dict['HindIII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GANTC'),
        'compsite': '(?=(?P<HinfI>GA.TC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'ANT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GANTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
    }


rest_dict['HinfI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTTAAC'),
        'compsite': '(?=(?P<HpaI>GTTAAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTTAAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['HpaI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCGG'),
        'compsite': '(?=(?P<HpaII>CCGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'N', 'Q', 'R', 'V', 'X'),
    }


rest_dict['HpaII'] = _temp()


def _temp():
    return {
        'charac': (13, 7, None, None, 'GGTGA'),
        'compsite': '(?=(?P<HphI>GGTGA))|(?=(?P<HphI_as>TCACC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 7,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTGA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B', 'N'),
    }


rest_dict['HphI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTNNAC'),
        'compsite': '(?=(?P<Hpy166II>GT..AC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTNNAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['Hpy166II'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TCNNGA'),
        'compsite': '(?=(?P<Hpy178III>TC..GA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCNNGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Hpy178III'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TCNGA'),
        'compsite': '(?=(?P<Hpy188I>TC.GA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCNGA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['Hpy188I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TCNNGA'),
        'compsite': '(?=(?P<Hpy188III>TC..GA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCNNGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['Hpy188III'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTNNAC'),
        'compsite': '(?=(?P<Hpy8I>GT..AC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTNNAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Hpy8I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CGWCG'),
        'compsite': '(?=(?P<Hpy99I>CG[AT]CG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'CGWCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGWCG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['Hpy99I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCCTA'),
        'compsite': '(?=(?P<Hpy99XIII>GCCTA))|(?=(?P<Hpy99XIII_as>TAGGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCTA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Hpy99XIII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGWTAA'),
        'compsite': '(?=(?P<Hpy99XIV>GG[AT]TAA))|(?=(?P<Hpy99XIV_as>TTA[AT]CC))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGWTAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Hpy99XIV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGWCNA'),
        'compsite': '(?=(?P<Hpy99XIV_mut1>GG[AT]C.A))|(?=(?P<Hpy99XIV_mut1_as>T.G[AT]CC))',
        'dna': None,
        'freq': 512.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGWCNA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Hpy99XIV_mut1'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TCANNNNNNTRG'),
        'compsite': '(?=(?P<Hpy99XXII>TCA......T[AG]G))|(?=(?P<Hpy99XXII_as>C[CT]A......TGA))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCANNNNNNTRG',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Hpy99XXII'] = _temp()


def _temp():
    return {
        'charac': (11, 5, None, None, 'CCTTC'),
        'compsite': '(?=(?P<HpyAV>CCTTC))|(?=(?P<HpyAV_as>GAAGG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['HpyAV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCGTA'),
        'compsite': '(?=(?P<HpyAXIV>GCGTA))|(?=(?P<HpyAXIV_as>TACGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGTA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HpyAXIV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CRTTAA'),
        'compsite': '(?=(?P<HpyAXVI_mut1>C[AG]TTAA))|(?=(?P<HpyAXVI_mut1_as>TTAA[CT]G))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CRTTAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HpyAXVI_mut1'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CRTCNA'),
        'compsite': '(?=(?P<HpyAXVI_mut2>C[AG]TC.A))|(?=(?P<HpyAXVI_mut2_as>T.GA[CT]G))',
        'dna': None,
        'freq': 512.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CRTCNA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HpyAXVI_mut2'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'ACNGT'),
        'compsite': '(?=(?P<HpyCH4III>AC.GT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACNGT',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['HpyCH4III'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACGT'),
        'compsite': '(?=(?P<HpyCH4IV>ACGT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['HpyCH4IV'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TGCA'),
        'compsite': '(?=(?P<HpyCH4V>TGCA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGCA',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['HpyCH4V'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'GCNNNNNNNGC'),
        'compsite': '(?=(?P<HpyF10VI>GC.......GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNNNNNNNGC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['HpyF10VI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTNAG'),
        'compsite': '(?=(?P<HpyF3I>CT.AG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTNAG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['HpyF3I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACGT'),
        'compsite': '(?=(?P<HpySE526I>ACGT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['HpySE526I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CYANNNNNNNTRG'),
        'compsite': '(?=(?P<HpyUM032XIII>C[CT]A.......T[AG]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYANNNNNNNTRG',
        'size': 13,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HpyUM032XIII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CYANNNNNNNTTC'),
        'compsite': '(?=(?P<HpyUM032XIII_mut1>C[CT]A.......TTC))|(?=(?P<HpyUM032XIII_mut1_as>GAA.......T[AG]G))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYANNNNNNNTTC',
        'size': 13,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HpyUM032XIII_mut1'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAAAG'),
        'compsite': '(?=(?P<HpyUM032XIV>GAAAG))|(?=(?P<HpyUM032XIV_as>CTTTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAAG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HpyUM032XIV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TNGGNAG|GTGGNAG'),
        'compsite': '(?=(?P<HpyUM037X>T.GG.AG))|(?=(?P<HpyUM037X_as>CT.CC.A))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TNGGNAG|GTGGNAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['HpyUM037X'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GRCGYC'),
        'compsite': '(?=(?P<Hsp92I>G[AG]CG[CT]C))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRCGYC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('R',),
    }


rest_dict['Hsp92I'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CATG'),
        'compsite': '(?=(?P<Hsp92II>CATG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('R',),
    }


rest_dict['Hsp92II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCGC'),
        'compsite': '(?=(?P<HspAI>GCGC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['HspAI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GTATNAC'),
        'compsite': '(?=(?P<Jma19592I>GTAT.AC))|(?=(?P<Jma19592I_as>GT.ATAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTATNAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Jma19592I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GRGCRAC'),
        'compsite': '(?=(?P<Jma19592II>G[AG]GC[AG]AC))|(?=(?P<Jma19592II_as>GT[CT]GC[CT]C))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRGCRAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Jma19592II'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GRNGAAT'),
        'compsite': '(?=(?P<Jsp2502II>G[AG].GAAT))|(?=(?P<Jsp2502II_as>ATTC.[CT]C))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRNGAAT',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Jsp2502II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGCGCC'),
        'compsite': '(?=(?P<KasI>GGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GCGC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['KasI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGGWCCC'),
        'compsite': '(?=(?P<KflI>GGG[AT]CCC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGWCCC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['KflI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'RTCGAG'),
        'compsite': '(?=(?P<Kor51II>[AG]TCGAG))|(?=(?P<Kor51II_as>CTCGA[CT]))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RTCGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Kor51II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCCGGA'),
        'compsite': '(?=(?P<Kpn2I>TCCGGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCGGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Kpn2I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GGTACC'),
        'compsite': '(?=(?P<KpnI>GGTACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTACC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
    }


rest_dict['KpnI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GTTCNAC'),
        'compsite': '(?=(?P<KpnNIH30III>GTTC.AC))|(?=(?P<KpnNIH30III_as>GT.GAAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTTCNAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['KpnNIH30III'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCCGGC'),
        'compsite': '(?=(?P<KroI>GCCGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCGGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['KroI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TGATCA'),
        'compsite': '(?=(?P<Ksp22I>TGATCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGATCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Ksp22I'] = _temp()


def _temp():
    return {
        'charac': (7, 4, None, None, 'CTCTTC'),
        'compsite': '(?=(?P<Ksp632I>CTCTTC))|(?=(?P<Ksp632I_as>GAAGAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 4,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCTTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Ksp632I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTTAAC'),
        'compsite': '(?=(?P<KspAI>GTTAAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTTAAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['KspAI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CCGCGG'),
        'compsite': '(?=(?P<KspI>CCGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'GC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('M', 'S'),
    }


rest_dict['KspI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GATC'),
        'compsite': '(?=(?P<Kzo9I>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Kzo9I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CYAAANG'),
        'compsite': '(?=(?P<Lba2029III>C[CT]AAA.G))|(?=(?P<Lba2029III_as>C.TTT[AG]G))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYAAANG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Lba2029III'] = _temp()


def _temp():
    return {
        'charac': (8, 4, None, None, 'GCTCTTC'),
        'compsite': '(?=(?P<LguI>GCTCTTC))|(?=(?P<LguI_as>GAAGAGC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': 4,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTCTTC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['LguI'] = _temp()


def _temp():
    return {
        'charac': (6, -1, None, None, 'GCTCC'),
        'compsite': '(?=(?P<LmnI>GCTCC))|(?=(?P<LmnI_as>GGAGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'CN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['LmnI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'AGCGCCG'),
        'compsite': '(?=(?P<Lmo370I>AGCGCCG))|(?=(?P<Lmo370I_as>CGGCGCT))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGCGCCG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Lmo370I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TAGRAG'),
        'compsite': '(?=(?P<Lmo911II>TAG[AG]AG))|(?=(?P<Lmo911II_as>CT[CT]CTA))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TAGRAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Lmo911II'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'RGCGCY'),
        'compsite': '(?=(?P<LpnI>[AG]GCGC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGCGCY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['LpnI'] = _temp()


def _temp():
    return {
        'charac': (14, 14, None, None, 'CCDG'),
        'compsite': '(?=(?P<LpnPI>CC[AGT]G))|(?=(?P<LpnPI_as>C[ACT]GG))',
        'dna': None,
        'freq': 85.33333333333333,
        'fst3': 14,
        'fst5': 14,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCDG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['LpnPI'] = _temp()


def _temp():
    return {
        'charac': (13, 12, None, None, 'GCAGC'),
        'compsite': '(?=(?P<Lsp1109I>GCAGC))|(?=(?P<Lsp1109I_as>GCTGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 12,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Lsp1109I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'AGCACC'),
        'compsite': '(?=(?P<Lsp48III>AGCACC))|(?=(?P<Lsp48III_as>GGTGCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGCACC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Lsp48III'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CRAGCAC'),
        'compsite': '(?=(?P<Lsp6406VI>C[AG]AGCAC))|(?=(?P<Lsp6406VI_as>GTGCT[CT]G))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CRAGCAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Lsp6406VI'] = _temp()


def _temp():
    return {
        'charac': (10, 9, None, None, 'GCATC'),
        'compsite': '(?=(?P<LweI>GCATC))|(?=(?P<LweI_as>GATGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 9,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCATC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['LweI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACCWGGT'),
        'compsite': '(?=(?P<MabI>ACC[AT]GGT))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCWGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCWGGT',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['MabI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTAG'),
        'compsite': '(?=(?P<MaeI>CTAG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTAG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('M',),
    }


rest_dict['MaeI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACGT'),
        'compsite': '(?=(?P<MaeII>ACGT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('M',),
    }


rest_dict['MaeII'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GTNAC'),
        'compsite': '(?=(?P<MaeIII>GT.AC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GTNAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTNAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('M', 'S'),
    }


rest_dict['MaeIII'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GATC'),
        'compsite': '(?=(?P<MalI>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['MalI'] = _temp()


def _temp():
    return {
        'charac': (28, 19, None, None, 'CRTTGAC'),
        'compsite': '(?=(?P<MaqI>C[AG]TTGAC))|(?=(?P<MaqI_as>GTCAA[CT]G))',
        'dna': None,
        'freq': 8192.0,
        'fst3': 19,
        'fst5': 28,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CRTTGAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['MaqI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCGCGCG'),
        'compsite': '(?=(?P<MauBI>CGCGCGCG))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCGCGCG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['MauBI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'AGGCGA'),
        'compsite': '(?=(?P<Mba11I>AGGCGA))|(?=(?P<Mba11I_as>TCGCCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGGCGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Mba11I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CCGCTC'),
        'compsite': '(?=(?P<MbiI>CCGCTC))|(?=(?P<MbiI_as>GAGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['MbiI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GATC'),
        'compsite': '(?=(?P<MboI>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'K', 'N', 'Q', 'R', 'X', 'Y'),
    }


rest_dict['MboI'] = _temp()


def _temp():
    return {
        'charac': (13, 7, None, None, 'GAAGA'),
        'compsite': '(?=(?P<MboII>GAAGA))|(?=(?P<MboII_as>TCTTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 7,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAGA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'J', 'K', 'N', 'Q', 'R', 'V', 'X'),
    }


rest_dict['MboII'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GCGCGC'),
        'compsite': '(?=(?P<McaTI>GCGCGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'GC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGCGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['McaTI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAAGNNNNNCTC'),
        'compsite': '(?=(?P<Mcr10I>GAAG.....CTC))|(?=(?P<Mcr10I_as>GAG.....CTTC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAGNNNNNCTC',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Mcr10I'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CGRYCG'),
        'compsite': '(?=(?P<McrI>CG[AG][CT]CG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'RY',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGRYCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['McrI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CAATTG'),
        'compsite': '(?=(?P<MfeI>CAATTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAATTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['MfeI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RGATCY'),
        'compsite': '(?=(?P<MflI>[AG]GATC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGATCY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['MflI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GDGCHC'),
        'compsite': '(?=(?P<MhlI>G[AGT]GC[ACT]C))',
        'dna': None,
        'freq': 455.1111111111111,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'DGCH',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GDGCHC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['MhlI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GTNNAC'),
        'compsite': '(?=(?P<MjaIV>GT..AC))',
        'dna': None,
        'freq': 256.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTNNAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['MjaIV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAGAYGT'),
        'compsite': '(?=(?P<MkaDII>GAGA[CT]GT))|(?=(?P<MkaDII_as>AC[AG]TCTC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGAYGT',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['MkaDII'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGGCCA'),
        'compsite': '(?=(?P<MlsI>TGGCCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGGCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['MlsI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'AATT'),
        'compsite': '(?=(?P<MluCI>AATT))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AATT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['MluCI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACGCGT'),
        'compsite': '(?=(?P<MluI>ACGCGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGCGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['MluI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGGCCA'),
        'compsite': '(?=(?P<MluNI>TGGCCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGGCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('M',),
    }


rest_dict['MluNI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCGCC'),
        'compsite': '(?=(?P<Mly113I>GGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Mly113I'] = _temp()


def _temp():
    return {
        'charac': (10, 5, None, None, 'GAGTC'),
        'compsite': '(?=(?P<MlyI>GAGTC))|(?=(?P<MlyI_as>GACTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['MlyI'] = _temp()


def _temp():
    return {
        'charac': (26, 18, None, None, 'TCCRAC'),
        'compsite': '(?=(?P<MmeI>TCC[AG]AC))|(?=(?P<MmeI_as>GT[CT]GGA))',
        'dna': None,
        'freq': 2048.0,
        'fst3': 18,
        'fst5': 26,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCRAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N', 'X'),
    }


rest_dict['MmeI'] = _temp()


def _temp():
    return {
        'charac': (11, 6, None, None, 'CCTC'),
        'compsite': '(?=(?P<MnlI>CCTC))|(?=(?P<MnlI_as>GAGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': 6,
        'fst5': 11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'N', 'Q', 'V', 'X'),
    }


rest_dict['MnlI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGGCCA'),
        'compsite': '(?=(?P<Mox20I>TGGCCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGGCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Mox20I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'ATGCAT'),
        'compsite': '(?=(?P<Mph1103I>ATGCAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATGCAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Mph1103I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCCGGCG'),
        'compsite': '(?=(?P<MreI>CGCCGGCG))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCCGGCG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['MreI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCCGGA'),
        'compsite': '(?=(?P<MroI>TCCGGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCGGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('M', 'O'),
    }


rest_dict['MroI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCCGGC'),
        'compsite': '(?=(?P<MroNI>GCCGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCGGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['MroNI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GAANNNNTTC'),
        'compsite': '(?=(?P<MroXI>GAA....TTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAANNNNTTC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['MroXI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGGCCA'),
        'compsite': '(?=(?P<MscI>TGGCCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGGCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N', 'O'),
    }


rest_dict['MscI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TTAA'),
        'compsite': '(?=(?P<MseI>TTAA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTAA',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['MseI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CAYNNNNRTG'),
        'compsite': '(?=(?P<MslI>CA[CT]....[AG]TG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAYNNNNRTG',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['MslI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGGCCA'),
        'compsite': '(?=(?P<Msp20I>TGGCCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGGCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['Msp20I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CMGCKG'),
        'compsite': '(?=(?P<MspA1I>C[AC]GC[GT]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CMGCKG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N', 'R', 'V'),
    }


rest_dict['MspA1I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTTAAG'),
        'compsite': '(?=(?P<MspCI>CTTAAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TTAA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['MspCI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCGG'),
        'compsite': '(?=(?P<MspI>CCGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'J', 'K', 'N', 'Q', 'R', 'V', 'X'),
    }


rest_dict['MspI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ACGRAG'),
        'compsite': '(?=(?P<MspI7II>ACG[AG]AG))|(?=(?P<MspI7II_as>CT[CT]CGT))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGRAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['MspI7II'] = _temp()


def _temp():
    return {
        'charac': (13, 13, None, None, 'CNNR'),
        'compsite': '(?=(?P<MspJI>C..[AG]))|(?=(?P<MspJI_as>[CT]..G))',
        'dna': None,
        'freq': 8.0,
        'fst3': 13,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CNNR',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['MspJI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCNGG'),
        'compsite': '(?=(?P<MspR9I>CC.GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['MspR9I'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GTTTAAAC'),
        'compsite': '(?=(?P<MssI>GTTTAAAC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTTTAAAC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['MssI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGCGCA'),
        'compsite': '(?=(?P<MstI>TGCGCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGCGCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['MstI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GCGCNGCGC'),
        'compsite': '(?=(?P<MteI>GCGC.GCGC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGCNGCGC',
        'size': 9,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['MteI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CACGCAG'),
        'compsite': '(?=(?P<MtuHN878II>CACGCAG))|(?=(?P<MtuHN878II_as>CTGCGTG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGCAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['MtuHN878II'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CAATTG'),
        'compsite': '(?=(?P<MunI>CAATTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAATTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K', 'M', 'S'),
    }


rest_dict['MunI'] = _temp()


def _temp():
    return {
        'charac': (7, -1, None, None, 'GAATGC'),
        'compsite': '(?=(?P<Mva1269I>GAATGC))|(?=(?P<Mva1269I_as>GCATTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'CN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAATGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Mva1269I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCWGG'),
        'compsite': '(?=(?P<MvaI>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'W',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B', 'M'),
    }


rest_dict['MvaI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCG'),
        'compsite': '(?=(?P<MvnI>CGCG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('M',),
    }


rest_dict['MvnI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'GCNNNNNNNGC'),
        'compsite': '(?=(?P<MwoI>GC.......GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNNNNNNNGC',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['MwoI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCCGGC'),
        'compsite': '(?=(?P<NaeI>GCCGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCGGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C', 'K', 'N'),
    }


rest_dict['NaeI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ACCAGC'),
        'compsite': '(?=(?P<Nal45188II>ACCAGC))|(?=(?P<Nal45188II_as>GCTGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCAGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Nal45188II'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCGCC'),
        'compsite': '(?=(?P<NarI>GGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'M', 'N', 'Q', 'R', 'S', 'X'),
    }


rest_dict['NarI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ACCGAC'),
        'compsite': '(?=(?P<Nbr128II>ACCGAC))|(?=(?P<Nbr128II_as>GTCGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Nbr128II'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCSGG'),
        'compsite': '(?=(?P<NciI>CC[CG]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'S',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCSGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('J', 'N', 'R'),
    }


rest_dict['NciI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCATGG'),
        'compsite': '(?=(?P<NcoI>CCATGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCATGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X', 'Y'),
    }


rest_dict['NcoI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CATATG'),
        'compsite': '(?=(?P<NdeI>CATATG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATATG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'X'),
    }


rest_dict['NdeI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GATC'),
        'compsite': '(?=(?P<NdeII>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('J', 'M'),
    }


rest_dict['NdeII'] = _temp()


def _temp():
    return {
        'charac': (12, 7, None, None, 'GCCGC'),
        'compsite': '(?=(?P<NgoAVII>GCCGC))|(?=(?P<NgoAVII_as>GCGGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 7,
        'fst5': 12,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['NgoAVII'] = _temp()


def _temp():
    return {
        'charac': (-12, -25, 24, 11, 'GACNNNNNTGA'),
        'compsite': '(?=(?P<NgoAVIII>GAC.....TGA))|(?=(?P<NgoAVIII_as>TCA.....GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -25,
        'fst5': -12,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': 11,
        'scd5': 24,
        'site': 'GACNNNNNTGA',
        'size': 11,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['NgoAVIII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCCGGC'),
        'compsite': '(?=(?P<NgoMIV>GCCGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCGGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['NgoMIV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CAAGRAG'),
        'compsite': '(?=(?P<NhaXI>CAAG[AG]AG))|(?=(?P<NhaXI_as>CT[CT]CTTG))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAAGRAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['NhaXI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCTAGC'),
        'compsite': '(?=(?P<NheI>GCTAGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTAGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['NheI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCWGC'),
        'compsite': '(?=(?P<NhoI>GC[AT]GC))',
        'dna': None,
        'freq': 512.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCWGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['NhoI'] = _temp()


def _temp():
    return {
        'charac': (25, 17, None, None, 'CATCAC'),
        'compsite': '(?=(?P<NlaCI>CATCAC))|(?=(?P<NlaCI_as>GTGATG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 17,
        'fst5': 25,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATCAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['NlaCI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CATG'),
        'compsite': '(?=(?P<NlaIII>CATG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['NlaIII'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GGNNCC'),
        'compsite': '(?=(?P<NlaIV>GG..CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNNCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['NlaIV'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CYCGRG'),
        'compsite': '(?=(?P<Nli3877I>C[CT]CG[AG]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'YCGR',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CYCGRG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Nli3877I'] = _temp()


def _temp():
    return {
        'charac': (27, 19, None, None, 'GCCGAG'),
        'compsite': '(?=(?P<NmeAIII>GCCGAG))|(?=(?P<NmeAIII_as>CTCGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 19,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['NmeAIII'] = _temp()


def _temp():
    return {
        'charac': (-12, -13, 13, 12, 'RCCGGY'),
        'compsite': '(?=(?P<NmeDI>[AG]CCGG[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -13,
        'fst5': -12,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 12,
        'scd5': 13,
        'site': 'RCCGGY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['NmeDI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GTSAC'),
        'compsite': '(?=(?P<NmuCI>GT[CG]AC))',
        'dna': None,
        'freq': 512.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GTSAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTSAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['NmuCI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCGGCCGC'),
        'compsite': '(?=(?P<NotI>GCGGCCGC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGGCCGC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['NotI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCGAC'),
        'compsite': '(?=(?P<NpeUS61II>GATCGAC))|(?=(?P<NpeUS61II_as>GTCGATC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCGAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['NpeUS61II'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TCGCGA'),
        'compsite': '(?=(?P<NruI>TCGCGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCGCGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'X'),
    }


rest_dict['NruI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TGCGCA'),
        'compsite': '(?=(?P<NsbI>TGCGCA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGCGCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['NsbI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'ATGCAT'),
        'compsite': '(?=(?P<NsiI>ATGCAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATGCAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J', 'M', 'N', 'Q', 'R', 'S', 'X'),
    }


rest_dict['NsiI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CMGCKG'),
        'compsite': '(?=(?P<NspBII>C[AC]GC[GT]G))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CMGCKG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['NspBII'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'RCATGY'),
        'compsite': '(?=(?P<NspI>[AG]CATG[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RCATGY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['NspI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TTCGAA'),
        'compsite': '(?=(?P<NspV>TTCGAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTCGAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('J',),
    }


rest_dict['NspV'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CACNNNNGTG'),
        'compsite': '(?=(?P<OliI>CAC....GTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACNNNNGTG',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['OliI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'YAGGAG'),
        'compsite': '(?=(?P<OspHL35III>[CT]AGGAG))|(?=(?P<OspHL35III_as>CTCCT[AG]))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YAGGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['OspHL35III'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GTAC'),
        'compsite': '(?=(?P<PabI>GTAC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTAC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PabI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCTTGA'),
        'compsite': '(?=(?P<Pac19842II>CCTTGA))|(?=(?P<Pac19842II_as>TCAAGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTTGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pac19842II'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'TTAATTAA'),
        'compsite': '(?=(?P<PacI>TTAATTAA))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTAATTAA',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B', 'N', 'O'),
    }


rest_dict['PacI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GTAATC'),
        'compsite': '(?=(?P<PacIII>GTAATC))|(?=(?P<PacIII_as>GATTAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTAATC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PacIII'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GCATGC'),
        'compsite': '(?=(?P<PaeI>GCATGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCATGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PaeI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTCGAG'),
        'compsite': '(?=(?P<PaeR7I>CTCGAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TCGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['PaeR7I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCATGA'),
        'compsite': '(?=(?P<PagI>TCATGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCATGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PagI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCRTGAG'),
        'compsite': '(?=(?P<Pal408I>CC[AG]TGAG))|(?=(?P<Pal408I_as>CTCA[CT]GG))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCRTGAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pal408I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCGCGCC'),
        'compsite': '(?=(?P<PalAI>GGCGCGCC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCGCC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PalAI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCCWGGG'),
        'compsite': '(?=(?P<PasI>CCC[AT]GGG))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'CWG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCWGGG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PasI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCGCGC'),
        'compsite': '(?=(?P<PauI>GCGCGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGCGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PauI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GACGAG'),
        'compsite': '(?=(?P<PcaII>GACGAG))|(?=(?P<PcaII_as>CTCGTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PcaII'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGGCCT'),
        'compsite': '(?=(?P<PceI>AGGCCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGGCCT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['PceI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACATGT'),
        'compsite': '(?=(?P<PciI>ACATGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACATGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['PciI'] = _temp()


def _temp():
    return {
        'charac': (8, 4, None, None, 'GCTCTTC'),
        'compsite': '(?=(?P<PciSI>GCTCTTC))|(?=(?P<PciSI_as>GAAGAGC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': 4,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTCTTC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PciSI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'WCGNNNNNNNCGW'),
        'compsite': '(?=(?P<PcsI>[AT]CG.......CG[AT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'WCGNNNNNNNCGW',
        'size': 13,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PcsI'] = _temp()


def _temp():
    return {
        'charac': (7, -1, None, None, 'GAATGC'),
        'compsite': '(?=(?P<PctI>GAATGC))|(?=(?P<PctI_as>GCATTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'CN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAATGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['PctI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCGGNAG'),
        'compsite': '(?=(?P<Pdi8503III>CCGG.AG))|(?=(?P<Pdi8503III_as>CT.CCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGGNAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pdi8503III'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCCGGC'),
        'compsite': '(?=(?P<PdiI>GCCGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCGGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PdiI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GAANNNNTTC'),
        'compsite': '(?=(?P<PdmI>GAA....TTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAANNNNTTC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PdmI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CACCAC'),
        'compsite': '(?=(?P<Pdu1735I>CACCAC))|(?=(?P<Pdu1735I_as>GTGGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACCAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pdu1735I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCAGT'),
        'compsite': '(?=(?P<PenI>GCAGT))|(?=(?P<PenI_as>ACTGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCAGT',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PenI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GAWTC'),
        'compsite': '(?=(?P<PfeI>GA[AT]TC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'AWT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAWTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PfeI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TCGTAG'),
        'compsite': '(?=(?P<Pfl1108I>TCGTAG))|(?=(?P<Pfl1108I_as>CTACGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCGTAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pfl1108I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGTACG'),
        'compsite': '(?=(?P<Pfl23II>CGTACG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGTACG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Pfl23II'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCNNGC'),
        'compsite': '(?=(?P<Pfl8569I>GC..GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNNGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pfl8569I'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GACNNNGTC'),
        'compsite': '(?=(?P<PflFI>GAC...GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNGTC',
        'size': 9,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['PflFI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CCANNNNNTGG'),
        'compsite': '(?=(?P<PflMI>CCA.....TGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCANNNNNTGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['PflMI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCCNGGA'),
        'compsite': '(?=(?P<PfoI>TCC.GGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCNGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCCNGGA',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PfoI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TANAAG'),
        'compsite': '(?=(?P<PfrJS12IV>TA.AAG))|(?=(?P<PfrJS12IV_as>CTT.TA))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TANAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PfrJS12IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGCGGAG'),
        'compsite': '(?=(?P<PfrJS12V>GGCGGAG))|(?=(?P<PfrJS12V_as>CTCCGCC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGGAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PfrJS12V'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CTTCNAC'),
        'compsite': '(?=(?P<PfrJS15III>CTTC.AC))|(?=(?P<PfrJS15III_as>GT.GAAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTCNAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PfrJS15III'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGYGAB'),
        'compsite': '(?=(?P<Pin17FIII>GG[CT]GA[CGT]))|(?=(?P<Pin17FIII_as>[ACG]TC[AG]CC))',
        'dna': None,
        'freq': 682.6666666666666,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGYGAB',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pin17FIII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACCGGT'),
        'compsite': '(?=(?P<PinAI>ACCGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCGGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('Q', 'X'),
    }


rest_dict['PinAI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GCNGC'),
        'compsite': '(?=(?P<PkrI>GC.GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PkrI'] = _temp()


def _temp():
    return {
        'charac': (27, 19, None, None, 'CATCAG'),
        'compsite': '(?=(?P<PlaDI>CATCAG))|(?=(?P<PlaDI_as>CTGATG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 19,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PlaDI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CGATCG'),
        'compsite': '(?=(?P<Ple19I>CGATCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGATCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Ple19I'] = _temp()


def _temp():
    return {
        'charac': (9, 5, None, None, 'GAGTC'),
        'compsite': '(?=(?P<PleI>GAGTC))|(?=(?P<PleI_as>GACTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['PleI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGCCGAC'),
        'compsite': '(?=(?P<PliMI>CGCCGAC))|(?=(?P<PliMI_as>GTCGGCG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCCGAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PliMI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GGCGCC'),
        'compsite': '(?=(?P<PluTI>GGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'GCGC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['PluTI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CACGTG'),
        'compsite': '(?=(?P<PmaCI>CACGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['PmaCI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GTTTAAAC'),
        'compsite': '(?=(?P<PmeI>GTTTAAAC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTTTAAAC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['PmeI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CACGTG'),
        'compsite': '(?=(?P<PmlI>CACGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['PmlI'] = _temp()


def _temp():
    return {
        'charac': (-7, -24, 25, 8, 'GAACNNNNNCTC'),
        'compsite': '(?=(?P<PpiI>GAAC.....CTC))|(?=(?P<PpiI_as>GAG.....GTTC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': -24,
        'fst5': -7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 8,
        'scd5': 25,
        'site': 'GAACNNNNNCTC',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PpiI'] = _temp()


def _temp():
    return {
        'charac': (9, 5, None, None, 'GAGTC'),
        'compsite': '(?=(?P<PpsI>GAGTC))|(?=(?P<PpsI_as>GACTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PpsI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ATGCAT'),
        'compsite': '(?=(?P<Ppu10I>ATGCAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATGCAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Ppu10I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'YACGTR'),
        'compsite': '(?=(?P<Ppu21I>[CT]ACGT[AG]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'YACGTR',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Ppu21I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'RGGWCCY'),
        'compsite': '(?=(?P<PpuMI>[AG]GG[AT]CC[CT]))',
        'dna': None,
        'freq': 2048.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGGWCCY',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['PpuMI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACATGT'),
        'compsite': '(?=(?P<PscI>ACATGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACATGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PscI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'RCCGAAG'),
        'compsite': '(?=(?P<Pse18267I>[AG]CCGAAG))|(?=(?P<Pse18267I_as>CTTCGG[CT]))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RCCGAAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pse18267I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GACNNNNGTC'),
        'compsite': '(?=(?P<PshAI>GAC....GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNNGTC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('K', 'N'),
    }


rest_dict['PshAI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATTAAT'),
        'compsite': '(?=(?P<PshBI>ATTAAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATTAAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['PshBI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TTATAA'),
        'compsite': '(?=(?P<PsiI>TTATAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTATAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['PsiI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCGAAG'),
        'compsite': '(?=(?P<Psp0357II>GCGAAG))|(?=(?P<Psp0357II_as>CTTCGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Psp0357II'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GGWCC'),
        'compsite': '(?=(?P<Psp03I>GG[AT]CC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGWCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Psp03I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GAGCTC'),
        'compsite': '(?=(?P<Psp124BI>GAGCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'AGCT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Psp124BI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'AACGTT'),
        'compsite': '(?=(?P<Psp1406I>AACGTT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AACGTT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['Psp1406I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'RGGWCCY'),
        'compsite': '(?=(?P<Psp5II>[AG]GG[AT]CC[CT]))',
        'dna': None,
        'freq': 2048.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGGWCCY',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Psp5II'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'CCWGG'),
        'compsite': '(?=(?P<Psp6I>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCWGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['Psp6I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CACGTG'),
        'compsite': '(?=(?P<PspCI>CACGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['PspCI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGTNACC'),
        'compsite': '(?=(?P<PspEI>GGT.ACC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GTNAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTNACC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['PspEI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCCAGC'),
        'compsite': '(?=(?P<PspFI>CCCAGC))|(?=(?P<PspFI_as>GCTGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCAGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PspFI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'CCWGG'),
        'compsite': '(?=(?P<PspGI>CC[AT]GG))',
        'dna': None,
        'freq': 512.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCWGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['PspGI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGTACG'),
        'compsite': '(?=(?P<PspLI>CGTACG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGTACG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PspLI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GGNNCC'),
        'compsite': '(?=(?P<PspN4I>GG..CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNNCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PspN4I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGGCCC'),
        'compsite': '(?=(?P<PspOMI>GGGCCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGCCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N', 'V'),
    }


rest_dict['PspOMI'] = _temp()


def _temp():
    return {
        'charac': (27, 18, None, None, 'CGCCCAR'),
        'compsite': '(?=(?P<PspOMII>CGCCCA[AG]))|(?=(?P<PspOMII_as>[CT]TGGGCG))',
        'dna': None,
        'freq': 8192.0,
        'fst3': 18,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCCCAR',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PspOMII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGNCC'),
        'compsite': '(?=(?P<PspPI>GG.CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['PspPI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'RGGWCCY'),
        'compsite': '(?=(?P<PspPPI>[AG]GG[AT]CC[CT]))',
        'dna': None,
        'freq': 2048.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGGWCCY',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PspPPI'] = _temp()


def _temp():
    return {
        'charac': (21, 13, None, None, 'CCYCAG'),
        'compsite': '(?=(?P<PspPRI>CC[CT]CAG))|(?=(?P<PspPRI_as>CTG[AG]GG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': 13,
        'fst5': 21,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCYCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PspPRI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'VCTCGAGB'),
        'compsite': '(?=(?P<PspXI>[ACG]CTCGAG[CGT]))',
        'dna': None,
        'freq': 7281.777777777777,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TCGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'VCTCGAGB',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('I', 'N'),
    }


rest_dict['PspXI'] = _temp()


def _temp():
    return {
        'charac': (-7, -25, 25, 7, 'GAACNNNNNNTAC'),
        'compsite': '(?=(?P<PsrI>GAAC......TAC))|(?=(?P<PsrI_as>GTA......GTTC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': -25,
        'fst5': -7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 7,
        'scd5': 25,
        'site': 'GAACNNNNNNTAC',
        'size': 13,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PsrI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'RGGNCCY'),
        'compsite': '(?=(?P<PssI>[AG]GG.CC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGGNCCY',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PssI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CNYACAC'),
        'compsite': '(?=(?P<Pst14472I>C.[CT]ACAC))|(?=(?P<Pst14472I_as>GTGT[AG].G))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CNYACAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pst14472I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCGAG'),
        'compsite': '(?=(?P<Pst273I>GATCGAG))|(?=(?P<Pst273I_as>CTCGATC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCGAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Pst273I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CTGCAG'),
        'compsite': '(?=(?P<PstI>CTGCAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTGCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['PstI'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'CAGNNNCTG'),
        'compsite': '(?=(?P<PstNI>CAG...CTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAGNNNCTG',
        'size': 9,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['PstNI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'BBCGD'),
        'compsite': '(?=(?P<PsuGI>[CGT][CGT]CG[AGT]))|(?=(?P<PsuGI_as>[ACT]CG[ACG][ACG]))',
        'dna': None,
        'freq': 37.925925925925924,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'BBCGD',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['PsuGI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RGATCY'),
        'compsite': '(?=(?P<PsuI>[AG]GATC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGATCY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PsuI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GACNNNGTC'),
        'compsite': '(?=(?P<PsyI>GAC...GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNGTC',
        'size': 9,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PsyI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCGCGC'),
        'compsite': '(?=(?P<PteI>GCGCGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGCGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['PteI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CGATCG'),
        'compsite': '(?=(?P<PvuI>CGATCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGATCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['PvuI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CAGCTG'),
        'compsite': '(?=(?P<PvuII>CAGCTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAGCTG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['PvuII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CACGAGH'),
        'compsite': '(?=(?P<Rba2021I>CACGAG[ACT]))|(?=(?P<Rba2021I_as>[AGT]CTCGTG))',
        'dna': None,
        'freq': 5461.333333333333,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACGAGH',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Rba2021I'] = _temp()


def _temp():
    return {
        'charac': (27, 18, None, None, 'CATCGAC'),
        'compsite': '(?=(?P<RceI>CATCGAC))|(?=(?P<RceI_as>GTCGATG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': 18,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CATCGAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RceI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCGCAG'),
        'compsite': '(?=(?P<RdeGBI>CCGCAG))|(?=(?P<RdeGBI_as>CTGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RdeGBI'] = _temp()


def _temp():
    return {
        'charac': (26, 18, None, None, 'ACCCAG'),
        'compsite': '(?=(?P<RdeGBII>ACCCAG))|(?=(?P<RdeGBII_as>CTGGGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 18,
        'fst5': 26,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RdeGBII'] = _temp()


def _temp():
    return {
        'charac': (-9, -17, 17, 9, 'TGRYCA'),
        'compsite': '(?=(?P<RdeGBIII>TG[AG][CT]CA))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -17,
        'fst5': -9,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': 9,
        'scd5': 17,
        'site': 'TGRYCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RdeGBIII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGCCAG'),
        'compsite': '(?=(?P<RflFIII>CGCCAG))|(?=(?P<RflFIII_as>CTGGCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RflFIII'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GCGATCGC'),
        'compsite': '(?=(?P<RgaI>GCGATCGC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGATCGC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['RgaI'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'GGCCGGCC'),
        'compsite': '(?=(?P<RigI>GGCCGGCC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCCGGCC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['RigI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'VCW'),
        'compsite': '(?=(?P<RlaI>[ACG]C[AT]))|(?=(?P<RlaI_as>[AT]G[CGT]))',
        'dna': None,
        'freq': 10.666666666666666,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'VCW',
        'size': 3,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RlaI'] = _temp()


def _temp():
    return {
        'charac': (26, 18, None, None, 'ACACAG'),
        'compsite': '(?=(?P<RlaII>ACACAG))|(?=(?P<RlaII_as>CTGTGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 18,
        'fst5': 26,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACACAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RlaII'] = _temp()


def _temp():
    return {
        'charac': (18, 9, None, None, 'CCCACA'),
        'compsite': '(?=(?P<RleAI>CCCACA))|(?=(?P<RleAI_as>TGTGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 9,
        'fst5': 18,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCACA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RleAI'] = _temp()


def _temp():
    return {
        'charac': (27, 18, None, None, 'CGRGGAC'),
        'compsite': '(?=(?P<RpaB5I>CG[AG]GGAC))|(?=(?P<RpaB5I_as>GTCC[CT]CG))',
        'dna': None,
        'freq': 8192.0,
        'fst3': 18,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGRGGAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RpaB5I'] = _temp()


def _temp():
    return {
        'charac': (27, 18, None, None, 'CCCGCAG'),
        'compsite': '(?=(?P<RpaBI>CCCGCAG))|(?=(?P<RpaBI_as>CTGCGGG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': 18,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCGCAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RpaBI'] = _temp()


def _temp():
    return {
        'charac': (18, 9, None, None, 'GTYGGAG'),
        'compsite': '(?=(?P<RpaI>GT[CT]GGAG))|(?=(?P<RpaI_as>CTCC[AG]AC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': 9,
        'fst5': 18,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTYGGAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RpaI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GRTGGAG'),
        'compsite': '(?=(?P<RpaTI>G[AG]TGGAG))|(?=(?P<RpaTI_as>CTCCA[CT]C))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRTGGAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RpaTI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TCGCGA'),
        'compsite': '(?=(?P<RruI>TCGCGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCGCGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['RruI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GTAC'),
        'compsite': '(?=(?P<RsaI>GTAC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTAC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'M', 'N', 'Q', 'R', 'S', 'V', 'X', 'Y'),
    }


rest_dict['RsaI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GTAC'),
        'compsite': '(?=(?P<RsaNI>GTAC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTAC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['RsaNI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CAYNNNNRTG'),
        'compsite': '(?=(?P<RseI>CA[CT]....[AG]TG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAYNNNNRTG',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['RseI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ACGCAG'),
        'compsite': '(?=(?P<Rsp008IV>ACGCAG))|(?=(?P<Rsp008IV_as>CTGCGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Rsp008IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCCCAT'),
        'compsite': '(?=(?P<Rsp008V>GCCCAT))|(?=(?P<Rsp008V_as>ATGGGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCCAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Rsp008V'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CTTCGAG'),
        'compsite': '(?=(?P<RspPBTS2III>CTTCGAG))|(?=(?P<RspPBTS2III_as>CTCGAAG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTCGAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['RspPBTS2III'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGGWCCG'),
        'compsite': '(?=(?P<Rsr2I>CGG[AT]CCG))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGWCCG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Rsr2I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGGWCCG'),
        'compsite': '(?=(?P<RsrII>CGG[AT]CCG))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGWCCG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('N', 'Q', 'X'),
    }


rest_dict['RsrII'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GAGCTC'),
        'compsite': '(?=(?P<SacI>GAGCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'AGCT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['SacI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CCGCGG'),
        'compsite': '(?=(?P<SacII>CCGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'GC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'N', 'O', 'Q', 'R', 'X'),
    }


rest_dict['SacII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CAATNAG'),
        'compsite': '(?=(?P<Saf8902III>CAAT.AG))|(?=(?P<Saf8902III_as>CT.ATTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAATNAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Saf8902III'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GTCGAC'),
        'compsite': '(?=(?P<SalI>GTCGAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TCGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTCGAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['SalI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGGWCCC'),
        'compsite': '(?=(?P<SanDI>GGG[AT]CCC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGWCCC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SanDI'] = _temp()


def _temp():
    return {
        'charac': (8, 4, None, None, 'GCTCTTC'),
        'compsite': '(?=(?P<SapI>GCTCTTC))|(?=(?P<SapI_as>GAAGAGC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': 4,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTCTTC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['SapI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TTAA'),
        'compsite': '(?=(?P<SaqAI>TTAA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTAA',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SaqAI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GCNGC'),
        'compsite': '(?=(?P<SatI>GC.GC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCNGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SatI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GATC'),
        'compsite': '(?=(?P<Sau3AI>GATC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('C', 'J', 'K', 'M', 'N', 'R', 'X'),
    }


rest_dict['Sau3AI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGNCC'),
        'compsite': '(?=(?P<Sau96I>GG.CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GNC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('J', 'N'),
    }


rest_dict['Sau96I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'compsite': '(?=(?P<SauI>CCT.AGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'TNA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNAGG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SauI'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'CCTGCAGG'),
        'compsite': '(?=(?P<SbfI>CCTGCAGG))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTGCAGG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('I', 'N', 'V'),
    }


rest_dict['SbfI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TGAAC'),
        'compsite': '(?=(?P<Sbo46I>TGAAC))|(?=(?P<Sbo46I_as>GTTCA))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TGAAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sbo46I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGTACT'),
        'compsite': '(?=(?P<ScaI>AGTACT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGTACT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['ScaI'] = _temp()


def _temp():
    return {
        'charac': (10, 5, None, None, 'GAGTC'),
        'compsite': '(?=(?P<SchI>GAGTC))|(?=(?P<SchI_as>GACTC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 5,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SchI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CTCGAG'),
        'compsite': '(?=(?P<SciI>CTCGAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SciI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCTAAT'),
        'compsite': '(?=(?P<ScoDS2II>GCTAAT))|(?=(?P<ScoDS2II_as>ATTAGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCTAAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['ScoDS2II'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCNGG'),
        'compsite': '(?=(?P<ScrFI>CC.GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('J', 'N'),
    }


rest_dict['ScrFI'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'CCTGCAGG'),
        'compsite': '(?=(?P<SdaI>CCTGCAGG))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTGCAGG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SdaI'] = _temp()


def _temp():
    return {
        'charac': (27, 19, None, None, 'CAGRAG'),
        'compsite': '(?=(?P<SdeAI>CAG[AG]AG))|(?=(?P<SdeAI_as>CT[CT]CTG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': 19,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAGRAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SdeAI'] = _temp()


def _temp():
    return {
        'charac': (-11, -24, 23, 10, 'GACNNNNRTGA'),
        'compsite': '(?=(?P<SdeOSI>GAC....[AG]TGA))|(?=(?P<SdeOSI_as>TCA[CT]....GTC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -24,
        'fst5': -11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': 10,
        'scd5': 23,
        'site': 'GACNNNNRTGA',
        'size': 11,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SdeOSI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GDGCHC'),
        'compsite': '(?=(?P<SduI>G[AGT]GC[ACT]C))',
        'dna': None,
        'freq': 455.1111111111111,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'DGCH',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GDGCHC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SduI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCNNGG'),
        'compsite': '(?=(?P<SecI>CC..GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CNNG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNNGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SecI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'CGCG'),
        'compsite': '(?=(?P<SelI>CGCG))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SelI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen13311III>GATCAG))|(?=(?P<Sen13311III_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen13311III'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen13III>GATCAG))|(?=(?P<Sen13III_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen13III'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen1736II>GATCAG))|(?=(?P<Sen1736II_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen1736II'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen1878IV>GATCAG))|(?=(?P<Sen1878IV_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen1878IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen1880IV>GATCAG))|(?=(?P<Sen1880IV_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen1880IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen1896IV>GATCAG))|(?=(?P<Sen1896IV_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen1896IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen1898IV>GATCAG))|(?=(?P<Sen1898IV_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen1898IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen1906IV>GATCAG))|(?=(?P<Sen1906IV_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen1906IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen1908IV>GATCAG))|(?=(?P<Sen1908IV_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen1908IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sen1910IV>GATCAG))|(?=(?P<Sen1910IV_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sen1910IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<SenC1808III>GATCAG))|(?=(?P<SenC1808III_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SenC1808III'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<SenC1810IV>GATCAG))|(?=(?P<SenC1810IV_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SenC1810IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'ACRCAG'),
        'compsite': '(?=(?P<SenSARA26III>AC[AG]CAG))|(?=(?P<SenSARA26III_as>CTG[CT]GT))',
        'dna': None,
        'freq': 2048.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACRCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SenSARA26III'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<SenTFIV>GATCAG))|(?=(?P<SenTFIV_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SenTFIV'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'ASST'),
        'compsite': '(?=(?P<SetI>A[CG][CG]T))',
        'dna': None,
        'freq': 64.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'ASST',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ASST',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['SetI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACCWGGT'),
        'compsite': '(?=(?P<SexAI>ACC[AT]GGT))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCWGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACCWGGT',
        'size': 7,
        'substrat': 'DNA',
        'suppl': ('M', 'N'),
    }


rest_dict['SexAI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GCGATCGC'),
        'compsite': '(?=(?P<SfaAI>GCGATCGC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGATCGC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SfaAI'] = _temp()


def _temp():
    return {
        'charac': (10, 9, None, None, 'GCATC'),
        'compsite': '(?=(?P<SfaNI>GCATC))|(?=(?P<SfaNI_as>GATGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 9,
        'fst5': 10,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCATC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I', 'N', 'V'),
    }


rest_dict['SfaNI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTRYAG'),
        'compsite': '(?=(?P<SfcI>CT[AG][CT]AG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TRYA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTRYAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['SfcI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTRYAG'),
        'compsite': '(?=(?P<SfeI>CT[AG][CT]AG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TRYA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTRYAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SfeI'] = _temp()


def _temp():
    return {
        'charac': (8, -8, None, None, 'GGCCNNNNNGGCC'),
        'compsite': '(?=(?P<SfiI>GGCC.....GGCC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -8,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCCNNNNNGGCC',
        'size': 13,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['SfiI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GGCGCC'),
        'compsite': '(?=(?P<SfoI>GGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['SfoI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTCGAG'),
        'compsite': '(?=(?P<Sfr274I>CTCGAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TCGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Sfr274I'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CCGCGG'),
        'compsite': '(?=(?P<Sfr303I>CCGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'GC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Sfr303I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'TTCGAA'),
        'compsite': '(?=(?P<SfuI>TTCGAA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTCGAA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('M', 'S'),
    }


rest_dict['SfuI'] = _temp()


def _temp():
    return {
        'charac': (13, 13, None, None, 'CNNG'),
        'compsite': '(?=(?P<SgeI>C..G))',
        'dna': None,
        'freq': 16.0,
        'fst3': 13,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CNNG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SgeI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GCGATCGC'),
        'compsite': '(?=(?P<SgfI>GCGATCGC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'AT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGATCGC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('R',),
    }


rest_dict['SgfI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CRCCGGYG'),
        'compsite': '(?=(?P<SgrAI>C[AG]CCGG[CT]G))',
        'dna': None,
        'freq': 16384.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CRCCGGYG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['SgrAI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'CCGCGG'),
        'compsite': '(?=(?P<SgrBI>CCGCGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'GC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGCGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['SgrBI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGTCGACG'),
        'compsite': '(?=(?P<SgrDI>CGTCGACG))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TCGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGTCGACG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SgrDI'] = _temp()


def _temp():
    return {
        'charac': (14, 14, None, None, 'CCDS'),
        'compsite': '(?=(?P<SgrTI>CC[AGT][CG]))|(?=(?P<SgrTI_as>[CG][ACT]GG))',
        'dna': None,
        'freq': 42.666666666666664,
        'fst3': 14,
        'fst5': 14,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCDS',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SgrTI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GGCGCGCC'),
        'compsite': '(?=(?P<SgsI>GGCGCGCC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CGCG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCGCC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SgsI'] = _temp()


def _temp():
    return {
        'charac': (2, 0, None, None, 'GGGTC'),
        'compsite': '(?=(?P<SimI>GGGTC))|(?=(?P<SimI_as>GACCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 0,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GTC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGGTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SimI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGWCC'),
        'compsite': '(?=(?P<SinI>GG[AT]CC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGWCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('X',),
    }


rest_dict['SinI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTCGAG'),
        'compsite': '(?=(?P<SlaI>CTCGAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TCGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C', 'Y'),
    }


rest_dict['SlaI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'CCCGGG'),
        'compsite': '(?=(?P<SmaI>CCCGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCGGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
    }


rest_dict['SmaI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'ATTTAAAT'),
        'compsite': '(?=(?P<SmiI>ATTTAAAT))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATTTAAAT',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'K', 'V'),
    }


rest_dict['SmiI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CAYNNNNRTG'),
        'compsite': '(?=(?P<SmiMI>CA[CT]....[AG]TG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAYNNNNRTG',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['SmiMI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTYRAG'),
        'compsite': '(?=(?P<SmlI>CT[CT][AG]AG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TYRA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTYRAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['SmlI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTYRAG'),
        'compsite': '(?=(?P<SmoI>CT[CT][AG]AG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TYRA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTYRAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SmoI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'TACGTA'),
        'compsite': '(?=(?P<SnaBI>TACGTA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TACGTA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C', 'K', 'M', 'N', 'R'),
    }


rest_dict['SnaBI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GTATAC'),
        'compsite': '(?=(?P<SnaI>GTATAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTATAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SnaI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGCCGAG'),
        'compsite': '(?=(?P<Sno506I>GGCCGAG))|(?=(?P<Sno506I_as>CTCGGCC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCCGAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sno506I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'ACTAGT'),
        'compsite': '(?=(?P<SpeI>ACTAGT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACTAGT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['SpeI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GCATGC'),
        'compsite': '(?=(?P<SphI>GCATGC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCATGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['SphI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGTACG'),
        'compsite': '(?=(?P<SplI>CGTACG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGTACG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SplI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TCGAG'),
        'compsite': '(?=(?P<SpnRII>TCGAG))|(?=(?P<SpnRII_as>CTCGA))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCGAG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SpnRII'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCGGRAG'),
        'compsite': '(?=(?P<SpoDI>GCGG[AG]AG))|(?=(?P<SpoDI_as>CT[CT]CCGC))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGGRAG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SpoDI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GCCCGGGC'),
        'compsite': '(?=(?P<SrfI>GCCCGGGC))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCCCGGGC',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['SrfI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CGCCGGCG'),
        'compsite': '(?=(?P<Sse232I>CGCCGGCG))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCCGGCG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sse232I'] = _temp()


def _temp():
    return {
        'charac': (6, -6, None, None, 'CCTGCAGG'),
        'compsite': '(?=(?P<Sse8387I>CCTGCAGG))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -6,
        'fst5': 6,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTGCAGG',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['Sse8387I'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'AGGWCCT'),
        'compsite': '(?=(?P<Sse8647I>AGG[AT]CCT))',
        'dna': None,
        'freq': 8192.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGGWCCT',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sse8647I'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'AATT'),
        'compsite': '(?=(?P<Sse9I>AATT))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AATT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Sse9I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGGCCT'),
        'compsite': '(?=(?P<SseBI>AGGCCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGGCCT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['SseBI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCGC'),
        'compsite': '(?=(?P<SsiI>CCGC))|(?=(?P<SsiI_as>GCGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGC',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SsiI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAAGGC'),
        'compsite': '(?=(?P<Ssp6803IV>GAAGGC))|(?=(?P<Ssp6803IV_as>GCCTTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAAGGC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Ssp6803IV'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGCAGCG'),
        'compsite': '(?=(?P<Ssp714II>CGCAGCG))|(?=(?P<Ssp714II_as>CGCTGCG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGCAGCG',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Ssp714II'] = _temp()


def _temp():
    return {
        'charac': (13, 8, None, None, 'GGTGA'),
        'compsite': '(?=(?P<SspD5I>GGTGA))|(?=(?P<SspD5I_as>TCACC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 8,
        'fst5': 13,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGTGA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SspD5I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGCGCC'),
        'compsite': '(?=(?P<SspDI>GGCGCC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GCGC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGCGCC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['SspDI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AATATT'),
        'compsite': '(?=(?P<SspI>AATATT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AATATT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'N', 'Q', 'R', 'V', 'X'),
    }


rest_dict['SspI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTAG'),
        'compsite': '(?=(?P<SspMI>CTAG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTAG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['SspMI'] = _temp()


def _temp():
    return {
        'charac': (27, 18, None, None, 'CGAAGAC'),
        'compsite': '(?=(?P<SstE37I>CGAAGAC))|(?=(?P<SstE37I_as>GTCTTCG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': 18,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGAAGAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['SstE37I'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GAGCTC'),
        'compsite': '(?=(?P<SstI>GAGCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'AGCT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C',),
    }


rest_dict['SstI'] = _temp()


def _temp():
    return {
        'charac': (8, 8, None, None, 'CCCG'),
        'compsite': '(?=(?P<Sth132I>CCCG))|(?=(?P<Sth132I_as>CGGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': 8,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sth132I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GGACGAC'),
        'compsite': '(?=(?P<Sth20745III>GGACGAC))|(?=(?P<Sth20745III_as>GTCGTCC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGACGAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sth20745III'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'CCGG'),
        'compsite': '(?=(?P<Sth302II>CCGG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCGG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sth302II'] = _temp()


def _temp():
    return {
        'charac': (15, 14, None, None, 'GGATG'),
        'compsite': '(?=(?P<StsI>GGATG))|(?=(?P<StsI_as>CATCC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 14,
        'fst5': 15,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'NNNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGATG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['StsI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGGCCT'),
        'compsite': '(?=(?P<StuI>AGGCCT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGGCCT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'X'),
    }


rest_dict['StuI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GATCAG'),
        'compsite': '(?=(?P<Sty13348III>GATCAG))|(?=(?P<Sty13348III_as>CTGATC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GATCAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Sty13348III'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'CCNGG'),
        'compsite': '(?=(?P<StyD4I>CC.GG))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'CCNGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCNGG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['StyD4I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCWWGG'),
        'compsite': '(?=(?P<StyI>CC[AT][AT]GG))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CWWG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCWWGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('C', 'J', 'N'),
    }


rest_dict['StyI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'ATTTAAAT'),
        'compsite': '(?=(?P<SwaI>ATTTAAAT))',
        'dna': None,
        'freq': 65536.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATTTAAAT',
        'size': 8,
        'substrat': 'DNA',
        'suppl': ('J', 'M', 'N', 'S'),
    }


rest_dict['SwaI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'ACNGT'),
        'compsite': '(?=(?P<TaaI>AC.GT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACNGT',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['TaaI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'ACGT'),
        'compsite': '(?=(?P<TaiI>ACGT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'ACGT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['TaiI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCGA'),
        'compsite': '(?=(?P<TaqI>TCGA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'CG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCGA',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['TaqI'] = _temp()


def _temp():
    return {
        'charac': (17, 9, None, None, 'GACCGA'),
        'compsite': '(?=(?P<TaqII>GACCGA))|(?=(?P<TaqII_as>TCGGTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 9,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACCGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('Q', 'X'),
    }


rest_dict['TaqII'] = _temp()


def _temp():
    return {
        'charac': (17, 9, None, None, 'CACCCA'),
        'compsite': '(?=(?P<TaqIII>CACCCA))|(?=(?P<TaqIII_as>TGGGTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': 9,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['TaqIII'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'AATT'),
        'compsite': '(?=(?P<TasI>AATT))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AATT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['TasI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'WGTACW'),
        'compsite': '(?=(?P<TatI>[AT]GTAC[AT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GTAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'WGTACW',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['TatI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GCSGC'),
        'compsite': '(?=(?P<TauI>GC[CG]GC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'CSG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCSGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['TauI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GAWTC'),
        'compsite': '(?=(?P<TfiI>GA[AT]TC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'AWT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAWTC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['TfiI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TTAA'),
        'compsite': '(?=(?P<Tru1I>TTAA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTAA',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['Tru1I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TTAA'),
        'compsite': '(?=(?P<Tru9I>TTAA))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TTAA',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('I', 'M', 'R', 'V'),
    }


rest_dict['Tru9I'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CASTG'),
        'compsite': '(?=(?P<TscAI>CA[CG]TG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 10,
        'ovhgseq': 'NNCASTGNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CASTG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['TscAI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GTSAC'),
        'compsite': '(?=(?P<TseFI>GT[CG]AC))',
        'dna': None,
        'freq': 512.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GTSAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTSAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['TseFI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GCWGC'),
        'compsite': '(?=(?P<TseI>GC[AT]GC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'CWG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCWGC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['TseI'] = _temp()


def _temp():
    return {
        'charac': (17, 9, None, None, 'TARCCA'),
        'compsite': '(?=(?P<TsoI>TA[AG]CCA))|(?=(?P<TsoI_as>TGG[CT]TA))',
        'dna': None,
        'freq': 2048.0,
        'fst3': 9,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TARCCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['TsoI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GTSAC'),
        'compsite': '(?=(?P<Tsp45I>GT[CG]AC))',
        'dna': None,
        'freq': 512.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GTSAC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTSAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['Tsp45I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'ACNGT'),
        'compsite': '(?=(?P<Tsp4CI>AC.GT))',
        'dna': None,
        'freq': 256.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACNGT',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Tsp4CI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GRACGAC'),
        'compsite': '(?=(?P<TspARh3I>G[AG]ACGAC))|(?=(?P<TspARh3I_as>GTCGT[CT]C))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GRACGAC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['TspARh3I'] = _temp()


def _temp():
    return {
        'charac': (16, 9, None, None, 'ATGAA'),
        'compsite': '(?=(?P<TspDTI>ATGAA))|(?=(?P<TspDTI_as>TTCAT))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 9,
        'fst5': 16,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATGAA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('Q', 'X'),
    }


rest_dict['TspDTI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'AATT'),
        'compsite': '(?=(?P<TspEI>AATT))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AATT',
        'size': 4,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['TspEI'] = _temp()


def _temp():
    return {
        'charac': (16, 9, None, None, 'ACGGA'),
        'compsite': '(?=(?P<TspGWI>ACGGA))|(?=(?P<TspGWI_as>TCCGT))',
        'dna': None,
        'freq': 1024.0,
        'fst3': 9,
        'fst5': 16,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ACGGA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('Q', 'X'),
    }


rest_dict['TspGWI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCCGGG'),
        'compsite': '(?=(?P<TspMI>CCCGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCGGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['TspMI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CASTG'),
        'compsite': '(?=(?P<TspRI>CA[CG]TG))',
        'dna': None,
        'freq': 512.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 10,
        'ovhgseq': 'NNCASTGNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CASTG',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['TspRI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAGNNNCTC'),
        'compsite': '(?=(?P<TssI>GAG...CTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGNNNCTC',
        'size': 9,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['TssI'] = _temp()


def _temp():
    return {
        'charac': (-8, -25, 24, 7, 'CACNNNNNNTCC'),
        'compsite': '(?=(?P<TstI>CAC......TCC))|(?=(?P<TstI_as>GGA......GTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -25,
        'fst5': -8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 5,
        'ovhgseq': 'NNNNN',
        'results': None,
        'scd3': 7,
        'scd5': 24,
        'site': 'CACNNNNNNTCC',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['TstI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GCGAC'),
        'compsite': '(?=(?P<TsuI>GCGAC))|(?=(?P<TsuI_as>GTCGC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GCGAC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['TsuI'] = _temp()


def _temp():
    return {
        'charac': (4, -4, None, None, 'GACNNNGTC'),
        'compsite': '(?=(?P<Tth111I>GAC...GTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -4,
        'fst5': 4,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACNNNGTC',
        'size': 9,
        'substrat': 'DNA',
        'suppl': ('I', 'K', 'N', 'Q', 'V', 'X'),
    }


rest_dict['Tth111I'] = _temp()


def _temp():
    return {
        'charac': (17, 9, None, None, 'CAARCA'),
        'compsite': '(?=(?P<Tth111II>CAA[AG]CA))|(?=(?P<Tth111II_as>TG[CT]TTG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': 9,
        'fst5': 17,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CAARCA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Tth111II'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TCGTA'),
        'compsite': '(?=(?P<UbaF11I>TCGTA))|(?=(?P<UbaF11I_as>TACGA))',
        'dna': None,
        'freq': 1024.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCGTA',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['UbaF11I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CTACNNNGTC'),
        'compsite': '(?=(?P<UbaF12I>CTAC...GTC))|(?=(?P<UbaF12I_as>GAC...GTAG))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTACNNNGTC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['UbaF12I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'GAGNNNNNNCTGG'),
        'compsite': '(?=(?P<UbaF13I>GAG......CTGG))|(?=(?P<UbaF13I_as>CCAG......CTC))',
        'dna': None,
        'freq': 16384.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAGNNNNNNCTGG',
        'size': 13,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['UbaF13I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CCANNNNNTCG'),
        'compsite': '(?=(?P<UbaF14I>CCA.....TCG))|(?=(?P<UbaF14I_as>CGA.....TGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCANNNNNTCG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['UbaF14I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TACNNNNNRTGT'),
        'compsite': '(?=(?P<UbaF9I>TAC.....[AG]TGT))|(?=(?P<UbaF9I_as>ACA[CT].....GTA))',
        'dna': None,
        'freq': 8192.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TACNNNNNRTGT',
        'size': 12,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['UbaF9I'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGAACG'),
        'compsite': '(?=(?P<UbaPI>CGAACG))|(?=(?P<UbaPI_as>CGTTCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGAACG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['UbaPI'] = _temp()


def _temp():
    return {
        'charac': (-7, -11, 11, 7, 'GAGCTC'),
        'compsite': '(?=(?P<UcoMSI>GAGCTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -11,
        'fst5': -7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': 7,
        'scd5': 11,
        'site': 'GAGCTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['UcoMSI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GGNCC'),
        'compsite': '(?=(?P<UnbI>GG.CC))',
        'dna': None,
        'freq': 256.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GGNCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGNCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['UnbI'] = _temp()


def _temp():
    return {
        'charac': (7, -7, None, None, 'CCANNNNNTGG'),
        'compsite': '(?=(?P<Van91I>CCA.....TGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -7,
        'fst5': 7,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 3,
        'ovhgseq': 'NNN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCANNNNNTGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('B', 'K'),
    }


rest_dict['Van91I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTTAAG'),
        'compsite': '(?=(?P<Vha464I>CTTAAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TTAA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTTAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('V',),
    }


rest_dict['Vha464I'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GTGCAC'),
        'compsite': '(?=(?P<VneI>GTGCAC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTGCAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['VneI'] = _temp()


def _temp():
    return {
        'charac': (0, 0, None, None, 'GGWCC'),
        'compsite': '(?=(?P<VpaK11AI>GG[AT]CC))',
        'dna': None,
        'freq': 512.0,
        'fst3': 0,
        'fst5': 0,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -5,
        'ovhgseq': 'GGWCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGWCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['VpaK11AI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'GGWCC'),
        'compsite': '(?=(?P<VpaK11BI>GG[AT]CC))',
        'dna': None,
        'freq': 512.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -3,
        'ovhgseq': 'GWC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GGWCC',
        'size': 5,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['VpaK11BI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'ATTAAT'),
        'compsite': '(?=(?P<VspI>ATTAAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATTAAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'I', 'R', 'V'),
    }


rest_dict['VspI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CACRAYC'),
        'compsite': '(?=(?P<Vtu19109I>CAC[AG]A[CT]C))|(?=(?P<Vtu19109I_as>G[AG]T[CT]GTG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACRAYC',
        'size': 7,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Vtu19109I'] = _temp()


def _temp():
    return {
        'charac': (27, 19, None, None, 'CACRAG'),
        'compsite': '(?=(?P<WviI>CAC[AG]AG))|(?=(?P<WviI_as>CT[CT]GTG))',
        'dna': None,
        'freq': 2048.0,
        'fst3': 19,
        'fst5': 27,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 2,
        'ovhgseq': 'NN',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CACRAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['WviI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'CCTNNNNNAGG'),
        'compsite': '(?=(?P<XagI>CCT.....AGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTNNNNNAGG',
        'size': 11,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['XagI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RAATTY'),
        'compsite': '(?=(?P<XapI>[AG]AATT[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'AATT',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RAATTY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['XapI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'TCTAGA'),
        'compsite': '(?=(?P<XbaI>TCTAGA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TCTAGA',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
    }


rest_dict['XbaI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'TACGAG'),
        'compsite': '(?=(?P<Xca85IV>TACGAG))|(?=(?P<Xca85IV_as>CTCGTA))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'TACGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Xca85IV'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'RCATGY'),
        'compsite': '(?=(?P<XceI>[AG]CATG[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'CATG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RCATGY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['XceI'] = _temp()


def _temp():
    return {
        'charac': (8, -8, None, None, 'CCANNNNNNNNNTGG'),
        'compsite': '(?=(?P<XcmI>CCA.........TGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -8,
        'fst5': 8,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCANNNNNNNNNTGG',
        'size': 15,
        'substrat': 'DNA',
        'suppl': ('N',),
    }


rest_dict['XcmI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTCGAG'),
        'compsite': '(?=(?P<XhoI>CTCGAG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'TCGA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTCGAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
    }


rest_dict['XhoI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'RGATCY'),
        'compsite': '(?=(?P<XhoII>[AG]GATC[CT]))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GATC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'RGATCY',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['XhoII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCCGGG'),
        'compsite': '(?=(?P<XmaI>CCCGGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CCGG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCCGGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N', 'R', 'V'),
    }


rest_dict['XmaI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CGGCCG'),
        'compsite': '(?=(?P<XmaIII>CGGCCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'GGCC',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGCCG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['XmaIII'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CCTAGG'),
        'compsite': '(?=(?P<XmaJI>CCTAGG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -4,
        'ovhgseq': 'CTAG',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CCTAGG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['XmaJI'] = _temp()


def _temp():
    return {
        'charac': (2, -2, None, None, 'GTMKAC'),
        'compsite': '(?=(?P<XmiI>GT[AC][GT]AC))',
        'dna': None,
        'freq': 1024.0,
        'fst3': -2,
        'fst5': 2,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'MK',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GTMKAC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('B',),
    }


rest_dict['XmiI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'GAANNNNTTC'),
        'compsite': '(?=(?P<XmnI>GAA....TTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GAANNNNTTC',
        'size': 10,
        'substrat': 'DNA',
        'suppl': ('N', 'R'),
    }


rest_dict['XmnI'] = _temp()


def _temp():
    return {
        'charac': (1, -1, None, None, 'CTAG'),
        'compsite': '(?=(?P<XspI>CTAG))',
        'dna': None,
        'freq': 256.0,
        'fst3': -1,
        'fst5': 1,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': -2,
        'ovhgseq': 'TA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CTAG',
        'size': 4,
        'substrat': 'DNA',
        'suppl': ('K',),
    }


rest_dict['XspI'] = _temp()


def _temp():
    return {
        'charac': (11, 9, None, None, 'C'),
        'compsite': '(?=(?P<YkrI>C))|(?=(?P<YkrI_as>G))',
        'dna': None,
        'freq': 4.0,
        'fst3': 9,
        'fst5': 11,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 1,
        'ovhgseq': 'N',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'C',
        'size': 1,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['YkrI'] = _temp()


def _temp():
    return {
        'charac': (None, None, None, None, 'CGGAAG'),
        'compsite': '(?=(?P<Yps3606I>CGGAAG))|(?=(?P<Yps3606I_as>CTTCCG))',
        'dna': None,
        'freq': 4096.0,
        'fst3': None,
        'fst5': None,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': None,
        'ovhgseq': None,
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'CGGAAG',
        'size': 6,
        'substrat': 'DNA',
        'suppl': (),
    }


rest_dict['Yps3606I'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'GACGTC'),
        'compsite': '(?=(?P<ZraI>GACGTC))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'GACGTC',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'N', 'V'),
    }


rest_dict['ZraI'] = _temp()


def _temp():
    return {
        'charac': (3, -3, None, None, 'AGTACT'),
        'compsite': '(?=(?P<ZrmI>AGTACT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -3,
        'fst5': 3,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 0,
        'ovhgseq': '',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'AGTACT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I',),
    }


rest_dict['ZrmI'] = _temp()


def _temp():
    return {
        'charac': (5, -5, None, None, 'ATGCAT'),
        'compsite': '(?=(?P<Zsp2I>ATGCAT))',
        'dna': None,
        'freq': 4096.0,
        'fst3': -5,
        'fst5': 5,
        'inact_temp': 65,
        'opt_temp': 37,
        'ovhg': 4,
        'ovhgseq': 'TGCA',
        'results': None,
        'scd3': None,
        'scd5': None,
        'site': 'ATGCAT',
        'size': 6,
        'substrat': 'DNA',
        'suppl': ('I', 'V'),
    }


rest_dict['Zsp2I'] = _temp()


suppliers = {}


def _temp():
    return (
        'Life Technologies',
        ['Bsp120I', 'Eco52I', 'Ecl136II', 'Bme1390I', 'XceI', 'RruI', 'XagI', 'Hin6I', 'HpyF3I', 'Ppu21I', 'Cfr13I', 'SacII', 'Hpy8I', 'BseLI', 'HpyF10VI', 'EheI', 'NmuCI', 'Alw26I', 'SgeI', 'BseMII', 'XbaI', 'BglII', 'Bsp143I', 'BmeT110I', 'NotI', 'Psp1406I', 'PfeI', 'LweI', 'AanI', 'CsiI', 'Eco147I', 'SsiI', 'ApaI', 'SfiI', 'SgsI', 'EcoO109I', 'SphI', 'CseI', 'MboI', 'Bsp68I', 'FokI', 'CaiI', 'FspAI', 'Alw44I', 'BglI', 'Lsp1109I', 'Eco88I', 'BspOI', 'AasI', 'PauI', 'Cfr10I', 'PstI', 'SdaI', 'PasI', 'ClaI', 'NdeI', 'Eco105I', 'Bst1107I', 'BseDI', 'Bpu1102I', 'PvuI', 'BstXI', 'BamHI', 'Bsh1285I', 'AjiI', 'Mph1103I', 'Pfl23II', 'SfaAI', 'DraI', 'XhoI', 'XmiI', 'SduI', 'HapII', 'LguI', 'SatI', 'HpaII', 'Kpn2I', 'BcnI', 'BveI', 'TaiI', 'HhaI', 'Eam1104I', 'HincII', 'AjuI', 'AdeI', 'RseI', 'MnlI', 'BshTI', 'ScaI', 'BshNI', 'KspAI', 'BauI', 'BseSI', 'HpaI', 'Mva1269I', 'TscAI', 'MbiI', 'TaaI', 'PfoI', 'FspBI', 'SspI', 'Eam1105I', 'Bpu10I', 'NruI', 'OliI', 'EcoRV', 'PaeI', 'Van91I', 'Eco130I', 'Bsu15I', 'BclI', 'Alw21I', 'VspI', 'SmaI', 'MauBI', 'Hin1II', 'BseGI', 'PsyI', 'Psp5II', 'Csp6I', 'NsbI', 'TasI', 'BpiI', 'MluI', 'BcuI', 'BoxI', 'PvuII', 'Tru1I', 'PsuI', 'SalI', 'TatI', 'XmaJI', 'FaqI', 'BspPI', 'StuI', 'DpnI', 'SgrDI', 'AluI', 'NheI', 'XapI', 'CpoI', 'HindIII', 'BseMI', 'RsaI', 'Cfr9I', 'SmiI', 'BspTI', 'BfoI', 'AatII', 'SacI', 'BfmI', 'Eco81I', 'Bsp119I', 'NcoI', 'MlsI', 'SmoI', 'Bsh1236I', 'BfuI', 'SchI', 'PdiI', 'GsuI', 'Eco57I', 'KflI', 'SaqAI', 'BspLI', 'AloI', 'BmsI', 'SpeI', 'AccI', 'Eco31I', 'Cfr42I', 'PdmI', 'MssI', 'TaqI', 'MunI', 'MspI', 'Eco47I', 'AfaI', 'SspDI', 'EcoT22I', 'PagI', 'Hin1I', 'BsuRI', 'Acc65I', 'Bsp1407I', 'PscI', 'PspFI', 'Eco91I', 'BplI', 'Eco47III', 'BseNI', 'HphI', 'EcoRI', 'EcoRII', 'KpnI', 'MvaI', 'MboII', 'TauI', 'HinfI', 'BseXI', 'AarI', 'Eco24I', 'HaeIII', 'MreI', 'BseJI', 'Eco32I', 'Eco72I', 'Esp3I', 'PteI', 'PacI', 'BalI'],
    )


suppliers['B'] = _temp()


def _temp():
    return (
        'Minotech Biotechnology',
        ['SgrBI', 'XbaI', 'BglII', 'BseCI', 'NotI', 'SfiI', 'SphI', 'SlaI', 'MboI', 'MspCI', 'SstI', 'BglI', 'CspAI', 'PstI', 'BamHI', 'ApaLI', 'AsuII', 'SseBI', 'BssAI', 'ScaI', 'HpaI', 'SspI', 'NruI', 'EcoRV', 'BclI', 'SmaI', 'BsiSI', 'Sau3AI', 'PvuII', 'SalI', 'StyI', 'BstEII', 'BseAI', 'AluI', 'NheI', 'PspPI', 'HindIII', 'RsaI', 'NcoI', 'TaqI', 'BseBI', 'SnaBI', 'EcoRI', 'BshFI', 'KpnI', 'HinfI', 'NaeI'],
    )


suppliers['C'] = _temp()


def _temp():
    return (
        'Agilent Technologies',
        ['DpnI'],
    )


suppliers['E'] = _temp()


def _temp():
    return (
        'SibEnzyme Ltd.',
        ['BsuI', 'BstHHI', 'PspXI', 'AsuC2I', 'RgaI', 'BlsI', 'BstPAI', 'AspS9I', 'PpsI', 'AclI', 'GlaI', 'XbaI', 'BglII', 'AsuHPI', 'BstMBI', 'AbsI', 'MalI', 'PceI', 'BstX2I', 'BstSCI', 'BstDSI', 'AluBI', 'ApaI', 'CciI', 'SfiI', 'SphI', 'FblI', 'MfeI', 'FokI', 'AsiGI', 'Bst2BI', 'Bst2UI', 'PalAI', 'MspR9I', 'Rsr2I', 'BglI', 'Sse9I', 'MspA1I', 'BspACI', 'BstMAI', 'BstBAI', 'Tth111I', 'Ama87I', 'DriI', 'PstI', 'Bso31I', 'SetI', 'BstDEI', 'MhlI', 'SmiMI', 'BstXI', 'Bse8I', 'BamHI', 'BstACI', 'BstKTI', 'BssECI', 'BslFI', 'BstV2I', 'PsiI', 'DraI', 'Bse21I', 'BstMWI', 'FauNDI', 'Bsp19I', 'Zsp2I', 'AccB1I', 'Ple19I', 'HpaII', 'PcsI', 'BstH2I', 'CciNI', 'SspMI', 'PspPPI', 'Ksp22I', 'GluI', 'Sfr274I', 'AcoI', 'Bsp13I', 'RsaNI', 'Fsp4HI', 'FalI', 'BsePI', 'SfaNI', 'MnlI', 'DseDI', 'EgeI', 'DraIII', 'BstC8I', 'Mox20I', 'BstSFI', 'Kzo9I', 'Psp6I', 'MabI', 'HpaI', 'ZraI', 'BstAFI', 'PkrI', 'BtrI', 'PspLI', 'Bme18I', 'FatI', 'VneI', 'XmaI', 'SspI', 'Bse1I', 'Bpu10I', 'NruI', 'KroI', 'AccBSI', 'EcoRV', 'AsiSI', 'BpmI', 'AcsI', 'PctI', 'VspI', 'BmuI', 'HgaI', 'AspLEI', 'BstSLI', 'HindII', 'Bst4CI', 'SmaI', 'PstNI', 'BstNSI', 'Bst6I', 'Sfr303I', 'BssT1I', 'Bbv12I', 'GsaI', 'BisI', 'Bsa29I', 'AcuI', 'BstENI', 'Psp124BI', 'AclWI', 'Bse118I', 'MluI', 'PspOMI', 'PvuII', 'BstAUI', 'AgsI', 'SalI', 'FaeI', 'BstSNI', 'Bsc4I', 'AluI', 'ArsI', 'AjnI', 'RigI', 'Acc36I', 'HindIII', 'AspA2I', 'RsaI', 'FaiI', 'SmiI', 'LmnI', 'MroXI', 'AatII', 'ErhI', 'BstV1I', 'ZrmI', 'MteI', 'Bse3DI', 'BstFNI', 'EcoICRI', 'SbfI', 'PspCI', 'AsuNHI', 'TaqI', 'Acc16I', 'MspI', 'PspEI', 'AfeI', 'BseX3I', 'FauI', 'BarI', 'Bpu14I', 'BsuRI', 'HspAI', 'Acc65I', 'BspFNI', 'Tru9I', 'AhlI', 'AoxI', 'EcoRI', 'BstMCI', 'AccB7I', 'KpnI', 'BssNAI', 'MboII', 'TseFI', 'HinfI', 'BmtI', 'BstF5I', 'HaeIII', 'PspN4I', 'FriOI', 'PciI', 'PciSI', 'HpySE526I', 'MroNI', 'Bsp1720I', 'BstAPI', 'Mly113I', 'PsrI'],
    )


suppliers['I'] = _temp()


def _temp():
    return (
        'Nippon Gene Co., Ltd.',
        ['SacII', 'XbaI', 'FspI', 'BglII', 'NotI', 'AxyI', 'ApaI', 'SfiI', 'EcoO109I', 'BssHII', 'SphI', 'FokI', 'Alw44I', 'BglI', 'PstI', 'NdeI', 'AflII', 'NspV', 'BstXI', 'BamHI', 'AseI', 'AccIII', 'DraI', 'XhoI', 'ScrFI', 'EcoT38I', 'AvaII', 'HhaI', 'HincII', 'AgeI', 'ScaI', 'Bsp1286I', 'AvaI', 'Sau96I', 'HpaI', 'SspI', 'NruI', 'EcoRV', 'NciI', 'BclI', 'AccII', 'SmaI', 'Sau3AI', 'MluI', 'PvuII', 'SalI', 'StyI', 'BstEII', 'StuI', 'AluI', 'NheI', 'HindIII', 'RsaI', 'SacI', 'NcoI', 'SwaI', 'SpeI', 'AccI', 'TaqI', 'MspI', 'NdeII', 'AcyI', 'HaeII', 'NsiI', 'EcoRI', 'NarI', 'EcoRII', 'KpnI', 'BsmI', 'MboII', 'HinfI', 'HaeIII', 'BalI'],
    )


suppliers['J'] = _temp()


def _temp():
    return (
        'Takara Bio Inc.',
        ['Eco52I', 'SacII', 'Aor13HI', 'XbaI', 'BglII', 'Aor51HI', 'BmeT110I', 'NotI', 'Psp1406I', 'ApaI', 'SfiI', 'EcoO109I', 'BssHII', 'SphI', 'MboI', 'PshBI', 'FokI', 'BglI', 'Cfr10I', 'Tth111I', 'PstI', 'ClaI', 'NdeI', 'AflII', 'BspT107I', 'Bst1107I', 'Bpu1102I', 'PvuI', 'BstXI', 'BamHI', 'BspT104I', 'ApaLI', 'AccIII', 'DraI', 'XhoI', 'HapII', 'BciT130I', 'BcnI', 'HhaI', 'HincII', 'ScaI', 'Bsp1286I', 'DdeI', 'EcoO65I', 'HpaI', 'EcoT14I', 'PmaCI', 'SspI', 'NruI', 'EcoRV', 'Van91I', 'VpaK11BI', 'AccII', 'PshAI', 'SmaI', 'Sau3AI', 'NsbI', 'MluI', 'PvuII', 'SalI', 'FbaI', 'StuI', 'DpnI', 'AluI', 'NheI', 'CpoI', 'HindIII', 'SmiI', 'AatII', 'SacI', 'Eco81I', 'NcoI', 'MflI', 'XspI', 'SpeI', 'AccI', 'TaqI', 'MunI', 'MspI', 'AfaI', 'BanII', 'EcoT22I', 'BstPI', 'BlnI', 'Hin1I', 'Bsp1407I', 'HaeII', 'SnaBI', 'EcoRI', 'KpnI', 'MboII', 'HinfI', 'HaeIII', 'NaeI', 'Sse8387I', 'BmgT120I', 'EaeI', 'BalI'],
    )


suppliers['K'] = _temp()


def _temp():
    return (
        'Roche Applied Science',
        ['XbaI', 'BglII', 'NotI', 'SfuI', 'ApaI', 'SfiI', 'BssHII', 'SphI', 'FokI', 'PstI', 'ClaI', 'NdeI', 'PvuI', 'BstXI', 'BamHI', 'DraI', 'XhoI', 'MaeIII', 'Asp718I', 'ScaI', 'DraIII', 'DdeI', 'MroI', 'HpaI', 'NruI', 'EcoRV', 'MvnI', 'BclI', 'HindII', 'SmaI', 'KspI', 'Sau3AI', 'Asp700I', 'MluI', 'PvuII', 'MaeI', 'SalI', 'StuI', 'DpnI', 'AluI', 'NheI', 'HindIII', 'RsaI', 'AatII', 'SacI', 'AflIII', 'NcoI', 'SwaI', 'SpeI', 'AccI', 'TaqI', 'MunI', 'CfoI', 'BfrI', 'NdeII', 'BlnI', 'BbrPI', 'Tru9I', 'NsiI', 'Eco47III', 'SnaBI', 'EcoRI', 'NarI', 'KpnI', 'MvaI', 'BsmI', 'HinfI', 'MluNI', 'HaeIII', 'MaeII', 'SexAI'],
    )


suppliers['M'] = _temp()


def _temp():
    return (
        'New England Biolabs',
        ['BsaJI', 'PflMI', 'NmeAIII', 'EcoNI', 'MslI', 'AciI', 'Tsp45I', 'XmnI', 'BstUI', 'CviAII', 'PspXI', 'ApoI', 'SacII', 'BmgBI', 'HpyCH4III', 'TspRI', 'MwoI', 'NlaIII', 'AclI', 'HinP1I', 'BseRI', 'PflFI', 'XbaI', 'FspI', 'BaeI', 'BglII', 'BccI', 'CspCI', 'MscI', 'NotI', 'BsaI', 'BsiEI', 'BsoBI', 'BssSI', 'ApaI', 'SfiI', 'EcoO109I', 'BsmFI', 'BssHII', 'SphI', 'HpyCH4V', 'BtgZI', 'BsiHKAI', 'MfeI', 'MboI', 'FokI', 'BsmBI', 'BsrI', 'PmlI', 'AlwI', 'BceAI', 'BglI', 'MspA1I', 'NlaIV', 'MluCI', 'PleI', 'Tth111I', 'TseI', 'BspMI', 'RsrII', 'PstI', 'AbaSI', 'Fnu4HI', 'BanI', 'ClaI', 'NdeI', 'AflII', 'BtsI', 'MmeI', 'PvuI', 'BstXI', 'BamHI', 'BfuAI', 'LpnPI', 'ApaLI', 'AseI', 'PsiI', 'DraI', 'XhoI', 'BaeGI', 'ScrFI', 'MseI', 'SrfI', 'HpaII', 'BcoDI', 'KasI', 'BsaBI', 'AvaII', 'SapI', 'BsmAI', 'HhaI', 'BsgI', 'HincII', 'PluTI', 'SfaNI', 'MnlI', 'AgeI', 'AleI', 'Cac8I', 'ScaI', 'BlpI', 'DraIII', 'BstNI', 'SfoI', 'Bsu36I', 'Bsp1286I', 'EciI', 'AvaI', 'DdeI', 'BbvCI', 'BsrFI', 'DpnII', 'Sau96I', 'HpaI', 'EarI', 'PmeI', 'ZraI', 'FatI', 'BstYI', 'XmaI', 'SspI', 'Bpu10I', 'NruI', 'FspEI', 'TfiI', 'EagI', 'EcoRV', 'SgrAI', 'AsiSI', 'FseI', 'BpmI', 'BciVI', 'NciI', 'BpuEI', 'BclI', 'HgaI', 'PspGI', 'PshAI', 'AvrII', 'BsrGI', 'BbvI', 'SmaI', 'ApeKI', 'CviKI_1', 'BsaHI', 'BsiWI', 'AcuI', 'Sau3AI', 'SfcI', 'MluI', 'PspOMI', 'PvuII', 'AhdI', 'CviQI', 'BspHI', 'BseYI', 'HpyAV', 'BtgI', 'SalI', 'StyI', 'Eco53kI', 'BstEII', 'StuI', 'DpnI', 'MspJI', 'AluI', 'BtsCI', 'NheI', 'HindIII', 'BsrDI', 'RsaI', 'Hpy188III', 'BfaI', 'NgoMIV', 'AatII', 'BspCNI', 'SacI', 'AflIII', 'PaeR7I', 'NcoI', 'BstZ17I', 'BspQI', 'SwaI', 'SbfI', 'BsaXI', 'BspEI', 'Hpy166II', 'BbsI', 'SpeI', 'Hpy99I', 'AccI', 'TaqI', 'BcgI', 'MspI', 'BanII', 'AfeI', 'FauI', 'TspMI', 'BtsIMutI', 'Acc65I', 'NspI', 'HaeII', 'NsiI', 'BsrBI', 'BslI', 'StyD4I', 'BstBI', 'SnaBI', 'HphI', 'EcoRI', 'NarI', 'Hpy188I', 'BsaAI', 'KpnI', 'BmrI', 'AscI', 'BsmI', 'MboII', 'BspDI', 'HinfI', 'BmtI', 'AlwNI', 'SmlI', 'HaeIII', 'NaeI', 'PciI', 'SexAI', 'XcmI', 'PacI', 'BstAPI', 'BsaWI', 'PpuMI', 'HpyCH4IV', 'MlyI', 'EaeI', 'DrdI'],
    )


suppliers['N'] = _temp()


def _temp():
    return (
        'Toyobo Biochemicals',
        ['SacII', 'BglII', 'MscI', 'NotI', 'SfiI', 'SphI', 'BglI', 'PstI', 'PvuI', 'BamHI', 'XhoI', 'HincII', 'ScaI', 'DdeI', 'MroI', 'EcoRV', 'BclI', 'SmaI', 'MluI', 'PvuII', 'SalI', 'DpnI', 'AluI', 'NheI', 'HindIII', 'SacI', 'NcoI', 'SpeI', 'EcoRI', 'KpnI', 'HinfI', 'HaeIII', 'PacI'],
    )


suppliers['O'] = _temp()


def _temp():
    return (
        'Molecular Biology Resources - CHIMERx',
        ['SacII', 'XbaI', 'BglII', 'NotI', 'BsiHKCI', 'ApaI', 'SfiI', 'BssHII', 'SphI', 'MboI', 'BglI', 'Tth111I', 'RsrII', 'PstI', 'ClaI', 'NdeI', 'PvuI', 'BstXI', 'BamHI', 'PinAI', 'DraI', 'XhoI', 'HpaII', 'TaqII', 'HhaI', 'HincII', 'MnlI', 'ScaI', 'TspDTI', 'AvaI', 'DdeI', 'HpaI', 'SspI', 'NruI', 'EcoRV', 'SmaI', 'MluI', 'PvuII', 'SalI', 'StuI', 'DpnI', 'AluI', 'NheI', 'HindIII', 'RsaI', 'SacI', 'NcoI', 'TspGWI', 'SpeI', 'AccI', 'TaqI', 'MspI', 'NsiI', 'EcoRI', 'NarI', 'CviJI', 'KpnI', 'MboII', 'AcvI', 'HinfI', 'HaeIII', 'BalI'],
    )


suppliers['Q'] = _temp()


def _temp():
    return (
        'Promega Corporation',
        ['XmnI', 'SacII', 'XbaI', 'BglII', 'NotI', 'ApaI', 'SfiI', 'BssHII', 'SphI', 'MboI', 'BglI', 'MspA1I', 'PstI', 'BanI', 'ClaI', 'NdeI', 'CspI', 'PvuI', 'BstXI', 'BamHI', 'AccIII', 'DraI', 'XhoI', 'SgfI', 'HpaII', 'AvaII', 'HhaI', 'HincII', 'AgeI', 'ScaI', 'DdeI', 'HpaI', 'Hsp92II', 'XmaI', 'SspI', 'NruI', 'EcoRV', 'NciI', 'BclI', 'VspI', 'SmaI', 'Sau3AI', 'BstZI', 'MluI', 'PvuII', 'SalI', 'BstEII', 'StuI', 'DpnI', 'AluI', 'Hsp92I', 'NheI', 'HindIII', 'RsaI', 'SacI', 'NcoI', 'EcoICRI', 'SpeI', 'AccI', 'TaqI', 'MspI', 'CfoI', 'Tru9I', 'HaeII', 'NsiI', 'Eco47III', 'SnaBI', 'EcoRI', 'NarI', 'KpnI', 'MboII', 'HinfI', 'HaeIII', 'BalI'],
    )


suppliers['R'] = _temp()


def _temp():
    return (
        'Sigma Chemical Corporation',
        ['XbaI', 'BglII', 'NotI', 'SfuI', 'ApaI', 'SfiI', 'SphI', 'PstI', 'ClaI', 'NdeI', 'PvuI', 'BamHI', 'DraI', 'XhoI', 'MaeIII', 'Asp718I', 'ScaI', 'DdeI', 'HpaI', 'NruI', 'EcoRV', 'BclI', 'HindII', 'SmaI', 'KspI', 'MluI', 'PvuII', 'SalI', 'StuI', 'DpnI', 'AluI', 'NheI', 'HindIII', 'RsaI', 'SacI', 'AflIII', 'NcoI', 'SwaI', 'SpeI', 'TaqI', 'MunI', 'CfoI', 'BfrI', 'BlnI', 'NsiI', 'Eco47III', 'EcoRI', 'NarI', 'KpnI', 'BsmI', 'HinfI', 'HaeIII', 'EclXI'],
    )


suppliers['S'] = _temp()


def _temp():
    return (
        'Vivantis Technologies',
        ['BstHHI', 'BmeRI', 'BstPAI', 'AspS9I', 'AclI', 'XbaI', 'BglII', 'AsuHPI', 'BstMBI', 'PceI', 'BstX2I', 'BstDSI', 'ApaI', 'SfiI', 'SphI', 'BshVI', 'BtuMI', 'FblI', 'FokI', 'AsiGI', 'Bst2UI', 'Rsr2I', 'BglI', 'Sse9I', 'MspA1I', 'BstMAI', 'BstBAI', 'Tth111I', 'Ama87I', 'PstI', 'BmcAI', 'BmrFI', 'Bso31I', 'BpuMI', 'BstDEI', 'MhlI', 'SmiMI', 'BstXI', 'Bse8I', 'BamHI', 'Msp20I', 'BstV2I', 'DraI', 'Bse21I', 'FauNDI', 'Bsp19I', 'Zsp2I', 'AccB1I', 'HpaII', 'BstH2I', 'CciNI', 'Ksp22I', 'Sfr274I', 'Bsp13I', 'BsePI', 'SfaNI', 'MnlI', 'DseDI', 'DraIII', 'HpaI', 'ZraI', 'AfiI', 'Bme18I', 'VneI', 'XmaI', 'SspI', 'Bse1I', 'Bpu10I', 'AccBSI', 'EcoRV', 'AcsI', 'PctI', 'VspI', 'AspLEI', 'HindII', 'Bst4CI', 'SmaI', 'BstNSI', 'Bst6I', 'Sfr303I', 'BssT1I', 'Bbv12I', 'BstENI', 'Psp124BI', 'Bse118I', 'MluI', 'PspOMI', 'PvuII', 'BstAUI', 'SalI', 'BstSNI', 'BsnI', 'AluI', 'HindIII', 'AspA2I', 'RsaI', 'SmiI', 'BssNI', 'MroXI', 'AatII', 'Bse3DI', 'BstFNI', 'EcoICRI', 'BmiI', 'SbfI', 'PspCI', 'AsuNHI', 'Vha464I', 'TaqI', 'Acc16I', 'MspI', 'PspEI', 'BseX3I', 'Bpu14I', 'HspAI', 'Acc65I', 'Tru9I', 'AhlI', 'EcoRI', 'BstMCI', 'AccB7I', 'KpnI', 'BssNAI', 'MboII', 'HinfI', 'BmtI', 'BstF5I', 'DinI', 'BssMI', 'FriOI', 'MroNI', 'Bsp1720I'],
    )


suppliers['V'] = _temp()


def _temp():
    return (
        'EURx Ltd.',
        ['SacII', 'XbaI', 'BglII', 'NotI', 'BsiHKCI', 'ApaI', 'SfiI', 'BssHII', 'SphI', 'MboI', 'FokI', 'BglI', 'Tth111I', 'RsrII', 'PstI', 'ClaI', 'NdeI', 'MmeI', 'PvuI', 'BstXI', 'BamHI', 'PinAI', 'DraI', 'XhoI', 'HpaII', 'TaqII', 'AvaII', 'HhaI', 'HincII', 'BspMAI', 'MnlI', 'ScaI', 'TspDTI', 'AvaI', 'DdeI', 'HpaI', 'SspI', 'NruI', 'EcoRV', 'SinI', 'SmaI', 'Sau3AI', 'MluI', 'PvuII', 'SalI', 'StuI', 'DpnI', 'AluI', 'NheI', 'BsuTUI', 'HindIII', 'RsaI', 'SacI', 'BspANI', 'NcoI', 'TspGWI', 'SpeI', 'AccI', 'TaqI', 'MspI', 'BanII', 'NsiI', 'BspTNI', 'EcoRI', 'NarI', 'CviJI', 'KpnI', 'MboII', 'AcvI', 'HinfI', 'HaeIII', 'BalI'],
    )


suppliers['X'] = _temp()


def _temp():
    return (
        'SinaClon BioScience Co.',
        ['SlaI', 'MboI', 'FokI', 'BstXI', 'BamHI', 'SmaI', 'BsiSI', 'AluI', 'HindIII', 'RsaI', 'NcoI', 'EcoRI', 'KpnI', 'HinfI'],
    )


suppliers['Y'] = _temp()


typedict = {}


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['NmeDI'],
    )


typedict['type130'] = _temp()


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['UcoMSI'],
    )


typedict['type132'] = _temp()


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['RdeGBIII'],
    )


typedict['type142'] = _temp()


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['FalI', 'BplI'],
    )


typedict['type143'] = _temp()


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BdaI', 'AlfI'],
    )


typedict['type144'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['Sno506I', 'Cla11845III', 'Hpy99XIV', 'Lmo370I', 'Pdi8503III', 'Pac19842II', 'AteTI', 'Sth20745III', 'Sen1880IV', 'RflFIII', 'MspI7II', 'Ecl35734I', 'PacIII', 'Hpy99XIII', 'TspARh3I', 'SenC1810IV', 'AhyRBAHI', 'Mcr10I', 'Sbo46I', 'Saf8902III', 'Sen1910IV', 'Hpy99XXII', 'Pst273I', 'Sen13311III', 'Kor51II', 'Awo1030IV', 'EsaSSI', 'PliMI', 'HbaII', 'Hpy99XIV_mut1', 'Cly7489II', 'CjeNV', 'Jsp2502II', 'BfaSII', 'Pse18267I', 'SenC1808III', 'Asp114II', 'RspPBTS2III', 'Bce3081I', 'PcaII', 'SenSARA26III', 'DrdII', 'PfrJS12V', 'MkaDII', 'SpoDI', 'Jma19592II', 'Pal408I', 'Ble402II', 'Adh6U21I', 'Lsp6406VI', 'Exi27195I', 'RdeGBI', 'Cal14237I', 'Rsp008V', 'Acc65V', 'Nal45188II', 'Eco4465II', 'KpnNIH30III', 'Cau10061II', 'Ssp714II', 'Mba11I', 'Pdu1735I', 'Sen1898IV', 'Bag18758I', 'Yps3606I', 'NpeUS61II', 'AspJHL3II', 'Rba2021I', 'OspHL35III', 'ScoDS2II', 'AbaCIII', 'CjeFV', 'Sen1736II', 'Lmo911II', 'HpyAXIV', 'Ssp6803IV', 'Cdi11397I', 'AspDUT2V', 'RpaTI', 'Sen1878IV', 'BscGI', 'Xca85IV', 'Psp0357II', 'FtnUV', 'Cma23826I', 'Rsp008IV', 'Cgl13032I', 'Sen1906IV', 'EcoMVII', 'Cbo67071IV', 'Nbr128II', 'MtuHN878II', 'Jma19592I', 'Gba708II', 'Bsp3004IV', 'Pst14472I', 'HpyUM032XIII_mut1', 'Sen1896IV', 'PfrJS12IV', 'NhaXI', 'Lba2029III', 'Aco12261II', 'HpyUM032XIV', 'Aba6411II', 'Eli8509II', 'Cba16038I', 'Esp3007I', 'Csp2014I', 'GauT27I', 'BloAII', 'Sty13348III', 'BanLI', 'HpyAXVI_mut1', 'PfrJS15III', 'Cdu23823II', 'Vtu19109I', 'Sen1908IV', 'CcrNAIII', 'Bsp460III', 'Cgl13032II', 'Cch467III', 'SenTFIV', 'Cfupf3II', 'HpyAXVI_mut2', 'Pin17FIII', 'SpnRII', 'Asu14238IV', 'Lsp48III', 'CalB3II', 'CjeFIII', 'AchA6III', 'Sen13III', 'AhyYL17I', 'EcoE1140I', 'CjeNII', 'Cdi81III', 'HpyUM037X', 'Cba13II'],
    )


typedict['type146'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['RlaI', 'BspNCI', 'AbaUMB2I', 'BspGI', 'UbaPI', 'BmgI', 'UbaF14I', 'FinI', 'CjeP659IV', 'AlwFI', 'TsuI', 'UbaF9I', 'UbaF13I', 'PsuGI', 'Pfl1108I', 'CjuII', 'UbaF12I', 'PenI', 'UbaF11I'],
    )


typedict['type148'] = _temp()


def _temp():
    return (
        ('Palindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['HpyUM032XIII', 'MjaIV'],
    )


typedict['type2'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BsrBI', 'MlyI'],
    )


typedict['type209'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['NgoAVII'],
    )


typedict['type210'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BmgBI', 'AjiI', 'MbiI', 'BtrI', 'AccBSI', 'SchI'],
    )


typedict['type211'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['CdiI', 'SspD5I'],
    )


typedict['type212'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['AciI', 'BssSI', 'BspACI', 'BbvCI'],
    )


typedict['type221'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['SsiI', 'Bst2BI', 'BauI', 'BseYI', 'PspFI'],
    )


typedict['type223'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['SimI', 'BsiI', 'GdiII'],
    )


typedict['type224'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['Alw26I', 'BccI', 'BsmFI', 'BtgZI', 'FokI', 'BsmBI', 'AlwI', 'BceAI', 'Lsp1109I', 'PleI', 'BspMI', 'BfuAI', 'BcoDI', 'BsmAI', 'Bpu10I', 'HgaI', 'BbvI', 'Eco31I', 'Esp3I'],
    )


typedict['type225'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['StsI', 'BscAI'],
    )


typedict['type226'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['PpsI', 'LweI', 'BsaI', 'CseI', 'BstMAI', 'Bso31I', 'LpnPI', 'BslFI', 'BstV2I', 'LguI', 'SapI', 'BveI', 'Eam1104I', 'SfaNI', 'EarI', 'FspEI', 'Bst6I', 'BpiI', 'AclWI', 'FaqI', 'BspPI', 'MspJI', 'Acc36I', 'BstV1I', 'BspQI', 'BmsI', 'BbsI', 'FauI', 'BspTNI', 'BseXI', 'AarI', 'PciSI'],
    )


typedict['type227'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['EcoBLMcrX', 'BspD6I', 'BbvII', 'BcefI', 'AspBHI', 'AceIII', 'Ksp632I', 'SgrTI', 'BinI', 'Sth132I'],
    )


typedict['type228'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['GsaI'],
    )


typedict['type235'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['NmeAIII', 'BseMII', 'BseRI', 'BsrI', 'MmeI', 'TaqII', 'BsgI', 'MnlI', 'BpmI', 'BpuEI', 'AcuI', 'HpyAV', 'BspCNI', 'TspGWI', 'Eco57I', 'HphI', 'BmrI', 'MboII', 'BstF5I'],
    )


typedict['type237'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['CstMI', 'BfiI', 'BsbI', 'CdpI', 'ApyPI', 'SdeAI', 'DraRI', 'RpaBI', 'TsoI', 'TaqIII', 'Tth111II', 'CchIII', 'PspPRI', 'AquII', 'AquIII', 'SstE37I', 'AmaCSI', 'RceI', 'WviI', 'PlaDI', 'CchII', 'RpaI', 'NlaCI', 'RpaB5I', 'RlaII', 'MaqI', 'CjeNIII', 'PspOMII', 'AquIV', 'RdeGBII'],
    )


typedict['type238'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BsuI', 'AsuHPI', 'AbaSI', 'BtsI', 'TspDTI', 'EciI', 'Mva1269I', 'Bse1I', 'BciVI', 'PctI', 'BmuI', 'BseGI', 'BtsCI', 'BsrDI', 'BseMI', 'LmnI', 'Bse3DI', 'BfuI', 'GsuI', 'BtsIMutI', 'BseNI', 'BsmI'],
    )


typedict['type239'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['Eco57MI', 'Bce83I', 'YkrI', 'Hin4II', 'BmeDI', 'RleAI'],
    )


typedict['type240'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BceSIV'],
    )


typedict['type274'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['CspCI', 'AloI', 'BcgI'],
    )


typedict['type285'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['NgoAVIII', 'TstI', 'SdeOSI', 'CjeI', 'PpiI'],
    )


typedict['type286'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BaeI', 'AjuI', 'ArsI', 'BsaXI', 'BarI', 'PsrI'],
    )


typedict['type287'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['Bsp24I', 'CjePI', 'Hin4I'],
    )


typedict['type288'] = _temp()


def _temp():
    return (
        ('Palindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['NhoI', 'AvaIII', 'HgiEII', 'TssI', 'SnaI', 'CjuI', 'Dde51507I'],
    )


typedict['type4'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['XmnI', 'BstUI', 'Hpy8I', 'FspI', 'AluBI', 'PmlI', 'MspA1I', 'NlaIV', 'DraI', 'HincII', 'AleI', 'Cac8I', 'ScaI', 'BstC8I', 'SfoI', 'HpaI', 'SspI', 'NruI', 'EcoRV', 'PshAI', 'HindII', 'SmaI', 'PvuII', 'AluI', 'RsaI', 'SwaI', 'BsuRI', 'SnaBI', 'BsaAI', 'CviJI', 'HaeIII', 'NaeI', 'BalI'],
    )


typedict['type65'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['FnuDII', 'CviRI', 'EsaBC3I'],
    )


typedict['type66'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['MslI', 'Ecl136II', 'RruI', 'Ppu21I', 'BstPAI', 'EheI', 'GlaI', 'Aor51HI', 'MalI', 'PceI', 'MscI', 'AanI', 'Eco147I', 'BtuMI', 'HpyCH4V', 'Bsp68I', 'FspAI', 'BstBAI', 'BmcAI', 'Eco105I', 'Bst1107I', 'SmiMI', 'Bse8I', 'Msp20I', 'PsiI', 'SrfI', 'BsaBI', 'SseBI', 'RseI', 'EgeI', 'Mox20I', 'KspAI', 'PmeI', 'ZraI', 'PmaCI', 'OliI', 'MvnI', 'AccII', 'CviKI_1', 'Asp700I', 'NsbI', 'BoxI', 'BstSNI', 'BsnI', 'Eco53kI', 'StuI', 'DpnI', 'FaiI', 'SmiI', 'MroXI', 'ZrmI', 'BspANI', 'BstZ17I', 'BstFNI', 'EcoICRI', 'BmiI', 'MlsI', 'Bsh1236I', 'PdiI', 'PspCI', 'BspLI', 'Hpy166II', 'PdmI', 'MssI', 'Acc16I', 'AfaI', 'AfeI', 'BbrPI', 'BspFNI', 'Eco47III', 'BshFI', 'BssNAI', 'AcvI', 'MluNI', 'DinI', 'PspN4I', 'BseJI', 'Eco32I', 'Eco72I'],
    )


typedict['type67'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['SciI', 'MstI', 'Sth302II', 'HaeI', 'AhaIII', 'Pfl8569I', 'NspBII', 'LpnI'],
    )


typedict['type68'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['CviAII', 'ApoI', 'AclI', 'HinP1I', 'XbaI', 'BglII', 'BseCI', 'NotI', 'BssHII', 'MfeI', 'MboI', 'Sse9I', 'Cfr10I', 'ClaI', 'NdeI', 'AflII', 'BamHI', 'ApaLI', 'AseI', 'XhoI', 'MseI', 'HapII', 'HpaII', 'Kpn2I', 'KasI', 'AgeI', 'BsrFI', 'DpnII', 'FatI', 'BstYI', 'XmaI', 'EagI', 'SgrAI', 'Bsu15I', 'BclI', 'VspI', 'BsaHI', 'Sau3AI', 'MluI', 'CviQI', 'BspHI', 'SalI', 'NheI', 'HindIII', 'Cfr9I', 'NgoMIV', 'PaeR7I', 'NcoI', 'TaqI', 'MunI', 'MspI', 'TspMI', 'HspAI', 'Acc65I', 'EcoRI', 'AscI', 'BsaWI', 'HpyCH4IV', 'EaeI'],
    )


typedict['type77'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['XhoII', 'XmaIII', 'CfrI'],
    )


typedict['type78'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['Bsp120I', 'Eco52I', 'PspXI', 'Hin6I', 'Aor13HI', 'BstMBI', 'AbsI', 'Bsp143I', 'BstX2I', 'Psp1406I', 'SfuI', 'CciI', 'SgsI', 'BshVI', 'SlaI', 'PshBI', 'AsiGI', 'MspCI', 'PalAI', 'Alw44I', 'MluCI', 'PauI', 'CspAI', 'NspV', 'BspT104I', 'BstACI', 'PinAI', 'Pfl23II', 'AccIII', 'FauNDI', 'Bsp19I', 'CciNI', 'SspMI', 'Ksp22I', 'Asp718I', 'AsuII', 'Sfr274I', 'AcoI', 'Bsp13I', 'BssAI', 'RsaNI', 'BsePI', 'BshTI', 'Kzo9I', 'MroI', 'BstAFI', 'PspLI', 'VneI', 'FspBI', 'KroI', 'AcsI', 'AvrII', 'BsrGI', 'MauBI', 'BsiSI', 'Bsa29I', 'BsiWI', 'Csp6I', 'BstZI', 'TasI', 'Bse118I', 'BcuI', 'PspOMI', 'MaeI', 'BstAUI', 'Tru1I', 'PsuI', 'FbaI', 'TatI', 'XmaJI', 'BseAI', 'SgrDI', 'Hsp92I', 'BsuTUI', 'XapI', 'AspA2I', 'BssNI', 'BfaI', 'BspTI', 'Bsp119I', 'MflI', 'SaqAI', 'XspI', 'BspEI', 'AsuNHI', 'SpeI', 'Vha464I', 'SspDI', 'BseX3I', 'BfrI', 'NdeII', 'PagI', 'BlnI', 'Hin1I', 'Bpu14I', 'AcyI', 'Bsp1407I', 'Tru9I', 'PscI', 'AhlI', 'BstBI', 'AoxI', 'NarI', 'BspDI', 'MreI', 'BssMI', 'MaeII', 'PciI', 'HpySE526I', 'MroNI', 'PteI', 'Mly113I', 'EclXI'],
    )


typedict['type79'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BspLU11I', 'Ppu10I', 'Sse232I', 'BetI', 'Asi256I', 'SelI', 'BspMII', 'SplI', 'TspEI'],
    )


typedict['type80'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BsaJI', 'EcoNI', 'Tsp45I', 'Cfr13I', 'AspS9I', 'BsoBI', 'EcoO109I', 'Tth111I', 'TseI', 'RsrII', 'Fnu4HI', 'BanI', 'BssECI', 'ScrFI', 'AvaII', 'BcnI', 'Fsp4HI', 'BlpI', 'BstNI', 'AvaI', 'DdeI', 'Sau96I', 'TfiI', 'NciI', 'SinI', 'PspGI', 'ApeKI', 'AjnI', 'PspPI', 'AflIII', 'AccI', 'StyD4I', 'EcoRII', 'MvaI', 'HinfI', 'SmlI', 'SexAI', 'PpuMI'],
    )


typedict['type81'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['HgiCI', 'EcoHI'],
    )


typedict['type82'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['Bme1390I', 'AsuC2I', 'XagI', 'HpyF3I', 'NmuCI', 'SgeI', 'PflFI', 'BmeT110I', 'BstSCI', 'AxyI', 'PfeI', 'CsiI', 'BstDSI', 'BsiHKCI', 'FblI', 'Bst2UI', 'MspR9I', 'Rsr2I', 'Eco88I', 'Ama87I', 'PasI', 'BmrFI', 'BspT107I', 'BpuMI', 'BstDEI', 'BseDI', 'Bpu1102I', 'CspI', 'XmiI', 'Bse21I', 'AccB1I', 'SatI', 'BciT130I', 'MaeIII', 'PspPPI', 'GluI', 'BshNI', 'BstSFI', 'Bsu36I', 'Psp6I', 'EcoO65I', 'MabI', 'Bme18I', 'PfoI', 'EcoT14I', 'Eco130I', 'VpaK11BI', 'PsyI', 'BssT1I', 'BisI', 'BstENI', 'Psp5II', 'SfcI', 'BtgI', 'StyI', 'BstEII', 'CpoI', 'Hpy188III', 'ErhI', 'MteI', 'BfmI', 'Eco81I', 'SmoI', 'KflI', 'PspEI', 'Eco47I', 'BstPI', 'BseBI', 'Eco91I', 'TseFI', 'Bsp1720I', 'BmgT120I'],
    )


typedict['type83'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['Hpy178III', 'SecI', 'EspI', 'CauII', 'DraII', 'AsuI', 'DsaI', 'SanDI', 'Sse8647I', 'UnbI', 'SfeI', 'VpaK11AI', 'SauI'],
    )


typedict['type84'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['SacII', 'NlaIII', 'ApaI', 'PstI', 'HhaI', 'PluTI', 'AsiSI', 'FseI', 'AatII', 'SacI', 'Cfr42I', 'NspI', 'HaeII', 'KpnI'],
    )


typedict['type89'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['McaTI', 'PabI'],
    )


typedict['type90'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['SgrBI', 'BstHHI', 'XceI', 'RgaI', 'SphI', 'SstI', 'BspOI', 'SdaI', 'PvuI', 'Mph1103I', 'BstKTI', 'SfaAI', 'SgfI', 'Zsp2I', 'Ple19I', 'BstH2I', 'TaiI', 'BspMAI', 'Hsp92II', 'PaeI', 'AspLEI', 'BstNSI', 'Sfr303I', 'Hin1II', 'KspI', 'Psp124BI', 'FaeI', 'RigI', 'BfoI', 'SbfI', 'CfoI', 'EcoT22I', 'NsiI', 'BmtI', 'Sse8387I', 'PacI'],
    )


typedict['type91'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['ChaI'],
    )


typedict['type92'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['TspRI', 'MwoI', 'SfiI', 'BglI', 'BstXI', 'BaeGI', 'EcoT38I', 'DraIII', 'Bsp1286I', 'AhdI', 'AgsI', 'Bsc4I', 'Hpy99I', 'BanII', 'BslI', 'Hpy188I', 'XcmI', 'BstAPI'],
    )


typedict['type93'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BthCI', 'HauII'],
    )


typedict['type94'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['PflMI', 'BmeRI', 'BlsI', 'BseLI', 'HpyF10VI', 'HpyCH4III', 'BsiEI', 'BsiHKAI', 'CaiI', 'AasI', 'DriI', 'SetI', 'MhlI', 'Bsh1285I', 'BstMWI', 'SduI', 'PcsI', 'AdeI', 'DseDI', 'BseSI', 'TscAI', 'PkrI', 'TaaI', 'AfiI', 'Eam1105I', 'Van91I', 'Alw21I', 'BstSLI', 'Bst4CI', 'PstNI', 'Bbv12I', 'BstMCI', 'AccB7I', 'TauI', 'Eco24I', 'AlwNI', 'FriOI', 'DrdI'],
    )


typedict['type95'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['Psp03I', 'Tsp4CI', 'ApaBI', 'FmuI', 'BsiYI', 'Nli3877I', 'HgiJII', 'PssI', 'McrI', 'HgiAI'],
    )


typedict['type96'] = _temp()


del _temp
