# coding=utf-8

from __future__ import unicode_literals
from .. import Provider as AddressProvider


class Provider(AddressProvider):
    building_number_formats = ('#', '##', '###', '#', '##', '###')

    street_suffixes = (
        'baan', 'boulevard', 'dreef', 'hof', 'laan', 'lei', 'pad',
        'ring', 'singel', 'steeg', 'straat', 'weg',
    )

    # the 4 digit numerical part of Belgium postal codes is between 1000 and 9999;
    # see https://nl.wikipedia.org/wiki/Postcode#Postnummers_in_België
    postcode_formats = ('%###',)

    city_formats = ('{{city}}',)

    # countries are from http://nl.wikipedia.org/wiki/ISO_3166-1
    countries = (
        'Afghanistan', 'Albanië', 'Algerije', 'Amerikaans-Samoa',
        'Amerikaanse Maagdeneilanden', 'Andorra', 'Angola', 'Anguilla',
        'Antarctica', 'Antigua en Barbuda', 'Argentinië', 'Armenië', 'Aruba',
        'Australië', 'Azerbeidzjan', "Bahama's", 'Bahrein', 'Bangladesh',
        'Barbados', 'België', 'Belize', 'Benin', 'Bermuda', 'Bhutan',
        'Bolivia', 'Bonaire, Sint Eustatius en Saba', 'Bosnië en Herzegovina',
        'Botswana', 'Bouveteiland', 'Brazilië',
        'Brits Indische Oceaanterritorium', 'Britse Maagdeneilanden', 'Brunei',
        'Bulgarije', 'Burkina Faso', 'Burundi', 'Cambodja', 'Canada',
        'Centraal-Afrikaanse Republiek', 'Chili', 'China', 'Christmaseiland',
        'Cocoseilanden', 'Colombia', 'Comoren', 'Congo-Brazzaville',
        'Congo-Kinshasa', 'Cookeilanden', 'Costa Rica', 'Cuba', 'Curaçao',
        'Cyprus', 'Denemarken', 'Djibouti', 'Dominica',
        'Dominicaanse Republiek', 'Duitsland', 'Ecuador', 'Egypte',
        'El Salvador', 'Equatoriaal-Guinea', 'Eritrea', 'Estland', 'Ethiopië',
        'Faeröer', 'Falklandeilanden', 'Fiji', 'Filipijnen', 'Finland',
        'Frankrijk', 'Frans-Guyana', 'Frans-Polynesië',
        'Franse Zuidelijke en Antarctische Gebieden', 'Gabon', 'Gambia',
        'Georgië', 'Ghana', 'Gibraltar', 'Grenada', 'Griekenland', 'Groenland',
        'Guadeloupe', 'Guam', 'Guatemala', 'Guernsey', 'Guinee',
        'Guinee-Bissau', 'Guyana', 'Haïti', 'Heard en McDonaldeilanden',
        'Honduras', 'Hongarije', 'Hongkong', 'IJsland', 'Ierland', 'India',
        'Indonesië', 'Irak', 'Iran', 'Israël', 'Italië', 'Ivoorkust',
        'Jamaica', 'Japan', 'Jemen', 'Jersey', 'Jordanië', 'Kaaimaneilanden',
        'Kaapverdië', 'Kameroen', 'Kazachstan', 'Kenia', 'Kirgizië',
        'Kiribati', 'Kleine Pacifische eilanden van de Verenigde Staten',
        'Koeweit', 'Kroatië', 'Laos', 'Lesotho', 'Letland', 'Libanon',
        'Liberia', 'Libië', 'Liechtenstein', 'Litouwen', 'Luxemburg', 'Macau',
        'Macedonië', 'Madagaskar', 'Malawi', 'Maldiven', 'Maleisië', 'Mali',
        'Malta', 'Man', 'Marokko', 'Marshalleilanden', 'Martinique',
        'Mauritanië', 'Mauritius', 'Mayotte', 'Mexico', 'Micronesia',
        'Moldavië', 'Monaco', 'Mongolië', 'Montenegro', 'Montserrat',
        'Mozambique', 'Myanmar', 'Namibië', 'Nauru', 'Nederland', 'Nepal',
        'Nicaragua', 'Nieuw-Caledonië', 'Nieuw-Zeeland', 'Niger', 'Nigeria',
        'Niue', 'Noord-Korea', 'Noordelijke Marianen', 'Noorwegen', 'Norfolk',
        'Oeganda', 'Oekraïne', 'Oezbekistan', 'Oman', 'Oost-Timor',
        'Oostenrijk', 'Pakistan', 'Palau', 'Palestina', 'Panama',
        'Papoea-Nieuw-Guinea', 'Paraguay', 'Peru', 'Pitcairneilanden', 'Polen',
        'Portugal', 'Puerto Rico', 'Qatar', 'Roemenië', 'Rusland', 'Rwanda',
        'Réunion', 'Saint Kitts en Nevis', 'Saint Lucia',
        'Saint Vincent en de Grenadines', 'Saint-Barthélemy',
        'Saint-Pierre en Miquelon', 'Salomonseilanden', 'Samoa', 'San Marino',
        'Sao Tomé en Principe', 'Saoedi-Arabië', 'Senegal', 'Servië',
        'Seychellen', 'Sierra Leone', 'Singapore', 'Sint Maarten',
        'Sint-Helena, Ascension en Tristan da Cunha', 'Sint-Maarten',
        'Slovenië', 'Slowakije', 'Soedan', 'Somalië', 'Spanje',
        'Spitsbergen en Jan Mayen', 'Sri Lanka', 'Suriname', 'Swaziland',
        'Syrië', 'Tadzjikistan', 'Taiwan', 'Tanzania', 'Thailand', 'Togo',
        'Tokelau', 'Tonga', 'Trinidad en Tobago', 'Tsjaad', 'Tsjechië',
        'Tunesië', 'Turkije', 'Turkmenistan', 'Turks- en Caicoseilanden',
        'Tuvalu', 'Uruguay', 'Vanuatu', 'Vaticaanstad', 'Venezuela',
        'Verenigd Koninkrijk', 'Verenigde Arabische Emiraten',
        'Verenigde Staten', 'Vietnam', 'Wallis en Futuna', 'Westelijke Sahara',
        'Wit-Rusland', 'Zambia', 'Zimbabwe', 'Zuid-Afrika',
        'Zuid-Georgia en de Zuidelijke Sandwicheilanden', 'Zuid-Korea',
        'Zuid-Soedan', 'Zweden', 'Zwitserland', 'Åland',
    )

    # cities as listed on "postcodezoeker"
    # http://www.postcodes-maps.be/postcodelijst.php
    cities = (
        "'s Herenelderen", "'s-Gravenvoeren", "'s-Gravenwezel", "Aaigem", "Aalbeke",
        "Aalst", "Aalter", "Aarschot", "Aarsele", "Aartrijke", "Aartselaar", "Abolens",
        "Abée", "Achel", "Achet", "Achêne", "Acosse", "Acoz", "Adegem", "Adinkerke",
        "Affligem", "Afsnee", "Agimont", "Aineffe", "Aische-en-Refail", "Aiseau",
        "Aiseau-Presles", "Aisemont", "Alken", "Alle", "Alleur", "Alsemberg",
        "Alveringem", "Amay", "Amberloup", "Ambly", "Ambresin", "Amel", "Amonines",
        "Amougies", "Ampsin", "Andenne", "Anderlecht", "Anderlues", "Andrimont",
        "Angleur", "Angre", "Angreau", "Anhée", "Anlier", "Anloy", "Annevoie-Rouillon",
        "Ans", "Anseremme", "Anseroeul", "Antheit", "Anthisnes", "Anthée", "Antoing",
        "Antwerpen", "Anvaing", "Anzegem", "Appels", "Appelterre-Eichem", "Arbre",
        "Arbrefontaine", "Arc-Ainières", "Arc-Wattripont", "Archennes", "Ardooie",
        "Arendonk", "Argenteau", "Arlon", "Arquennes", "Arsimont", "Arville", "As",
        "Aspelare", "Asper", "Asquillies", "Asse", "Assebroek", "Assenede", "Assenois",
        "Assent", "Assesse", "Astene", "Ath", "Athis", "Athus", "Attenhoven", "Attenrode",
        "Attert", "Attre", "Aubange", "Aubechies", "Aubel", "Aublain", "Auby-sur-Semois",
        "Audregnies", "Aulnois", "Autelbas", "Autre-Eglise", "Autreppe", "Auvelais",
        "Ave-et-Auffe", "Avekapelle", "Avelgem", "Avennes", "Averbode",
        "Avernas-le-Bauduin", "Avin", "Awans", "Awenne", "Awirs", "Aye", "Ayeneux",
        "Aywaille", "Baaigem", "Baal", "Baardegem", "Baarle-Hertog", "Baasrode",
        "Bachte-Maria-Leerne", "Baelen", "Bagimont", "Baileux", "Bailièvre", "Baillamont",
        "Bailleul", "Baillonville", "Baisieux", "Baisy-Thy", "Balegem", "Balen",
        "Balâtre", "Bambrugge", "Bande", "Barbençon", "Barchon", "Baronville", "Barry",
        "Barvaux-Condroz", "Barvaux-sur-Ourthe", "Bas-Oha", "Basse-Bodeux", "Bassenge",
        "Bassevelde", "Bassilly", "Bastogne", "Basècles", "Batsheers", "Battice",
        "Battignies", "Baudour", "Bauffe", "Baugnies", "Baulers", "Bavegem", "Bavikhove",
        "Bazel", "Beaufays", "Beaumont", "Beauraing", "Beausaint", "Beauvoorde",
        "Beauwelz", "Beclers", "Beek", "Beerlegem", "Beernem", "Beerse", "Beersel",
        "Beerst", "Beert", "Beervelde", "Beerzel", "Beez", "Beffe", "Begijnendijk",
        "Beho", "Beigem", "Bekegem", "Bekkerzeel", "Bekkevoort", "Belgrade", "Bellaire",
        "Bellecourt", "Bellefontaine", "Bellegem", "Bellem", "Bellevaux",
        "Bellevaux-Ligneuville", "Bellingen", "Beloeil", "Belsele", "Ben-Ahin", "Bende",
        "Berbroek", "Berchem", "Berendrecht", "Berg", "Bergilers", "Beringen", "Berlaar",
        "Berlare", "Berlingen", "Berloz", "Berneau", "Bernissart", "Bersillies-l'Abbaye",
        "Bertem", "Bertogne", "Bertrix", "Bertrée", "Berzée", "Beselare", "Betekom",
        "Bettincourt", "Beuzet", "Bevekom", "Bevel", "Bever", "Bevercé", "Bevere",
        "Beveren-Leie", "Beveren-Roeselare", "Beveren-Waas", "Beveren-aan-den-Ijzer",
        "Beverlo", "Beverst", "Beyne-Heusay", "Bienne-lez-Happart", "Bierbeek", "Biercée",
        "Bierges", "Bierghes", "Bierset", "Bierwart", "Biesme", "Biesme-sous-Thuin",
        "Biesmerée", "Biez", "Bihain", "Bikschote", "Bilstain", "Bilzen", "Binche",
        "Binderveld", "Binkom", "Bioul", "Bissegem", "Bizet", "Bièvre", "Blaasveld",
        "Blaimont", "Blandain", "Blanden", "Blankenberge", "Blaregnies", "Blaton",
        "Blaugies", "Blehen", "Bleid", "Bleret", "Blicquy", "Blégny", "Bléharies",
        "Bocholt", "Boechout", "Boekhout", "Boekhoute", "Boezinge", "Bogaarden", "Bohan",
        "Boignée", "Boirs", "Bois-d'Haine", "Bois-de-Lessines", "Bois-de-Villers",
        "Bois-et-Borsu", "Bolinne", "Bolland", "Bomal", "Bomal-sur-Ourthe", "Bombaye",
        "Bommershoven", "Bon-Secours", "Boncelles", "Boneffe", "Bonheiden", "Boninne",
        "Bonlez", "Bonnert", "Bonneville", "Bonsin", "Booischot", "Booitshoeke", "Boom",
        "Boorsem", "Boortmeerbeek", "Borchtlombeek", "Borgerhout", "Borgloon", "Borlez",
        "Borlo", "Borlon", "Bornem", "Bornival", "Borsbeek", "Borsbeke", "Bossière",
        "Bossuit", "Bossut-Gottechain", "Bost", "Bothey", "Bottelare", "Bouffioulx",
        "Bouge", "Bougnies", "Bouillon", "Bourlers", "Bourseigne-Neuve",
        "Bourseigne-Vieille", "Boussoit", "Boussu", "Boussu-en-Fagne",
        "Boussu-lez-Walcourt", "Bousval", "Boutersem", "Bouvignes-sur-Meuse",
        "Bouvignies", "Bouwel", "Bovekerke", "Bovelingen", "Bovenistier", "Bovesse",
        "Bovigny", "Boëlhe", "Bra", "Braffe", "Braibant", "Braine-l'Alleud",
        "Braine-le-Château", "Braine-le-Comte", "Braives", "Brakel", "Branchon", "Bras",
        "Brasmenil", "Brasschaat", "Bray", "Brecht", "Bredene", "Bree", "Breendonk",
        "Bressoux", "Briegden", "Brielen", "Broechem", "Broekom", "Brugelette", "Brugge",
        "Brunehaut", "Brussegem", "Brussel", "Brustem", "Bruyelle", "Brye", "Brûly",
        "Brûly-de-Pesche", "Budingen", "Buggenhout", "Buissenal", "Buissonville",
        "Buizingen", "Buken", "Bulskamp", "Bunsbeek", "Burcht", "Burdinne", "Bure",
        "Burg-Reuland", "Burst", "Bury", "Buvingen", "Buvrinnes", "Buzenol", "Buzet",
        "Büllingen", "Bütgenbach", "Callenelle", "Calonne", "Cambron-Casteau",
        "Cambron-Saint-Vincent", "Carlsbourg", "Carnières", "Casteau", "Castillon",
        "Celles", "Cerfontaine", "Chaineux", "Chairière", "Champion", "Champlon",
        "Chanly", "Chantemelle", "Chapelle-lez-Herlaimont", "Chapelle-à-Oie",
        "Chapelle-à-Wattines", "Chapon-Seraing", "Charleroi", "Charneux", "Chassepierre",
        "Chastre", "Chastre-Villeroux-Blanmont", "Chastrès", "Chaudfontaine",
        "Chaumont-Gistoux", "Chaussée-Notre-Dame-Louvignies", "Cherain", "Cheratte",
        "Chercq", "Chevetogne", "Chevron", "Chimay", "Chiny", "Chièvres", "Chokier",
        "Châtelet", "Châtelineau", "Châtillon", "Chênée", "Ciergnon", "Ciney", "Ciplet",
        "Ciply", "Clabecq", "Clavier", "Clermont", "Clermont-sous-Huy", "Cognelée",
        "Colfontaine", "Comblain-Fairon", "Comblain-au-Pont", "Comblain-la-Tour",
        "Conneux", "Corbais", "Corbion", "Cordes", "Corenne", "Cornesse", "Cornimont",
        "Corroy-le-Château", "Corroy-le-Grand", "Corswarem", "Cortil-Noirmont",
        "Cortil-Wodon", "Couillet", "Cour-sur-Heure", "Courcelles", "Courrière",
        "Court-Saint-Etienne", "Couthuin", "Coutisse", "Couture-Saint-Germain", "Couvin",
        "Cras-Avernas", "Crehen", "Crisnée", "Croix-lez-Rouveroy", "Crombach", "Crupet",
        "Cuesmes", "Cugnon", "Cul-des-Sarts", "Custinne", "Cérexhe-Heuseux",
        "Céroux-Mousty", "Dadizele", "Dailly", "Daknam", "Dalhem", "Damme", "Dampicourt",
        "Dampremy", "Darion", "Daussois", "Daussoulx", "Dave", "Daverdisse", "De Haan",
        "De Klinge", "De Moeren", "De Panne", "De Pinte", "Deerlijk", "Deftinge",
        "Deinze", "Denderbelle", "Denderhoutem", "Denderleeuw", "Dendermonde",
        "Denderwindeke", "Dentergem", "Denée", "Dergneau", "Dessel", "Desselgem",
        "Destelbergen", "Desteldonk", "Deurle", "Deurne", "Deux-Acren", "Dhuy",
        "Diepenbeek", "Diest", "Diets-Heur", "Dikkebus", "Dikkele", "Dikkelvenne",
        "Diksmuide", "Dilbeek", "Dilsen-Stokkem", "Dinant", "Dion", "Dion-Valmont",
        "Dison", "Dochamps", "Doel", "Dohan", "Doische", "Dolembreux", "Donceel",
        "Dongelberg", "Donk", "Donstiennes", "Dorinne", "Dormaal", "Dottenijs", "Dour",
        "Dourbes", "Dranouter", "Driekapellen", "Drieslinter", "Drogenbos", "Drongen",
        "Dréhance", "Dudzele", "Duffel", "Duisburg", "Duras", "Durbuy", "Durnal", "Dworp",
        "Eben-Emael", "Ebly", "Ecaussinnes", "Ecaussinnes-Lalaing",
        "Ecaussinnes-d'Enghien", "Edegem", "Edelare", "Edingen", "Eeklo", "Eernegem",
        "Egem", "Eggewaartskapelle", "Eghezée", "Ehein", "Eigenbilzen", "Eindhout",
        "Eine", "Eisden", "Eke", "Ekeren", "Eksaarde", "Eksel", "Elen", "Elene",
        "Elewijt", "Eliksem", "Elingen", "Ellemelle", "Ellezelles",
        "Ellignies-Sainte-Anne", "Ellignies-lez-Frasnes", "Ellikom", "Elouges", "Elsegem",
        "Elsenborn", "Elsene", "Elst", "Elverdinge", "Elversele", "Emblem", "Embourg",
        "Emelgem", "Emines", "Emptinne", "Ename", "Engelmanshoven", "Engis", "Enines",
        "Ensival", "Epinois", "Eppegem", "Eprave", "Erbaut", "Erbisoeul", "Ere",
        "Erembodegem", "Erezée", "Ermeton-sur-Biert", "Ernage", "Erneuville", "Ernonheid",
        "Erondegem", "Erpe", "Erpe-Mere", "Erpent", "Erpion", "Erps-Kwerps",
        "Erquelinnes", "Erquennes", "Ertvelde", "Erwetegem", "Escanaffles", "Esen",
        "Esneux", "Esplechin", "Esquelmes", "Essen", "Essene", "Estaimbourg",
        "Estaimpuis", "Estinnes", "Estinnes-au-Mont", "Estinnes-au-Val", "Etalle", "Ethe",
        "Etikhove", "Ettelgem", "Etterbeek", "Eugies", "Eupen", "Evegnée", "Evelette",
        "Everbeek", "Everberg", "Evere", "Evergem", "Evregnies", "Evrehailles",
        "Eynatten", "Ezemaal", "Fagnolle", "Faimes", "Falaën", "Falisolle", "Fallais",
        "Falmagne", "Falmignoul", "Familleureux", "Farciennes", "Faulx-les-Tombes",
        "Fauroeulx", "Fauvillers", "Faymonville", "Fays-les-Veneurs", "Fayt-le-Franc",
        "Fayt-lez-Manage", "Felenne", "Feluy", "Feneur", "Fernelmont", "Ferrières",
        "Feschaux", "Fexhe-Slins", "Fexhe-le-Haut-Clocher", "Filot", "Finnevaux",
        "Fize-Fontaine", "Fize-le-Marsal", "Flamierge", "Flavion", "Flawinne", "Fleurus",
        "Floreffe", "Florennes", "Florenville", "Floriffoux", "Florée", "Flostoy",
        "Flémalle", "Flémalle-Grande", "Flémalle-Haute", "Flénu", "Fléron", "Flône",
        "Focant", "Folx-les-Caves", "Fontaine-Valmont", "Fontaine-l'Evêque", "Fontenelle",
        "Fontenoille", "Fontenoy", "Fooz", "Forchies-la-Marche", "Forest", "Forges",
        "Forges-Philippe", "Forrières", "Forville", "Forêt", "Fosse", "Fosses-la-Ville",
        "Fouleng", "Fourbechies", "Foy-Notre-Dame", "Fraipont", "Fraire", "Fraiture",
        "Frameries", "Framont", "Franc-Waret", "Franchimont", "Francorchamps", "Franière",
        "Frasnes", "Frasnes-lez-Anvaing", "Frasnes-lez-Buissenal",
        "Frasnes-lez-Gosselies", "Freloux", "Freux", "Froidchapelle", "Froidfontaine",
        "Froidmont", "Fronville", "Froyennes", "Fumal", "Furfooz", "Furnaux", "Gaasbeek",
        "Gages", "Gallaix", "Galmaarden", "Ganshoren", "Gaurain-Ramecroix", "Gavere",
        "Gedinne", "Geel", "Geer", "Geest-Gérompont-Petit-Rosière", "Geetbets",
        "Gelbressée", "Gelinden", "Gellik", "Gelrode", "Geluveld", "Geluwe", "Gembes",
        "Gembloux", "Gemmenich", "Genappe", "Genk", "Genly", "Genoelselderen", "Gent",
        "Gentbrugge", "Gentinnes", "Genval", "Geraardsbergen", "Gerdingen", "Gerin",
        "Gerpinnes", "Gestel", "Gesves", "Ghislenghien", "Ghlin", "Ghoy", "Gibecq",
        "Gierle", "Gijverinkhove", "Gijzegem", "Gijzelbrechtegem", "Gijzenzele", "Gilly",
        "Gimnée", "Gingelom", "Gistel", "Gits", "Givry", "Glabais", "Glabbeek-Zuurbemde",
        "Glain", "Gleixhe", "Glimes", "Glons", "Gochenée", "Godarville", "Godinne",
        "Godveerdegem", "Goeferdinge", "Goegnies-Chaussée", "Goesnes", "Goetsenhoven",
        "Gomzé-Andoumont", "Gondregnies", "Gonrieux", "Gontrode", "Gooik", "Gors-Opleeuw",
        "Gorsem", "Gosselies", "Gotem", "Gottem", "Gottignies", "Gougnies", "Gourdinne",
        "Goutroux", "Gouvy", "Gouy-lez-Piéton", "Gozée", "Goé", "Graide", "Grammene",
        "Grand-Axhe", "Grand-Hallet", "Grand-Halleux", "Grand-Leez", "Grand-Manil",
        "Grand-Rechain", "Grand-Reng", "Grand-Rosière-Hottomont", "Grandglise",
        "Grandhan", "Grandmenil", "Grandmetz", "Grandrieu", "Grandville", "Grandvoir",
        "Grapfontaine", "Graty", "Graux", "Grazen", "Grembergen", "Grez-Doiceau",
        "Grimbergen", "Grimminge", "Grivegnée", "Grobbendonk", "Groot-Bijgaarden",
        "Groot-Gelmen", "Groot-Loon", "Gros-Fays", "Grosage", "Grote-Brogel",
        "Grote-Spouwen", "Grotenberge", "Gruitrode", "Grune", "Grupont", "Grâce-Berleur",
        "Grâce-Hollogne", "Guignies", "Guigoven", "Guirsch", "Gullegem", "Gutschoven",
        "Gérompont", "Gérouville", "Haacht", "Haaltert", "Haasdonk", "Haasrode", "Habay",
        "Habay-la-Neuve", "Habay-la-Vieille", "Habergy", "Haccourt", "Hachy",
        "Hacquegnies", "Haillot", "Haine-Saint-Paul", "Haine-Saint-Pierre", "Hainin",
        "Hakendover", "Halanzy", "Halen", "Hallaar", "Halle", "Halle-Booienhoven",
        "Halleux", "Halma", "Halmaal", "Haltinne", "Ham", "Ham-sur-Heure",
        "Ham-sur-Heure-Nalinnes", "Ham-sur-Sambre", "Hamipré", "Hamme", "Hamme-Mille",
        "Hamoir", "Hamois", "Hamont", "Hamont-Achel", "Hampteau", "Han-sur-Lesse",
        "Handzame", "Haneffe", "Hannut", "Hannêche", "Hanret", "Hansbeke",
        "Hantes-Wihéries", "Hanzinelle", "Hanzinne", "Harchies", "Harelbeke", "Haren",
        "Haren-Borgloon", "Haren-Tongeren", "Hargimont", "Harmignies", "Harnoncourt",
        "Harre", "Harsin", "Harveng", "Harzé", "Hasselt", "Hastière", "Hastière-Lavaux",
        "Hastière-par-Delà", "Hatrival", "Haulchin", "Hauset", "Haut-Fays", "Haut-Ittre",
        "Haut-le-Wastia", "Hautrage", "Havay", "Havelange", "Haversin", "Havinnes",
        "Havré", "Hechtel", "Hechtel-Eksel", "Heer", "Heers", "Hees", "Heestert",
        "Heffen", "Heikruis", "Heindonk", "Heinsch", "Heist-aan-Zee", "Heist-op-den-Berg",
        "Hekelgem", "Heks", "Helchteren", "Heldergem", "Helen-Bos", "Helkijn",
        "Hellebecq", "Hemelveerdegem", "Hemiksem", "Hemptinne", "Hemptinne-lez-Florennes",
        "Hendrieken", "Henis", "Hennuyères", "Henri-Chapelle", "Henripont", "Hensies",
        "Heppen", "Heppenbach", "Heppignies", "Herbeumont", "Herchies", "Herderen",
        "Herdersem", "Herent", "Herentals", "Herenthout", "Herfelingen", "Hergenrath",
        "Herk-de-Stad", "Hermalle-sous-Argenteau", "Hermalle-sous-Huy",
        "Hermeton-sur-Meuse", "Hermée", "Herne", "Herquegies", "Herseaux", "Herselt",
        "Herstal", "Herstappe", "Hertain", "Herten", "Hertsberge", "Herve", "Herzele",
        "Heule", "Heure", "Heure-le-Romain", "Heurne", "Heusden", "Heusden-Zolder",
        "Heusy", "Heuvelland", "Hever", "Heverlee", "Heyd", "Hillegem", "Hingene",
        "Hingeon", "Hives", "Hoboken", "Hodeige", "Hodister", "Hody", "Hoegaarden",
        "Hoeilaart", "Hoeke", "Hoelbeek", "Hoeleden", "Hoepertingen", "Hoeselt",
        "Hoevenen", "Hofstade", "Hogne", "Hognoul", "Hollain", "Hollange", "Hollebeke",
        "Hollogne-aux-Pierres", "Hollogne-sur-Geer", "Holsbeek", "Hombeek", "Hombourg",
        "Hompré", "Hondelange", "Honnay", "Honnelles", "Hooglede", "Hoogstade",
        "Hoogstraten", "Horebeke", "Horion-Hozémont", "Hornu", "Horpmaal", "Horrues",
        "Hotton", "Houdemont", "Houdeng-Aimeries", "Houdeng-Goegnies", "Houdremont",
        "Houffalize", "Hour", "Housse", "Houtain-Saint-Siméon", "Houtain-le-Val",
        "Houtaing", "Houtave", "Houtem", "Houthalen", "Houthalen-Helchteren", "Houthem",
        "Houthulst", "Houtvenne", "Houwaart", "Houx", "Houyet", "Hove", "Hoves",
        "Howardries", "Huccorgne", "Huise", "Huissignies", "Huizingen", "Huldenberg",
        "Hulshout", "Hulsonniaux", "Hulste", "Humain", "Humbeek", "Hundelgem", "Huppaye",
        "Huy", "Hyon", "Hélécine", "Hérinnes-lez-Pecq", "Héron", "Hévillers", "Ichtegem",
        "Iddergem", "Idegem", "Ieper", "Impe", "Incourt", "Ingelmunster", "Ingooigem",
        "Irchonwelz", "Isières", "Isnes", "Itegem", "Itterbeek", "Ittre", "Ivoz-Ramet",
        "Izegem", "Izel", "Izenberge", "Izier", "Jabbeke", "Jalhay", "Jallet", "Jamagne",
        "Jambes", "Jamiolle", "Jamioulx", "Jamoigne", "Jandrain-Jandrenouille", "Jauche",
        "Jauchelette", "Javingue", "Jehay", "Jehonville", "Jemappes", "Jemelle",
        "Jemeppe-sur-Meuse", "Jemeppe-sur-Sambre", "Jeneffe", "Jesseren", "Jette", "Jeuk",
        "Jodoigne", "Jodoigne-Souveraine", "Jollain-Merlin", "Joncret", "Julémont",
        "Jumet", "Jupille-sur-Meuse", "Juprelle", "Jurbise", "Juseret", "Kaaskerke",
        "Kachtem", "Kaggevinne", "Kain", "Kalken", "Kallo", "Kallo-Kieldrecht",
        "Kalmthout", "Kampenhout", "Kanegem", "Kanne", "Kapelle-op-den-Bos", "Kapellen",
        "Kaprijke", "Kaster", "Kasterlee", "Kaulille", "Keerbergen", "Keiem", "Kelmis",
        "Kemexhe", "Kemmel", "Kemzeke", "Kerkhove", "Kerkom", "Kerkom-bij-Sint-Truiden",
        "Kerksken", "Kermt", "Kerniel", "Kersbeek-Miskom", "Kessel", "Kessel-Lo",
        "Kessenich", "Kester", "Kettenis", "Keumiée", "Kieldrecht", "Kinrooi",
        "Klein-Gelmen", "Kleine-Brogel", "Kleine-Spouwen", "Klemskerke", "Klerken",
        "Kluisbergen", "Kluizen", "Knesselare", "Knokke", "Knokke-Heist", "Kobbegem",
        "Koekelare", "Koekelberg", "Koersel", "Koksijde", "Kolmont-Borgloon",
        "Kolmont-Tongeren", "Komen", "Komen-Waasten", "Koningshooikt", "Koninksem",
        "Kontich", "Kooigem", "Koolkerke", "Koolskamp", "Korbeek-Dijle", "Korbeek-Lo",
        "Kortemark", "Kortenaken", "Kortenberg", "Kortessem", "Kortijs", "Kortrijk",
        "Kortrijk-Dutsel", "Kozen", "Kraainem", "Krombeke", "Kruibeke", "Kruishoutem",
        "Kumtich", "Kuringen", "Kuttekoven", "Kuurne", "Kwaadmechelen", "Kwaremont", "La",
        "La Bruyère", "La Glanerie", "La Gleize", "La Hestre", "La Hulpe", "La Louvière",
        "La bouverie", "La-Roche-en-Ardenne", "Laakdal", "Laar", "Laarne", "Labuissière",
        "Lacuisine", "Ladeuze", "Laforêt", "Lahamaide", "Laken", "Lamain", "Lambermont",
        "Lambusart", "Lamine", "Lamontzée", "Lamorteau", "Lampernisse", "Lanaken",
        "Lanaye", "Landegem", "Landelies", "Landen", "Landenne", "Landskouter", "Laneffe",
        "Langdorp", "Langemark", "Langemark-Poelkapelle", "Lanklaar", "Lanquesaint",
        "Lantin", "Lantremange", "Laplaigne", "Lapscheure", "Lasne",
        "Lasne-Chapelle-Saint-Lambert", "Lathuy", "Latinne", "Latour", "Lauw", "Lauwe",
        "Lavacherie", "Lavaux-Sainte-Anne", "Lavoir", "Le Mesniel", "Le Roeulx",
        "Le Roux", "Lebbeke", "Lede", "Ledeberg", "Ledegem", "Leefdaal", "Leerbeek",
        "Leernes", "Leers-Nord", "Leers-et-Fosteau", "Leest", "Leeuwergem", "Leffinge",
        "Leignon", "Leisele", "Leke", "Lembeek", "Lembeke", "Lemberge", "Lendelede",
        "Lennik", "Lens", "Lens-Saint-Remy", "Lens-Saint-Servais", "Lens-sur-Geer",
        "Leopoldsburg", "Les Avins", "Les Bons", "Les Bulles", "Les Hayons",
        "Les Waleffes", "Lesdain", "Lessines", "Lessive", "Lesterny", "Lesve",
        "Lettelingen", "Letterhoutem", "Leugnies", "Leupegem", "Leut", "Leuven", "Leuze",
        "Leuze-en-Hainaut", "Leval-Chaudeville", "Leval-Trahegnies", "Liberchies",
        "Libin", "Libramont", "Libramont-Chevigny", "Lichtaart", "Lichtervelde",
        "Liedekerke", "Lieferinge", "Lier", "Lierde", "Lierneux", "Liernu", "Liers",
        "Liezele", "Ligne", "Ligney", "Ligny", "Lille", "Lillo", "Lillois-Witterzée",
        "Limal", "Limbourg", "Limelette", "Limerlé", "Limont", "Lincent", "Linden",
        "Linkebeek", "Linkhout", "Linsmeau", "Lint", "Linter", "Lippelo", "Lisogne",
        "Lissewege", "Lives-sur-Meuse", "Lixhe", "Liège", "Lo", "Lo-Reninge", "Lobbes",
        "Lochristi", "Lodelinsart", "Loenhout", "Loker", "Lokeren", "Loksbergen",
        "Lombardsijde", "Lombise", "Lommel", "Lommersweiler", "Lompret", "Lomprez",
        "Loncin", "Londerzeel", "Longchamps", "Longlier", "Longueville", "Longvilly",
        "Lontzen", "Lonzée", "Loonbeek", "Loppem", "Lorcé", "Lot", "Lotenhulle",
        "Louette-Saint-Denis", "Louette-Saint-Pierre", "Loupoigne", "Louvain-la-Neuve",
        "Louveigné", "Lovendegem", "Lovenjoel", "Loverval", "Loyers", "Lubbeek",
        "Luingne", "Lummen", "Lustin", "Luttre", "Léglise", "Maarke-Kerkem", "Maarkedal",
        "Maaseik", "Maasmechelen", "Mabompré", "Machelen", "Macon", "Macquenoise",
        "Maffe", "Maffle", "Magnée", "Maillen", "Mainvault", "Maisières", "Maissin",
        "Maizeret", "Mal", "Maldegem", "Malderen", "Malempré", "Malle", "Malmedy",
        "Malonne", "Malvoisin", "Malèves-Sainte-Marie-Wastines", "Manage", "Manderfeld",
        "Manhay", "Mannekensvere", "Maransart", "Marbais", "Marbaix", "Marbehan",
        "Marche-en-Famenne", "Marche-les-Dames", "Marche-lez-Ecaussinnes",
        "Marchienne-au-Pont", "Marchin", "Marchipont", "Marchovelette", "Marcinelle",
        "Marcourt", "Marenne", "Mariakerke", "Mariekerke", "Mariembourg", "Marilles",
        "Mark", "Marke", "Markegem", "Marneffe", "Marquain", "Martelange", "Martenslinde",
        "Martouzin-Neuville", "Masbourg", "Masnuy-Saint-Jean", "Masnuy-Saint-Pierre",
        "Massemen", "Massenhoven", "Matagne-la-Grande", "Matagne-la-Petite", "Mater",
        "Maubray", "Maulde", "Maurage", "Mazenzele", "Mazy", "Mazée", "Mechelen",
        "Mechelen-Bovelingen", "Mechelen-aan-de-Maas", "Meeffe", "Meensel-Kiezegem",
        "Meer", "Meerbeek", "Meerbeke", "Meerdonk", "Meerhout", "Meerle", "Meeswijk",
        "Meetkerke", "Meeuwen", "Meeuwen-Gruitrode", "Mehaigne", "Meigem", "Meilegem",
        "Meise", "Meix-devant-Virton", "Meix-le-Tige", "Melden", "Meldert", "Melen",
        "Melkwezer", "Melle", "Mellery", "Melles", "Mellet", "Mellier", "Melsbroek",
        "Melsele", "Melsen", "Membach", "Membre", "Membruggen", "Mendonk", "Menen",
        "Merbes-Sainte-Marie", "Merbes-le-Château", "Merchtem", "Merdorp", "Mere",
        "Merelbeke", "Merendree", "Merkem", "Merksem", "Merksplas", "Merlemont", "Mesen",
        "Meslin-l'Evêque", "Mesnil-Eglise", "Mesnil-Saint-Blaise", "Mespelare",
        "Messancy", "Messelbroek", "Mesvin", "Mettekoven", "Mettet", "Meulebeke", "Meux",
        "Meyerode", "Michelbeke", "Micheroux", "Middelburg", "Middelkerke",
        "Mielen-boven-Aalst", "Mignault", "Millen", "Milmort", "Minderhout", "Mirwart",
        "Miécret", "Modave", "Moelingen", "Moen", "Moerbeke", "Moerbeke-Waas", "Moere",
        "Moerkerke", "Moerzeke", "Moeskroen", "Moha", "Mohiville", "Moignelée", "Moircy",
        "Mol", "Molenbaix", "Molenbeek-Wersbeek", "Molenbeersel", "Molenstede", "Mollem",
        "Momalle", "Momignies", "Monceau-Imbrechies", "Monceau-en-Ardenne",
        "Monceau-sur-Sambre", "Mons", "Mons-lez-Liège", "Monstreux", "Mont",
        "Mont-Gauthier", "Mont-Saint-André", "Mont-Saint-Aubert", "Mont-Saint-Guibert",
        "Mont-Sainte-Aldegonde", "Mont-Sainte-Geneviève", "Mont-de-l'Enclus",
        "Mont-sur-Marchienne", "Montbliart", "Montegnée", "Montenaken",
        "Montignies-Saint-Christophe", "Montignies-lez-Lens", "Montignies-sur-Roc",
        "Montignies-sur-Sambre", "Montigny-le-Tilleul", "Montleban", "Montroeul-au-Bois",
        "Montroeul-sur-Haine", "Montzen", "Moorsel", "Moorsele", "Moorslede", "Moortsele",
        "Mopertingen", "Moregem", "Moresnet", "Morhet", "Morialmé", "Morkhoven",
        "Morlanwelz", "Morlanwelz-Mariemont", "Mormont", "Mornimont", "Mortier",
        "Mortroux", "Mortsel", "Morville", "Moulbaix", "Mourcourt", "Moustier",
        "Moustier-sur-Sambre", "Mouzaive", "Moxhe", "Mozet", "Muizen", "Mullem",
        "Munkzwalm", "Muno", "Munsterbilzen", "Munte", "Musson", "Mussy-la-Ville", "My",
        "Méan", "Mélin", "Mévergnies-lez-Lens", "Naast", "Nadrin", "Nafraiture",
        "Nalinnes", "Namur", "Namêche", "Nandrin", "Naninne", "Naomé", "Nassogne",
        "Natoye", "Nazareth", "Neder-over-Heembeek", "Nederboelare", "Nederbrakel",
        "Nederename", "Nederhasselt", "Nederokkerzeel", "Nederzwalm-Hermelgem",
        "Neerglabbeek", "Neerharen", "Neerhespen", "Neerheylissem", "Neerijse",
        "Neerlanden", "Neerlinter", "Neeroeteren", "Neerpelt", "Neerrepen", "Neervelp",
        "Neerwaasten", "Neerwinden", "Neigem", "Nerem", "Nessonvaux", "Nethen",
        "Nettinne", "Neu-Moresnet", "Neufchâteau", "Neufmaison", "Neufvilles", "Neupré",
        "Neuville", "Neuville-en-Condroz", "Nevele", "Niel", "Niel-bij-As",
        "Niel-bij-Sint-Truiden", "Nieuwenhove", "Nieuwenrode", "Nieuwerkerken",
        "Nieuwkapelle", "Nieuwkerke", "Nieuwkerken-Waas", "Nieuwmunster", "Nieuwpoort",
        "Nieuwrode", "Nijlen", "Nil-Saint-Vincent-Saint-Martin", "Nimy", "Ninove",
        "Nismes", "Nivelles", "Niverlée", "Nives", "Nobressart", "Nodebais", "Noduwez",
        "Noirchain", "Noirefontaine", "Noiseux", "Nokere", "Nollevaux", "Noorderwijk",
        "Noordschote", "Nossegem", "Nothomb", "Nouvelles", "Noville", "Noville-les-Bois",
        "Noville-sur-Méhaigne", "Nukerke", "Néchin", "Obaix", "Obigies", "Obourg",
        "Ochamps", "Ocquier", "Odeigne", "Odeur", "Oedelem", "Oekene", "Oelegem", "Oeren",
        "Oeselgem", "Oetingen", "Oeudeghien", "Oevel", "Offagne", "Ogy", "Ohain", "Ohey",
        "Oignies-en-Thiérache", "Oisquercq", "Oizy", "Okegem", "Olen", "Oleye",
        "Ollignies", "Olloy-sur-Viroin", "Olmen", "Olne", "Olsene", "Omal", "Ombret",
        "Omezée", "On", "Onhaye", "Onkerzele", "Onnezies", "Onoz",
        "Onze-Lieve-Vrouw-Lombeek", "Onze-Lieve-Vrouw-Waver", "Ooigem", "Ooike",
        "Oombergen", "Oorbeek", "Oordegem", "Oostakker", "Oostduinkerke", "Oosteeklo",
        "Oostende", "Oosterzele", "Oostham", "Oostkamp", "Oostkerke-Damme",
        "Oostkerke-Diksmuide", "Oostmalle", "Oostnieuwkerke", "Oostrozebeke",
        "Oostvleteren", "Oostwinkel", "Opbrakel", "Opdorp", "Opglabbeek", "Opgrimbie",
        "Ophain-Bois-Seigneur-Isaac", "Ophasselt", "Opheers", "Opheylissem", "Ophoven",
        "Opitter", "Oplinter", "Opoeteren", "Opont", "Opprebais", "Oppuurs", "Opvelp",
        "Opwijk", "Orbais", "Orchimont", "Orcq", "Ordingen", "Oret", "Oreye", "Orgeo",
        "Ormeignies", "Orp-Jauche", "Orp-le-Grand", "Orroir", "Orsmaal-Gussenhoven",
        "Ortho", "Ostiches", "Otegem", "Oteppe", "Othée", "Otrange", "Ottenburg",
        "Ottergem", "Ottignies", "Ottignies-Louvain-la-Neuve", "Oud-Heverlee",
        "Oud-Turnhout", "Oudegem", "Oudekapelle", "Oudenaarde", "Oudenaken", "Oudenburg",
        "Oudergem", "Ouffet", "Ougrée", "Oupeye", "Outer", "Outgaarden", "Outrelouxhe",
        "Outrijve", "Ouwegem", "Overboelare", "Overhespen", "Overijse", "Overmere",
        "Overpelt", "Overrepen", "Overwinden", "Paal", "Paifve", "Pailhe", "Paliseul",
        "Pamel", "Papignies", "Parike", "Passendale", "Patignies", "Paturages",
        "Paulatem", "Pecq", "Peer", "Peissant", "Pellaines", "Pellenberg", "Pepingen",
        "Pepinster", "Perk", "Pervijze", "Perwez", "Perwez-Haillot", "Pesche", "Pessoux",
        "Petegem-aan-de-Leie", "Petegem-aan-de-Schelde", "Petigny", "Petit-Fays",
        "Petit-Hallet", "Petit-Rechain", "Petit-Roeulx-lez-Braine",
        "Petit-Roeulx-lez-Nivelles", "Petit-Thier", "Petite-Chapelle", "Peutie",
        "Philippeville", "Pipaix", "Piringen", "Pironchamps", "Pittem", "Piéton",
        "Piétrain", "Piétrebais", "Plainevaux", "Plancenoit", "Ploegsteert", "Plombières",
        "Poederlee", "Poeke", "Poelkapelle", "Poesele", "Pollare", "Polleur",
        "Pollinkhove", "Pommeroeul", "Pondrôme", "Pont-de-Loup", "Pont-à-Celles",
        "Pontillas", "Poperinge", "Poppel", "Popuelles", "Porcheresse", "Pottes",
        "Poucet", "Poulseur", "Poupehan", "Pousset", "Presgaux", "Presles",
        "Profondeville", "Proven", "Pry", "Pulderbos", "Pulle", "Purnode", "Pussemange",
        "Putte", "Puurs", "Péronnes-lez-Antoing", "Péronnes-lez-Binche", "Péruwelz",
        "Quaregnon", "Quartes", "Quenast", "Queue-du-Bois", "Quevaucamps", "Quiévrain",
        "Quévy", "Quévy-le-Grand", "Quévy-le-Petit", "Rachecourt", "Racour", "Raeren",
        "Ragnies", "Rahier", "Ramegnies", "Ramegnies-Chin", "Ramelot", "Ramillies-Offus",
        "Ramsdonk", "Ramsel", "Ramskapelle-Knokke-Heist", "Ramskapelle-Nieuwpoort",
        "Rance", "Ransart", "Ransberg", "Ranst", "Ravels", "Rebaix", "Rebecq",
        "Rebecq-Rognon", "Recht", "Recogne", "Redu", "Reet", "Rekem", "Rekkem", "Relegem",
        "Remagne", "Remersdaal", "Remicourt", "Rendeux", "Reninge", "Reningelst",
        "Renlies", "Reppel", "Ressaix", "Ressegem", "Resteigne", "Retie", "Retinne",
        "Reuland", "Rhisnes", "Richelle", "Riemst", "Rienne", "Rijkel", "Rijkevorsel",
        "Rijkhoven", "Rijmenam", "Riksingen", "Rillaar", "Rivière", "Rixensart", "Rièzes",
        "Robechies", "Robelmont", "Robertville", "Roborst", "Rochefort", "Rochehaut",
        "Rocherath", "Roclenge-sur-Geer", "Rocourt", "Roesbrugge-Haringe", "Roeselare",
        "Rognée", "Roisin", "Roksem", "Rollegem", "Rollegem-Kapelle", "Roloux", "Roly",
        "Romedenne", "Romershoven", "Romerée", "Romsée", "Rongy", "Ronquières", "Ronse",
        "Ronsele", "Roosbeek", "Roosdaal", "Roselies", "Rosières", "Rosmeer",
        "Rosoux-Crenwick", "Rossignol", "Rosée", "Rotem", "Rotheux-Rimière", "Rotselaar",
        "Roucourt", "Rouveroy", "Rouvreux", "Rouvroy", "Roux", "Roux-Miroir", "Roy",
        "Rozebeke", "Ruddervoorde", "Ruette", "Ruien", "Ruisbroek", "Ruiselede",
        "Rukkelingen-Loon", "Rulles", "Rumbeke", "Rumes", "Rumillies", "Rummen",
        "Rumsdorp", "Rumst", "Runkelen", "Rupelmonde", "Russeignies", "Rutten", "Rèves",
        "Saint-Amand", "Saint-André", "Saint-Aubin", "Saint-Denis", "Saint-Denis-Bovesse",
        "Saint-Georges-sur-Meuse", "Saint-Germain", "Saint-Ghislain", "Saint-Gérard",
        "Saint-Géry", "Saint-Hubert", "Saint-Jean-Geest", "Saint-Léger", "Saint-Marc",
        "Saint-Mard", "Saint-Martin", "Saint-Maur", "Saint-Médard", "Saint-Nicolas",
        "Saint-Pierre", "Saint-Remy", "Saint-Remy-Geest", "Saint-Sauveur",
        "Saint-Servais", "Saint-Symphorien", "Saint-Séverin", "Saint-Vaast",
        "Saint-Vincent", "Sainte-Cécile", "Sainte-Marie-Chevigny",
        "Sainte-Marie-sur-Semois", "Sainte-Ode", "Saintes", "Saive", "Salles", "Samart",
        "Sambreville", "Samrée", "Sankt-Vith", "Sars-la-Bruyère", "Sars-la-Buissière",
        "Sart-Bernard", "Sart-Custinne", "Sart-Dames-Avelines", "Sart-Eustache",
        "Sart-Saint-Laurent", "Sart-en-Fagne", "Sart-lez-Spa", "Sautin", "Sautour",
        "Sauvenière", "Schaarbeek", "Schaffen", "Schalkhoven", "Schaltin", "Schelderode",
        "Scheldewindeke", "Schelle", "Schellebelle", "Schendelbeke", "Schepdaal",
        "Scherpenheuvel", "Scherpenheuvel-Zichem", "Schilde", "Schoonaarde", "Schore",
        "Schorisse", "Schoten", "Schriek", "Schuiferskapelle", "Schulen", "Schönberg",
        "Sclayn", "Scy", "Seilles", "Seloignes", "Semmerzake", "Seneffe", "Sensenruth",
        "Seny", "Senzeille", "Septon", "Seraing", "Seraing-le-Château", "Serinchamps",
        "Serskamp", "Serville", "Sibret", "Signeulx", "Sijsele", "Silenrieux", "Silly",
        "Sinaai-Waas", "Sinsin", "Sint-Agatha-Berchem", "Sint-Agatha-Rode", "Sint-Amands",
        "Sint-Amandsberg", "Sint-Andries", "Sint-Antelinks", "Sint-Baafs-Vijve",
        "Sint-Blasius-Boekel", "Sint-Denijs", "Sint-Denijs-Boekel", "Sint-Denijs-Westrem",
        "Sint-Eloois-Vijve", "Sint-Eloois-Winkel", "Sint-Genesius-Rode", "Sint-Gillis",
        "Sint-Gillis-Waas", "Sint-Gillis-bij-Dendermonde", "Sint-Goriks-Oudenhove",
        "Sint-Huibrechts-Hern", "Sint-Huibrechts-Lille", "Sint-Jacobs-Kapelle",
        "Sint-Jan", "Sint-Jan-in-Eremo", "Sint-Jans-Molenbeek", "Sint-Job-in-'t-Goor",
        "Sint-Joost-ten-Node", "Sint-Joris-Beernem", "Sint-Joris-Nieuwpoort",
        "Sint-Joris-Weert", "Sint-Joris-Winge", "Sint-Katelijne-Waver",
        "Sint-Katherina-Lombeek", "Sint-Kornelis-Horebeke", "Sint-Kruis",
        "Sint-Kruis-Winkel", "Sint-Kwintens-Lennik", "Sint-Lambrechts-Herk",
        "Sint-Lambrechts-Woluwe", "Sint-Laureins", "Sint-Laureins-Berchem",
        "Sint-Lenaarts", "Sint-Lievens-Esse", "Sint-Lievens-Houtem", "Sint-Margriete",
        "Sint-Margriete-Houtem", "Sint-Maria-Horebeke", "Sint-Maria-Latem",
        "Sint-Maria-Lierde", "Sint-Maria-Oudenhove-Brakel",
        "Sint-Maria-Oudenhove-Zottegem", "Sint-Martens-Bodegem", "Sint-Martens-Latem",
        "Sint-Martens-Leerne", "Sint-Martens-Lennik", "Sint-Martens-Lierde",
        "Sint-Martens-Voeren", "Sint-Michiels", "Sint-Niklaas", "Sint-Pauwels",
        "Sint-Pieters-Kapelle", "Sint-Pieters-Leeuw", "Sint-Pieters-Rode",
        "Sint-Pieters-Voeren", "Sint-Pieters-Woluwe", "Sint-Rijkers",
        "Sint-Stevens-Woluwe", "Sint-Truiden", "Sint-Ulriks-Kapelle", "Sippenaeken",
        "Sirault", "Sivry", "Sivry-Rance", "Sleidinge", "Slijpe", "Slins", "Sluizen",
        "Smeerebbe-Vloerzegem", "Smetlede", "Smuid", "Snaaskerke", "Snellegem",
        "Soheit-Tinlot", "Sohier", "Soignies", "Soiron", "Solre-Saint-Géry",
        "Solre-sur-Sambre", "Sombreffe", "Somme-Leuze", "Sommethonne", "Sommière",
        "Somzée", "Sorinne-la-Longue", "Sorinnes", "Sorée", "Sosoye", "Sougné-Remouchamps",
        "Soulme", "Soumagne", "Soumoy", "Sourbrodt", "Souvret", "Sovet", "Soy", "Soye",
        "Spa", "Spalbeek", "Spermalie", "Spiennes", "Spiere", "Spiere-Helkijn", "Spontin",
        "Spouwen", "Sprimont", "Spy", "Stabroek", "Staden", "Stalhille", "Stambruges",
        "Stave", "Stavele", "Stavelot", "Steendorp", "Steenhuffel",
        "Steenhuize-Wijnhuize", "Steenkerke", "Steenkerque", "Steenokkerzeel", "Stekene",
        "Stembert", "Stene", "Sterrebeek", "Stevoort", "Stokrooie", "Stoumont",
        "Straimont", "Strijpen", "Strijtem", "Strombeek-Bever", "Strée", "Strée-lez-Huy",
        "Strépy-Bracquegnies", "Stuivekenskerke", "Suarlée", "Sugny", "Surice", "Suxy",
        "Sélange", "Tailles", "Taintignies", "Tamines", "Tarcienne", "Tavier", "Taviers",
        "Tavigny", "Tellin", "Templeuve", "Temploux", "Temse", "Tenneville", "Teralfene",
        "Terhagen", "Termes", "Ternat", "Tertre", "Tervuren", "Terwagne", "Tessenderlo",
        "Testelt", "Teuven", "Theux", "Thiaumont", "Thieu", "Thieulain", "Thieusies",
        "Thimister", "Thimister-Clermont", "Thimougies", "Thiméon", "Thines", "Thirimont",
        "Thisnes", "Thommen", "Thon", "Thorembais-Saint-Trond", "Thorembais-les-Béguines",
        "Thoricourt", "Thuillies", "Thuin", "Thulin", "Thumaide", "Thy-le-Bauduin",
        "Thy-le-Château", "Thynes", "Thys", "Tiegem", "Tielen", "Tielrode", "Tielt",
        "Tielt-Winge", "Tienen", "Tignée", "Tihange", "Tildonk", "Tilff", "Tillet",
        "Tilleur", "Tillier", "Tilly", "Tinlot", "Tintange", "Tintigny", "Tisselt",
        "Toernich", "Tohogne", "Tollembeek", "Tongeren", "Tongerlo", "Tongre-Notre-Dame",
        "Tongre-Saint-Martin", "Tongrinne", "Tontelange", "Torgny", "Torhout", "Tourinne",
        "Tourinnes-Saint-Lambert", "Tournai", "Tournay", "Tourpes", "Transinne",
        "Trazegnies", "Treignes", "Trembleur", "Tremelo", "Trivières", "Trognée",
        "Trois-Ponts", "Trooz", "Tubize", "Turnhout", "Ucimont", "Uikhoven", "Uitbergen",
        "Uitkerke", "Ukkel", "Ulbeek", "Upigny", "Ursel", "Vaalbeek", "Val-Meer", "Vance",
        "Varendonk", "Varsenare", "Vaucelles", "Vaulx", "Vaulx-lez-Chimay",
        "Vaux-Chavanne", "Vaux-et-Borset", "Vaux-lez-Rosières", "Vaux-sous-Chèvremont",
        "Vaux-sur-Sûre", "Vechmaal", "Vedrin", "Veerle", "Velaine-sur-Sambre", "Velaines",
        "Veldegem", "Veldwezelt", "Vellereille-le-Sec", "Vellereille-les-Brayeux", "Velm",
        "Velroux", "Veltem-Beisem", "Velzeke-Ruddershove", "Vencimont", "Vergnies",
        "Verlaine", "Verlée", "Verrebroek", "Vertrijk", "Verviers", "Vesqueville",
        "Veulen", "Veurne", "Vezin", "Vezon", "Viane", "Vichte", "Vielsalm", "Viemme",
        "Viersel", "Vierset-Barse", "Vierves-sur-Viroin", "Viesville", "Vieux-Genappe",
        "Vieux-Waleffe", "Vieuxville", "Villance", "Ville-Pommeroeul", "Ville-en-Hesbaye",
        "Ville-sur-Haine", "Villerot", "Villers-Deux-Eglises", "Villers-Notre-Dame",
        "Villers-Perwin", "Villers-Poterie", "Villers-Saint-Amand",
        "Villers-Saint-Ghislain", "Villers-Saint-Siméon", "Villers-Sainte-Gertrude",
        "Villers-aux-Tours", "Villers-devant-Orval", "Villers-en-Fagne",
        "Villers-l'Evêque", "Villers-la-Bonne-Eau", "Villers-la-Loue", "Villers-la-Tour",
        "Villers-la-Ville", "Villers-le-Bouillet", "Villers-le-Gambon",
        "Villers-le-Peuplier", "Villers-le-Temple", "Villers-lez-Heest",
        "Villers-sur-Lesse", "Villers-sur-Semois", "Vilvoorde", "Vinalmont",
        "Vinderhoute", "Vinkem", "Vinkt", "Virelles", "Virginal-Samme", "Viroinval",
        "Virton", "Vissenaken", "Visé", "Vitrival", "Vivegnis", "Vivy", "Vladslo",
        "Vlamertinge", "Vlekkem", "Vleteren", "Vlezenbeek", "Vliermaal", "Vliermaalroot",
        "Vlierzele", "Vlijtingen", "Vlimmeren", "Vlissegem", "Vloesberg", "Vodecée",
        "Vodelée", "Voeren", "Vogenée", "Volkegem", "Vollezele", "Vonêche", "Voorde",
        "Voormezele", "Voort", "Voroux-Goreux", "Voroux-lez-Liers", "Vorselaar", "Vorsen",
        "Vorst", "Vosselaar", "Vosselare", "Vossem", "Vottem", "Vrasene", "Vremde",
        "Vreren", "Vresse-sur-Semois", "Vroenhoven", "Vucht", "Vurste", "Vyle-et-Tharoul",
        "Waanrode", "Waarbeke", "Waardamme", "Waarloos", "Waarmaarde", "Waarschoot",
        "Waasmont", "Waasmunster", "Waasten", "Wachtebeke", "Wadelincourt", "Wagnelée",
        "Waha", "Waillet", "Wakken", "Walcourt", "Walem", "Walhain", "Walhain-Saint-Paul",
        "Walhorn", "Walsbets", "Walshoutem", "Waltwilder", "Wambeek", "Wancennes",
        "Wandre", "Wanfercée-Baulet", "Wange", "Wangenies", "Wanlin", "Wanne",
        "Wannebecq", "Wannegem-Lede", "Wansin", "Wanze", "Wanzele", "Warchin", "Warcoing",
        "Wardin", "Waregem", "Waremme", "Waret-l'Evêque", "Waret-la-Chaussée",
        "Warisoulx", "Warnant", "Warnant-Dreye", "Warquignies", "Warsage", "Warzée",
        "Wasmes", "Wasmes-Audemez-Briffoeil", "Wasmuel", "Wasseiges", "Waterland-Oudeman",
        "Waterloo", "Watermaal-Bosvoorde", "Watervliet", "Watou", "Wattripont", "Waudrez",
        "Waulsort", "Wauthier-Braine", "Waver", "Wavreille", "Wayaux", "Ways", "Webbekom",
        "Wechelderzande", "Weelde", "Weerde", "Weert", "Wegnez", "Weillen", "Weismes",
        "Welden", "Welkenraedt", "Welle", "Wellen", "Wellin", "Wemmel", "Wenduine",
        "Werbomont", "Werchter", "Werken", "Werm", "Wervik", "Wespelaar", "Westende",
        "Westerlo", "Westkapelle", "Westkerke", "Westmalle", "Westmeerbeek", "Westouter",
        "Westrem", "Westrozebeke", "Westvleteren", "Wetteren", "Wevelgem", "Wez-Velvain",
        "Wezemaal", "Wezembeek-Oppem", "Wezeren", "Wibrin", "Wichelen", "Widooie",
        "Wiekevorst", "Wielsbeke", "Wierde", "Wiers", "Wiesme", "Wieze", "Wihogne",
        "Wihéries", "Wijchmaal", "Wijer", "Wijgmaal", "Wijnegem", "Wijshagen",
        "Wijtschate", "Wilderen", "Willaupuis", "Willebringen", "Willebroek", "Willemeau",
        "Willerzie", "Wilrijk", "Wilsele", "Wilskerke", "Wimmertingen", "Winenne",
        "Wingene", "Winksele", "Wintershoven", "Witry", "Wodecq", "Woesten", "Wolkrange",
        "Wolvertem", "Wommelgem", "Wommersom", "Wonck", "Wondelgem", "Wontergem",
        "Wortegem", "Wortegem-Petegem", "Wortel", "Woubrechtegem", "Woumen", "Wulpen",
        "Wulvergem", "Wulveringem", "Wuustwezel", "Wépion", "Wéris", "Xhendelesse",
        "Xhendremael", "Xhoris", "Yernée-Fraineux", "Yves-Gomezée", "Yvoir", "Zaffelare",
        "Zandbergen", "Zande", "Zandhoven", "Zandvliet", "Zandvoorde-Oostende",
        "Zandvoorde-Zonnebeke", "Zarlardinge", "Zarren", "Zaventem", "Zedelgem",
        "Zeebrugge", "Zegelsem", "Zele", "Zelem", "Zellik", "Zelzate", "Zemst",
        "Zepperen", "Zerkegem", "Zevekote", "Zeveneken", "Zeveren", "Zevergem", "Zichem",
        "Zichen-Zussen-Bolder", "Zillebeke", "Zingem", "Zoerle-Parwijs", "Zoersel",
        "Zolder", "Zomergem", "Zonhoven", "Zonnebeke", "Zonnegem", "Zottegem",
        "Zoutenaaie", "Zoutleeuw", "Zuidschote", "Zuienkerke", "Zulte", "Zulzeke",
        "Zutendaal", "Zwalm", "Zwevegem", "Zwevezele", "Zwijnaarde", "Zwijndrecht",
        "Zétrud-Lumay", "l'Escaillère",
    )

    provinces = (
        "Antwerpen", "Henegouwen", "Limburg", "Luik", "Luxemburg", "Namen",
        "Oost-Vlaanderen", "Vlaams-Brabant", "Waals-Brabant", "West-Vlaanderen",
    )

    street_name_formats = (
        '{{first_name}}{{street_suffix}}',
    )

    street_address_formats = (
        '{{street_name}} {{building_number}}',
    )

    address_formats = (
        "{{street_address}}\n{{postcode}}\n{{city}}",
        "{{street_address}}\n{{postcode}} {{city}}",
    )

    def province(self):
        return self.random_element(self.provinces)

    def city(self):
        return self.random_element(self.cities)
