/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCollectionBinding
extends NotNullDeserializeBinding
implements MultiNodeBinding {
    private List<Binding> itemBindings;
    protected final Class<?> itemType;
    @Nullable
    private final AbstractCollection annotation;
    @Nullable
    protected final XCollection newAnnotation;
    private Serializer serializer;

    AbstractCollectionBinding(@NotNull Class elementType, @Nullable MutableAccessor accessor) {
        if (elementType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(0);
        }
        super(accessor);
        this.itemType = elementType;
        XCollection xCollection = this.newAnnotation = accessor == null ? null : accessor.getAnnotation(XCollection.class);
        this.annotation = this.newAnnotation == null ? (accessor == null ? null : accessor.getAnnotation(AbstractCollection.class)) : null;
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        if (originalType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(1);
        }
        if (serializer2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(2);
        }
        this.serializer = serializer2;
    }

    private boolean isSurroundWithTag() {
        return this.newAnnotation == null && (this.annotation == null || this.annotation.surroundWithTag());
    }

    @NotNull
    private Class<?>[] getElementTypes() {
        if (this.newAnnotation != null) {
            Class<?>[] classArray = this.newAnnotation.elementTypes();
            if (classArray == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(3);
            }
            return classArray;
        }
        Class[] classArray = this.annotation == null ? ArrayUtil.EMPTY_CLASS_ARRAY : this.annotation.elementTypes();
        if (classArray == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(4);
        }
        return classArray;
    }

    @NotNull
    private synchronized List<Binding> getElementBindings() {
        if (this.itemBindings == null) {
            Binding binding = this.serializer.getBinding(this.itemType);
            Class<?>[] elementTypes = this.getElementTypes();
            if (elementTypes.length == 0) {
                this.itemBindings = binding == null ? Collections.emptyList() : Collections.singletonList(binding);
            } else {
                this.itemBindings = new SmartList<Binding>();
                if (binding != null) {
                    this.itemBindings.add(binding);
                }
                for (Class<?> aClass2 : elementTypes) {
                    Binding b = this.serializer.getBinding(aClass2);
                    if (b == null || this.itemBindings.contains(b)) continue;
                    this.itemBindings.add(b);
                }
                if (this.itemBindings.isEmpty()) {
                    this.itemBindings = Collections.emptyList();
                }
            }
        }
        List<Binding> list2 = this.itemBindings;
        if (list2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    private Binding getElementBinding(@NotNull Element element) {
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(6);
        }
        for (Binding binding : this.getElementBindings()) {
            if (!binding.isBoundTo(element)) continue;
            return binding;
        }
        return null;
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context2, @NotNull Element element) {
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(8);
        }
        if (!this.isSurroundWithTag()) {
            Object object = this.doDeserializeList(context2, Collections.singletonList(element));
            if (object == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(9);
            }
            return object;
        }
        Object object = this.doDeserializeList(context2, element.getChildren());
        if (object == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(10);
        }
        return object;
    }

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context2, @NotNull List<? extends Element> elements) {
        if (elements == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(11);
        }
        if (!this.isSurroundWithTag()) {
            return this.doDeserializeList(context2, elements);
        }
        assert (elements.size() == 1);
        Element element = elements.get(0);
        return this.doDeserializeList(context2 == null && element.getName().equals("set") ? new HashSet() : context2, element.getChildren());
    }

    @NotNull
    protected abstract Object doDeserializeList(@Nullable Object var1, @NotNull List<? extends Element> var2);

    protected final Object deserializeItem(@NotNull Element node, @Nullable Object context2) {
        Binding binding;
        if (node == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(12);
        }
        if ((binding = this.getElementBinding(node)) == null) {
            String attributeName = this.getValueAttributeName();
            String value = attributeName.isEmpty() ? XmlSerializerImpl.getTextValue(node, "") : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value, this.itemType);
        }
        return binding.deserializeUnsafe(context2, node);
    }

    @NotNull
    private String getElementName() {
        if (this.newAnnotation != null) {
            String string = this.newAnnotation.elementName();
            if (string == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = this.annotation == null ? "option" : this.annotation.elementTag();
        if (string == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private String getValueAttributeName() {
        if (this.newAnnotation != null) {
            String string = this.newAnnotation.valueAttributeName();
            if (string == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
        if (string == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(17);
        }
        if (this.isSurroundWithTag()) {
            return element.getName().equals(this.getCollectionTagName(null));
        }
        if (this.getElementBindings().isEmpty()) {
            return element.getName().equals(this.getElementName());
        }
        return this.getElementBinding(element) != null;
    }

    @NotNull
    protected abstract String getCollectionTagName(@Nullable Object var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 6: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementBindings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAttributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementBinding";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserializeItem";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

