/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ArrayHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ArrayLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionLoopHeader;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0011*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;", "scopeOwnerSymbol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;Lkotlin/jvm/functions/Function0;)V", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "processHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "castIfNecessary", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "targetType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "numberCastFunctionName", "Lorg/jetbrains/kotlin/name/Name;", "ensureNotNullable", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "expression", "ir.backend.common"})
public final class HeaderProcessor {
    private final Symbols<CommonBackendContext> symbols;
    private final CommonBackendContext context;
    private final HeaderInfoBuilder headerInfoBuilder;
    private final Function0<IrSymbol> scopeOwnerSymbol;

    @Nullable
    public final ForLoopHeader processHeader(@NotNull IrVariable variable2) {
        ForLoopHeader forLoopHeader;
        Intrinsics.checkParameterIsNotNull(variable2, "variable");
        boolean bl = Intrinsics.areEqual(variable2.getOrigin(), IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!IrTypeUtilsKt.isSubtypeOfClass(variable2.getType(), this.symbols.getIterator())) {
            return null;
        }
        IrExpression irExpression = variable2.getInitializer();
        if (!(irExpression instanceof IrCall)) {
            irExpression = null;
        }
        IrCall irCall = (IrCall)irExpression;
        IrExpression iterable = irCall != null ? irCall.getDispatchReceiver() : null;
        Object object = iterable;
        if (object == null || (object = (HeaderInfo)object.accept(this.headerInfoBuilder, null)) == null) {
            return null;
        }
        Object headerInfo = object;
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder(this.context, this.scopeOwnerSymbol.invoke(), variable2.getStartOffset(), variable2.getEndOffset());
        boolean bl5 = false;
        boolean bl6 = false;
        DeclarationIrBuilder $this$builder = builder;
        boolean bl7 = false;
        Object object2 = headerInfo;
        boolean bl8 = false;
        boolean bl9 = false;
        Object $this$with = object2;
        boolean bl10 = false;
        IrVariable inductionVariable = Scope.createTemporaryVariable$default($this$builder.getScope(), this.castIfNecessary(((HeaderInfo)$this$with).getFirst(), ((HeaderInfo)$this$with).getProgressionType().elementType($this$builder.getContext().getIrBuiltIns()), ((HeaderInfo)$this$with).getProgressionType().getElementCastFunctionName()), "inductionVariable", true, null, IrDeclarationOrigin.FOR_LOOP_IMPLICIT_VARIABLE.INSTANCE, null, 40, null);
        IrVariable lastValue = Scope.createTemporaryVariable$default($this$builder.getScope(), this.ensureNotNullable($this$builder, this.castIfNecessary(((HeaderInfo)$this$with).getLast(), ((HeaderInfo)$this$with).getProgressionType().elementType($this$builder.getContext().getIrBuiltIns()), ((HeaderInfo)$this$with).getProgressionType().getElementCastFunctionName())), "last", false, null, IrDeclarationOrigin.FOR_LOOP_IMPLICIT_VARIABLE.INSTANCE, null, 44, null);
        IrVariable stepValue = Scope.createTemporaryVariable$default($this$builder.getScope(), this.ensureNotNullable($this$builder, this.castIfNecessary(((HeaderInfo)$this$with).getStep(), ((HeaderInfo)$this$with).getProgressionType().stepType($this$builder.getContext().getIrBuiltIns()), ((HeaderInfo)$this$with).getProgressionType().getStepCastFunctionName())), "step", false, null, IrDeclarationOrigin.FOR_LOOP_IMPLICIT_VARIABLE.INSTANCE, null, 44, null);
        Object object3 = headerInfo;
        if (object3 instanceof ArrayHeaderInfo) {
            forLoopHeader = new ArrayLoopHeader((ArrayHeaderInfo)headerInfo, inductionVariable, lastValue, stepValue);
        } else if (object3 instanceof ProgressionHeaderInfo) {
            forLoopHeader = new ProgressionLoopHeader((ProgressionHeaderInfo)headerInfo, inductionVariable, lastValue, stepValue);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return forLoopHeader;
    }

    private final IrExpression ensureNotNullable(@NotNull DeclarationIrBuilder $this$ensureNotNullable, IrExpression expression2) {
        return expression2.getType() instanceof IrSimpleType && IrTypeUtilsKt.isNullable(expression2.getType()) ? (IrExpression)ExpressionHelpersKt.irImplicitCast($this$ensureNotNullable, expression2, IrTypesKt.makeNotNull(expression2.getType())) : expression2;
    }

    private final IrExpression castIfNecessary(@NotNull IrExpression $this$castIfNecessary, IrType targetType, Name numberCastFunctionName) {
        IrExpression irExpression;
        if (Intrinsics.areEqual(IrTypesKt.toKotlinType($this$castIfNecessary.getType()), IrTypesKt.toKotlinType(targetType))) {
            irExpression = $this$castIfNecessary;
        } else {
            IrSimpleFunction element$iv;
            block4: {
                IrClass irClass = IrTypesKt.getClass($this$castIfNecessary.getType());
                if (irClass == null) {
                    Intrinsics.throwNpe();
                }
                Sequence<IrSimpleFunction> $this$first$iv = IrUtilsKt.getFunctions(irClass);
                boolean $i$f$first = false;
                Iterator<IrSimpleFunction> iterator2 = $this$first$iv.iterator();
                while (iterator2.hasNext()) {
                    IrSimpleFunction it = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), numberCastFunctionName)) continue;
                    break block4;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction function2 = element$iv;
            IrCallImpl irCallImpl = new IrCallImpl($this$castIfNecessary.getStartOffset(), $this$castIfNecessary.getEndOffset(), function2.getReturnType(), function2.getSymbol());
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl3 = false;
            $this$apply.setDispatchReceiver($this$castIfNecessary);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    public HeaderProcessor(@NotNull CommonBackendContext context2, @NotNull HeaderInfoBuilder headerInfoBuilder2, @NotNull Function0<? extends IrSymbol> scopeOwnerSymbol) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(headerInfoBuilder2, "headerInfoBuilder");
        Intrinsics.checkParameterIsNotNull(scopeOwnerSymbol, "scopeOwnerSymbol");
        this.context = context2;
        this.headerInfoBuilder = headerInfoBuilder2;
        this.scopeOwnerSymbol = scopeOwnerSymbol;
        this.symbols = this.context.getIr().getSymbols();
    }
}

