# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# <pep8 compliant>

bl_info = {
    "name": "Hotkey: 'Ctrl Shift Tab'",
    "description": "Snap Element Menu",
    "author": "pitiwazou, meta-androcto",
    "version": (0, 1, 1),
    "blender": (2, 80, 0),
    "location": "3d View",
    "warning": "",
    "wiki_url": "",
    "category": "Snap Element Pie"
    }

import bpy
from bpy.types import (
        Menu,
        Operator,
        )


# Pie Snap - Shift + Tab
class PIE_MT_Snaping(Menu):
    bl_idname = "PIE_MT_snapping"
    bl_label = "Pie Snapping"

    def draw(self, context):
        layout = self.layout
        pie = layout.menu_pie()
        # 4 - LEFT
        pie.operator("snap.vertex", text="Vertex", icon='SNAP_VERTEX')
        # 6 - RIGHT
        pie.operator("snap.face", text="Face", icon='SNAP_FACE')
        # 2 - BOTTOM
        pie.operator("snap.edge", text="Edge", icon='SNAP_EDGE')
        # 8 - TOP
        pie.prop(context.tool_settings, "use_snap", text="Snap On/Off")
        # 7 - TOP - LEFT
        pie.operator("snap.volume", text="Volume", icon='SNAP_VOLUME')
        # 9 - TOP - RIGHT
        pie.operator("snap.increment", text="Increment", icon='SNAP_INCREMENT')
        # 1 - BOTTOM - LEFT
        pie.operator("snap.alignrotation", text="Align rotation", icon='SNAP_NORMAL')
        # 3 - BOTTOM - RIGHT
        pie.operator("wm.call_menu_pie", text="Snap Target", icon='NONE').name = "SNAP_MT_targetmenu"


class PIE_OT_SnapActive(Operator):
    bl_idname = "snap.active"
    bl_label = "Snap Active"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        ts = context.tool_settings

        if ts.use_snap is True:
            ts.use_snap = False

        elif ts.use_snap is False:
            ts.use_snap = True

        return {'FINISHED'}


class PIE_OT_SnapVolume(Operator):
    bl_idname = "snap.volume"
    bl_label = "Snap Volume"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        ts = context.tool_settings
        if ts.use_snap is False:
            ts.use_snap = True
            ts.snap_elements = {'VOLUME'}
        if ts.snap_elements != {'VOLUME'}:
            ts.snap_elements = {'VOLUME'}
        return {'FINISHED'}


class PIE_OT_SnapFace(Operator):
    bl_idname = "snap.face"
    bl_label = "Snap Face"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        ts = context.tool_settings

        if ts.use_snap is False:
            ts.use_snap = True
            ts.snap_elements = {'FACE'}

        if ts.snap_elements != {'FACE'}:
            ts.snap_elements = {'FACE'}
        return {'FINISHED'}


class PIE_OT_SnapEdge(Operator):
    bl_idname = "snap.edge"
    bl_label = "Snap Edge"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        ts = context.tool_settings

        if ts.use_snap is False:
            ts.use_snap = True
            ts.snap_elements = {'EDGE'}

        if ts.snap_elements != {'EDGE'}:
            ts.snap_elements = {'EDGE'}
        return {'FINISHED'}


class PIE_OT_SnapVertex(Operator):
    bl_idname = "snap.vertex"
    bl_label = "Snap Vertex"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        ts = context.tool_settings

        if ts.use_snap is False:
            ts.use_snap = True
            ts.snap_elements = {'VERTEX'}

        if ts.snap_elements != {'VERTEX'}:
            ts.snap_elements = {'VERTEX'}
        return {'FINISHED'}


class PIE_OT_SnapIncrement(Operator):
    bl_idname = "snap.increment"
    bl_label = "Snap Increment"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        ts = context.tool_settings

        if ts.use_snap is False:
            ts.use_snap = True
            ts.snap_elements = {'INCREMENT'}

        if ts.snap_elements != {'INCREMENT'}:
            ts.snap_elements = {'INCREMENT'}
        return {'FINISHED'}


class PIE_OT_SnapAlignRotation(Operator):
    bl_idname = "snap.alignrotation"
    bl_label = "Snap Align rotation"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        ts = context.tool_settings

        if ts.use_snap_align_rotation is True:
            ts.use_snap_align_rotation = False

        elif ts.use_snap_align_rotation is False:
            ts.use_snap_align_rotation = True

        return {'FINISHED'}


class PIE_OT_SnapTargetVariable(Operator):
    bl_idname = "object.snaptargetvariable"
    bl_label = "Snap Target Variable"
    bl_options = {'REGISTER', 'UNDO'}

    variable: bpy.props.StringProperty()

    @classmethod
    def poll(cls, context):
        return True

    def execute(self, context):
        ts = context.tool_settings

        ts.snap_target = self.variable
        return {'FINISHED'}

# Menu Snap Target - Shift + Tab


class PIE_MT_SnapTargetMenu(Menu):
    bl_idname = "SNAP_MT_targetmenu"
    bl_label = "Snap Target Menu"

    def draw(self, context):
        layout = self.layout
        pie = layout.menu_pie()
        # 4 - LEFT
        pie.operator("object.snaptargetvariable", text="Active").variable = 'ACTIVE'
        # 6 - RIGHT
        pie.operator("object.snaptargetvariable", text="Median").variable = 'MEDIAN'
        # 2 - BOTTOM
        pie.operator("object.snaptargetvariable", text="Center").variable = 'CENTER'
        # 8 - TOP
        pie.operator("object.snaptargetvariable", text="Closest").variable = 'CLOSEST'
        # 7 - TOP - LEFT
        # 9 - TOP - RIGHT
        # 1 - BOTTOM - LEFT
        # 3 - BOTTOM - RIGHT


# Pie Snapping - Shift + Tab

classes = (
    PIE_MT_Snaping,
    PIE_MT_SnapTargetMenu,
    PIE_OT_SnapActive,
    PIE_OT_SnapVolume,
    PIE_OT_SnapFace,
    PIE_OT_SnapEdge,
    PIE_OT_SnapVertex,
    PIE_OT_SnapIncrement,
    PIE_OT_SnapAlignRotation,
    PIE_OT_SnapTargetVariable
    )

addon_keymaps = []


def register():
    for cls in classes:
        bpy.utils.register_class(cls)

    wm = bpy.context.window_manager
    if wm.keyconfigs.addon:
        # Snapping
        km = wm.keyconfigs.addon.keymaps.new(name='3D View Generic', space_type='VIEW_3D')
        kmi = km.keymap_items.new('wm.call_menu_pie', 'TAB', 'PRESS', ctrl=True, shift=True)
        kmi.properties.name = "PIE_MT_snapping"
        addon_keymaps.append((km, kmi))


def unregister():
    for cls in classes:
        bpy.utils.unregister_class(cls)

    wm = bpy.context.window_manager
    kc = wm.keyconfigs.addon
    if kc:
        for km, kmi in addon_keymaps:
            km.keymap_items.remove(kmi)
    addon_keymaps.clear()


if __name__ == "__main__":
    register()
