/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\fH\u0082\bJ+\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\fH\u0082\bJ \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010!\u001a\u00020\"2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010$\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\f\u0010%\u001a\u00020&*\u00020\u0007H\u0002J\f\u0010'\u001a\u00020(*\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "()V", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "declarationsWithStatuses", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "storeClass", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "klass", "computeResult", "Lkotlin/Function0;", "storeDeclaration", "declaration", "transformConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "data", "", "transformDeclarationStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "declarationStatus", "transformMemberDeclaration", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "transformNamedFunction", "namedFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "transformProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "transformRegularClass", "regularClass", "resolveModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "resolveVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "resolve"})
public final class FirStatusResolveTransformer
extends FirAbstractTreeTransformer {
    private final List<FirDeclaration> declarationsWithStatuses;
    private final List<FirRegularClass> classes;

    private final Visibility resolveVisibility(@NotNull FirDeclaration $this$resolveVisibility) {
        FirRegularClass klass2;
        if ($this$resolveVisibility instanceof FirConstructor && (klass2 = CollectionsKt.lastOrNull(this.classes)) != null && (klass2.getClassKind() == ClassKind.ENUM_CLASS || klass2.getModality() == Modality.SEALED)) {
            Visibility visibility = Visibilities.PRIVATE;
            Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PRIVATE");
            return visibility;
        }
        Visibility visibility = Visibilities.PUBLIC;
        Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PUBLIC");
        return visibility;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Modality resolveModality(@NotNull FirDeclaration $this$resolveModality) {
        Modality modality;
        FirDeclaration firDeclaration = $this$resolveModality;
        if (firDeclaration instanceof FirEnumEntry) {
            modality = Modality.FINAL;
            return modality;
        }
        if (firDeclaration instanceof FirRegularClass) {
            if (((FirRegularClass)$this$resolveModality).getClassKind() == ClassKind.INTERFACE) {
                modality = Modality.ABSTRACT;
                return modality;
            }
            modality = Modality.FINAL;
            return modality;
        }
        if (!(firDeclaration instanceof FirCallableMemberDeclaration)) {
            modality = Modality.FINAL;
            return modality;
        }
        FirRegularClass containingClass = CollectionsKt.lastOrNull(this.classes);
        if (containingClass == null) {
            modality = Modality.FINAL;
            return modality;
        }
        if (containingClass.getClassKind() == ClassKind.INTERFACE) {
            if (Intrinsics.areEqual(((FirCallableMemberDeclaration)$this$resolveModality).getVisibility(), Visibilities.PRIVATE)) {
                modality = Modality.FINAL;
                return modality;
            }
            if ($this$resolveModality instanceof FirNamedFunction && ((FirNamedFunction)$this$resolveModality).getBody() == null) {
                modality = Modality.ABSTRACT;
                return modality;
            }
            if ($this$resolveModality instanceof FirProperty && ((FirProperty)$this$resolveModality).getInitializer() == null && ((FirProperty)$this$resolveModality).getGetter().getBody() == null) {
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$resolveModality).getSetter();
                if ((firPropertyAccessor != null ? firPropertyAccessor.getBody() : null) == null) {
                    modality = Modality.ABSTRACT;
                    return modality;
                }
            }
            modality = Modality.OPEN;
            return modality;
        }
        if (((FirCallableMemberDeclaration)$this$resolveModality).isOverride() && containingClass.getModality() != Modality.FINAL) {
            modality = Modality.OPEN;
            return modality;
        }
        modality = Modality.FINAL;
        return modality;
    }

    @NotNull
    public CompositeTransformResult<FirDeclarationStatus> transformDeclarationStatus(@NotNull FirDeclarationStatus declarationStatus, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declarationStatus, "declarationStatus");
        if (Intrinsics.areEqual(declarationStatus.getVisibility(), Visibilities.UNKNOWN) || declarationStatus.getModality() == null) {
            FirDeclaration declaration2 = CollectionsKt.last(this.declarationsWithStatuses);
            Visibility visibility = declarationStatus.getVisibility();
            Visibility visibility2 = Intrinsics.areEqual(visibility, Visibilities.UNKNOWN) ? this.resolveVisibility(declaration2) : declarationStatus.getVisibility();
            Modality modality = declarationStatus.getModality();
            if (modality == null) {
                modality = this.resolveModality(declaration2);
            }
            Modality modality2 = modality;
            FirDeclarationStatus resolvedStatus = ((FirDeclarationStatusImpl)declarationStatus).resolved(visibility2, modality2);
            FirElement $this$compose$iv = resolvedStatus;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        return super.transformDeclarationStatus(declarationStatus, data);
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(regularClass, "regularClass");
        FirStatusResolveTransformer this_$iv = this;
        boolean $i$f$storeClass = false;
        Collection collection = this_$iv.classes;
        boolean bl = false;
        collection.add(regularClass);
        boolean bl2 = false;
        CompositeTransformResult<FirDeclaration> result$iv = super.transformRegularClass(regularClass, data);
        this_$iv.classes.remove(CollectionsKt.getLastIndex(this_$iv.classes));
        return result$iv;
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformMemberDeclaration(@NotNull FirMemberDeclaration memberDeclaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(memberDeclaration, "memberDeclaration");
        FirStatusResolveTransformer this_$iv = this;
        boolean $i$f$storeDeclaration = false;
        Collection collection = this_$iv.declarationsWithStatuses;
        boolean bl = false;
        collection.add((FirDeclaration)memberDeclaration);
        boolean bl2 = false;
        CompositeTransformResult<FirDeclaration> result$iv = super.transformMemberDeclaration(memberDeclaration, data);
        this_$iv.declarationsWithStatuses.remove(CollectionsKt.getLastIndex(this_$iv.declarationsWithStatuses));
        return result$iv;
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(propertyAccessor, "propertyAccessor");
        FirStatusResolveTransformer this_$iv = this;
        boolean $i$f$storeDeclaration = false;
        Collection collection = this_$iv.declarationsWithStatuses;
        boolean bl = false;
        collection.add((FirDeclaration)propertyAccessor);
        boolean bl2 = false;
        CompositeTransformResult<FirDeclaration> result$iv = super.transformPropertyAccessor(propertyAccessor, data);
        this_$iv.declarationsWithStatuses.remove(CollectionsKt.getLastIndex(this_$iv.declarationsWithStatuses));
        return result$iv;
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformConstructor(@NotNull FirConstructor constructor, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        FirStatusResolveTransformer this_$iv = this;
        boolean $i$f$storeDeclaration = false;
        Collection collection = this_$iv.declarationsWithStatuses;
        boolean bl = false;
        collection.add((FirDeclaration)constructor);
        boolean bl2 = false;
        CompositeTransformResult<FirDeclaration> result$iv = super.transformConstructor(constructor, data);
        this_$iv.declarationsWithStatuses.remove(CollectionsKt.getLastIndex(this_$iv.declarationsWithStatuses));
        return result$iv;
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformNamedFunction(@NotNull FirNamedFunction namedFunction, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(namedFunction, "namedFunction");
        FirStatusResolveTransformer this_$iv = this;
        boolean $i$f$storeDeclaration = false;
        Collection collection = this_$iv.declarationsWithStatuses;
        boolean bl = false;
        collection.add((FirDeclaration)namedFunction);
        boolean bl2 = false;
        CompositeTransformResult<FirDeclaration> result$iv = super.transformNamedFunction(namedFunction, data);
        this_$iv.declarationsWithStatuses.remove(CollectionsKt.getLastIndex(this_$iv.declarationsWithStatuses));
        return result$iv;
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformProperty(@NotNull FirProperty property, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        FirStatusResolveTransformer this_$iv = this;
        boolean $i$f$storeDeclaration = false;
        Collection collection = this_$iv.declarationsWithStatuses;
        boolean bl = false;
        collection.add((FirDeclaration)property);
        boolean bl2 = false;
        CompositeTransformResult<FirDeclaration> result$iv = super.transformProperty(property, data);
        this_$iv.declarationsWithStatuses.remove(CollectionsKt.getLastIndex(this_$iv.declarationsWithStatuses));
        return result$iv;
    }

    public FirStatusResolveTransformer() {
        List list2;
        FirStatusResolveTransformer firStatusResolveTransformer = this;
        boolean bl = false;
        firStatusResolveTransformer.declarationsWithStatuses = list2 = (List)new ArrayList();
        firStatusResolveTransformer = this;
        bl = false;
        firStatusResolveTransformer.classes = list2 = (List)new ArrayList();
    }
}

