/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridesBackwardCompatibilityHelper;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmOverridesBackwardCompatibilityHelper$WhenMappings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmOverridesBackwardCompatibilityHelper;", "Lorg/jetbrains/kotlin/resolve/OverridesBackwardCompatibilityHelper;", "()V", "isOverridingOnlyDescriptorsThatCanBeImplicitlyOverridden", "", "overriddenDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "visitedDescriptors", "", "isPlatformSpecificDescriptorThatCanBeImplicitlyOverridden", "overrideCanBeOmitted", "overridingDescriptor", "frontend.java"})
public final class JvmOverridesBackwardCompatibilityHelper
implements OverridesBackwardCompatibilityHelper {
    public static final JvmOverridesBackwardCompatibilityHelper INSTANCE;

    @Override
    public boolean overrideCanBeOmitted(@NotNull CallableMemberDescriptor overridingDescriptor) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(overridingDescriptor, "overridingDescriptor");
            boolean bl2 = false;
            HashSet visitedDescriptors = new HashSet();
            Collection<? extends CallableMemberDescriptor> collection = overridingDescriptor.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, "overridingDescriptor.overriddenDescriptors");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl3 = false;
                    CallableMemberDescriptor callableMemberDescriptor = it;
                    Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                    if (INSTANCE.isPlatformSpecificDescriptorThatCanBeImplicitlyOverridden(callableMemberDescriptor, visitedDescriptors)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isPlatformSpecificDescriptorThatCanBeImplicitlyOverridden(CallableMemberDescriptor overriddenDescriptor2, Set<CallableMemberDescriptor> visitedDescriptors) {
        if (overriddenDescriptor2.getModality() == Modality.FINAL) {
            return false;
        }
        if (visitedDescriptors.contains(overriddenDescriptor2.getOriginal())) {
            return true;
        }
        CallableMemberDescriptor callableMemberDescriptor = overriddenDescriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "overriddenDescriptor.original");
        visitedDescriptors.add(callableMemberDescriptor);
        switch (JvmOverridesBackwardCompatibilityHelper$WhenMappings.$EnumSwitchMapping$0[overriddenDescriptor2.getKind().ordinal()]) {
            case 1: 
            case 2: {
                return this.isOverridingOnlyDescriptorsThatCanBeImplicitlyOverridden(overriddenDescriptor2, visitedDescriptors);
            }
            case 3: {
                if (overriddenDescriptor2.getAnnotations().hasAnnotation(PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME())) {
                    return true;
                }
                if (overriddenDescriptor2 instanceof JavaMethodDescriptor) {
                    ClassDescriptor classDescriptor2 = DescriptorUtils.getContainingClass(overriddenDescriptor2);
                    if (classDescriptor2 == null) {
                        return false;
                    }
                    Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "DescriptorUtils.getConta\u2026          ?: return false");
                    ClassDescriptor containingClass = classDescriptor2;
                    if (JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtilsKt.getFqNameUnsafe(containingClass)) != null) {
                        return true;
                    }
                    if (((JavaMethodDescriptor)overriddenDescriptor2).getOverriddenDescriptors().isEmpty()) {
                        return false;
                    }
                    return this.isOverridingOnlyDescriptorsThatCanBeImplicitlyOverridden(overriddenDescriptor2, visitedDescriptors);
                }
                return false;
            }
        }
        return false;
    }

    private final boolean isOverridingOnlyDescriptorsThatCanBeImplicitlyOverridden(CallableMemberDescriptor overriddenDescriptor2, Set<CallableMemberDescriptor> visitedDescriptors) {
        boolean bl;
        block3: {
            Collection<? extends CallableMemberDescriptor> collection = overriddenDescriptor2.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, "overriddenDescriptor.overriddenDescriptors");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    CallableMemberDescriptor callableMemberDescriptor = it;
                    Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                    if (INSTANCE.isPlatformSpecificDescriptorThatCanBeImplicitlyOverridden(callableMemberDescriptor, visitedDescriptors)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private JvmOverridesBackwardCompatibilityHelper() {
    }

    static {
        JvmOverridesBackwardCompatibilityHelper jvmOverridesBackwardCompatibilityHelper;
        INSTANCE = jvmOverridesBackwardCompatibilityHelper = new JvmOverridesBackwardCompatibilityHelper();
    }
}

